/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TreeMouseAdapter
extends MouseAdapter {
    protected final int DOUBLE_CLICK_ACTION = 2;
    protected final int NO_MOUSE_CLICK_ACTION = 0;
    protected final int POPUP_TRIGGER_ACTION = 3;
    protected final int SINGLE_CLICK_ACTION = 1;
    public final String TAB = "\t";

    protected int getMouseClickAction(MouseEvent e) {
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
            return 3;
        }
        if (e.getClickCount() == 1) {
            return 1;
        }
        if (e.getClickCount() == 2) {
            return 2;
        }
        return 0;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void printAllPaths(JTree tree) {
        int count = tree.getSelectionCount();
        TreePath[] paths = tree.getSelectionPaths();
        this.printHeader();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                this.printPath(tree, paths[i]);
                ++i;
            }
        }
    }

    private void printHeader() {
        System.out.println("============================================");
        System.out.println("| navigation:TreeMouseAdapter.printPaths() |");
        System.out.println("============================================");
        System.out.print("\tRow");
        System.out.print("\tPath");
        System.out.println("\tParent");
        System.out.println("--------------------------------------------");
    }

    private void printPath(JTree tree, TreePath path) {
        if (path != null) {
            System.out.print("\t" + tree.getRowForPath(path));
            System.out.print("\t" + path);
            System.out.println("\t" + path.getParentPath());
        } else {
            System.out.print("\tnull");
            System.out.print("\tnull");
            System.out.println("\tnull");
        }
    }

    protected void updateSelectedPath(MouseEvent e) {
        JTree tree = (JTree)e.getComponent();
        TreePath lastSelectedPath = tree.getSelectionPath();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null && lastSelectedPath != null) {
            TreePath[] paths = tree.getSelectionPaths();
            int i = 0;
            while (i < paths.length) {
                if (path.equals(paths[i])) {
                    tree.addSelectionPath(path);
                    return;
                }
                ++i;
            }
        }
        tree.setSelectionPath(path);
    }
}

