/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.gui.tables;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExpAnalyzeResults;
import at.tugraz.genome.arraynormgui.ProgramProperties;
import at.tugraz.genome.math.stattests.AnovaOutcomeData;
import at.tugraz.genome.utils.GenericFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class AnovaResultsTable
extends JTable
implements ActionListener {
    private AnovaOutcomeData[] anova_outcome_;
    private AnovaTableModel anovtab_model_;
    static /* synthetic */ Class class$java$lang$Object;
    private ExpAnalyzeResults exp_analysis_results_;
    private DefaultTableCellRenderer myCellRenderer;
    private int num_anovas_;
    private JPopupMenu popup_menu_;
    private Border standardBorder;

    public AnovaResultsTable(ExpAnalyzeResults expresdata) {
        this.exp_analysis_results_ = expresdata;
        this.anova_outcome_ = this.exp_analysis_results_.getAnova_complete_results_();
        this.num_anovas_ = this.exp_analysis_results_.getData_length_();
        this.anovtab_model_ = new AnovaTableModel();
        this.setModel(this.anovtab_model_);
        this.setRowHeight(16);
        this.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.doLayout();
        this.setFont(new Font("Dialog", 1, 12));
        AnovTabMouseListener anovatab_listener = new AnovTabMouseListener();
        this.addMouseListener(anovatab_listener);
        this.addMouseMotionListener(anovatab_listener);
        this.createPopup();
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source.getText() == "Save table information...") {
            Thread thread = new Thread(){

                public void run() {
                    AnovaResultsTable.this.saveTable();
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void createPopup() {
        this.popup_menu_ = new JPopupMenu("Save table information...");
        JMenuItem saveMenuItem = new JMenuItem("Save table information...");
        saveMenuItem.addActionListener(this);
        this.popup_menu_.add(saveMenuItem);
    }

    public void saveTable() {
        File file = null;
        JFileChooser fc = new JFileChooser(ProgramProperties.GetInstance().FileOpeningPath);
        String ff_describtion = "resultfile";
        String[] ff_extension = new String[]{".txt"};
        GenericFileFilter resultfiles_filter = new GenericFileFilter(ff_describtion, ff_extension);
        fc.addChoosableFileFilter(resultfiles_filter);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(resultfiles_filter);
        int returnVal = fc.showSaveDialog(null);
        fc.setVisible(true);
        if (returnVal == 0 && !(file = fc.getSelectedFile()).getName().toLowerCase().endsWith(".txt")) {
            file = new File(file.getAbsolutePath() + ".txt");
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String dummy = "";
            int j = 0;
            while (j < this.getColumnCount()) {
                dummy = dummy + this.getColumnName(j).trim();
                if (j < this.getColumnCount() - 1) {
                    dummy = dummy + "\t";
                }
                ++j;
            }
            out.write(dummy, 0, dummy.length());
            out.newLine();
            int i = 0;
            while (i < this.getRowCount()) {
                dummy = "";
                int j2 = 0;
                while (j2 < this.getColumnCount()) {
                    dummy = dummy + String.valueOf(this.getValueAt(i, j2));
                    if (j2 < this.getColumnCount() - 1) {
                        dummy = dummy + "\t";
                    }
                    ++j2;
                }
                out.write(dummy, 0, dummy.length());
                out.newLine();
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    class AnovTabMouseListener
    extends MouseInputAdapter {
        AnovTabMouseListener() {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                AnovaResultsTable.this.popup_menu_.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.maybeShowPopup(e);
            }
        }
    }

    private class GeneTableCellRenderer
    extends DefaultTableCellRenderer {
        public GeneTableCellRenderer() {
            this.setBackground(Color.white);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setOpaque(true);
            cell.setFont(new Font("Dialog", 1, 12));
            int rightborder = 0;
            int bottomborder = 0;
            if (row % 2 == 1) {
                cell.setBackground(new Color(237, 243, 254));
            } else {
                cell.setBackground(Color.white);
            }
            if (row + 1 == AnovaResultsTable.this.anovtab_model_.getRowCount()) {
                bottomborder = 1;
            }
            if (column + 1 != AnovaResultsTable.this.anovtab_model_.getColumnCount()) {
                rightborder = 1;
            }
            MatteBorder cellBorder = BorderFactory.createMatteBorder(0, 0, bottomborder, rightborder, new Color(217, 217, 217));
            cell.setBorder(BorderFactory.createCompoundBorder(cellBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            if (column > 1) {
                cell.setHorizontalAlignment(0);
            } else {
                cell.setHorizontalAlignment(2);
            }
            if (isSelected) {
                cell.setBackground(new Color(60, 128, 222));
                cell.setForeground(Color.white);
            } else {
                cell.setForeground(Color.black);
            }
            return cell;
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g);
        }
    }

    private class AnovaTableModel
    extends AbstractTableModel {
        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = AnovaResultsTable.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Gene ID";
            }
            if (col == 1) {
                return "Gene Name";
            }
            if (col == 2) {
                return "MSA";
            }
            if (col == 3) {
                return "MSE";
            }
            if (col == 4) {
                return "F-stat";
            }
            if (col == 5) {
                return "p-val";
            }
            if (col == 6) {
                return "signif";
            }
            return null;
        }

        public int getRowCount() {
            return AnovaResultsTable.this.num_anovas_;
        }

        public Object getValueAt(int row, int col) {
            Object returnObject = null;
            try {
                double dummy;
                if (col == 0) {
                    returnObject = AnovaResultsTable.this.exp_analysis_results_.getGene_ids_()[row];
                }
                if (col == 1) {
                    returnObject = AnovaResultsTable.this.exp_analysis_results_.getGene_names_()[row];
                }
                if (col == 2) {
                    dummy = AnovaResultsTable.this.anova_outcome_[row].getMsa_();
                    returnObject = new Double(dummy);
                }
                if (col == 3) {
                    dummy = AnovaResultsTable.this.anova_outcome_[row].getMse_();
                    returnObject = new Double(dummy);
                }
                if (col == 4) {
                    dummy = AnovaResultsTable.this.anova_outcome_[row].getF_stat_();
                    returnObject = new Double(dummy);
                }
                if (col == 5) {
                    dummy = AnovaResultsTable.this.anova_outcome_[row].getP_value_();
                    returnObject = new Double(dummy);
                }
                if (col == 6) {
                    returnObject = new Boolean(AnovaResultsTable.this.anova_outcome_[row].isSignificant_());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                returnObject = null;
            }
            return returnObject;
        }

        public Object getValueAtDepricated(int row, int col) {
            double dummy;
            Object returnObject = null;
            if (col == 0) {
                returnObject = AnovaResultsTable.this.exp_analysis_results_.getGene_ids_()[row];
            }
            if (col == 1) {
                returnObject = AnovaResultsTable.this.exp_analysis_results_.getGene_names_()[row];
            }
            if (col == 2) {
                dummy = AnovaResultsTable.this.anova_outcome_[row].getMsa_();
                returnObject = !Double.isNaN(dummy) ? new Double(dummy) : new String("NaN");
            }
            if (col == 3) {
                dummy = AnovaResultsTable.this.anova_outcome_[row].getMse_();
                returnObject = !Double.isNaN(dummy) ? new Double(dummy) : new String("NaN");
            }
            if (col == 4) {
                dummy = AnovaResultsTable.this.anova_outcome_[row].getF_stat_();
                returnObject = !Double.isNaN(dummy) ? new Double(dummy) : new String("NaN");
            }
            if (col == 5) {
                dummy = AnovaResultsTable.this.anova_outcome_[row].getP_value_();
                returnObject = !Double.isNaN(dummy) ? new Double(dummy) : new String("NaN");
            }
            if (col == 6) {
                returnObject = new Boolean(AnovaResultsTable.this.anova_outcome_[row].isSignificant_());
            }
            return "hallo";
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

