/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.experiment.vo;

import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.experiment.ejb.Subexperiment;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassRawbioassayVO;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class SubexperimentVO
implements Serializable {
    private Long id;
    private String name;
    private String description;
    private Collection rawbioassayVOs;
    private Collection expClassVOs;

    public SubexperimentVO(String name, String description) throws ValidationException {
        if (name == null || name.length() == 0) {
            throw new ValidationException("name was null or empty ", this.getClass());
        }
        this.name = name;
        this.description = description;
    }

    public SubexperimentVO(Subexperiment entity) {
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescription(entity.getDescription());
        this.rawbioassayVOs = entity.getExperimentClassRawbioassayVOs();
        this.expClassVOs = entity.getExperimentClassVOs();
    }

    public SubexperimentVO(Subexperiment entity, int level) {
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescription(entity.getDescription());
        if (level > 0) {
            this.rawbioassayVOs = entity.getExperimentClassRawbioassayVOs(level - 1);
            this.expClassVOs = entity.getExperimentClassVOs(level - 1);
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(Long id) throws ValidationException {
        if (this.id != null) {
            throw new ValidationException("Id is already set !", this.getClass());
        }
        if (id == null) {
            throw new ValidationException("null not allowed !", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection getExperimentClassRawBioassayVOs() {
        return this.rawbioassayVOs;
    }

    public Collection getExperimentClassVOs() {
        return this.expClassVOs;
    }

    public SubexperimentDTO createSubExperimentDTO() {
        System.out.println("createSubExperimentDTO");
        SubexperimentDTO subExperimentDTO = new SubexperimentDTO();
        subExperimentDTO.setDescription(this.getDescription());
        subExperimentDTO.setId(this.getId());
        subExperimentDTO.setName(this.getName());
        System.out.println("createSubExperimentDTO.1");
        if (this.getExperimentClassVOs() != null) {
            Iterator experimentClassVOs = this.getExperimentClassVOs().iterator();
            Vector<ExperimentClassDTO> experimentClassDTOs = new Vector<ExperimentClassDTO>();
            while (experimentClassVOs.hasNext()) {
                ExperimentClassVO experimentClassVO = (ExperimentClassVO)experimentClassVOs.next();
                ExperimentClassDTO experimentClassDTO = experimentClassVO.createExperimentClassDTO();
                experimentClassDTOs.add(experimentClassDTO);
            }
            subExperimentDTO.setExperimentClassDTOs(experimentClassDTOs);
        }
        System.out.println("createSubExperimentDTO.2");
        if (this.getExperimentClassRawBioassayVOs() != null) {
            Iterator experimentClassRawBioassayVOs = this.getExperimentClassRawBioassayVOs().iterator();
            Vector<ExperimentClassRawbioassayDTO> experimentClassRawBioassayDTOs = new Vector<ExperimentClassRawbioassayDTO>();
            while (experimentClassRawBioassayVOs.hasNext()) {
                ExperimentClassRawbioassayVO experimentClassRawBioassayVO = (ExperimentClassRawbioassayVO)experimentClassRawBioassayVOs.next();
                ExperimentClassRawbioassayDTO experimentClassRawBioassayDTO = experimentClassRawBioassayVO.createExperimentClassRawbioassayDTO();
                experimentClassRawBioassayDTOs.add(experimentClassRawBioassayDTO);
            }
            subExperimentDTO.setExperimentClassRawBioassayDTOs(experimentClassRawBioassayDTOs);
        }
        return subExperimentDTO;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer("at.tugraz.genome.marsejb.experiment.vo.SubexperimentVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id=");
        _ret.append(this.id);
        _ret.append(",\n");
        _ret.append("java.lang.String name=");
        _ret.append(this.name);
        _ret.append(",\n");
        _ret.append("java.lang.String description=");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SubexperimentVO) {
            SubexperimentVO obj = (SubexperimentVO)o;
            boolean res = true;
            boolean bl = res = this.getId() == obj.getId() || this.getId() != null && obj.getId() != null && this.getId().equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.getName() == obj.getName() || this.getName() != null && obj.getName() != null && this.getName().equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.getDescription() == obj.getDescription() || this.getDescription() != null && obj.getDescription() != null && this.getDescription().equals(obj.getDescription());
                    if (!res) {
                        // empty if block
                    }
                }
            }
            return res;
        }
        return false;
    }
}

