/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.molecule.vo;

import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.molecule.ejb.Organism;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;

public class OrganismVO
implements Serializable {
    private Long id;
    private String name;
    private String nameabbreviation;
    private String description;
    private Long userid;
    private SubmitterVO userVO;
    private Long instituteid;

    public OrganismVO(Organism entity) {
        block4: {
            try {
                this.setId(entity.getId());
                this.setName(entity.getName());
                this.setNameabbreviation(entity.getNameabbreviation());
                this.setDescription(entity.getDescription());
                this.setUserid(entity.getUserid());
                if (this.userid == null) break block4;
                try {
                    this.setUserVO(entity.getUserVO());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (ValidationException validationExc) {
                System.out.println(validationExc);
            }
        }
    }

    public OrganismVO(String name, String nameabbreviation, String description, Long userID) throws ValidationException {
        if (name == null) {
            throw new ValidationException("name in OrganisVO is NULL", this.getClass());
        }
        if (nameabbreviation == null) {
            throw new ValidationException("nameabbreviation in OrganismVO is NULL", this.getClass());
        }
        if (nameabbreviation.length() != 2) {
            throw new ValidationException("nameabbreviation in OrganismVO has to have exactly 2 characters", this.getClass());
        }
        this.setName(name);
        this.setNameabbreviation(nameabbreviation);
        this.setDescription(description);
        this.setUserid(userID);
    }

    public void setUserid(Long userID) {
        this.userid = userID;
    }

    public Long getUserid() {
        return this.userid;
    }

    public SubmitterVO getUserVO() {
        return this.userVO;
    }

    public void setUserVO(SubmitterVO userVO) {
        this.userVO = userVO;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameabbreviation() {
        return this.nameabbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in OrganismVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("is in OrganismVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameabbreviation(String nameabbreviation) {
        this.nameabbreviation = nameabbreviation.toUpperCase();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.molecule.vo.OrganismVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String nameabbreviation = ");
        _ret.append(this.nameabbreviation);
        _ret.append("\n");
        _ret.append("java.lang.String description = ");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof OrganismVO) {
            OrganismVO obj = (OrganismVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.nameabbreviation == obj.getNameabbreviation() || this.nameabbreviation != null && obj.getNameabbreviation() != null && this.nameabbreviation.equals(obj.getNameabbreviation());
                    if (res) {
                        boolean bl4 = res = this.description == obj.getDescription() || this.description != null && obj.getDescription() != null && this.description.equals(obj.getDescription());
                        if (!res) {
                            // empty if block
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }

    public int hashCode() {
        return (this.id.toString() + this.name + this.nameabbreviation).hashCode();
    }
}

