/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.rawbioassaydata.vo;

import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.rawbioassaydata.ejb.Imageacquisition;
import at.tugraz.genome.marsejb.rawbioassaydata.vo.HardwareVO;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;

public class ImageacquisitionVO
implements Serializable {
    private Long id;
    private String name;
    private String description;
    private Long userid;
    private Date addeddate;
    private Date scandate;
    private BigDecimal usecount;
    private HardwareVO hardwareVO;
    private Collection imageVOs;
    private Collection rawBioassayVOs;
    private SubmitterVO submitterVO;

    public ImageacquisitionVO(Imageacquisition entity) {
        block4: {
            try {
                this.setId(entity.getId());
                this.setName(entity.getName());
                this.setDescription(entity.getDescription());
                this.setUserid(entity.getUserid());
                this.setAddeddate(entity.getAddeddate());
                this.setScandate(entity.getScandate());
                this.setUsecount(entity.getUsecount());
                this.hardwareVO = new HardwareVO(entity.getHardware());
                this.imageVOs = entity.getImageVOs();
                this.rawBioassayVOs = entity.getRawbioassayVOs();
                try {
                    if (entity.getUserid() == null) break block4;
                    this.submitterVO = entity.getSubmitterVO();
                }
                catch (EJBServerException ese) {
                    ese.printStackTrace();
                }
            }
            catch (ValidationException validationExc) {
                validationExc.printStackTrace();
            }
        }
    }

    public ImageacquisitionVO(Imageacquisition entity, int level) {
        block5: {
            try {
                this.setId(entity.getId());
                this.setName(entity.getName());
                this.setDescription(entity.getDescription());
                this.setUserid(entity.getUserid());
                this.setAddeddate(entity.getAddeddate());
                this.setScandate(entity.getScandate());
                this.setUsecount(entity.getUsecount());
                if (level <= 0) break block5;
                this.hardwareVO = new HardwareVO(entity.getHardware());
                this.imageVOs = entity.getImageVOs();
                this.rawBioassayVOs = entity.getRawbioassayVOs(level - 1);
                try {
                    if (entity.getUserid() != null) {
                        this.submitterVO = entity.getSubmitterVO();
                    }
                }
                catch (EJBServerException ese) {
                    ese.printStackTrace();
                }
            }
            catch (ValidationException validationExc) {
                validationExc.printStackTrace();
            }
        }
    }

    public ImageacquisitionVO(String name, String description, Long userID, Date addedDate, Date scanDate, BigDecimal useCount, HardwareVO hardwareVO) throws ValidationException {
        this.setName(name);
        this.setDescription(description);
        this.setUserid(userID);
        this.setAddeddate(addedDate);
        this.setScandate(scanDate);
        this.setUsecount(useCount);
        this.setHardware(hardwareVO);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUserid() {
        return this.userid;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public Date getScandate() {
        return this.scandate;
    }

    public BigDecimal getUsecount() {
        return this.usecount;
    }

    public HardwareVO getHardware() {
        return this.hardwareVO;
    }

    public Collection getImageVOs() {
        return this.imageVOs;
    }

    public Collection getRawBioassayVOs() {
        return this.rawBioassayVOs;
    }

    public SubmitterVO getSubmitterVO() {
        return this.submitterVO;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in ImageacquisitionVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("id in ImageacquisitionVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) throws ValidationException {
        if (name == null) {
            throw new ValidationException("name in ImageacquisitionVO is NULL", this.getClass());
        }
        if (name.trim().length() < 1) {
            throw new ValidationException("name in ImageacquisitionVO must have more than 0 characters", this.getClass());
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserid(Long userid) throws ValidationException {
        if (userid == null) {
            throw new ValidationException("userid in ImageacquisitionVO is NULL", this.getClass());
        }
        this.userid = userid;
    }

    public void setAddeddate(Date addeddate) throws ValidationException {
        if (addeddate == null) {
            throw new ValidationException("addeddate in ImageacquisitionVO is NULL", this.getClass());
        }
        this.addeddate = addeddate;
    }

    public void setScandate(Date scandate) throws ValidationException {
        if (scandate == null) {
            throw new ValidationException("scandate in ImageacquisitionVO is NULL", this.getClass());
        }
        this.scandate = scandate;
    }

    public void setUsecount(BigDecimal usecount) throws ValidationException {
        if (usecount == null) {
            throw new ValidationException("usecount in ImageacquisitionVO is NULL", this.getClass());
        }
        this.usecount = usecount;
    }

    public void setHardware(HardwareVO hardware) throws ValidationException {
        if (hardware == null) {
            throw new ValidationException("hardware in ImageacquisitionVO is NULL", this.getClass());
        }
        this.hardwareVO = hardware;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.vo.ImageacquisitionVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String description = ");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("java.lang.Long userid = ");
        _ret.append(this.userid);
        _ret.append("\n");
        _ret.append("java.sql.Date addeddate = ");
        _ret.append(this.addeddate);
        _ret.append("\n");
        _ret.append("java.sql.Date scandate = ");
        _ret.append(this.scandate);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal usecount = ");
        _ret.append(this.usecount);
        _ret.append("\n");
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.ejb.Hardware hardware = ");
        _ret.append(this.hardwareVO);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ImageacquisitionVO) {
            ImageacquisitionVO obj = (ImageacquisitionVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.description == obj.getDescription() || this.description != null && obj.getDescription() != null && this.description.equals(obj.getDescription());
                    if (res) {
                        boolean bl4 = res = this.userid == obj.getUserid() || this.userid != null && obj.getUserid() != null && this.userid.equals(obj.getUserid());
                        if (res) {
                            boolean bl5 = res = this.addeddate == obj.getAddeddate() || this.addeddate != null && obj.getAddeddate() != null && this.addeddate.equals(obj.getAddeddate());
                            if (res) {
                                boolean bl6 = res = this.scandate == obj.getScandate() || this.scandate != null && obj.getScandate() != null && this.scandate.equals(obj.getScandate());
                                if (res) {
                                    boolean bl7 = res = this.usecount == obj.getUsecount() || this.usecount != null && obj.getUsecount() != null && this.usecount.equals(obj.getUsecount());
                                    if (res) {
                                        boolean bl8 = res = this.hardwareVO == obj.getHardware() || this.hardwareVO != null && obj.getHardware() != null && this.hardwareVO.equals(obj.getHardware());
                                        if (!res) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

