/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.samplehybridization.vo;

import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.samplehybridization.ejb.Sample;
import at.tugraz.genome.marsejb.samplehybridization.ejb.Sampleannotation;
import at.tugraz.genome.marsejb.samplehybridization.ejb.Sampletissue;
import at.tugraz.genome.marsejb.samplehybridization.vo.SampleannotationVO;
import at.tugraz.genome.marsejb.samplehybridization.vo.SampletissueVO;
import at.tugraz.genome.marsejb.utils.vo.ProviderVO;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class SampleVO
implements Serializable {
    private Long id;
    private String sampleid;
    private String name;
    private String descr;
    private Long userid;
    private Date addeddate;
    private Long usecount;
    private Collection sampleannotations;
    private SampletissueVO sampletissue;
    private ProviderVO providerVO;
    private SubmitterVO submitterVO;
    private String type;
    private Collection sampleParentVOs;

    public SampleVO(Sample entity, int level) {
        block6: {
            this.id = entity.getId();
            this.setSampleid(entity.getSampleid());
            this.setName(entity.getName());
            this.setDescr(entity.getDescr());
            this.setUserid(entity.getUserid());
            this.setAddeddate(entity.getAddeddate());
            this.setUsecount(entity.getUsecount());
            try {
                this.setSampleannotationEOs(entity.getSampleannotation());
            }
            catch (ValidationException validationExc) {
                validationExc.printStackTrace();
            }
            this.setType(entity.getType());
            this.sampleParentVOs = new Vector();
            Iterator iterator = entity.getSampleParents().iterator();
            while (iterator.hasNext()) {
                Sample parent = (Sample)iterator.next();
                this.sampleParentVOs.add(new SampleVO(parent, level - 1));
            }
            if (level <= 0) break block6;
            this.setSampletissue(entity.getSampletissue());
            try {
                this.setProviderVO(entity.getProviderVO());
                this.setSubmitterVO(entity.getSubmitterVO());
            }
            catch (EJBFinderException ef) {
                ef.printStackTrace();
            }
            catch (EJBServerException es) {
                es.printStackTrace();
            }
        }
    }

    public SampleVO(String sampleid, String name, String descr, SampletissueVO sampletissueVO, Long userid, Date addeddate, Long usecount, ProviderVO providerVO, String type, Collection sampleParentVOs) throws ValidationException {
        if (name == null || name.length() == 0) {
            throw new ValidationException("name was not set", this.getClass());
        }
        if (sampletissueVO == null) {
            throw new ValidationException("sampletissue was not set", this.getClass());
        }
        if (userid == null) {
            throw new ValidationException("userid was not set", this.getClass());
        }
        if (addeddate == null) {
            throw new ValidationException("addeddate was not set", this.getClass());
        }
        if (usecount == null) {
            throw new ValidationException("usecount was not set", this.getClass());
        }
        if (addeddate == null) {
            throw new ValidationException("addeddate was not set", this.getClass());
        }
        if (type == null) {
            throw new ValidationException("type was null", this.getClass());
        }
        if (!(type.equals("TI") || type.equals("CC") || type.equals("SP") || type.equals("CS"))) {
            throw new ValidationException("type must be set to TI for tissue or CC for Cellculture", this.getClass());
        }
        this.sampleid = sampleid;
        this.name = name;
        this.descr = descr;
        this.sampletissue = sampletissueVO;
        this.userid = userid;
        this.addeddate = addeddate;
        this.usecount = usecount;
        this.providerVO = providerVO;
        this.type = type;
        this.sampleParentVOs = sampleParentVOs;
    }

    public Long getId() {
        return this.id;
    }

    public String getSampleid() {
        return this.sampleid;
    }

    public String getName() {
        return this.name;
    }

    public String getDescr() {
        return this.descr;
    }

    public Long getUserid() {
        return this.userid;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public Long getUsecount() {
        return this.usecount;
    }

    public Collection getSampleannotations() {
        return this.sampleannotations;
    }

    public SampletissueVO getSampletissue() {
        return this.sampletissue;
    }

    public String getSampletissueName() {
        return this.sampletissue.getName();
    }

    public ProviderVO getProvider() {
        return this.providerVO;
    }

    public SubmitterVO getSubmitter() {
        return this.submitterVO;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type.equals("TI")) {
            return "Tissue";
        }
        if (this.type.equals("CC")) {
            return "Cell Culture";
        }
        if (this.type.equals("SP")) {
            return "Sample Pool";
        }
        if (this.type.equals("CS")) {
            return "Cell Suspension";
        }
        return "Other";
    }

    public Collection getSampleParentVOs() {
        return this.sampleParentVOs;
    }

    public void setId(Long id) throws ValidationException {
        if (this.id != null) {
            throw new ValidationException("Id is already set !", this.getClass());
        }
        if (id == null) {
            throw new ValidationException("null not allowed !", this.getClass());
        }
        this.id = id;
    }

    public void setSampleid(String sampleid) {
        this.sampleid = sampleid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public void setAddeddate(Date addeddate) {
        this.addeddate = addeddate;
    }

    public void setUsecount(Long usecount) {
        this.usecount = usecount;
    }

    private void setSampleannotationEOs(Collection sampleannotation) throws ValidationException {
        this.sampleannotations = new Vector();
        Iterator it = sampleannotation.iterator();
        SampleannotationVO saVO = null;
        while (it.hasNext()) {
            Sampleannotation sa = (Sampleannotation)it.next();
            saVO = new SampleannotationVO(sa);
            this.sampleannotations.add(saVO);
        }
    }

    public void setSampletissue(SampletissueVO vo) {
        this.sampletissue = vo;
    }

    public void setSampletissue(Sampletissue entity) {
        this.sampletissue = new SampletissueVO(entity);
    }

    public void setProviderVO(ProviderVO providerVO) {
        this.providerVO = providerVO;
    }

    public void setSubmitterVO(SubmitterVO submitterVO) {
        this.submitterVO = submitterVO;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSampleParentVOs(Collection sampleparentVOs) {
        this.sampleParentVOs = sampleparentVOs;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.samplehybridization.vo.SampleVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String descr = ");
        _ret.append(this.descr);
        _ret.append("\n");
        _ret.append("java.lang.Long userid = ");
        _ret.append(this.userid);
        _ret.append("\n");
        _ret.append("java.sql.Date addeddate = ");
        _ret.append(this.addeddate);
        _ret.append("\n");
        _ret.append("java.lang.Long usecount = ");
        _ret.append(this.usecount);
        _ret.append("\n");
        _ret.append("java.util.Collection sampleannotation = ");
        _ret.append(this.sampleannotations);
        _ret.append("\n");
        _ret.append("at.tugraz.genome.marsejb.samplehybridization.ejb.Sampletissue sampletissue = ");
        _ret.append(this.sampletissue);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SampleVO) {
            SampleVO obj = (SampleVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.descr == obj.getDescr() || this.descr != null && obj.getDescr() != null && this.descr.equals(obj.getDescr());
                    if (res) {
                        boolean bl4 = res = this.userid == obj.getUserid() || this.userid != null && obj.getUserid() != null && this.userid.equals(obj.getUserid());
                        if (res) {
                            boolean bl5 = res = this.addeddate == obj.getAddeddate() || this.addeddate != null && obj.getAddeddate() != null && this.addeddate.equals(obj.getAddeddate());
                            if (res) {
                                boolean bl6 = res = this.usecount == obj.getUsecount() || this.usecount != null && obj.getUsecount() != null && this.usecount.equals(obj.getUsecount());
                                if (res) {
                                    boolean bl7 = res = this.sampleannotations == obj.getSampleannotations() || this.sampleannotations != null && obj.getSampleannotations() != null && this.sampleannotations.equals(obj.getSampleannotations());
                                    if (res) {
                                        boolean bl8 = res = this.sampletissue == obj.getSampletissue() || this.sampletissue != null && obj.getSampletissue() != null && this.sampletissue.equals(obj.getSampletissue());
                                        if (!res) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

