/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import at.tugraz.genome.utils.GenericFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JpegPngEncoder {
    Component component_;
    String format_name_;
    Container parent_;

    public JpegPngEncoder(Container parent, Component compo) {
        this.parent_ = parent;
        this.component_ = compo;
        this.saveComponent();
    }

    public void saveComponent() {
        boolean save_error_ = false;
        Exception ex = null;
        JFileChooser savecomponent_fchooser = new JFileChooser();
        savecomponent_fchooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter jpg_filefilter = new GenericFileFilter("JPEG Images", new String[]{".jpg", ".jpeg"});
        GenericFileFilter png_filefilter = new GenericFileFilter("PNG Images", new String[]{".png"});
        savecomponent_fchooser.addChoosableFileFilter(jpg_filefilter);
        savecomponent_fchooser.addChoosableFileFilter(png_filefilter);
        savecomponent_fchooser.setDialogTitle("Capture Picture");
        int return_val = savecomponent_fchooser.showSaveDialog(this.parent_);
        if (return_val == 0) {
            String file_name = savecomponent_fchooser.getSelectedFile().getAbsolutePath();
            if (savecomponent_fchooser.getFileFilter().getDescription().equals(jpg_filefilter.getDescription())) {
                if (!file_name.toLowerCase().endsWith(".jpg")) {
                    file_name = file_name + ".jpg";
                }
                Dimension size = this.component_.getSize();
                BufferedImage image_out_ = new BufferedImage(size.width, size.height, 1);
                Graphics2D g2 = image_out_.createGraphics();
                this.component_.paint(g2);
                try {
                    FileOutputStream out = new FileOutputStream(file_name);
                    ImageIO.write((RenderedImage)image_out_, "JPEG", out);
                    ((OutputStream)out).close();
                }
                catch (Exception e) {
                    ex = e;
                    save_error_ = true;
                }
            } else if (savecomponent_fchooser.getFileFilter().getDescription().equals(png_filefilter.getDescription())) {
                if (!file_name.toLowerCase().endsWith(".png")) {
                    file_name = file_name + ".png";
                }
                Dimension size = this.component_.getSize();
                BufferedImage image_out_ = new BufferedImage(size.width, size.height, 1);
                Graphics2D g2 = image_out_.createGraphics();
                this.component_.paint(g2);
                try {
                    FileOutputStream out = new FileOutputStream(file_name);
                    ImageIO.write((RenderedImage)image_out_, "PNG", out);
                    ((OutputStream)out).close();
                }
                catch (Exception e) {
                    ex = e;
                    save_error_ = true;
                }
            }
            if (save_error_) {
                JOptionPane.showMessageDialog(this.parent_, "File not saved!\n" + ex, "Warning", 2);
            } else {
                JOptionPane.showMessageDialog(this.parent_, "File successfully saved!", "Information", 1);
                System.out.println("File successfully saved!");
            }
        }
    }
}

