/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

public class MathUtils {
    private static final int BASE10 = 10;
    private static final int BASE2 = 2;
    private static double log10_ = Math.log(10.0);
    private static double log2_ = Math.log(2.0);

    public static double[] arrayLog10(double[] arg) {
        double[] temp = arg;
        try {
            int i = 0;
            while (i < arg.length) {
                temp[i] = arg[i] > 0.0 ? Math.log(arg[i]) / log10_ : 0.0;
                ++i;
            }
            return temp;
        }
        catch (ArithmeticException e) {
            System.err.println("Wrong argument given!");
        }
        catch (Exception e) {
            System.err.println("General exception please check your argument again: \n" + e);
        }
        return temp;
    }

    public static double[] arrayLog2(double[] arg) {
        double[] temp = arg;
        try {
            int i = 0;
            while (i < arg.length) {
                temp[i] = arg[i] > 0.0 ? Math.log(arg[i]) / log2_ : 0.0;
                ++i;
            }
            return temp;
        }
        catch (ArithmeticException e) {
            System.err.println("Wrong argument given!");
        }
        catch (Exception e) {
            System.err.println("General exception please check your argument again: \n" + e);
        }
        return temp;
    }

    public static double log10(double arg) {
        double temp = 0.0;
        try {
            if (arg > 0.0) {
                temp = Math.log(arg) / log10_;
            }
        }
        catch (ArithmeticException e) {
            System.err.println("Wrong argument given!");
        }
        catch (Exception e) {
            System.err.println("General exception please check your argument again: \n" + e);
        }
        return temp;
    }

    public static double log2(double arg) {
        double temp = 0.0;
        try {
            if (arg > 0.0) {
                temp = Math.log(arg) / log2_;
            }
        }
        catch (ArithmeticException e) {
            System.err.println("Wrong argument given!");
        }
        catch (Exception e) {
            System.err.println("General exception please check your argument again: \n" + e);
        }
        return temp;
    }

    public static void main(String[] arg) {
        System.out.println("First method:  " + MathUtils.log10(10000.0));
        System.out.println("Second method:  " + MathUtils.log2(512.0));
        double[] test1 = new double[]{10.0, 1000000.0, 1000.0, 1.0E7, -2.3121564654564E8};
        test1 = MathUtils.arrayLog10(test1);
        int i = 0;
        while (i < test1.length) {
            System.out.println("Third method:  " + test1[i]);
            ++i;
        }
        double[] test2 = new double[]{1024.0, 4096.0, 128.0, -3.265564545645647E15};
        test2 = MathUtils.arrayLog2(test2);
        int i2 = 0;
        while (i2 < test2.length) {
            System.out.println("Fourth method:  " + test2[i2]);
            ++i2;
        }
    }
}

