/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class RecentFileList
implements ActionListener {
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    private Vector files;
    private EventListenerList listenerList = new EventListenerList();
    private int size;
    private String type;
    private int used;

    public RecentFileList(String type, int size) {
        this.files = new Vector(size);
        this.size = size;
        this.type = type;
        this.used = 0;
    }

    public RecentFileList(String type) {
        this(type, 4);
    }

    public RecentFileList(int size) {
        this(null, size);
    }

    public RecentFileList() {
        this(null);
    }

    public void actionPerformed(ActionEvent e) {
        this.fireActionPerformed(e);
    }

    public void add(String name) {
        int pos = this.files.indexOf(name);
        if (pos > 0) {
            this.files.removeElementAt(pos);
            this.files.insertElementAt(name, 0);
        } else if (pos != 0) {
            if (this.used == this.size) {
                this.files.removeElementAt(this.size - 1);
            } else {
                ++this.used;
            }
            this.files.insertElementAt(name, 0);
        }
    }

    public void add(File f) {
        try {
            this.add(f.getCanonicalPath());
        }
        catch (IOException x) {
            this.add(f.getAbsolutePath());
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = RecentFileList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void buildMenu(JMenu menu) {
        if (this.used > 0) {
            int i = 0;
            while (i < this.used) {
                JMenuItem item = new JMenuItem(String.valueOf(i + 1) + " " + this.files.elementAt(i));
                item.setActionCommand(this.files.elementAt(i).toString());
                if (this.size < 9) {
                    item.setMnemonic(Character.forDigit(i + 1, 10));
                }
                item.addActionListener(this);
                menu.add(item);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? RecentFileList.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public void load(Properties props) {
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        this.files.removeAllElements();
        this.used = Integer.parseInt(props.getProperty(key + "Used", "0"));
        int i = 0;
        while (i < this.used) {
            String value = props.getProperty(key + i);
            if (value == null) break;
            this.files.addElement(value);
            ++i;
        }
    }

    public void remove(String name) {
        if (this.files.removeElement(name)) {
            --this.used;
        }
    }

    public void remove(File f) {
        this.remove(f.getName());
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = RecentFileList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void save(Properties props) {
        String key = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        int i = 0;
        while (i < this.used) {
            ((Hashtable)props).put(key + i, this.files.elementAt(i).toString());
            ++i;
        }
        ((Hashtable)props).put(key + "Used", String.valueOf(this.used));
    }
}

