/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.LocatorControl_FocusAdapter;
import com.borland.jbcl.control.TextFieldControl;
import com.borland.jbcl.model.DataSetModel;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class LocatorControl
extends TextFieldControl
implements Serializable {
    private boolean caseSensitive = true;

    public LocatorControl() {
        this.enableEvents(12L);
        this.addFocusListener(new LocatorControl_FocusAdapter(this));
        this.locateOnly = true;
    }

    protected void postText() {
    }

    protected void updateText() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
        }
        if (c instanceof Window && ((Window)c).getFocusOwner() != this) {
            super.updateText();
        }
    }

    public boolean canSet(boolean startingEdit) {
        return super.canSet(false);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
            e.consume();
        }
        if (e.getID() == 402) {
            this.locatorKeyReleased(e);
        }
        super.processKeyEvent(e);
    }

    private void locatorKeyReleased(KeyEvent e) {
        if (this.getDataSet() != null) {
            int locateOptions = e.getKeyCode() == 40 ? 2 : (e.getKeyCode() == 38 ? 4 : 32);
            String text = this.getText();
            if (text.toLowerCase().equals(text)) {
                locateOptions |= 8;
            }
            if (!this.caseSensitive) {
                text = text.toLowerCase();
                locateOptions |= 8;
            }
            try {
                this.getDataSet().interactiveLocate(text, this.getColumnName(), locateOptions, e.getKeyCode() == 10);
            }
            catch (Exception ex) {
                DataSetModel.handleException(ex);
            }
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

