/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BorderItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    public static final int OUTER_RAISED = 256;
    public static final int OUTER_SUNKEN = 512;
    public static final int INNER_RAISED = 1024;
    public static final int INNER_SUNKEN = 2048;
    public static final int EDGE_RAISED = 1280;
    public static final int EDGE_SUNKEN = 2560;
    public static final int EDGE_ETCHED = 1536;
    public static final int EDGE_BUMP = 2304;
    public static final int EDGE_OUTER = 768;
    public static final int EDGE_INNER = 3072;
    public static final int EDGE_ALL = 3840;
    public static final int NONE = 0;
    public static final int PLAIN = 1;
    public static final int RAISED = 2;
    public static final int RECESSED = 3;
    public static final int EMBOSSED = 4;
    public static final int GROOVED = 5;
    public static final int BUTTON_UP = 6;
    public static final int BUTTON_DN = 7;
    public static final int WND_RAISED = 8;
    public static final int WND_RECESSED = 9;
    public static final int WELL_SET = 10;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int TOP_LEFT = 3;
    public static final int TOP_RIGHT = 6;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 12;
    public static final int RECT = 15;
    public static final int FILL = 2048;
    public static final int SOFT = 4096;
    public static final int FLAT = 16384;
    public static final int MONO = 32768;
    private static int[] edges;
    private static int[] flagses;
    private int edge;
    private int which;
    private int flags;
    private transient ItemPainter painter;

    public BorderItemPainter(int edgeOrStyle, int which, int flags) {
        if ((edgeOrStyle & 0xF00) == 0) {
            this.edge = edges[edgeOrStyle];
            this.flags = flagses[edgeOrStyle] | flags;
        } else {
            this.edge = edgeOrStyle;
            this.flags = flags;
        }
        this.which = which;
    }

    public BorderItemPainter(int edgeOrStyle, int which) {
        this(edgeOrStyle, which, 0);
    }

    public BorderItemPainter(int edgeOrStyle) {
        this(edgeOrStyle, 15, 0);
    }

    public BorderItemPainter() {
        this(0, 15, 0);
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle, int which, int flags) {
        this(edgeOrStyle, which, flags);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle, int which) {
        this(edgeOrStyle, which);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle) {
        this(edgeOrStyle);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter) {
        this();
        this.painter = painter;
    }

    public int getEdgeOrStyle() {
        return this.edge;
    }

    public void setEdgeOrStyle(int newEdge) {
        if ((newEdge & 0xF00) == 0) {
            this.edge = edges[newEdge];
            this.flags = flagses[newEdge] | this.flags;
        } else {
            this.edge = newEdge;
        }
    }

    public int getWhichEdges() {
        return this.which;
    }

    public void setWhichEdges(int newWhich) {
        this.which = newWhich;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter newPainter) {
        this.painter = newPainter;
    }

    public Insets getInsets() {
        int thickness = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
        return new Insets(thickness * ((this.which & 2) != 0 ? 1 : 0), thickness * ((this.which & 1) != 0 ? 1 : 0), thickness * ((this.which & 8) != 0 ? 1 : 0), thickness * ((this.which & 4) != 0 ? 1 : 0));
    }

    public Dimension getPreferredSize(Object data, Graphics g, int state, ItemPaintSite site) {
        Insets insets = this.getInsets();
        if (this.painter != null) {
            Dimension inner = this.painter.getPreferredSize(data, g, state, site);
            return new Dimension(inner.width + insets.left + insets.right, inner.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    public void paint(Object data, Graphics g, Rectangle bounds, int state, ItemPaintSite site) {
        boolean trans;
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
        boolean bl = trans = site != null ? site.isTransparent() : false;
        if (trans) {
            this.flags &= 0xFFFFF7FF;
        }
        BorderItemPainter.drawEdge(g, bounds, this.edge, this.which, this.flags);
        if (this.painter != null) {
            Insets insets = this.getInsets();
            int thickness = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
            bounds.x += insets.left;
            bounds.width -= insets.left + insets.right;
            bounds.y += insets.top;
            bounds.height -= insets.top + insets.bottom;
            g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
            this.painter.paint(data, g, bounds, state, site);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static boolean drawEdge(Graphics g, Rectangle bounds, int edge, int which, int flags) {
        int ci;
        Color[] brColors;
        Color[] tlColors;
        Rectangle b = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if ((flags & 0x8000) != 0) {
            if ((edge & 0x300) != 0) {
                BorderItemPainter.paintFrame(g, b, which, SystemColor.windowBorder, SystemColor.windowBorder);
                b.grow(-1, -1);
            }
            if ((flags & 0x800) != 0) {
                g.setColor(SystemColor.window);
                g.drawRect(b.x, b.y, b.width, b.height);
            }
            return true;
        }
        if ((flags & 0x4000) != 0) {
            if ((edge & 0x300) != 0) {
                BorderItemPainter.paintFrame(g, b, which, SystemColor.controlShadow, SystemColor.controlShadow);
                b.grow(-1, -1);
            }
            if ((flags & 0x800) != 0) {
                g.setColor(SystemColor.control);
                g.drawRect(b.x, b.y, b.width, b.height);
            }
            return true;
        }
        if ((edge & 0x300) != 0) {
            tlColors = new Color[]{SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow};
            brColors = new Color[]{SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight};
            ci = ((edge & 0x200) != 0 ? 2 : 0) | ((flags & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.paintFrame(g, b, which, tlColors[ci], brColors[ci]);
            b.grow(-1, -1);
        }
        if ((edge & 0xC00) != 0) {
            tlColors = new Color[]{SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow};
            brColors = new Color[]{SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight};
            ci = ((edge & 0x800) != 0 ? 2 : 0) | ((flags & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.paintFrame(g, b, which, tlColors[ci], brColors[ci]);
            b.grow(-1, -1);
        }
        if ((flags & 0x800) != 0) {
            g.setColor(SystemColor.control);
            g.fillRect(b.x, b.y, b.width, b.height);
        }
        return true;
    }

    static void paintFrame(Graphics g, Rectangle b, int which, Color tlColor, Color brColor) {
        if ((which & 3) != 0) {
            g.setColor(tlColor);
            if ((which & 1) != 0) {
                g.drawLine(b.x, b.y + 1, b.x, b.y + b.height - 1);
            }
            if ((which & 2) != 0) {
                g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
            }
        }
        if ((which & 0xC) != 0) {
            g.setColor(brColor);
            if ((which & 4) != 0) {
                g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
            }
            if ((which & 8) != 0) {
                g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
            }
        }
    }

    static void paintFrameC(Graphics g, Rectangle b, int which, Color tlColor, Color brColor, Color bcColor) {
        if ((which & 3) != 0) {
            g.setColor(tlColor);
            if ((which & 1) != 0) {
                g.drawLine(b.x, b.y + 1, 1, b.y + b.height - 1);
            }
            if ((which & 2) != 0) {
                g.drawLine(b.x, b.y, b.x + b.width - 2, b.y);
                g.setColor(bcColor);
                g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y);
            }
        }
        if ((which & 0xC) != 0) {
            g.setColor(brColor);
            if ((which & 4) != 0) {
                g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
            }
            if ((which & 8) != 0) {
                g.drawLine(b.x + 1, b.y + b.height - 1, b.width - 2, b.y + b.height - 1);
                g.setColor(bcColor);
                g.drawLine(b.x, b.y + b.height - 1, b.x, b.y + b.height - 1);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
        OUTER_RAISED = 256;
        OUTER_SUNKEN = 512;
        INNER_RAISED = 1024;
        INNER_SUNKEN = 2048;
        EDGE_RAISED = 1280;
        EDGE_SUNKEN = 2560;
        EDGE_ETCHED = 1536;
        EDGE_BUMP = 2304;
        EDGE_OUTER = 768;
        EDGE_INNER = 3072;
        EDGE_ALL = 3840;
        NONE = 0;
        PLAIN = 1;
        RAISED = 2;
        RECESSED = 3;
        EMBOSSED = 4;
        GROOVED = 5;
        BUTTON_UP = 6;
        BUTTON_DN = 7;
        WND_RAISED = 8;
        WND_RECESSED = 9;
        WELL_SET = 10;
        LEFT = 1;
        TOP = 2;
        RIGHT = 4;
        BOTTOM = 8;
        TOP_LEFT = 3;
        TOP_RIGHT = 6;
        BOTTOM_LEFT = 9;
        BOTTOM_RIGHT = 12;
        RECT = 15;
        FILL = 2048;
        SOFT = 4096;
        FLAT = 16384;
        MONO = 32768;
        edges = new int[]{0, 0, 1024, 2048, 2304, 1536, 1280, 2560, 1280, 2560, 1536};
        flagses = new int[]{0, 0, 0, 0, 0, 0, 4096, 4096, 0, 0, 0};
    }
}

