/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCenter;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCCircularTick;
import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCGaugePickEvent;
import com.klg.jclass.swing.gauge.JCNeedle;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.swing.gauge.RadialConstraint;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class JCCircularGauge
extends JCGauge
implements Serializable {
    static final long serialVersionUID = -1921545230171587587L;
    protected GaugeType gaugeType = GaugeType.FULL_CIRCLE;
    protected JCCenter center;
    protected Vector labels = new Vector();

    public JCCircularGauge() {
        JCCenter jCCenter = new JCCenter(this);
        this.setCenter(jCCenter);
        JCNeedle jCNeedle = new JCNeedle(this);
        this.addNeedle(jCNeedle);
        JCCircularScale jCCircularScale = new JCCircularScale(this);
        this.setScale(jCCircularScale);
        JCCircularTick jCCircularTick = new JCCircularTick(jCCircularScale);
        this.addTick(jCCircularTick);
        this.setPreferredSize(new Dimension(75, 75));
    }

    public JCCircularGauge(GaugeType gaugeType) {
        this.gaugeType = gaugeType;
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, radialConstraint, 0);
    }

    public void addLabel(JComponent jComponent, RadialConstraint radialConstraint, int n) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, radialConstraint, n);
    }

    protected Rectangle getArcBounds() {
        Rectangle rectangle = null;
        int n = (int)this.scale.getRadius();
        int n2 = (int)(this.scale.getRadius() * 2.0);
        int n3 = this.scale.getInsets().top;
        int n4 = this.scale.getInsets().left;
        Rectangle rectangle2 = this.gaugeArea.getBounds();
        if (this.gaugeType.equals(GaugeType.FULL_CIRCLE)) {
            rectangle = new Rectangle(n3, n4, n2, n2);
            rectangle.setLocation((rectangle2.width - rectangle.width) / 2, (rectangle2.height - rectangle.height) / 2);
        } else if (this.gaugeType.equals(GaugeType.TOP_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3, n4, n2, n2);
            rectangle.setLocation((rectangle2.width - rectangle.width) / 2, rectangle.y);
        } else if (this.gaugeType.equals(GaugeType.BOTTOM_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3, -(n - n4), n2, n2);
            rectangle.setLocation((rectangle2.width - rectangle.width) / 2, rectangle.y);
        } else if (this.gaugeType.equals(GaugeType.LEFT_HALF_CIRCLE)) {
            rectangle = new Rectangle(n3, n4, n2, n2);
            rectangle.setLocation(rectangle.x, (rectangle2.height - rectangle.height) / 2);
        } else if (this.gaugeType.equals(GaugeType.RIGHT_HALF_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), n4, n2, n2);
            rectangle.setLocation(rectangle.x, (rectangle2.height - rectangle.height) / 2);
        } else if (this.gaugeType.equals(GaugeType.LOWER_LEFT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(n3, -(n - n4), n2, n2);
        } else if (this.gaugeType.equals(GaugeType.LOWER_RIGHT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), -(n - n4), n2, n2);
        } else if (this.gaugeType.equals(GaugeType.UPPER_RIGHT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(-(n - n3), n4, n2, n2);
        } else if (this.gaugeType.equals(GaugeType.UPPER_LEFT_QUARTER_CIRCLE)) {
            rectangle = new Rectangle(n3, n4, n2, n2);
        }
        return rectangle;
    }

    public JCCenter getCenter() {
        return this.center;
    }

    public JCNeedle getClosestNeedle(JCGaugePickEvent jCGaugePickEvent, JCNeedle.InteractionType interactionType) {
        JCNeedle jCNeedle = null;
        double d = this.valueToAngle(jCGaugePickEvent.getValue());
        Enumeration enumeration = this.needles.elements();
        while (enumeration.hasMoreElements()) {
            JCNeedle jCNeedle2 = (JCNeedle)enumeration.nextElement();
            if (jCNeedle2.getInteractionType() != JCNeedle.InteractionType.CLICK_DRAG && jCNeedle2.getInteractionType() != interactionType) continue;
            if (jCNeedle == null) {
                jCNeedle = jCNeedle2;
                continue;
            }
            double d2 = this.valueToAngle(jCNeedle2.getValue());
            double d3 = this.valueToAngle(jCNeedle.getValue());
            double d4 = GaugeUtil.distanceBetweenAngles(d, d2);
            double d5 = GaugeUtil.distanceBetweenAngles(d, d3);
            if (!(d5 > d4)) continue;
            jCNeedle = jCNeedle2;
        }
        return jCNeedle;
    }

    public GaugeType getGaugeType() {
        return this.gaugeType;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCNeedle jCNeedle;
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null && (jCNeedle = this.getClosestNeedle(jCGaugePickEvent, JCNeedle.InteractionType.CLICK)) != null) {
            jCNeedle.setValue(jCGaugePickEvent.getValue());
            this.redraw();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            if (this.draggedNeedle == null) {
                this.draggedNeedle = this.getClosestNeedle(jCGaugePickEvent, JCNeedle.InteractionType.DRAG);
            }
            if (this.draggedNeedle != null) {
                this.draggedNeedle.setValue(jCGaugePickEvent.getValue());
                this.redraw();
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        this.gaugeArea.doLayout();
        super.paintComponent(graphics);
    }

    public void redraw() {
        if (this.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void removeLabel(JComponent jComponent) {
        if (this.labels.contains(jComponent)) {
            this.labels.removeElement(jComponent);
            this.getGaugeArea().remove(jComponent);
        }
    }

    public void setCenter(JCCenter jCCenter) {
        this.setCenter(jCCenter, 0);
    }

    public void setCenter(JCCenter jCCenter, int n) {
        if (this.center != null) {
            this.gaugeArea.remove(this.center);
        }
        this.center = jCCenter;
        if (jCCenter != null) {
            this.getGaugeArea().add(jCCenter, new RadialConstraint(this, 0.0, 0.0), n);
        }
    }

    public void setGaugeType(GaugeType gaugeType) {
        this.gaugeType = gaugeType;
        if (this.gaugeArea != null) {
            this.gaugeArea.doLayout();
        }
        if (this.scale != null) {
            if (gaugeType == GaugeType.FULL_CIRCLE) {
                this.scale.setStartAngle(0.0);
                this.scale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.TOP_HALF_CIRCLE) {
                this.scale.setStartAngle(0.0);
                this.scale.setStopAngle(180.0);
            } else if (gaugeType == GaugeType.BOTTOM_HALF_CIRCLE) {
                this.scale.setStartAngle(180.0);
                this.scale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.LEFT_HALF_CIRCLE) {
                this.scale.setStartAngle(90.0);
                this.scale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.RIGHT_HALF_CIRCLE) {
                this.scale.setStartAngle(270.0);
                this.scale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.LOWER_LEFT_QUARTER_CIRCLE) {
                this.scale.setStartAngle(180.0);
                this.scale.setStopAngle(270.0);
            } else if (gaugeType == GaugeType.LOWER_RIGHT_QUARTER_CIRCLE) {
                this.scale.setStartAngle(270.0);
                this.scale.setStopAngle(360.0);
            } else if (gaugeType == GaugeType.UPPER_RIGHT_QUARTER_CIRCLE) {
                this.scale.setStartAngle(0.0);
                this.scale.setStopAngle(90.0);
            } else if (gaugeType == GaugeType.UPPER_LEFT_QUARTER_CIRCLE) {
                this.scale.setStartAngle(90.0);
                this.scale.setStopAngle(180.0);
            }
            this.scale.doLayout();
            int n = 0;
            while (n < this.scale.getTicks().size()) {
                JCTick jCTick = (JCTick)this.scale.getTicks().elementAt(n);
                jCTick.doLayout();
                ++n;
            }
        }
        this.redraw();
    }

    protected double valueToAngle(double d) {
        return GaugeUtil.valueToAngle(d, this.scale.getMin(), this.scale.getMax(), this.scale.getStartAngle(), this.scale.getStopAngle());
    }

    public static class GaugeType
    implements Serializable {
        public static final GaugeType FULL_CIRCLE = new GaugeType(0, 360);
        public static final GaugeType TOP_HALF_CIRCLE = new GaugeType(0, 180);
        public static final GaugeType BOTTOM_HALF_CIRCLE = new GaugeType(180, 180);
        public static final GaugeType LEFT_HALF_CIRCLE = new GaugeType(90, 180);
        public static final GaugeType RIGHT_HALF_CIRCLE = new GaugeType(270, 180);
        public static final GaugeType UPPER_RIGHT_QUARTER_CIRCLE = new GaugeType(0, 90);
        public static final GaugeType LOWER_RIGHT_QUARTER_CIRCLE = new GaugeType(270, 90);
        public static final GaugeType UPPER_LEFT_QUARTER_CIRCLE = new GaugeType(90, 90);
        public static final GaugeType LOWER_LEFT_QUARTER_CIRCLE = new GaugeType(180, 90);
        int startAngle;
        int sweepAngle;

        private GaugeType(int n, int n2) {
            this.startAngle = n;
            this.sweepAngle = n2;
        }

        public boolean equals(GaugeType gaugeType) {
            return this.startAngle == gaugeType.startAngle && this.sweepAngle == gaugeType.sweepAngle;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public int getSweepAngle() {
            return this.sweepAngle;
        }
    }
}

