/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularGauge;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.swing.gauge.RadialLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;

public class JCCircularScale
extends JCScale
implements Serializable {
    static final long serialVersionUID = 6835510720826476109L;
    protected double startAngle = 0.0;
    protected double stopAngle = 360.0;
    protected JCCircularGauge gauge;
    protected double minSize = 50.0;
    protected double extent = 1.0;
    protected boolean paintCompleteBackground = false;

    public JCCircularScale(JCCircularGauge jCCircularGauge) {
        this.gauge = jCCircularGauge;
        this.setLayout(new RadialLayout());
        this.setForeground(Color.white);
    }

    public JCCircularScale(JCCircularGauge jCCircularGauge, JCScale.Direction direction, double d, double d2, double d3, double d4, Color color) {
        super(direction, d, d2, color);
        this.gauge = jCCircularGauge;
        this.startAngle = d3;
        this.stopAngle = d4;
        this.setLayout(new RadialLayout());
    }

    public Component add(Component component) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE), n);
        return component;
    }

    public double getExtent() {
        return this.extent;
    }

    public JCCircularGauge getGauge() {
        return this.gauge;
    }

    public boolean getPaintCompleteBackground() {
        return this.paintCompleteBackground;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public double getRadius() {
        int n = this.getParent().getBounds().width;
        int n2 = this.getParent().getBounds().height;
        Insets insets = this.getParent().getInsets();
        Insets insets2 = this.getInsets();
        double d = Math.max(this.minSize, (double)Math.min(n -= insets2.left + insets2.right + insets.left + insets.right, n2 -= insets2.top + insets.top + insets2.bottom + insets.bottom));
        JCCircularGauge.GaugeType gaugeType = this.gauge.getGaugeType();
        if (gaugeType.equals(JCCircularGauge.GaugeType.FULL_CIRCLE)) {
            d /= 2.0;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.TOP_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.BOTTOM_HALF_CIRCLE)) {
            while (n / 2 > n2) {
                --n;
            }
            d = n / 2;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.LEFT_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.RIGHT_HALF_CIRCLE)) {
            while (n2 / 2 > n) {
                --n2;
            }
            d = n2 / 2;
        }
        return d;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getStopAngle() {
        return this.stopAngle;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        double d = this.startAngle;
        double d2 = this.stopAngle;
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        int n2 = this.gauge.getArcBounds().x;
        int n3 = this.gauge.getArcBounds().y;
        int n4 = this.gauge.getArcBounds().width;
        int n5 = this.gauge.getArcBounds().height;
        n2 += (n4 - (int)((double)n4 * this.extent)) / 2;
        n3 += (n5 - (int)((double)n5 * this.extent)) / 2;
        n4 = (int)((double)n4 * this.extent);
        n5 = (int)((double)n5 * this.extent);
        if (this.getPaintCompleteBackground()) {
            d = this.gauge.getGaugeType().getStartAngle();
            n = this.gauge.getGaugeType().getSweepAngle();
        } else {
            if (d >= d2) {
                d2 += 360.0;
            }
            n = (int)GaugeUtil.arcAngle(d, d2);
        }
        graphics2.fillArc(n2, n3, n4, n5, (int)d, n);
        graphics2.dispose();
    }

    public double pick(Point point) {
        int n;
        int n2;
        double d;
        double d2 = 0.0;
        double d3 = this.stopAngle;
        boolean bl = false;
        if (this.getStartAngle() == this.getStopAngle()) {
            d3 += 360.0;
            bl = true;
        }
        if ((d = GaugeUtil.pointToAngle(n2 = point.x - this.gauge.getArcBounds().x, n = point.y - this.gauge.getArcBounds().y, this.getRadius(), this.getRadius())) < this.startAngle) {
            d += 360.0;
        }
        d2 = GaugeUtil.angleToValue(d, this.min, this.max, this.startAngle, d3);
        if (this.getDirection().equals(JCScale.Direction.CLOCKWISE)) {
            d2 = this.max - d2 + this.min;
        }
        return d2;
    }

    public void redraw() {
        if (this.gauge.getRepaintEnabled() && this.gauge.isShowing()) {
            Enumeration enumeration = this.gauge.getTicks().elements();
            while (enumeration.hasMoreElements()) {
                JCTick jCTick = (JCTick)enumeration.nextElement();
                jCTick.redraw(true);
            }
            this.repaint();
        }
    }

    public void setExtent(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.extent = d;
        this.redraw();
    }

    public void setPaintCompleteBackground(boolean bl) {
        this.paintCompleteBackground = bl;
        this.redraw();
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.redraw();
    }

    public void setStopAngle(double d) {
        this.stopAngle = d;
        this.redraw();
    }
}

