/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.DefaultLegendPopulatorRenderer;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCGaugeArea;
import com.klg.jclass.swing.gauge.JCGaugePickEvent;
import com.klg.jclass.swing.gauge.JCGaugePickListener;
import com.klg.jclass.swing.gauge.JCNeedle;
import com.klg.jclass.swing.gauge.JCRange;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.util.DefaultComponentLayout;
import com.klg.jclass.util.DefaultComponentLayoutUser;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCGauge
extends JComponent
implements MouseListener,
MouseMotionListener,
DefaultComponentLayoutUser,
Serializable {
    static final long serialVersionUID = 1763099717300034832L;
    protected JCGaugeArea gaugeArea;
    protected JComponent header;
    protected JComponent footer;
    protected JCLegend legend;
    protected JCCircularScale scale;
    protected Vector needles;
    protected JCListenerList pickListeners = null;
    protected JCNeedle draggedNeedle = null;
    protected Vector ranges;
    protected boolean snapToValue = false;
    protected boolean repaintEnabled = true;
    protected Rectangle gaugeAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public JCGauge() {
        this.init();
    }

    public void addNeedle(JCNeedle jCNeedle) {
        this.needles.addElement(jCNeedle);
        this.gaugeArea.add(jCNeedle);
    }

    public void addNeedle(JCNeedle jCNeedle, int n) {
        this.needles.addElement(jCNeedle);
        this.gaugeArea.add((Component)jCNeedle, n);
    }

    public void addPickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCGaugePickListener);
    }

    public void addRange(JCRange jCRange) {
        this.addRange(jCRange, 0);
    }

    public void addRange(JCRange jCRange, int n) {
        this.ranges.addElement(jCRange);
        this.scale.add((Component)jCRange, n);
    }

    public void addTick(JCTick jCTick) {
        this.scale.addTick(jCTick);
    }

    public void addTick(JCTick jCTick, int n) {
        this.scale.addTick(jCTick, n);
    }

    public JComponent getComponentArea() {
        return this.getGaugeArea();
    }

    public int getDrawingAreaHeight() {
        Insets insets = this.getInsets();
        int n = 0;
        if (insets != null) {
            n = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n);
    }

    public int getDrawingAreaWidth() {
        Insets insets = this.getInsets();
        int n = 0;
        if (insets != null) {
            n = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n);
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public JCGaugeArea getGaugeArea() {
        return this.gaugeArea;
    }

    public JComponent getHeader() {
        return this.header;
    }

    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == this.gaugeArea) {
            return this.gaugeAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return null;
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public Vector getNeedles() {
        return this.needles;
    }

    public Vector getRanges() {
        return this.ranges;
    }

    public boolean getRepaintEnabled() {
        return this.repaintEnabled;
    }

    public JCCircularScale getScale() {
        return this.scale;
    }

    public boolean getSnapToValue() {
        return this.snapToValue;
    }

    public Vector getTicks() {
        return this.scale.getTicks();
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new DefaultComponentLayout());
        this.header = new JLabel();
        this.header.setVisible(false);
        this.add(this.header);
        this.gaugeArea = new JCGaugeArea(this);
        this.add(this.gaugeArea);
        this.footer = new JLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
        this.legend = new JCGridLegend();
        this.legend.setVisible(false);
        this.add(this.legend);
        this.needles = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ranges = new Vector();
        DefaultLegendPopulatorRenderer defaultLegendPopulatorRenderer = new DefaultLegendPopulatorRenderer(this.legend, this.ranges);
        this.legend.setLegendPopulator(defaultLegendPopulatorRenderer);
        this.legend.setLegendRenderer(defaultLegendPopulatorRenderer);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.draggedNeedle = null;
    }

    public JCGaugePickEvent pick(Point point) {
        JCGaugePickEvent jCGaugePickEvent = null;
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (!(component instanceof JCLegend) && component instanceof JCGaugeArea) {
            double d = this.scale.pick(point2);
            if (this.snapToValue) {
                d = Math.round(d);
            }
            if (!this.scale.inBounds((jCGaugePickEvent = new JCGaugePickEvent(this, component, d, point2)).getValue())) {
                jCGaugePickEvent = null;
            }
        }
        return jCGaugePickEvent;
    }

    public void removeNeedle(JCNeedle jCNeedle) {
        if (this.needles.contains(jCNeedle)) {
            this.needles.removeElement(jCNeedle);
            this.gaugeArea.remove(jCNeedle);
        }
    }

    public void removePickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCGaugePickListener);
    }

    public void removeRange(JCRange jCRange) {
        if (this.ranges.contains(jCRange)) {
            this.ranges.removeElement(jCRange);
            this.scale.remove(jCRange);
        }
    }

    public void removeTick(JCTick jCTick) {
        this.scale.removeTick(jCTick);
    }

    public void sendPickEvent(JCGaugePickEvent jCGaugePickEvent) {
        Enumeration enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCGaugePickListener)enumeration.nextElement()).pick(jCGaugePickEvent);
        }
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
    }

    public void setGaugeArea(JCGaugeArea jCGaugeArea) {
        if (jCGaugeArea == null) {
            return;
        }
        if (this.gaugeArea != null) {
            this.remove(this.gaugeArea);
        }
        this.gaugeArea = jCGaugeArea;
        this.add(this.gaugeArea);
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        this.add(this.legend);
    }

    public void setRepaintEnabled(boolean bl) {
        this.repaintEnabled = bl;
        if (bl) {
            this.repaint();
        }
    }

    public void setScale(JCCircularScale jCCircularScale) {
        if (this.scale != null) {
            this.gaugeArea.remove(this.scale);
        }
        this.scale = jCCircularScale;
        this.gaugeArea.add(jCCircularScale);
    }

    public void setSnapToValue(boolean bl) {
        this.snapToValue = bl;
    }
}

