/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TreeWithSortableChildren
implements JCTreeTableModel,
JCRowSortModel,
Serializable {
    protected JCTreeTableModel treetable;
    protected int sortColumn = -1;
    protected int sortOrder = 1;
    protected JCRowComparator rowComparator = new DefaultRowComparator(1);
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = new RowIntComparator();
    protected HashMap nodeChildIndexMaps = null;
    protected boolean autoSort = true;
    protected boolean needsResorting = true;
    protected boolean needsReordering = false;
    protected JCListenerList listeners = null;

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel) {
        this.setModel(jCTreeTableModel);
    }

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel, JCRowComparator jCRowComparator) {
        this(jCTreeTableModel);
        this.rowComparator = jCRowComparator;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.add(this.listeners, treeModelListener);
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public Object getChild(Object object, int n) {
        int[] nArray = this.getIndices(object);
        if (nArray != null) {
            n = this.sortOrder == 1 ? nArray[n] : nArray[nArray.length - n - 1];
        }
        return this.treetable.getChild(object, n);
    }

    public int getChildCount(Object object) {
        return this.treetable.getChildCount(object);
    }

    public Class getColumnClass(int n) {
        return this.treetable.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (this.nodeChildIndexMaps == null) {
            return this.treetable.getIndexOfChild(object, object2);
        }
        int[] nArray = this.getIndices(object);
        if (nArray == null) {
            return this.treetable.getIndexOfChild(object, object2);
        }
        int n = 0;
        while (n < nArray.length) {
            if (this.treetable.getChild(object, n) == object2) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Node not child of specified parent");
    }

    protected int[] getIndices(Object object) {
        int n = this.treetable.getChildCount(object);
        if (this.sortColumn == -1 || n == 0) {
            return null;
        }
        HashObject hashObject = new HashObject(object);
        int[] nArray = (int[])this.nodeChildIndexMaps.get(hashObject);
        if (nArray == null) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n2;
                ++n2;
            }
            this.rowIntComparator.parent = object;
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
            }
            int[] nArray2 = new int[]{this.sortColumn};
            this.rowComparator.setKeyColumns(this.keyColumnsArray[this.sortColumn] != null ? this.keyColumnsArray[this.sortColumn] : nArray2);
            JCMappingSort.sort(this.rowIntComparator, nArray);
            this.nodeChildIndexMaps.put(hashObject, nArray);
        }
        return nArray;
    }

    public int[] getKeyColumns(int n) {
        return this.keyColumnsArray[n];
    }

    public JCTreeTableModel getModel() {
        return this.treetable;
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    public Object getRoot() {
        return this.treetable.getRoot();
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public Object getValueAt(Object object, int n) {
        return this.treetable.getValueAt(object, n);
    }

    public boolean isCellEditable(Object object, int n) {
        return this.treetable.isCellEditable(object, n);
    }

    public boolean isDataSorted() {
        return this.nodeChildIndexMaps != null;
    }

    public boolean isLeaf(Object object) {
        return this.treetable.isLeaf(object);
    }

    protected void postTreeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent == null) {
            treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.treetable.getRoot()), null, null);
        }
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, treeModelListener);
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    public void setDataSorted(boolean bl) {
        if (bl && this.sortColumn == -1) {
            return;
        }
        if (!bl && this.isDataSorted()) {
            this.needsReordering = true;
            this.sortColumn = -1;
        }
        if (this.needsResorting || this.needsReordering) {
            if (this.needsResorting) {
                this.nodeChildIndexMaps = new HashMap();
                this.needsReordering = false;
            }
            this.postTreeStructureChanged(null);
            this.needsResorting = false;
        }
    }

    public void setKeyColumns(int n, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
        }
        this.keyColumnsArray[n] = nArray;
        this.needsResorting = true;
    }

    public void setModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == this.treetable) {
            return;
        }
        this.treetable = jCTreeTableModel;
        jCTreeTableModel.addTreeModelListener(new Listener());
    }

    public void setSortColumn(int n) {
        if (this.sortColumn == n) {
            return;
        }
        if (this.treetable.getColumnCount() <= n) {
            throw new IllegalArgumentException("index value greater than number of columns");
        }
        this.sortColumn = n;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void setSortOrder(int n) {
        this.sortOrder = n;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void setValueAt(Object object, Object object2, int n) {
        this.treetable.setValueAt(object, object2, n);
    }

    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.treetable.valueForPathChanged(treePath, object);
    }

    class Listener
    implements TreeModelListener {
        Listener() {
        }

        protected TreeModelEvent convertTreeEvent(TreeModelEvent treeModelEvent) {
            return new TreeModelEvent((Object)TreeWithSortableChildren.this, treeModelEvent.getTreePath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = null;
            if (treeModelEvent == null) {
                treeModelEvent2 = new TreeModelEvent((Object)TreeWithSortableChildren.this, new TreePath(TreeWithSortableChildren.this.treetable.getRoot()), null, null);
            }
            if (TreeWithSortableChildren.this.nodeChildIndexMaps == null && (treeModelEvent2 = this.convertTreeEvent(treeModelEvent)) == null) {
                return;
            }
            if (treeModelEvent2 != null) {
                Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
                while (enumeration.hasMoreElements()) {
                    TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                    treeModelListener.treeNodesChanged(treeModelEvent2);
                }
            } else {
                TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
                this.treeNodesChanged(null);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent2);
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent2);
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = new TreeModelEvent((Object)TreeWithSortableChildren.this, treeModelEvent.getTreePath());
            TreeWithSortableChildren.this.postTreeStructureChanged(treeModelEvent);
        }
    }

    public static class HashObject {
        WeakReference weak;

        public HashObject(Object object) {
            this.weak = new WeakReference<Object>(object);
        }

        public boolean equals(Object object) {
            Object t = this.weak.get();
            Object var3_3 = null;
            if (object != null) {
                var3_3 = ((HashObject)object).weak.get();
            }
            if (t == null) {
                return false;
            }
            return t == var3_3;
        }

        public int hashCode() {
            Object t = this.weak.get();
            if (t == null) {
                return 0;
            }
            return t.hashCode();
        }
    }

    class ComparableRow
    implements JCComparableRow {
        public Object node = null;
        public int row;

        ComparableRow() {
        }

        public int getRowIndex() {
            return this.row;
        }

        public Object getValueAt(int n) {
            return TreeWithSortableChildren.this.treetable.getValueAt(this.node, n);
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        protected ComparableRow r1;
        protected ComparableRow r2;
        public Object parent;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
            this.parent = null;
        }

        public int compare(int n, int n2) {
            this.r1.row = n;
            this.r1.node = TreeWithSortableChildren.this.treetable.getChild(this.parent, n);
            this.r2.row = n2;
            this.r2.node = TreeWithSortableChildren.this.treetable.getChild(this.parent, n2);
            return TreeWithSortableChildren.this.rowComparator.compare(this.r1, this.r2);
        }
    }
}

