/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import uk.ac.vamsas.client.IVorbaIdFactory;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.Vobjhash;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.VorbaIdFactory;
import uk.ac.vamsas.objects.core.VamsasDocument;

public class VorbaXmlBinder
implements UnmarshalListener {
    private static Log log = LogFactory.getLog((Class)VorbaXmlBinder.class);
    private final IVorbaIdFactory vorbafactory;
    private final Vector obj;
    private final Hashtable oldobjhashes;
    private final Hashtable objrefs;
    private final Vector updatedobjs;

    public VorbaXmlBinder(IVorbaIdFactory vorbafactory2, Vector unrefedObj, Hashtable objrefs2, Hashtable oldobjhashes, Vector updatedObj) {
        this.vorbafactory = vorbafactory2;
        this.obj = unrefedObj;
        this.objrefs = objrefs2;
        this.oldobjhashes = oldobjhashes;
        this.updatedobjs = updatedObj;
    }

    public void attributesProcessed(Object object) {
    }

    public void fieldAdded(String fieldName, Object parent, Object child) {
        if (parent instanceof Vobject && child instanceof Vobject && ((Vobject)child).V_parent == null) {
            ((Vobject)child).setV_parent((Vobject)parent);
        }
    }

    public void initialized(Object object) {
        if (object instanceof Vobject) {
            Vobject vobject = (Vobject)object;
        }
    }

    public void unmarshalled(Object newobj) {
        if (newobj instanceof Vobject) {
            Vobject nobj = (Vobject)newobj;
            nobj.set__stored_in_document(true);
            try {
                if (nobj.isRegisterable() && nobj.___id_field != null) {
                    VorbaId nobj_id = null;
                    nobj.__vorba = this.vorbafactory;
                    String idstring = nobj.__getInstanceIdField();
                    if (idstring != null) {
                        if (idstring.length() > 0) {
                            nobj.setVorbaId(VorbaId.newId(idstring));
                            nobj_id = nobj.getVorbaId();
                            if (this.objrefs.containsKey(nobj_id) && !this.objrefs.get(nobj_id).equals(nobj)) {
                                System.err.println("Serious problem : duplicate id '" + idstring + "' found! expect badness.");
                            }
                            this.objrefs.put(nobj_id, nobj);
                        } else {
                            this.obj.add(nobj);
                        }
                    } else {
                        this.obj.add(nobj);
                    }
                    nobj.doHash();
                    if (nobj_id != null) {
                        if (this.oldobjhashes.containsKey(nobj_id)) {
                            Vobjhash oldhash = (Vobjhash)this.oldobjhashes.get(nobj_id);
                            if (oldhash.isUpdated(nobj)) {
                                nobj.set__updated_since_last_read(true);
                                this.updatedobjs.addElement(nobj);
                            }
                        } else {
                            nobj.set__added_since_last_read(true);
                        }
                        this.oldobjhashes.put(nobj_id, new Vobjhash(nobj));
                    } else {
                        nobj.set__added_since_last_read(true);
                    }
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static void putVamsasDocument(PrintWriter outstream, VorbaIdFactory vorba, VamsasDocument doc) throws IOException, MarshalException, ValidationException {
        if (vorba == null) {
            throw new Error("Null VorbaIdFactory Parameter");
        }
        if (doc.__vorba == null) {
            doc.__vorba = vorba;
        }
        doc.__ensure_instance_ids();
        Marshaller mshl = new Marshaller((Writer)outstream);
        mshl.marshal((Object)doc);
    }

    private static boolean ensure_references(Vector unrefed, Hashtable objrefs) {
        boolean sync = true;
        if (unrefed.size() > 0) {
            sync = false;
            ListIterator newobj = unrefed.listIterator();
            while (newobj.hasNext()) {
                Vobject o = (Vobject)newobj.next();
                VorbaId id = o.getVorbaId();
                if (!objrefs.containsKey(id)) {
                    objrefs.put(id, o);
                    continue;
                }
                if (objrefs.get(id).equals(o)) continue;
                throw new Error("Serious! Duplicate reference made by vorbaIdFactory!");
            }
        }
        return sync;
    }

    public static Object[] getVamsasObjects(Reader instream, VorbaIdFactory factory, Vobject root) {
        Unmarshaller unmarshaller = new Unmarshaller((Object)root);
        unmarshaller.setIDResolver(new IDResolver(){

            public Object resolve(String id) {
                log.warn((Object)("Warning - id " + id + " is not found in the Vamsas XML! (TODO: Ignore if this is a forward reference!)"));
                return null;
            }
        });
        Hashtable objrefs = new Hashtable();
        if (factory.extanthashv == null) {
            factory.extanthashv = new Hashtable();
        }
        Hashtable oobjhashes = factory.extanthashv;
        VorbaIdFactory vorbafactory = factory;
        Vector unrefedObj = new Vector();
        Vector updatedObj = new Vector();
        unmarshaller.setUnmarshalListener((UnmarshalListener)new VorbaXmlBinder(vorbafactory, unrefedObj, objrefs, oobjhashes, updatedObj));
        try {
            if (instream.ready()) {
                Object obj = unmarshaller.unmarshal(instream);
                boolean sync = VorbaXmlBinder.ensure_references(unrefedObj, objrefs);
                if (!(obj instanceof Vobject)) {
                    return null;
                }
                vorbafactory.setNewIdHash(objrefs);
                return new Object[]{obj, objrefs, new Boolean(sync), updatedObj};
            }
        }
        catch (MarshalException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

