/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.picking;

import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.objects.core.Input;
import uk.ac.vamsas.objects.core.Pos;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;

public class SelectionMessage
extends Message {
    private String selectionID;
    private String[] vorbaIDs;
    RangeType ranges;

    public SelectionMessage(String str) {
        block11: {
            int i;
            String[] segs;
            block10: {
                this.message = str;
                String[] elements = str.split("\t");
                String[] positions = null;
                segs = null;
                for (i = 0; i < elements.length; ++i) {
                    if (elements[i].startsWith("selectionID=")) {
                        this.selectionID = elements[i].substring(12);
                    }
                    if (elements[i].startsWith("vorbaIDs=")) {
                        this.vorbaIDs = elements[i].substring(8).split("|");
                    }
                    if (elements[i].startsWith("positions=")) {
                        positions = elements[i].substring(10).split(",");
                    }
                    if (!elements[i].startsWith("ranges=")) continue;
                    segs = elements[i].substring(7).split(",");
                }
                if (positions == null) break block10;
                this.ranges = new Input();
                for (i = 0; i < positions.length; ++i) {
                    Pos p = new Pos();
                    try {
                        p.setI(Integer.parseInt((String)positions[i]));
                        this.ranges.addPos(p);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                break block11;
            }
            if (segs == null) break block11;
            this.ranges = new Input();
            for (i = 0; i < segs.length; i += 2) {
                Seg s = new Seg();
                s.setInclusive(segs[i].startsWith("["));
                try {
                    s.setStart(Integer.parseInt(segs[i].substring(1)));
                    s.setEnd(Integer.parseInt(segs[i + 1]));
                    this.ranges.addSeg(s);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public SelectionMessage(String selectionID, String[] vorbaIDs, RangeType ranges) {
        this.selectionID = selectionID;
        if (selectionID != null && selectionID.indexOf("\t") > -1) {
            throw new Error("VAMSAS Selection Messages are not allowed to have Tab Characters in their selection ID");
        }
        this.vorbaIDs = vorbaIDs;
        this.ranges = ranges;
        StringBuffer message = new StringBuffer();
        message.append("SELECTION\t");
        if (selectionID != null) {
            message.append("selectionID=" + selectionID);
            message.append("\t");
        }
        message.append("vorbaIDs=");
        for (int ids = 0; ids < vorbaIDs.length; ++ids) {
            if (ids > 0) {
                message.append("|");
            }
            if (vorbaIDs[ids] == null) {
                throw new Error("null vorbaID in SelectionMessage ID vector.(" + ids + ")");
            }
            if (vorbaIDs[ids].indexOf("\t") > -1) {
                throw new Error("Invalid vorbaID string in SelectionMessage ID vector. (" + vorbaIDs[ids] + ")");
            }
            message.append(vorbaIDs[ids]);
        }
        if (ranges != null) {
            if (ranges.getPosCount() > 0) {
                message.append("\tpositions=");
                Pos[] pos = ranges.getPos();
                for (int p = 0; p < pos.length; ++p) {
                    if (p > 0) {
                        message.append(",");
                    }
                    message.append(pos[p].getI());
                }
            } else if (ranges.getSegCount() > 0) {
                message.append("\tranges=");
                Seg[] rng = ranges.getSeg();
                for (int p = 0; p < rng.length; ++p) {
                    boolean inc = rng[p].getInclusive();
                    if (p > 0) {
                        message.append(",");
                    }
                    if (inc) {
                        message.append("[");
                    } else {
                        message.append("(");
                    }
                    message.append(rng[p].getStart());
                    message.append(",");
                    message.append(rng[p].getEnd());
                }
            }
        }
        message.append("\n");
        this.message = message.toString();
    }

    public String getSelectionID() {
        return this.selectionID;
    }

    public String[] getVorbaIDs() {
        return this.vorbaIDs;
    }

    public RangeType getRanges() {
        return this.ranges;
    }
}

