/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.LockedFileOutputStream;
import uk.ac.vamsas.client.simpleclient.NativeLock;

public class FileLock
extends Lock {
    private File _lock = null;
    protected static String _LockSuffix = "lck";
    private NativeLock advisory = null;

    private boolean ensureLockFile(boolean block) {
        block4: {
            if (this._lock == null) {
                return false;
            }
            if (this.advisory != null && this.advisory.isLocked()) {
                return true;
            }
            try {
                this.advisory = new NativeLock(this._lock, block);
            }
            catch (Exception e) {
                if (this._lock.exists()) break block4;
                this.log.fatal((Object)("Failed to create advisory lock file " + this._lock), (Throwable)e);
                throw new Error("Failed to create advisory lock file " + this._lock);
            }
        }
        return this.advisory != null && this.advisory.isLocked();
    }

    private void tidy() {
        if (this._lock != null) {
            if (this.advisory != null) {
                if (this.advisory.target != null) {
                    this.advisory.target.deleteOnExit();
                }
                this.advisory.release(true);
            }
            this.advisory = null;
            this._lock = null;
        }
    }

    public FileLock(File lockfile, boolean block) {
        super(lockfile);
        try {
            this._lock = this.make_lockForTarget(lockfile);
            if (!this.ensureLockFile(block)) {
                this.log.debug((Object)("Couldn't get lock on " + this._lock));
                this.tidy();
                return;
            }
            if (!lockfile.exists() && !lockfile.createNewFile()) {
                this.log.warn((Object)("Failed to create locked file " + lockfile));
                return;
            }
        }
        catch (FileNotFoundException e) {
            this.log.debug((Object)("FileLock failed with target=" + lockfile + " and lockfile suffix of " + _LockSuffix));
        }
        catch (IOException e) {
            this.log.error((Object)("Error! Problems with IO when creating a lock on " + lockfile.getAbsolutePath()), (Throwable)e);
        }
    }

    private File make_lockForTarget(File lockfile) {
        return new File(lockfile.getParentFile(), lockfile.getName() + "." + _LockSuffix);
    }

    private boolean openRaFile() throws IOException {
        if (this.target == null) {
            return false;
        }
        if (this.advisory == null || !this.advisory.isLocked()) {
            return false;
        }
        if (this.rafile == null || this.rafile.getFD() == null || !this.rafile.getFD().valid()) {
            this.rafile = new RandomAccessFile(this.target, "rw");
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reusing existing RandomAccessFile on " + this.target));
        }
        return this.rafile.getChannel() != null && this.rafile.getChannel().isOpen();
    }

    public boolean isLocked() {
        if (this.advisory != null) {
            if (this.advisory.isLocked()) {
                return true;
            }
            this.advisory = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Lockfile " + this._lock + " unexpectedly deleted ?"));
            }
        }
        return false;
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean closeChannel) {
        if (!this.isLocked()) {
            return;
        }
        if (this.rafile != null) {
            if (closeChannel) {
                try {
                    this.rafile.close();
                }
                catch (Exception e) {
                    this.log.debug((Object)("Unexpected exception whilst closing RandomAccessFile on " + this.target), (Throwable)e);
                }
                this.rafile = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Releasing advisory lock on " + this.target));
            }
        }
        this.tidy();
    }

    public FileInputStream getFileInputStream(boolean atStart) throws IOException {
        if (!this.isLocked()) {
            this.log.debug((Object)("Don't hold lock on " + this.target + " to get locked FileInputStream."));
            return null;
        }
        this.openRaFile();
        if (atStart) {
            this.rafile.seek(0L);
        }
        return new FileInputStream(this.rafile.getFD());
    }

    public FileOutputStream getFileOutputStream(boolean clear) throws IOException {
        if (!this.isLocked()) {
            this.log.debug((Object)("Don't hold lock on " + this.target + " to get locked FileOutputStream."));
            return null;
        }
        this.openRaFile();
        if (clear) {
            this.rafile.seek(0L);
            this.rafile.setLength(0L);
        } else {
            this.rafile.seek(this.rafile.length());
        }
        return new LockedFileOutputStream(this.rafile.getFD());
    }

    public BufferedOutputStream getBufferedOutputStream(boolean clear) throws IOException {
        this.log.debug((Object)("Getting BufferedOutputStream (clear=" + clear + ")"));
        FileOutputStream fos = this.getFileOutputStream(clear);
        if (fos != null) {
            return new BufferedOutputStream(fos);
        }
        return null;
    }

    public long length() {
        if (this.isLocked()) {
            if (!this.target.exists()) {
                try {
                    this.target.createNewFile();
                }
                catch (Exception e) {
                    this.log.error((Object)("Invalid lock:Failed to create target file " + this.target));
                    this.tidy();
                    return -1L;
                }
                return 0L;
            }
            return this.target.length();
        }
        return -1L;
    }

    protected void finalize() throws Throwable {
        this.release(true);
        super.finalize();
    }

    public RandomAccessFile getRaFile() throws IOException {
        if (this.isLocked() && this.openRaFile()) {
            return this.rafile;
        }
        this.log.debug((Object)("Failed to getRaFile on target " + this.target));
        return null;
    }

    public FileChannel getRaChannel() throws IOException {
        if (this.isLocked() && this.openRaFile()) {
            return this.rafile.getChannel();
        }
        this.log.debug((Object)("Failed to getRaChannel on target " + this.target));
        return null;
    }

    public boolean isTargetLockFile(File afile) {
        return this.isLocked() && (this.target.equals(afile) || this.make_lockForTarget(this.target).equals(afile));
    }
}

