/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.util.Enumeration;
import java.util.Vector;
import uk.ac.vamsas.objects.core.Property;

public class Properties {
    public static final String STRINGTYPE = "string";
    public static final String FLOATTYPE = "float";
    public static final String INTEGERTYPE = "integer";
    public static final String BOOLEANTYPE = "boolean";

    public static Property newProperty(String name, String type, String content) {
        Property vProperty = new Property();
        vProperty.setName(name);
        if (type != null) {
            vProperty.setType(type);
        } else {
            vProperty.setType(STRINGTYPE);
        }
        vProperty.setContent(content);
        return vProperty;
    }

    public static boolean addOrReplace(Vector properties, Property newprop) {
        if (properties.size() > 0) {
            Enumeration en = properties.elements();
            while (en.hasMoreElements()) {
                Object el = en.nextElement();
                if (el instanceof Property) {
                    Property prop = (Property)el;
                    if (!prop.getName().equals(newprop.getName()) || !prop.getType().equals(newprop.getType())) continue;
                    if (prop.getContent().equals(newprop.getContent())) {
                        return false;
                    }
                    prop.setContent(newprop.getContent());
                    return true;
                }
                throw new Error("Implementation Error: properties must be a Vector of uk.ac.vamsas.objects.core.Property objects only.");
            }
        }
        properties.addElement(newprop);
        return true;
    }

    public static boolean isValid(Property p) {
        if (p.getType().equalsIgnoreCase(STRINGTYPE)) {
            return true;
        }
        if (p.getType().equalsIgnoreCase(BOOLEANTYPE)) {
            try {
                Boolean bool = new Boolean(p.getContent());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (p.getType().equalsIgnoreCase(FLOATTYPE)) {
            try {
                Float fv = new Float(p.getContent());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (p.getType().equalsIgnoreCase(INTEGERTYPE)) {
            try {
                Integer fv = new Integer(p.getContent());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isString(Property p) {
        return Properties.isType(p, STRINGTYPE);
    }

    public static boolean isFloat(Property p) {
        return Properties.isType(p, FLOATTYPE);
    }

    public static boolean isInteger(Property p) {
        return Properties.isType(p, INTEGERTYPE);
    }

    public static boolean isBoolean(Property p) {
        return Properties.isType(p, BOOLEANTYPE);
    }

    public static boolean isType(Property p, String typeString) {
        return p == null ? false : p.getType().toLowerCase().equals(typeString);
    }
}

