/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.InputStream;
import java.io.PrintStream;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.objects.core.Alignment;
import uk.ac.vamsas.objects.core.AppData;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Instance;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.Tree;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;

public class ArchiveReports {
    public static boolean reportProvenance(Provenance p, PrintStream outstr) {
        if (p == null) {
            outstr.println("No Provenance");
            return false;
        }
        Entry[] pe = p.getEntry();
        for (int i = 0; i < pe.length; ++i) {
            outstr.print(pe[i].getDate() + "\t'" + pe[i].getUser() + "'\t" + pe[i].getApp() + "\t'" + pe[i].getAction() + "' ");
            ArchiveReports.outputVobjectState(pe[i], outstr);
        }
        return true;
    }

    public static boolean appDataEntryReport(AppData appD, VamsasArchiveReader archive, boolean cascade, PrintStream outstr) {
        if (appD != null) {
            boolean nulldata = false;
            if (appD.getDataReference() != null) {
                String appData = appD.getDataReference();
                if (appData == null) {
                    outstr.println("Empty DataReference - not valid ?");
                } else if (appData.length() > 1) {
                    outstr.print("a reference (" + appData + ")");
                    InputStream jstrm = archive.getAppdataStream(appData);
                    if (jstrm != null) {
                        outstr.println(" which resolves to a JarEntry.");
                    } else {
                        outstr.println(" which does not resolve to a JarEntry.");
                        outstr.println("Unresolved appdata reference '" + appData + "'");
                    }
                } else {
                    nulldata = true;
                }
            } else if (appD.getData() == null) {
                nulldata &= true;
            } else {
                outstr.println("an embedded chunk of " + appD.getData().length + " bytes.");
            }
            if (nulldata) {
                outstr.println("Null AppData reference/data chunk.");
            }
        }
        return true;
    }

    public static boolean appDataReport(ApplicationData appD, VamsasArchiveReader archive, boolean cascade, PrintStream outstr) {
        if (appD != null) {
            int i;
            int j;
            ArchiveReports.appDataEntryReport(appD, archive, cascade, outstr);
            if (appD.getInstanceCount() > 0) {
                Instance[] inst = appD.getInstance();
                j = inst.hashCode();
                for (i = 0; i < j; ++i) {
                    outstr.println("Data for App Instance URN: '" + inst[i].getUrn());
                    ArchiveReports.appDataEntryReport(inst[i], archive, cascade, outstr);
                }
            }
            if (appD.getUserCount() > 0) {
                User[] users = appD.getUser();
                j = users.length;
                for (i = 0; i < j; ++i) {
                    outstr.println("Data for User '" + users[i].getFullname() + "' of '" + users[i].getOrganization() + "'");
                    ArchiveReports.appDataEntryReport(users[i], archive, cascade, outstr);
                }
            }
        }
        return true;
    }

    public static boolean reportDocument(VamsasDocument document, VamsasArchiveReader archive, boolean cascade, PrintStream outstr) {
        if (document != null) {
            outstr.println("Vamsas Document version '" + document.getVersion() + "'");
            ArchiveReports.reportProvenance(document.getProvenance(), outstr);
            outstr.print("Document contains " + document.getVAMSASCount() + " VAMSAS Elements and " + document.getApplicationDataCount() + " Application data elements.\n");
            if (document.getVAMSASCount() > 0 && cascade) {
                ArchiveReports.rootReport(document.getVAMSAS(), true, outstr);
            }
            if (document.getApplicationDataCount() > 0) {
                outstr.print("There are " + document.getApplicationDataCount() + " ApplicationData references.\n");
                ApplicationData[] appd = document.getApplicationData();
                int j = appd.length;
                for (int i = 0; i < j; ++i) {
                    outstr.print("Application " + i + ": '" + appd[i].getName() + "'\nVersion '" + appd[i].getVersion() + "'\n");
                    outstr.print("AppData is :");
                    ArchiveReports.appDataReport(appd[i], archive, cascade, outstr);
                }
            }
            return true;
        }
        outstr.println("Document Object is null");
        return false;
    }

    public static boolean rootReport(VAMSAS[] roots, boolean cascade, PrintStream outstr) {
        if (roots != null) {
            for (int i = 0; i < roots.length; ++i) {
                int j;
                VAMSAS r = roots[i];
                int ds = r.getDataSetCount();
                int tr = r.getTreeCount();
                outstr.print("Vamsas Root " + i + " (id=" + (r.getId() != null ? r.getId() : "<none>") + ") contains " + ds + " DataSets, " + tr + " Global trees\n");
                ArchiveReports.outputVobjectState(r, outstr);
                if (!cascade) continue;
                for (j = 0; j < ds; ++j) {
                    outstr.println("Dataset " + j);
                    cascade = ArchiveReports.datasetReport(r.getDataSet(j), true, outstr) && cascade;
                }
                for (j = 0; j < tr; ++j) {
                    outstr.println("Global tree " + j);
                    cascade = ArchiveReports.treeReport(r.getTree(j), true, outstr) && cascade;
                }
            }
            return true;
        }
        return false;
    }

    public static void outputVobjectState(Vobject v, PrintStream outstr) {
        outstr.print(" (Object is: ");
        boolean comma = false;
        if (v.is__stored_in_document()) {
            outstr.print(" stored");
            comma = true;
        }
        if (v.isNewInDocument()) {
            if (comma) {
                outstr.print(",");
            }
            comma = true;
            outstr.print(" new in document");
        }
        if (v.isUpdated()) {
            if (comma) {
                outstr.print(",");
            }
            comma = true;
            outstr.print(" updated since last read");
        }
        outstr.println(")");
    }

    public static boolean datasetReport(DataSet ds, boolean cascade, PrintStream outstr) {
        if (cascade) {
            ArchiveReports.reportProvenance(ds.getProvenance(), outstr);
        }
        ArchiveReports.outputVobjectState(ds, outstr);
        outstr.println("Dataset contains : " + ds.getSequenceCount() + " sequences, " + ds.getAlignmentCount() + " alignments and " + ds.getTreeCount() + " trees.");
        if (cascade) {
            ArchiveReports.alignmentReport(ds.getAlignment(), true, outstr);
        }
        return true;
    }

    public static boolean alignmentReport(Alignment[] al, boolean cascade, PrintStream outstr) {
        boolean val = true;
        if (al != null && al.length > 0) {
            for (int i = 0; i < al.length; ++i) {
                outstr.println("Alignment " + i + (al[i].isRegistered() ? " (" + al[i].getVorbaId() + ")" : " (unregistered)"));
                ArchiveReports.outputVobjectState(al[i], outstr);
                if (cascade) {
                    ArchiveReports.reportProvenance(al[i].getProvenance(), outstr);
                }
                outstr.println("Involves " + al[i].getAlignmentSequenceCount() + " sequences, has " + al[i].getAlignmentAnnotationCount() + " annotations and " + al[i].getTreeCount() + " trees.");
                if (!cascade) continue;
                for (int t = 0; t < al[i].getTreeCount(); ++t) {
                    ArchiveReports.treeReport(al[i].getTree(t), true, outstr);
                }
            }
        }
        return val;
    }

    public static boolean treeReport(Tree t, boolean cascade, PrintStream outstr) {
        outstr.print("Tree: '" + t.getTitle() + "' ");
        ArchiveReports.outputVobjectState(t, outstr);
        return !cascade || ArchiveReports.reportProvenance(t.getProvenance(), outstr);
    }
}

