/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class AnovaTable {
    private Matrix table = new Matrix(8, 4, 0.0);
    private String[] left = new String[8];
    private String top = "Source\tdf\tSS\tMS";
    int df;
    int dfDG;

    public void setTable(int row, Matrix M) {
        this.table.setMatrix(row, row, 0, 3, M);
    }

    public void setLeft(int row, String str) {
        this.left[row] = str;
    }

    public void setDF(int a) {
        this.df = a;
    }

    public int getDF() {
        return this.df;
    }

    public void setDfDG(int a) {
        this.dfDG = a;
    }

    public String[] getTableStringArray() {
        String[] strArray = new String[8];
        strArray[0] = this.top;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        DecimalFormat df = new DecimalFormat("##0.#E0");
        int i = 1;
        while (i < 8) {
            double d2 = this.table.get(i, 1);
            double d3 = this.table.get(i, 2);
            double d4 = this.table.get(i, 3);
            String s1 = this.left[i];
            String s2 = nf.format(d2);
            String s3 = df.format(d3);
            String s4 = nf.format(d4);
            strArray[i] = s1 + "\t" + s2 + "\t" + s3 + "\t" + s4;
            ++i;
        }
        return strArray;
    }

    public void PrintTable() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        DecimalFormat df = new DecimalFormat("##0.#E0");
        System.out.println(this.top);
        int i = 1;
        while (i < 8) {
            double d2 = this.table.get(i, 1);
            double d3 = this.table.get(i, 2);
            double d4 = this.table.get(i, 3);
            String s1 = this.left[i];
            String s2 = nf.format(d2);
            String s3 = df.format(d3);
            String s4 = nf.format(d4);
            System.out.println(s1 + "\t" + s2 + "\t" + s3 + "\t" + s4);
            ++i;
        }
    }

    public void PrintToFile(String file) {
        try {
            PrintWriter PW = new PrintWriter(new FileOutputStream(file));
            NumberFormat nf = NumberFormat.getNumberInstance();
            DecimalFormat df = new DecimalFormat("#0.##E0");
            PW.println(this.top);
            int i = 1;
            while (i < 8) {
                double d2 = this.table.get(i, 1);
                double d3 = this.table.get(i, 2);
                double d4 = this.table.get(i, 3);
                String s1 = this.left[i];
                String s2 = nf.format(d2);
                String s3 = df.format(d3);
                String s4 = nf.format(d4);
                PW.println(s1 + "\t" + s2 + "\t" + s3 + "\t" + s4);
                ++i;
            }
            PW.flush();
            PW.close();
        }
        catch (IOException e) {}
    }
}

