/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import JSci.maths.SpecialMath;
import MAANOVA.BetaDistribution;
import MAANOVA.ProbabilityDistribution;

public final class FDistribution
extends ProbabilityDistribution {
    private double p;
    private double q;
    private BetaDistribution beta;

    public FDistribution(double dgrP, double dgrQ) {
        if (dgrP <= 0.0 || dgrQ <= 0.0) {
            throw new IllegalArgumentException("The degrees of freedom must be greater than zero.");
        }
        this.p = dgrP;
        this.q = dgrQ;
        this.beta = new BetaDistribution(this.p / 2.0, this.q / 2.0);
    }

    public double getDegreesOfFreedomP() {
        return this.p;
    }

    public double getDegreesOfFreedomQ() {
        return this.q;
    }

    public double probability(double X) {
        this.checkRange(X, 0.0, Double.MAX_VALUE);
        double y = this.q / (this.q + this.p * X);
        return this.beta.probability(y) * y * y * this.p / this.q;
    }

    public double cumulative(double X) {
        this.checkRange(X, 0.0, Double.MAX_VALUE);
        return SpecialMath.incompleteBeta((double)(1.0 / (1.0 + this.q / (this.p * X))), (double)(this.p / 2.0), (double)(this.q / 2.0));
    }

    public double inverse(double probability) {
        this.checkRange(probability);
        if (probability == 0.0) {
            return 0.0;
        }
        if (probability == 1.0) {
            return Double.MAX_VALUE;
        }
        double y = this.beta.inverse(1.0 - probability);
        if (y < 2.23E-308) {
            return Double.MAX_VALUE;
        }
        return this.p / this.q * (1.0 / y - 1.0);
    }
}

