/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.castor.mapping.BindingType;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.types.BindXmlNodeType;
import org.exolab.castor.mapping.xml.types.FieldMappingCollectionType;
import org.exolab.castor.tools.MappingToolMappingLoader;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.util.XMLClassDescriptorResolverImpl;

public class MappingTool {
    private static final String UNDERSCORE = "_";
    private final Hashtable _mappings = new Hashtable();
    private final XMLClassDescriptorResolverImpl _resolver = (XMLClassDescriptorResolverImpl)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
    private Introspector _introspector = null;
    private final MappingToolMappingLoader _mappingLoader = new MappingToolMappingLoader();
    private boolean _forceIntrospection = false;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) {
        boolean force;
        CommandLineOptions allOptions = new CommandLineOptions();
        allOptions.addFlag("i", "classname", "Sets the input class");
        String desc = "Sets the output mapping filename";
        allOptions.addFlag("o", "filename", desc, true);
        desc = "Force overwriting of files.";
        allOptions.addFlag("f", "", desc, true);
        desc = "Displays this help screen.";
        allOptions.addFlag("h", "", desc, true);
        Properties options = allOptions.getOptions(args);
        if (options.getProperty("h") != null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printHelp(pw);
            pw.flush();
            return;
        }
        String classname = options.getProperty("i");
        String mappingName = options.getProperty("o");
        boolean bl = force = options.getProperty("f") != null;
        if (classname == null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printUsage(pw);
            pw.flush();
            return;
        }
        try {
            MappingTool tool = new MappingTool();
            tool.addClass(classname);
            Writer writer = null;
            if (mappingName == null || mappingName.length() == 0) {
                writer = new PrintWriter(System.out, true);
            } else {
                String message;
                ConsoleDialog dialog;
                File file = new File(mappingName);
                if (file.exists() && !force && !(dialog = new ConsoleDialog()).confirm(message = "The file already exists. Do you wish to overwrite '" + mappingName + "'?")) {
                    return;
                }
                writer = new FileWriter(file);
            }
            tool.write(writer);
        }
        catch (Exception except) {
            System.out.println(except);
            except.printStackTrace();
        }
    }

    public void addClass(String name) throws MappingException {
        this.addClass(name, true);
    }

    public void addClass(String name, boolean deep) throws MappingException {
        if (name == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        try {
            this.addClass(Class.forName(name), deep);
        }
        catch (ClassNotFoundException except) {
            throw new MappingException(except);
        }
    }

    public void addClass(Class cls) throws MappingException {
        this.addClass(cls, true);
    }

    public void addClass(Class cls, boolean deep) throws MappingException {
        XMLClassDescriptor xmlClass;
        if (cls == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        if (this._mappings.get(cls) != null) {
            return;
        }
        if (cls.isArray()) {
            Class<?> cType = cls.getComponentType();
            if (this._mappings.get(cType) != null) {
                return;
            }
            if (Types.isSimpleType(cType)) {
                return;
            }
            this.addClass(cType);
        }
        if (this._forceIntrospection && !Types.isConstructable(cls)) {
            throw new MappingException("mapping.classNotConstructable", cls.getName());
        }
        boolean introspected = false;
        try {
            if (this._forceIntrospection) {
                xmlClass = this._introspector.generateClassDescriptor(cls);
                introspected = true;
            } else {
                xmlClass = this._resolver.resolveXML(cls);
                introspected = Introspector.introspected(xmlClass);
            }
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
        ClassMapping classMap = new ClassMapping();
        classMap.setName(cls.getName());
        classMap.setDescription("Default mapping for class " + cls.getName());
        classMap.setAccess(null);
        MapTo mapTo = new MapTo();
        mapTo.setXml(xmlClass.getXMLName());
        mapTo.setNsUri(xmlClass.getNameSpaceURI());
        mapTo.setNsPrefix(xmlClass.getNameSpacePrefix());
        classMap.setMapTo(mapTo);
        this._mappings.put(cls, classMap);
        FieldDescriptor[] fields = xmlClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fdesc = fields[i];
            String fieldName = fdesc.getFieldName();
            boolean isContainer = false;
            if (introspected && fieldName.startsWith("##container")) {
                fdesc = fdesc.getClassDescriptor().getFields()[0];
                fieldName = fdesc.getFieldName();
                isContainer = true;
            }
            Class fieldType = fdesc.getFieldType();
            if (!introspected && fieldName.startsWith(UNDERSCORE)) {
                if (!MappingToolMappingLoader.canFindAccessors(cls, fieldName, fieldType)) {
                    fieldName = fieldName.substring(1);
                }
                if (!MappingToolMappingLoader.canFindAccessors(cls, fieldName, fieldType) && fieldName.endsWith("List")) {
                    int len = fieldName.length() - 4;
                    String tmpName = fieldName.substring(0, len);
                    if (MappingToolMappingLoader.canFindAccessors(cls, tmpName, fieldType)) {
                        fieldName = tmpName;
                    }
                }
            }
            FieldMapping fieldMap = new FieldMapping();
            fieldMap.setName(fieldName);
            boolean isArray = fieldType.isArray();
            while (fieldType.isArray()) {
                fieldType = fieldType.getComponentType();
            }
            if (fdesc.isRequired()) {
                fieldMap.setRequired(true);
            }
            if (fdesc.isTransient()) {
                fieldMap.setTransient(true);
            }
            if (fdesc.isMultivalued()) {
                if (isContainer) {
                    fieldMap.setContainer(false);
                }
                if (isArray) {
                    fieldMap.setCollection(FieldMappingCollectionType.ARRAY);
                } else {
                    String colName = CollectionHandlers.getCollectionName(fieldType);
                    if (colName != null) {
                        fieldMap.setCollection(FieldMappingCollectionType.valueOf(colName));
                        fieldType = class$java$lang$Object == null ? MappingTool.class$("java.lang.Object") : class$java$lang$Object;
                    } else if (MappingToolMappingLoader.returnsArray(cls, fieldName, fieldType)) {
                        fieldMap.setCollection(FieldMappingCollectionType.ARRAY);
                    } else {
                        fieldMap.setCollection(FieldMappingCollectionType.ENUMERATE);
                    }
                }
            }
            fieldMap.setType(fieldType.getName());
            fieldMap.setBindXml(new BindXml());
            fieldMap.getBindXml().setName(((XMLFieldDescriptor)fdesc).getXMLName());
            fieldMap.getBindXml().setNode(BindXmlNodeType.valueOf(((XMLFieldDescriptor)fields[i]).getNodeType().toString()));
            if (classMap.getClassChoice() == null) {
                classMap.setClassChoice(new ClassChoice());
            }
            classMap.getClassChoice().addFieldMapping(fieldMap);
            if (!deep || this._mappings.get(fieldType) != null || Types.isSimpleType(fieldType)) continue;
            this.addClass(fieldType);
        }
    }

    public void setForceIntrospection(boolean force) {
        this._forceIntrospection = force;
        if (force && this._introspector == null) {
            this._introspector = new Introspector();
        }
    }

    public void write(Writer writer) throws MappingException {
        try {
            MappingRoot mapping = new MappingRoot();
            mapping.setDescription("Castor generated mapping file");
            Enumeration enumeration = this._mappings.elements();
            while (enumeration.hasMoreElements()) {
                mapping.addClassMapping((ClassMapping)enumeration.nextElement());
            }
            Marshaller marshal = new Marshaller(writer);
            marshal.setNamespaceMapping(null, "http://castor.exolab.org/");
            marshal.setNamespaceMapping("cst", "http://castor.exolab.org/");
            marshal.marshal(mapping);
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

