/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;

public class DAM
extends AbstractAlgorithm {
    private boolean stop = false;
    private Matrix expMatrix;
    private Matrix expMatrixTranspose;
    private Matrix responseMatrix;
    private Matrix testDataMatrix;
    private Matrix trainingMatrix;
    private int numberOfGenes = 0;
    private int numberOfSamples = 0;
    private int numberOfClasses = 0;
    private int kValue = 0;
    private int[] trainingIndices;
    private int[] testIndices;
    private int[] classes;
    private int whichAlgorithm = 0;
    private boolean isPDA = true;
    private boolean preSelectGenes = true;
    private boolean performLOOCV = true;
    private double alpha = 0.05;
    private int numberOfSelectedGenes = 0;
    private int[] geneRank;
    private int highestGeneRank;
    private Vector[] selectedGeneIndices;
    private int[] usedGeneIndices;
    private int[] unusedGeneIndices;
    private final int used = 0;
    private final int unused = 1;
    private Vector[][] reducedGeneSetForA2;
    private Vector[] reducedGeneSet;
    private Vector[] clusters;
    private Vector[] classified;
    private Matrix classExpSumMatrix;
    private int[] classSampleArray;
    private Matrix geneComponentMatrix;
    private Matrix[] beta;
    private Matrix[] A_Matrix;
    private Matrix[] C_Matrix;
    private double[] cValues;
    private boolean[] singularMatrix;
    int denominator = 0;
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        FloatMatrix floatMatrix;
        Matrix matrix;
        Node node;
        int[] nArray;
        int n;
        int n2;
        int n3;
        int n4;
        this.expMatrix = this.getJamaMatrix(algorithmData.getMatrix("experiment"));
        this.expMatrixTranspose = this.expMatrix.transpose();
        this.numberOfGenes = this.expMatrix.getRowDimension();
        this.numberOfSamples = this.expMatrix.getColumnDimension();
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n5 = algorithmParameters.getInt("distance-function", 3);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        int n6 = algorithmParameters.getInt("dam-mode", 0);
        this.preSelectGenes = algorithmParameters.getBoolean("preSelectionGenes", false);
        this.whichAlgorithm = algorithmParameters.getInt("algorithmSelection", 0);
        this.isPDA = algorithmParameters.getBoolean("isPDA", true);
        this.preSelectGenes = algorithmParameters.getBoolean("preSelectGenes", true);
        this.numberOfClasses = algorithmParameters.getInt("numberOfClasses", 3);
        this.kValue = algorithmParameters.getInt("kValue", 3);
        this.alpha = algorithmParameters.getFloat("alpha", 0.05f);
        System.out.println("");
        System.out.println("DAM.java: numberOfGenes = " + this.numberOfGenes);
        System.out.println("DAM.java: numberOfSamples = " + this.numberOfSamples);
        System.out.println("DAM.java: Algorithm = A" + this.whichAlgorithm);
        System.out.println("DAM.java: Perform PDA = " + this.isPDA);
        System.out.println("DAM.java: preSelectGenes = " + this.preSelectGenes);
        System.out.println("DAM.java: numberOfClasses = " + this.numberOfClasses);
        System.out.println("DAM.java: kValue = " + this.kValue);
        System.out.println("DAM.java: alpha = " + this.alpha);
        System.out.println("");
        this.singularMatrix = new boolean[this.numberOfSamples];
        this.trainingIndices = algorithmData.getIntArray("trainingIndices");
        this.classes = algorithmData.getIntArray("classes");
        this.testIndices = algorithmData.getIntArray("testIndices");
        System.out.println("DAM.java: trainingIndices: ");
        for (n4 = 0; n4 < this.trainingIndices.length; ++n4) {
            System.out.print(this.trainingIndices[n4] + ", ");
        }
        System.out.println("");
        System.out.println("");
        System.out.println("DAM.java: classes: ");
        for (n4 = 0; n4 < this.classes.length; ++n4) {
            System.out.print(this.classes[n4] + ", ");
        }
        System.out.println("");
        System.out.println("");
        System.out.println("DAM.java: testIndices: ");
        for (n4 = 0; n4 < this.testIndices.length; ++n4) {
            System.out.print(this.testIndices[n4] + ", ");
        }
        System.out.println("");
        System.out.println("");
        this.responseMatrix = new Matrix(this.numberOfSamples, this.numberOfClasses);
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            for (n3 = 0; n3 < this.numberOfClasses; ++n3) {
                this.responseMatrix.set(n4, n3, 0.0);
            }
        }
        for (n4 = 0; n4 < this.trainingIndices.length; ++n4) {
            this.responseMatrix.set(this.trainingIndices[n4], this.classes[n4] - 1, 1.0);
        }
        if (this.trainingIndices.length > 0) {
            this.trainingMatrix = new Matrix(this.numberOfGenes, this.trainingIndices.length);
            this.trainingMatrix = this.expMatrix.getMatrix(0, this.numberOfGenes - 1, this.trainingIndices);
        }
        if (this.testIndices.length > 0) {
            this.testDataMatrix = new Matrix(this.numberOfGenes, this.testIndices.length);
            this.testDataMatrix = this.expMatrix.getMatrix(0, this.numberOfGenes - 1, this.testIndices);
        }
        this.classExpSumMatrix = new Matrix(this.numberOfGenes, this.numberOfClasses);
        this.classExpSumMatrix = this.expMatrix.times(this.responseMatrix);
        this.classSampleArray = new int[this.numberOfClasses];
        for (n4 = 0; n4 < this.numberOfClasses; ++n4) {
            for (n3 = 0; n3 < this.numberOfSamples; ++n3) {
                int n7 = n4;
                this.classSampleArray[n7] = (int)((double)this.classSampleArray[n7] + this.responseMatrix.get(n3, n4));
            }
        }
        this.geneRank = new int[this.numberOfGenes];
        this.reducedGeneSet = new Vector[2];
        this.reducedGeneSet[0] = new Vector();
        this.reducedGeneSet[1] = new Vector();
        this.reducedGeneSetForA2 = new Vector[this.numberOfSamples][2];
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            this.reducedGeneSetForA2[n4][0] = new Vector();
            this.reducedGeneSetForA2[n4][1] = new Vector();
        }
        Matrix matrix2 = new Matrix(this.numberOfSamples, this.numberOfClasses);
        Matrix[] matrixArray = new Matrix[this.numberOfClasses];
        Vector[] vectorArray = new Vector[this.numberOfClasses + 1];
        this.classified = new Vector[this.numberOfClasses + 1];
        Vector[] vectorArray2 = new Vector[this.numberOfClasses + 1];
        for (n2 = 0; n2 < this.numberOfClasses + 1; ++n2) {
            vectorArray[n2] = new Vector();
            this.classified[n2] = new Vector();
            vectorArray2[n2] = new Vector();
        }
        switch (this.whichAlgorithm) {
            case 0: {
                matrix2 = this.A0Algorithm(this.expMatrix);
                break;
            }
            case 1: {
                matrix2 = this.A1Algorithm(this.expMatrix);
                break;
            }
            case 2: {
                matrix2 = this.A2Algorithm(this.expMatrix);
                break;
            }
            case 3: {
                matrix2 = this.InitialClassification(this.expMatrix);
                break;
            }
            default: {
                this.A0Algorithm(this.expMatrix);
            }
        }
        if (matrix2 == null) {
            throw new AbortException();
        }
        for (n2 = 0; n2 < this.trainingIndices.length; ++n2) {
            vectorArray[this.classes[n2]].add(new Integer(this.trainingIndices[n2]));
        }
        if (this.whichAlgorithm == 3) {
            int n8;
            for (n2 = 0; n2 < vectorArray.length; ++n2) {
                for (n8 = 0; n8 < vectorArray[n2].size(); ++n8) {
                    vectorArray2[n2].add(vectorArray[n2].get(n8));
                }
            }
            for (n2 = 0; n2 < this.classified.length; ++n2) {
                for (n8 = 0; n8 < this.classified[n2].size(); ++n8) {
                    vectorArray2[n2].add(this.classified[n2].get(n8));
                }
            }
        }
        System.out.println(" ");
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            System.out.println("DAM.java - classifiers[" + n2 + "].size() = " + vectorArray[n2].size());
        }
        System.out.println(" ");
        for (n2 = 0; n2 < this.classified.length; ++n2) {
            System.out.println("DAM.java - classified[" + n2 + "].size() = " + this.classified[n2].size());
        }
        System.out.println(" ");
        for (n2 = 0; n2 < vectorArray2.length; ++n2) {
            System.out.println("DAM.java - classifierPlusClassified[" + n2 + "].size() = " + vectorArray2[n2].size());
        }
        this.clusters = new Vector[this.numberOfClasses * 3];
        for (n2 = 1; n2 <= this.numberOfClasses; ++n2) {
            this.clusters[n2 - 1] = vectorArray[n2];
            this.clusters[n2 - 1 + this.numberOfClasses] = this.classified[n2];
            this.clusters[n2 - 1 + this.numberOfClasses * 2] = vectorArray2[n2];
        }
        for (n2 = 1; n2 <= this.numberOfClasses; ++n2) {
            System.out.println("DAM.java - clusters 1 size " + this.clusters[n2 - 1].size());
            System.out.println("DAM.java - clusters 2 size " + this.clusters[n2 - 1 + this.numberOfClasses].size());
            System.out.println("DAM.java - clusters 3 size " + this.clusters[n2 - 1 + this.numberOfClasses * 2].size());
        }
        Matrix matrix3 = this.getMeans(this.clusters);
        Matrix matrix4 = this.getVariances(this.clusters, matrix3);
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (n = 0; n < this.clusters.length; ++n) {
            if (this.stop) {
                throw new AbortException();
            }
            nArray = this.convert2int(this.clusters[n]);
            node = new Node(nArray);
            nodeList.addNode(node);
        }
        if (this.whichAlgorithm == 2) {
            this.usedGeneIndices = new int[this.reducedGeneSetForA2[0][0].size()];
            this.unusedGeneIndices = new int[this.reducedGeneSetForA2[0][1].size()];
            for (n = 0; n < this.usedGeneIndices.length; ++n) {
                this.usedGeneIndices[n] = (Integer)this.reducedGeneSetForA2[0][0].get(n);
            }
            for (n = 0; n < this.unusedGeneIndices.length; ++n) {
                this.unusedGeneIndices[n] = (Integer)this.reducedGeneSetForA2[0][1].get(n);
            }
        } else {
            this.usedGeneIndices = new int[this.reducedGeneSet[0].size()];
            this.unusedGeneIndices = new int[this.reducedGeneSet[1].size()];
            for (n = 0; n < this.usedGeneIndices.length; ++n) {
                this.usedGeneIndices[n] = (Integer)this.reducedGeneSet[0].get(n);
            }
            for (n = 0; n < this.unusedGeneIndices.length; ++n) {
                this.unusedGeneIndices[n] = (Integer)this.reducedGeneSet[1].get(n);
            }
        }
        n = matrix3.getRowDimension();
        node = new Cluster();
        nodeList = node.getNodeList();
        for (int i = 0; i < this.reducedGeneSet.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            nArray = this.convert2int(this.reducedGeneSet[i]);
            matrix = new Node(nArray);
            nodeList.addNode((Node)matrix);
        }
        Matrix matrix5 = this.getMeansForGenes(this.reducedGeneSet);
        matrix = this.getVariancesForGenes(this.reducedGeneSet, matrix5);
        Matrix matrix6 = this.getMeansForGenes(this.reducedGeneSet);
        Matrix matrix7 = this.getVariancesForGenes(this.reducedGeneSet, matrix5);
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addParam("numberOfGenes", String.valueOf(this.numberOfGenes));
        algorithmData2.addMatrix("probFunction", this.getFloatMatrix(matrix2));
        FloatMatrix floatMatrix2 = this.getFloatMatrix(this.geneComponentMatrix).transpose();
        if (floatMatrix2.getColumnDimension() == 2) {
            floatMatrix = new FloatMatrix(floatMatrix2.getRowDimension(), 3);
            floatMatrix.setMatrix(0, floatMatrix2.getRowDimension() - 1, 0, floatMatrix2.getColumnDimension() - 1, floatMatrix2);
            for (int i = 0; i < floatMatrix2.getRowDimension(); ++i) {
                floatMatrix.set(i, 2, 0.0f);
            }
        } else {
            floatMatrix = floatMatrix2;
        }
        algorithmData2.addMatrix("matrix3D", floatMatrix);
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addCluster("geneCluster", (Cluster)node);
        algorithmData2.addMatrix("clusters_means", this.getFloatMatrix(matrix3));
        algorithmData2.addMatrix("clusters_variances", this.getFloatMatrix(matrix4));
        algorithmData2.addMatrix("clusters_means_used", this.getFloatMatrix(matrix5));
        algorithmData2.addMatrix("clusters_variances_used", this.getFloatMatrix(matrix));
        algorithmData2.addMatrix("clusters_means_unused", this.getFloatMatrix(matrix6));
        algorithmData2.addMatrix("clusters_variances_unused", this.getFloatMatrix(matrix7));
        algorithmData2.addIntArray("usedGeneIndices", this.usedGeneIndices);
        algorithmData2.addIntArray("unusedGeneIndices", this.unusedGeneIndices);
        return algorithmData2;
    }

    private Matrix extractResult(Matrix matrix) {
        int n;
        Matrix matrix2 = new Matrix(this.numberOfSamples, this.numberOfClasses);
        int n2 = matrix.getRowDimension();
        int n3 = matrix.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                matrix2.set(i, n, 0.0);
            }
        }
        double[][] dArray = matrix.getArray();
        n = 0;
        for (int i = 0; i < n2; ++i) {
            n = this.getClassID(dArray[i]);
            matrix2.set(i, n, 1.0);
        }
        return matrix2;
    }

    private int getClassID(double[] dArray) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 = Math.max(d, dArray[i]);
            if (!(d2 > d)) continue;
            n = i;
            d = d2;
        }
        return n;
    }

    public Vector[] geneSelection(Matrix matrix) {
        int n;
        int n2;
        System.out.println(" ");
        System.out.println("**************** Begin geneSelection() *************** ");
        System.out.println(" ");
        double d = 0.0;
        double d2 = 0.0;
        int n3 = matrix.getRowDimension();
        int n4 = matrix.getColumnDimension();
        double[][] dArray = new double[this.numberOfClasses][this.numberOfClasses];
        double[][] dArray2 = new double[this.numberOfClasses][this.numberOfClasses];
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Gene Screening\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        System.out.println("");
        System.out.println("geneSelection() - numOfGenes = " + n3);
        System.out.println("geneSelection() - numOfSamples = " + n4);
        System.out.println("geneSelection() - numberOfClasses = " + this.numberOfClasses);
        System.out.println("geneSelection() - alpha = " + this.alpha);
        TDistribution tDistribution = new TDistribution(n4 - (this.numberOfClasses + 1));
        d = -tDistribution.inverse(this.alpha / 2.0);
        double d3 = this.getTValue(n4 - (this.numberOfClasses + 1), this.alpha);
        System.out.println("geneSelection() - tValue = " + d);
        System.out.println("geneSelection() - tValue1 = " + d3);
        if (d < -1.0) {
            return null;
        }
        System.out.println("");
        System.out.println("geneSelection() - tValue = " + d);
        d2 = this.getSampleVariance(matrix, this.getSampleMeans(matrix));
        System.out.println("geneSelection() - meanSquareError = " + d2);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < this.numberOfClasses; ++n) {
                for (int i = n + 1; i < this.numberOfClasses; ++i) {
                    dArray[n][i] = d * Math.sqrt(d2 * (1.0 / (double)this.classSampleArray[n] + 1.0 / (double)this.classSampleArray[i]));
                    dArray2[n][i] = Math.abs(this.classExpSumMatrix.get(n2, n) / (double)this.classSampleArray[n] - this.classExpSumMatrix.get(n2, i) / (double)this.classSampleArray[i]);
                    if (!(dArray2[n][i] > dArray[n][i])) continue;
                    int n5 = n2;
                    this.geneRank[n5] = this.geneRank[n5] + 1;
                }
            }
        }
        this.highestGeneRank = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.geneRank[n2] <= this.highestGeneRank) continue;
            this.highestGeneRank = this.geneRank[n2];
        }
        System.out.println("");
        System.out.println("geneSelection() - highestGeneRank = " + this.highestGeneRank);
        Vector[] vectorArray = new Vector[this.highestGeneRank + 1];
        for (n2 = 0; n2 < this.highestGeneRank + 1; ++n2) {
            vectorArray[n2] = new Vector();
            for (n = 0; n < n3; ++n) {
                if (this.geneRank[n] != n2) continue;
                vectorArray[n2].add(new Integer(n));
                if (n2 <= 0) continue;
                vectorArray[0].remove(new Integer(n));
            }
        }
        for (n2 = 0; n2 < this.highestGeneRank + 1; ++n2) {
            System.out.println("geneSelection() - rank = " + n2 + ", geneIndices[rank].size()=" + vectorArray[n2].size());
        }
        System.out.println("");
        System.out.println(" ");
        System.out.println("**************** End geneSelection() *************** ");
        System.out.println(" ");
        return vectorArray;
    }

    public Matrix[] mleAlgorithm(Matrix matrix, Matrix matrix2) throws AlgorithmException {
        int n;
        int n2;
        System.out.println(" ");
        System.out.println("******************** Begin mleAlgorithm() ********************");
        System.out.println(" ");
        int n3 = matrix.getRowDimension();
        int n4 = matrix.getColumnDimension();
        System.out.println(" ");
        System.out.println("mleAlgorithm() - numOfGenes = " + n3);
        System.out.println("mleAlgorithm() - numOfSamples = " + n4);
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "MLE Algorithm \n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        Matrix[] matrixArray = new Matrix[n4];
        for (int i = 0; i < n4; ++i) {
            matrixArray[i] = new Matrix(n3 + 1, 1);
            matrixArray[i].set(0, 0, 1.0);
            matrixArray[i].setMatrix(1, n3, 0, 0, matrix.getMatrix(0, n3 - 1, i, i));
        }
        Matrix matrix3 = new Matrix(n3 + 1, n4);
        for (int i = 0; i < n4; ++i) {
            matrix3.set(0, i, 1.0);
        }
        matrix3.setMatrix(1, n3, 0, n4 - 1, matrix);
        Matrix matrix4 = new Matrix(this.numberOfClasses * (n3 + 1), 1);
        Matrix matrix5 = new Matrix(this.numberOfClasses * (n3 + 1), 1);
        Matrix[] matrixArray2 = new Matrix[this.numberOfClasses];
        Matrix[] matrixArray3 = new Matrix[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            matrixArray2[i] = new Matrix(n3 + 1, 1);
            matrixArray3[i] = new Matrix(n3 + 1, 1);
        }
        Matrix matrix6 = new Matrix(n4, this.numberOfClasses);
        Matrix matrix7 = new Matrix(this.numberOfClasses * (n3 + 1), 1);
        Matrix[][] matrixArray4 = new Matrix[this.numberOfClasses][this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            for (int j = 0; j < this.numberOfClasses; ++j) {
                matrixArray4[i][j] = new Matrix(n4, n4);
            }
        }
        Matrix matrix8 = new Matrix(this.numberOfClasses * (n3 + 1), this.numberOfClasses * (n3 + 1));
        Matrix[][] matrixArray5 = new Matrix[this.numberOfClasses][this.numberOfClasses];
        for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
            for (n = 0; n < this.numberOfClasses; ++n) {
                matrixArray5[n2][n] = new Matrix(n3 + 1, n3 + 1);
            }
        }
        for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
            for (n = 0; n < n3 + 1; ++n) {
                matrixArray2[n2].set(n, 0, (double)0.1f);
                matrixArray3[n2].set(n, 0, (double)0.1f);
            }
        }
        for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
            for (n = 0; n < n3 + 1; ++n) {
                matrix4.set(n2 * n, 0, matrixArray2[n2].get(n, 0));
                matrix5.set(n2 * n, 0, matrixArray2[n2].get(n, 0));
            }
        }
        Matrix matrix9 = matrix2.getMatrix(0, n4 - 1, 0, this.numberOfClasses - 1);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 40; ++i) {
            int n5;
            int n6;
            matrixArray2 = matrixArray3;
            for (int j = 0; j < n4; ++j) {
                for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                    d3 += Math.exp(matrixArray[j].transpose().times(matrixArray2[n6]).get(0, 0));
                }
                d2 = Math.log(1.0 + d3);
                for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                    d = matrixArray[j].transpose().times(matrixArray2[n6]).get(0, 0);
                    matrix6.set(j, n6, Math.exp(d - d2));
                }
                d3 = 0.0;
            }
            Matrix[] matrixArray6 = new Matrix[this.numberOfClasses];
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                matrixArray6[n6] = new Matrix(n3 + 1, 1);
                for (n5 = 0; n5 < n4; ++n5) {
                    matrixArray6[n6] = matrixArray6[n6].plus(matrixArray[n5].times(matrix9.get(n5, n6) - matrix6.get(n5, n6)));
                }
            }
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                matrix7.setMatrix(n6 * (n3 + 1), (n6 + 1) * (n3 + 1) - 1, 0, 0, matrixArray6[n6]);
            }
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                for (n5 = 0; n5 < this.numberOfClasses; ++n5) {
                    int n7;
                    if (n6 == n5) {
                        for (n7 = 0; n7 < n4; ++n7) {
                            matrixArray4[n6][n5].set(n7, n7, matrix6.get(n7, n6) * (1.0 - matrix6.get(n7, n6)));
                        }
                        continue;
                    }
                    for (n7 = 0; n7 < n4; ++n7) {
                        matrixArray4[n6][n5].set(n7, n7, matrix6.get(n7, n6) * matrix6.get(n7, n5));
                    }
                }
            }
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                for (n5 = 0; n5 < this.numberOfClasses; ++n5) {
                    matrixArray5[n6][n5] = n6 == n5 ? matrix3.times(matrixArray4[n6][n5]).times(matrix3.transpose()) : matrix3.times(matrixArray4[n6][n5]).times(matrix3.transpose()).uminus();
                }
            }
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                for (n5 = 0; n5 < this.numberOfClasses; ++n5) {
                    matrix8.setMatrix(n6 * (n3 + 1), (n6 + 1) * (n3 + 1) - 1, n5 * (n3 + 1), (n5 + 1) * (n3 + 1) - 1, matrixArray5[n6][n5]);
                }
            }
            for (n6 = 0; n6 < this.numberOfClasses; ++n6) {
                try {
                    Matrix matrix10 = matrix8.inverse();
                    matrixArray3[n6] = matrixArray2[n6].plus(matrix8.inverse().times(matrix7).getMatrix(n6 * (n3 + 1), (n6 + 1) * (n3 + 1) - 1, 0, 0));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    JOptionPane.showMessageDialog(null, "MLE Algorithm: Information Matrix is Singular", "Alert", 2);
                    throw new AlgorithmException("MLE Algorithm: Singular Matrix");
                }
            }
        }
        System.out.println(" ");
        System.out.println("******************** End mleAlgorithm() ********************");
        System.out.println(" ");
        return matrixArray3;
    }

    public double[] pdaAlgorithm(Matrix matrix) {
        System.out.println(" ");
        System.out.println("******************** Begin pdaAlgorithm() ********************");
        System.out.println(" ");
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        Matrix matrix2 = new Matrix(n + 1, n2);
        for (int i = 0; i < n2; ++i) {
            matrix2.set(0, i, 1.0);
        }
        matrix2.setMatrix(1, n, 0, n2 - 1, matrix);
        double[] dArray = new double[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            dArray[i] = matrix2.transpose().times(this.beta[i]).get(0, 0);
        }
        System.out.println(" ");
        System.out.println("******************** End pdaAlgorithm() ********************");
        System.out.println(" ");
        return dArray;
    }

    public int calculateQDAParameters(Matrix matrix, Matrix matrix2) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = matrix.getRowDimension();
        int n6 = matrix.getColumnDimension();
        System.out.println(" ");
        System.out.println("********** Begin calculateQDAParameters() **********");
        System.out.println(" ");
        Matrix[] matrixArray = new Matrix[this.numberOfClasses];
        int[] nArray = new int[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            nArray[i] = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                int n7 = i;
                nArray[n7] = (int)((double)nArray[n7] + matrix2.get(n4, i));
            }
            n4 = nArray[i];
            int[] nArray2 = new int[n4];
            n3 = 0;
            for (int j = 0; j < n6; ++j) {
                if (matrix2.get(j, i) != 1.0) continue;
                nArray2[n3] = j;
                ++n3;
            }
            matrixArray[i] = new Matrix(n5, nArray[i]);
            matrixArray[i] = matrix.getMatrix(0, n5 - 1, nArray2);
        }
        Matrix[] matrixArray2 = new Matrix[this.numberOfClasses];
        for (n4 = 0; n4 < this.numberOfClasses; ++n4) {
            matrixArray2[n4] = new Matrix(1, n5);
        }
        Matrix[] matrixArray3 = new Matrix[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            matrixArray3[i] = new Matrix(n5, n5);
        }
        Matrix[] matrixArray4 = new Matrix[this.numberOfClasses];
        for (n3 = 0; n3 < this.numberOfClasses; ++n3) {
            matrixArray4[n3] = new Matrix(n5, n5);
        }
        double[] dArray = new double[this.numberOfClasses];
        double[] dArray2 = new double[n6];
        this.A_Matrix = new Matrix[this.numberOfClasses];
        this.C_Matrix = new Matrix[this.numberOfClasses];
        for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
            this.C_Matrix[n2] = new Matrix(n5, 1);
        }
        this.cValues = new double[this.numberOfClasses];
        n2 = 0;
        for (int i = 0; i < this.numberOfClasses; ++i) {
            n2 = 0;
            for (int j = 0; j < n6; ++j) {
                n2 = (int)((double)n2 + matrix2.get(j, i));
            }
            dArray[i] = (double)n2 / (double)n6;
        }
        double d = 0.0;
        for (int i = 0; i < this.numberOfClasses; ++i) {
            for (int j = 0; j < n5; ++j) {
                d = 0.0;
                for (n = 0; n < matrixArray[i].getColumnDimension(); ++n) {
                    d += matrixArray[i].get(j, n);
                }
                matrixArray2[i].set(0, j, d / (double)matrixArray[i].getColumnDimension());
            }
        }
        double[][] dArray3 = new double[n5][n5];
        Matrix matrix3 = new Matrix(n5, n5);
        for (n = 0; n < this.numberOfClasses; ++n) {
            matrixArray3[n] = this.getCovarianceMatrix(matrixArray[n], matrixArray2[n]);
            double[][] dArray4 = matrixArray3[n].getArray();
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n5; ++j) {
                    matrix3.set(i, j, (double)((int)(dArray4[i][j] * 1000000.0)) / 1000000.0);
                }
            }
            if (Math.abs(matrix3.det()) < 1.0E-10) {
                System.out.println("calculateQDAParameters() -- Covariance Matrix is singular for class Id # " + n);
                System.out.println("calculateQDAParameters() -- det of covariance matrix for class " + matrixArray3[n].det());
                System.out.println(" ");
                JOptionPane.showMessageDialog(null, "QDA Algorithm: Covariance Matrix is Singular", "Alert", 2);
                throw new AlgorithmException("QDA Algorithm: Singular Matrix");
            }
            matrixArray4[n] = matrix3.inverse();
        }
        for (n = 0; n < this.numberOfClasses; ++n) {
            this.A_Matrix[n] = new Matrix(n5, n5);
            this.A_Matrix[n] = matrixArray4[n].times(-0.5);
        }
        for (n = 0; n < this.numberOfClasses; ++n) {
            this.C_Matrix[n] = matrixArray4[n].times(matrixArray2[n].transpose());
        }
        for (n = 0; n < this.numberOfClasses; ++n) {
            this.cValues[n] = Math.log(dArray[n]);
            int n8 = n;
            this.cValues[n8] = this.cValues[n8] - Math.log(matrix3.det()) * 0.5;
            int n9 = n;
            this.cValues[n9] = this.cValues[n9] - matrixArray2[n].times(this.C_Matrix[n]).get(0, 0) * 0.5;
        }
        System.out.println(" ");
        for (n = 0; n < this.numberOfClasses; ++n) {
            System.out.println("calculateQDAParameters() -- cValues for class #" + n + " is " + this.cValues[n]);
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("********** End calculateQDAParameters() **********");
        System.out.println(" ");
        return 1;
    }

    public double[] qdaAlgorithm(Matrix matrix) {
        int n;
        System.out.println(" ");
        System.out.println("************* Begin qdaAlgorithm() **************");
        System.out.println(" ");
        Matrix matrix2 = new Matrix(this.numberOfClasses, 1);
        Matrix matrix3 = new Matrix(1, 1);
        System.out.println("qdaAlgorithm() -- testMatrix: ");
        this.printMatrix(matrix);
        for (int i = 0; i < this.numberOfClasses; ++i) {
            matrix3 = matrix.transpose().times(this.A_Matrix[i]).times(matrix);
            matrix3 = matrix3.plus(this.C_Matrix[i].transpose().times(matrix));
            matrix2.set(i, 0, matrix3.get(0, 0) + this.cValues[i]);
        }
        System.out.println("qdaAlgorithm() -- Q_Matrix: ");
        this.printMatrix(matrix2);
        double d = 0.0;
        for (int i = 0; i < this.numberOfClasses; ++i) {
            d += Math.exp(matrix2.get(i, 0));
        }
        double[] dArray = new double[this.numberOfClasses];
        for (n = 0; n < this.numberOfClasses; ++n) {
            dArray[n] = Math.exp(matrix2.get(n, 0)) / d;
        }
        System.out.println("qdaAlgorithm() -- probFunction: ");
        for (n = 0; n < this.numberOfClasses; ++n) {
            System.out.print(dArray[n] + ", ");
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("************* End qdaAlgorithm() **************");
        System.out.println(" ");
        return dArray;
    }

    public Matrix mplsAlgorithm(Matrix matrix, Matrix matrix2, Matrix matrix3) {
        int n;
        int n2;
        double d;
        double d2;
        int n3;
        System.out.println(" ");
        System.out.println("************** Begin mplsAlgorithm() **************");
        System.out.println(" ");
        Matrix[] matrixArray = new Matrix[this.kValue + 1];
        Matrix[] matrixArray2 = new Matrix[this.kValue + 1];
        Matrix[] matrixArray3 = new Matrix[this.kValue];
        int n4 = matrix.getRowDimension();
        int n5 = matrix.getColumnDimension();
        int n6 = matrix3.getColumnDimension();
        System.out.println("mplsAlgorithm() - numOfGenes = " + n4);
        System.out.println("mplsAlgorithm() - numOfTrainingSamples = " + n5);
        System.out.println("mplsAlgorithm() - numOfTestSamples = " + n6);
        System.out.println(" ");
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.kValue, "Dimension Reduction (MPLS)\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (n3 = 0; n3 < this.kValue + 1; ++n3) {
            matrixArray[n3] = new Matrix(n4, n5);
            matrixArray2[n3] = new Matrix(n5, this.numberOfClasses);
            if (n3 >= this.kValue) continue;
            matrixArray3[n3] = new Matrix(n4, n6);
        }
        System.out.println("mplsAlgorithm() - Call getSampleMeans for trainingMatrix: ");
        Matrix matrix4 = this.getSampleMeans(matrix);
        Matrix matrix5 = this.getSampleVariances(matrix, matrix4);
        for (n3 = 0; n3 < n5; ++n3) {
            d2 = matrix4.get(0, n3);
            d = matrix5.get(0, n3);
            for (n2 = 0; n2 < n4; ++n2) {
                matrixArray[0].set(n2, n3, (matrix.get(n2, n3) - d2) / d);
            }
        }
        System.out.println("mplsAlgorithm() - Call getSampleMeans for trainingResponseMatrix: ");
        Matrix matrix6 = this.getSampleMeans(matrix2);
        Matrix matrix7 = this.getSampleVariances(matrix2, matrix6);
        for (n3 = 0; n3 < this.numberOfClasses; ++n3) {
            d2 = matrix6.get(0, n3);
            d = matrix7.get(0, n3);
            for (n2 = 0; n2 < n5; ++n2) {
                matrixArray2[0].set(n2, n3, (matrix2.get(n2, n3) - d2) / d);
            }
        }
        Matrix matrix8 = this.getSampleMeans(matrix3);
        Matrix matrix9 = this.getSampleVariances(matrix3, matrix8);
        for (n3 = 0; n3 < n6; ++n3) {
            d2 = matrix8.get(0, n3);
            d = matrix9.get(0, n3);
            for (n2 = 0; n2 < n4; ++n2) {
                matrixArray3[0].set(n2, n3, (matrix3.get(n2, n3) - d2) / d);
            }
        }
        double d3 = 1.0E-12;
        Matrix matrix10 = new Matrix(n5, 1);
        double d4 = 0.0;
        Matrix matrix11 = new Matrix(n4, 1);
        Matrix[] matrixArray4 = new Matrix[this.kValue];
        for (int i = 0; i < this.kValue; ++i) {
            matrixArray4[i] = new Matrix(n4, 1);
        }
        Matrix matrix12 = new Matrix(n4, 1);
        for (int i = 0; i < n4; ++i) {
            matrix12.set(i, 0, 0.0);
        }
        Matrix matrix13 = new Matrix(n5, 1);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        Matrix matrix14 = new Matrix(this.numberOfClasses, 1);
        Matrix[] matrixArray5 = new Matrix[this.kValue];
        Matrix[] matrixArray6 = new Matrix[this.kValue];
        Matrix[] matrixArray7 = new Matrix[this.kValue];
        double[] dArray = new double[this.kValue];
        for (int i = 0; i < this.kValue; ++i) {
            matrixArray5[i] = new Matrix(n5, 1);
            matrixArray6[i] = new Matrix(this.numberOfClasses, 1);
            matrixArray7[i] = new Matrix(n4, 1);
            dArray[i] = 0.0;
        }
        double d9 = 1.0;
        for (int i = 0; i < this.kValue; ++i) {
            int n7;
            for (n = 0; n < n5; ++n) {
                matrix10.set(n, 0, matrixArray2[i].get(n, 0));
            }
            d4 = matrix10.transpose().times(matrix10).get(0, 0);
            n = 0;
            double d10 = 1.0;
            while (d10 > d3 && n < 1000) {
                ++n;
                matrix11 = matrixArray[i].times(matrix10);
                for (n7 = 0; n7 < n4; ++n7) {
                    matrix11.set(n7, 0, matrix11.get(n7, 0) / d4);
                }
                d7 = Math.sqrt(matrix11.transpose().times(matrix11).get(0, 0));
                for (n7 = 0; n7 < n4; ++n7) {
                    matrix11.set(n7, 0, matrix11.get(n7, 0) / d7);
                }
                matrix13 = matrixArray[i].transpose().times(matrix11);
                d5 = matrix13.transpose().times(matrix13).get(0, 0);
                matrix14 = matrixArray2[i].transpose().times(matrix13);
                for (n7 = 0; n7 < this.numberOfClasses; ++n7) {
                    matrix14.set(n7, 0, matrix14.get(n7, 0) / d5);
                }
                d6 = Math.sqrt(matrix14.transpose().times(matrix14).get(0, 0));
                for (n7 = 0; n7 < this.numberOfClasses; ++n7) {
                    matrix14.set(n7, 0, matrix14.get(n7, 0) / d6);
                }
                matrix10 = matrixArray2[i].times(matrix14);
                if (n > 1) {
                    d10 = matrix11.minus(matrix12).transpose().times(matrix11.minus(matrix12)).get(0, 0);
                }
                System.out.println("mplsAlgorithm() - loop = " + n + "  delta = " + d10);
                for (n7 = 0; n7 < n4; ++n7) {
                    matrix12.set(n7, 0, matrix11.get(n7, 0));
                }
            }
            matrixArray6[i] = matrix14;
            matrixArray7[i] = matrixArray[i].times(matrix13);
            for (n7 = 0; n7 < n4; ++n7) {
                matrixArray7[i].set(n7, 0, matrixArray7[i].get(n7, 0) / d5);
            }
            d9 = Math.sqrt(matrixArray7[i].transpose().times(matrixArray7[i]).get(0, 0));
            for (n7 = 0; n7 < n4; ++n7) {
                matrixArray7[i].set(n7, 0, matrixArray7[i].get(n7, 0) / d9);
            }
            matrixArray5[i] = matrix13;
            matrixArray4[i] = matrix11;
            dArray[i] = matrix10.transpose().times(matrix13).get(0, 0) / d5;
            if (i < this.kValue) {
                matrixArray[i + 1] = matrixArray[i].minus(matrixArray5[i].times(matrixArray7[i].transpose()).transpose());
                matrixArray2[i + 1] = matrixArray2[i].minus(matrixArray5[i].times(matrixArray6[i].transpose()).times(dArray[i]));
            }
            algorithmEvent.setIntValue(i);
            algorithmEvent.setDescription("Calculating Component # " + (i + 1) + "\n");
            this.fireValueChanged(algorithmEvent);
        }
        Matrix[] matrixArray8 = new Matrix[this.kValue];
        for (n = 0; n < this.kValue; ++n) {
            matrixArray8[n] = new Matrix(n6, 1);
        }
        matrixArray8[0] = matrixArray3[0].transpose().times(matrixArray4[0]);
        for (n = 1; n < this.kValue; ++n) {
            matrixArray3[n] = matrixArray3[n - 1].minus(matrixArray8[n - 1].times(matrixArray7[n - 1].transpose()).transpose());
            matrixArray8[n] = matrixArray3[n].transpose().times(matrixArray4[n]);
        }
        Matrix matrix15 = new Matrix(this.kValue, n6);
        for (int i = 0; i < this.kValue; ++i) {
            for (int j = 0; j < n6; ++j) {
                matrix15.set(i, j, matrixArray8[i].get(j, 0));
            }
        }
        System.out.println(" ");
        System.out.println("************** End mplsAlgorithm() **************");
        System.out.println(" ");
        return matrix15;
    }

    public Matrix InitialClassification(Matrix matrix) throws AlgorithmException {
        int n;
        int n2;
        Matrix matrix2;
        Matrix matrix3;
        int n3;
        int n4;
        System.out.println(" ");
        System.out.println("******************** Begin InitialClassification() ********************");
        System.out.println(" ");
        double[][] dArray = new double[this.numberOfSamples][this.numberOfClasses];
        int n5 = 1;
        double[] dArray2 = new double[this.numberOfGenes];
        int n6 = this.trainingMatrix.getColumnDimension();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Initial Classification\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.preSelectGenes && matrix.getRowDimension() > this.kValue) {
            this.selectedGeneIndices = this.geneSelection(this.trainingMatrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                n5 = this.selectedGeneIndices[0].size();
            }
            System.out.println("***********************************");
            System.out.println("selected gene indices size for highest rank= " + this.selectedGeneIndices[this.highestGeneRank].size());
            System.out.println("highest rank = " + this.highestGeneRank);
            for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank].size(); ++n4) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(n4));
            }
            if (this.highestGeneRank > 1) {
                for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++n4) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(n4));
                }
            }
            n4 = 0;
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                if (this.isFoundInVector(n3, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(n3));
            }
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                dArray2[n3] = this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            matrix3 = new Matrix(n5, n6);
            matrix2 = new Matrix(n5, this.numberOfSamples);
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (dArray2[n3] == 1.0) {
                    for (n = 0; n < n6; ++n) {
                        matrix3.set(n2, n, this.trainingMatrix.get(n3, n));
                    }
                    for (n = 0; n < this.numberOfSamples; ++n) {
                        matrix2.set(n2, n, matrix.get(n3, n));
                    }
                }
                ++n3;
            }
            System.out.println(" ");
            System.out.println("InitialClassification() - numOfSelectedGenes = " + n5);
            System.out.println(" ");
        } else {
            for (n4 = 0; n4 < this.numberOfGenes; ++n4) {
                this.reducedGeneSet[0].add(new Integer(n4));
            }
            matrix3 = new Matrix(this.numberOfGenes, n6);
            matrix3 = this.trainingMatrix;
            matrix2 = new Matrix(this.numberOfGenes, this.numberOfSamples);
            matrix2 = matrix;
        }
        Matrix matrix4 = new Matrix(n6, this.numberOfClasses);
        matrix4 = this.responseMatrix.getMatrix(this.trainingIndices, 0, this.numberOfClasses - 1);
        Matrix matrix5 = matrix2.getRowDimension() == this.kValue ? matrix2 : this.mplsAlgorithm(matrix3, matrix4, matrix2);
        this.geneComponentMatrix = matrix5;
        System.out.println(" ");
        System.out.println("InitialClassification() - geneCompMatrix row = " + matrix5.getRowDimension());
        System.out.println("InitialClassification() - geneCompMatrix column = " + matrix5.getColumnDimension());
        System.out.println("InitialClassification() - geneCompMatrix: ");
        this.printMatrix(matrix5);
        Matrix matrix6 = matrix5.getMatrix(0, matrix5.getRowDimension() - 1, this.trainingIndices);
        System.out.println("InitialClassification() - trainingCompMatrix row = " + matrix6.getRowDimension());
        System.out.println("InitialClassification() - trainingCompMatrix column = " + matrix6.getColumnDimension());
        System.out.println("InitialClassification() - trainingCompMatrix :");
        this.printMatrix(matrix6);
        System.out.println("InitialClassification() - trainingRespMatrix :");
        this.printMatrix(matrix4);
        if (this.isPDA) {
            try {
                this.beta = this.mleAlgorithm(matrix6, matrix4);
            }
            catch (AlgorithmException algorithmException) {
                throw new AbortException();
            }
        }
        try {
            this.calculateQDAParameters(matrix6, matrix4);
        }
        catch (AlgorithmException algorithmException) {
            throw new AbortException();
        }
        int n7 = matrix5.getRowDimension();
        int n8 = matrix5.getColumnDimension();
        int[] nArray = new int[n8 - 1];
        Matrix matrix7 = new Matrix(n7, 1);
        System.out.println("InitialClassification() - numOfGenes " + n7);
        System.out.println("InitialClassification() - numOfTestSamples  " + n8);
        for (n2 = 0; n2 < this.testIndices.length; ++n2) {
            n3 = this.testIndices[n2];
            System.out.println(" ");
            System.out.println("InitialClassification() -- begin testSample = " + n3);
            matrix7 = matrix5.getMatrix(0, n7 - 1, n3, n3);
            System.out.println(" ");
            System.out.println("InitialClassification() - testMatrix: ");
            this.printMatrix(matrix7);
            dArray[n3] = this.isPDA ? this.pdaAlgorithm(matrix7) : this.qdaAlgorithm(matrix7);
        }
        System.out.println(" ");
        System.out.println("InitialClassification() - Probability Function: ");
        for (n2 = 0; n2 < this.testIndices.length; ++n2) {
            n3 = this.testIndices[n2];
            for (n = 0; n < this.numberOfClasses; ++n) {
                System.out.print(dArray[n3][n] + ",  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        double d = 0.0;
        int n9 = 0;
        for (int i = 0; i < this.testIndices.length; ++i) {
            n3 = this.testIndices[i];
            n9 = 0;
            if (!Double.isNaN(dArray[n3][0])) {
                d = dArray[n3][0];
                n9 = 1;
                for (int j = 0; j < this.numberOfClasses; ++j) {
                    if (!Double.isNaN(dArray[n3][j])) {
                        if (!(dArray[n3][j] > d)) continue;
                        d = dArray[n3][j];
                        n9 = j + 1;
                        continue;
                    }
                    n9 = 0;
                    j = this.numberOfClasses;
                }
            } else {
                n9 = 0;
            }
            this.classified[n9].add(new Integer(n3));
            System.out.println("InitialClassification() - Sample # " + n3 + " is in class " + n9);
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("******************** End InitialClassification() ********************");
        System.out.println(" ");
        return new Matrix(dArray);
    }

    public Matrix A0Algorithm(Matrix matrix) throws AlgorithmException {
        int n;
        int n2;
        Matrix matrix2;
        int n3;
        int n4;
        System.out.println(" ");
        System.out.println("******************** Begin A0Algorithm() ********************");
        System.out.println(" ");
        double[][] dArray = new double[this.numberOfSamples][this.numberOfClasses];
        int n5 = 1;
        double[] dArray2 = new double[this.numberOfGenes];
        int n6 = this.trainingMatrix.getColumnDimension();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A0\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.preSelectGenes && matrix.getRowDimension() > this.kValue) {
            this.selectedGeneIndices = this.geneSelection(matrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                n5 = this.selectedGeneIndices[0].size();
            }
            for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank].size(); ++n4) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(n4));
            }
            if (this.highestGeneRank > 1) {
                for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++n4) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(n4));
                }
            }
            n4 = 0;
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                if (this.isFoundInVector(n3, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(n3));
            }
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                dArray2[n3] = this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            matrix2 = new Matrix(n5, this.numberOfSamples);
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (dArray2[n3] == 1.0) {
                    for (n = 0; n < this.numberOfSamples; ++n) {
                        matrix2.set(n2, n, matrix.get(n3, n));
                    }
                }
                ++n3;
            }
            System.out.println(" ");
            System.out.println("A0Algorithm() - numOfSelectedGenes = " + n5);
            System.out.println(" ");
        } else {
            for (n4 = 0; n4 < this.numberOfGenes; ++n4) {
                this.reducedGeneSet[0].add(new Integer(n4));
            }
            matrix2 = new Matrix(this.numberOfGenes, this.numberOfSamples);
            matrix2 = matrix;
        }
        Matrix matrix3 = matrix2.getRowDimension() == this.kValue ? matrix2 : this.mplsAlgorithm(matrix2, this.responseMatrix, matrix2);
        this.geneComponentMatrix = matrix3;
        System.out.println(" ");
        System.out.println("A0Algorithm() - geneCompMatrix row = " + matrix3.getRowDimension());
        System.out.println("A0Algorithm() - geneCompMatrix column = " + matrix3.getColumnDimension());
        System.out.println(" ");
        System.out.println("A0Algorithm() - geneCompMatrix: ");
        for (n4 = 0; n4 < matrix3.getRowDimension(); ++n4) {
            for (n3 = 0; n3 < matrix3.getColumnDimension(); ++n3) {
                System.out.print(matrix3.get(n4, n3) + ", ");
            }
            System.out.println(" ");
            System.out.println(" ");
        }
        if (this.performLOOCV) {
            int n7 = matrix3.getRowDimension();
            int n8 = matrix3.getColumnDimension();
            int[] nArray = new int[n8 - 1];
            Matrix matrix4 = new Matrix(n7, 1);
            Matrix matrix5 = new Matrix(n7, n8 - 1);
            Matrix matrix6 = new Matrix(n8 - 1, this.numberOfClasses);
            System.out.println("A0Algorithm() - numOfGenes " + n7);
            System.out.println("A0Algorithm() - numOfTestSamples  " + n8);
            for (n3 = 0; n3 < n8; ++n3) {
                System.out.println("A0Algorithm() -- begin leaveOutSample = " + n3);
                this.singularMatrix[n3] = false;
                for (n2 = 0; n2 < n8; ++n2) {
                    if (n2 < n3) {
                        nArray[n2] = n2;
                        continue;
                    }
                    if (n2 <= n3) continue;
                    nArray[n2 - 1] = n2;
                }
                System.out.println(" ");
                System.out.println("A0Algorithm() - columnList: ");
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    System.out.print(nArray[n2] + ", ");
                }
                System.out.println(" ");
                System.out.println(" ");
                matrix5 = matrix3.getMatrix(0, n7 - 1, nArray);
                matrix6 = this.responseMatrix.getMatrix(nArray, 0, this.numberOfClasses - 1);
                System.out.println(" ");
                System.out.println("A0Algorithm() - subGeneCompMatrix: " + matrix5.getRowDimension() + " X " + matrix5.getColumnDimension());
                this.printMatrix(matrix5);
                matrix4 = matrix3.getMatrix(0, n7 - 1, n3, n3);
                System.out.println(" ");
                System.out.println("A0Algorithm() - testMatrix: " + matrix4.getRowDimension() + " X " + matrix4.getColumnDimension());
                System.out.println("A0Algorithm() - testMatrix: ");
                this.printMatrix(matrix4);
                if (this.isPDA) {
                    try {
                        this.beta = this.mleAlgorithm(matrix5, matrix6);
                    }
                    catch (AlgorithmException algorithmException) {
                        this.singularMatrix[n3] = true;
                        continue;
                    }
                    dArray[n3] = this.pdaAlgorithm(matrix4);
                    continue;
                }
                try {
                    this.calculateQDAParameters(matrix5, matrix6);
                }
                catch (AlgorithmException algorithmException) {
                    this.singularMatrix[n3] = true;
                    continue;
                }
                dArray[n3] = this.qdaAlgorithm(matrix4);
            }
            System.out.println(" ");
            System.out.println("A0Algorithm() - Probability Function: ");
            for (n3 = 0; n3 < n8; ++n3) {
                for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
                    System.out.print(dArray[n3][n2] + ",  ");
                }
                System.out.println(" ");
            }
            System.out.println(" ");
            double d = 0.0;
            n = 0;
            for (int i = 0; i < n8; ++i) {
                if (this.singularMatrix[i]) continue;
                d = dArray[i][0];
                n = 0;
                if (!Double.isNaN(dArray[i][0])) {
                    d = dArray[i][0];
                    n = 1;
                    for (int j = 0; j < this.numberOfClasses; ++j) {
                        if (!Double.isNaN(dArray[i][j])) {
                            if (!(dArray[i][j] > d)) continue;
                            d = dArray[i][j];
                            n = j + 1;
                            continue;
                        }
                        n = 0;
                        j = this.numberOfClasses;
                    }
                } else {
                    n = 0;
                }
                this.classified[n].add(new Integer(i));
                System.out.println("A0Algorithm() - Sample # " + i + " is in class # " + n);
            }
            System.out.println(" ");
        }
        System.out.println("DAM.java - A0Algorithm() -  classified.length = " + this.classified.length);
        for (int i = 0; i < this.classified.length; ++i) {
            System.out.println("DAM.java - A0Algorithm() -  classified[" + i + "].size() = " + this.classified[i].size());
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("******************** End A0Algorithm() ********************");
        System.out.println(" ");
        return new Matrix(dArray);
    }

    public Matrix A1Algorithm(Matrix matrix) throws AlgorithmException {
        int n;
        int n2;
        Matrix matrix2;
        int n3;
        int n4;
        System.out.println(" ");
        System.out.println("******************** Begin A1Algorithm() ********************");
        System.out.println(" ");
        double[][] dArray = new double[this.numberOfSamples][this.numberOfClasses];
        double[] dArray2 = new double[this.numberOfGenes];
        int n5 = 1;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A1\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.preSelectGenes && matrix.getRowDimension() > this.kValue) {
            this.selectedGeneIndices = this.geneSelection(matrix);
            if (this.selectedGeneIndices == null) {
                return null;
            }
            if (this.highestGeneRank > 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 1) {
                n5 = this.selectedGeneIndices[this.highestGeneRank].size();
            } else if (this.highestGeneRank == 0) {
                n5 = this.selectedGeneIndices[0].size();
            }
            for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank].size(); ++n4) {
                this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank].get(n4));
            }
            if (this.highestGeneRank > 1) {
                for (n4 = 0; n4 < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++n4) {
                    this.reducedGeneSet[0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(n4));
                }
            }
            n4 = 0;
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                if (this.isFoundInVector(n3, this.reducedGeneSet[0])) continue;
                this.reducedGeneSet[1].add(new Integer(n3));
            }
            for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                dArray2[n3] = this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank]) || this.isFoundInVector(n3, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
            }
            matrix2 = new Matrix(n5, this.numberOfSamples);
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (dArray2[n3] == 1.0) {
                    for (n = 0; n < this.numberOfSamples; ++n) {
                        matrix2.set(n2, n, matrix.get(n3, n));
                    }
                }
                ++n3;
            }
            System.out.println(" ");
            System.out.println("A1Algorithm() - numOfSelectedGenes = " + n5);
            System.out.println(" ");
        } else {
            for (n4 = 0; n4 < this.numberOfGenes; ++n4) {
                this.reducedGeneSet[0].add(new Integer(n4));
            }
            matrix2 = new Matrix(this.numberOfGenes, this.numberOfSamples);
            matrix2 = matrix;
        }
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            this.singularMatrix[n4] = false;
            n3 = 0;
            System.out.println("A1Algorithm() -- begin leaveOutSample = " + n4);
            int[] nArray = new int[this.numberOfSamples - 1];
            for (n = 0; n < this.numberOfSamples; ++n) {
                if (n < n4) {
                    nArray[n] = n;
                    continue;
                }
                if (n <= n4) continue;
                nArray[n - 1] = n;
            }
            System.out.println(" ");
            System.out.println("A1Algorithm() - columnList: ");
            for (n = 0; n < nArray.length; ++n) {
                System.out.print(nArray[n] + ", ");
            }
            System.out.println(" ");
            System.out.println(" ");
            Matrix matrix3 = matrix2.getMatrix(0, n5 - 1, nArray);
            Matrix matrix4 = this.responseMatrix.getMatrix(nArray, 0, this.numberOfClasses - 1);
            Matrix matrix5 = matrix2.getRowDimension() == this.kValue ? matrix2 : this.mplsAlgorithm(matrix3, matrix4, matrix2);
            this.geneComponentMatrix = matrix5;
            n = matrix5.getRowDimension();
            Matrix matrix6 = new Matrix(n, 1);
            matrix6 = matrix5.getMatrix(0, n - 1, n4, n4);
            Matrix matrix7 = new Matrix(n, this.numberOfSamples - 1);
            matrix7 = matrix5.getMatrix(0, n - 1, nArray);
            if (this.isPDA) {
                try {
                    this.beta = this.mleAlgorithm(matrix7, matrix4);
                }
                catch (AlgorithmException algorithmException) {
                    this.singularMatrix[n4] = true;
                    continue;
                }
                dArray[n4] = this.pdaAlgorithm(matrix6);
                continue;
            }
            try {
                this.calculateQDAParameters(matrix7, matrix4);
            }
            catch (AlgorithmException algorithmException) {
                this.singularMatrix[n4] = true;
                continue;
            }
            dArray[n4] = this.qdaAlgorithm(matrix6);
        }
        System.out.println(" ");
        System.out.println("A1Algorithm() - Probablity Function: ");
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            for (n3 = 0; n3 < this.numberOfClasses; ++n3) {
                System.out.print(dArray[n4][n3] + ",  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        double d = 0.0;
        n2 = 0;
        for (n = 0; n < this.numberOfSamples; ++n) {
            if (this.singularMatrix[n]) continue;
            d = dArray[n][0];
            n2 = 0;
            if (!Double.isNaN(dArray[n][0])) {
                d = dArray[n][0];
                n2 = 1;
                for (int i = 0; i < this.numberOfClasses; ++i) {
                    if (!Double.isNaN(dArray[n][i])) {
                        if (!(dArray[n][i] > d)) continue;
                        d = dArray[n][i];
                        n2 = i + 1;
                        continue;
                    }
                    n2 = 0;
                    i = this.numberOfClasses;
                }
            } else {
                n2 = 0;
            }
            this.classified[n2].add(new Integer(n));
            System.out.println("A1Algorithm() - Sample # " + n + " is in class # " + n2);
        }
        System.out.println(" ");
        System.out.println("DAM.java - A1Algorithm() -  classified.length = " + this.classified.length);
        for (n = 0; n < this.classified.length; ++n) {
            System.out.println("DAM.java - A1Algorithm() -  classified[" + n + "].size() = " + this.classified[n].size());
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("******************** End A1Algorithm() ********************");
        System.out.println(" ");
        return new Matrix(dArray);
    }

    public Matrix A2Algorithm(Matrix matrix) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        int n4;
        System.out.println(" ");
        System.out.println("******************** Begin A2Algorithm() ********************");
        System.out.println(" ");
        double[][] dArray = new double[this.numberOfSamples][this.numberOfClasses];
        double[] dArray2 = new double[this.numberOfGenes];
        int n5 = 1;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfGenes, "Classification Algorithm : A2\n");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        System.out.println("A2Algorithm() Start ---------");
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            Matrix matrix2;
            this.singularMatrix[n4] = false;
            System.out.println("A2Algorithm() -- For leaveOutSamp = " + n4 + " Start: ");
            int[] nArray = new int[this.numberOfSamples - 1];
            for (n3 = 0; n3 < this.numberOfSamples; ++n3) {
                if (n3 < n4) {
                    nArray[n3] = n3;
                    continue;
                }
                if (n3 <= n4) continue;
                nArray[n3 - 1] = n3;
            }
            System.out.println(" ");
            System.out.println("A2Algorithm() - columnList: ");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                System.out.print(nArray[n3] + ", ");
            }
            System.out.println(" ");
            System.out.println(" ");
            Matrix matrix3 = matrix.getMatrix(0, this.numberOfGenes - 1, nArray);
            Matrix matrix4 = this.responseMatrix.getMatrix(nArray, 0, this.numberOfClasses - 1);
            if (this.preSelectGenes && matrix.getRowDimension() > this.kValue) {
                int n6;
                this.selectedGeneIndices = this.geneSelection(matrix3);
                if (this.selectedGeneIndices == null) {
                    return null;
                }
                if (this.highestGeneRank > 1) {
                    n5 = this.selectedGeneIndices[this.highestGeneRank - 1].size() + this.selectedGeneIndices[this.highestGeneRank].size();
                } else if (this.highestGeneRank == 1) {
                    n5 = this.selectedGeneIndices[this.highestGeneRank].size();
                } else if (this.highestGeneRank == 0) {
                    n5 = this.selectedGeneIndices[0].size();
                }
                for (n3 = 0; n3 < this.selectedGeneIndices[this.highestGeneRank].size(); ++n3) {
                    this.reducedGeneSetForA2[n4][0].add(this.selectedGeneIndices[this.highestGeneRank].get(n3));
                }
                if (this.highestGeneRank > 1) {
                    for (n3 = 0; n3 < this.selectedGeneIndices[this.highestGeneRank - 1].size(); ++n3) {
                        this.reducedGeneSetForA2[n4][0].add(this.selectedGeneIndices[this.highestGeneRank - 1].get(n3));
                    }
                }
                n3 = 0;
                for (n6 = 0; n6 < this.numberOfGenes; ++n6) {
                    if (this.isFoundInVector(n6, this.reducedGeneSetForA2[n4][0])) continue;
                    this.reducedGeneSetForA2[n4][1].add(new Integer(n6));
                }
                for (n6 = 0; n6 < this.numberOfGenes; ++n6) {
                    dArray2[n6] = this.isFoundInVector(n6, this.selectedGeneIndices[this.highestGeneRank]) || this.highestGeneRank > 0 && this.isFoundInVector(n6, this.selectedGeneIndices[this.highestGeneRank - 1]) ? 1.0 : 0.0;
                }
                System.out.println(" ");
                System.out.println("A2Algorithm() - numOfSelectedGenes = " + n5);
                System.out.println(" ");
                matrix2 = new Matrix(n5, this.numberOfSamples);
                n6 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    if (dArray2[n6] == 1.0) {
                        for (int i = 0; i < this.numberOfSamples; ++i) {
                            matrix2.set(n2, i, matrix.get(n6, i));
                        }
                    }
                    ++n6;
                }
                System.out.println(" ");
                System.out.println("A2Algorithm() - numOfSelectedGenes = " + n5);
                System.out.println(" ");
            } else {
                for (n3 = 0; n3 < this.numberOfGenes; ++n3) {
                    this.reducedGeneSetForA2[n4][0].add(new Integer(n3));
                }
                matrix2 = new Matrix(this.numberOfGenes, this.numberOfSamples);
                matrix2 = matrix;
            }
            Matrix matrix5 = new Matrix(n5, this.numberOfSamples - 1);
            matrix5 = matrix2.getMatrix(0, n5 - 1, nArray);
            Matrix matrix6 = matrix2.getRowDimension() == this.kValue ? matrix2 : this.mplsAlgorithm(matrix5, matrix4, matrix2);
            this.geneComponentMatrix = matrix6;
            n3 = matrix6.getRowDimension();
            Matrix matrix7 = new Matrix(n3, 1);
            matrix7 = matrix6.getMatrix(0, n3 - 1, n4, n4);
            Matrix matrix8 = new Matrix(n3, this.numberOfSamples - 1);
            matrix8 = matrix6.getMatrix(0, n3 - 1, nArray);
            if (this.isPDA) {
                try {
                    this.beta = this.mleAlgorithm(matrix8, matrix4);
                }
                catch (AlgorithmException algorithmException) {
                    this.singularMatrix[n4] = true;
                    continue;
                }
                dArray[n4] = this.pdaAlgorithm(matrix7);
            } else {
                try {
                    this.calculateQDAParameters(matrix8, matrix4);
                }
                catch (AlgorithmException algorithmException) {
                    this.singularMatrix[n4] = true;
                    continue;
                }
                dArray[n4] = this.qdaAlgorithm(matrix7);
            }
            System.out.println("A2Algorithm() -- For leaveOutSamp = " + n4 + " End: ");
            System.out.println(" ");
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println("A2Algorithm() - Probablity Function: ");
        for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
            for (int i = 0; i < this.numberOfClasses; ++i) {
                System.out.print(dArray[n4][i] + ",  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        double d = 0.0;
        n3 = 0;
        for (n = 0; n < this.numberOfSamples; ++n) {
            if (this.singularMatrix[n]) continue;
            d = dArray[n][0];
            n3 = 0;
            if (!Double.isNaN(dArray[n][0])) {
                d = dArray[n][0];
                n3 = 1;
                for (n2 = 0; n2 < this.numberOfClasses; ++n2) {
                    if (!Double.isNaN(dArray[n][n2])) {
                        if (!(dArray[n][n2] > d)) continue;
                        d = dArray[n][n2];
                        n3 = n2 + 1;
                        continue;
                    }
                    n3 = 0;
                    n2 = this.numberOfClasses;
                }
            } else {
                n3 = 0;
            }
            this.classified[n3].add(new Integer(n));
            System.out.println("A2Algorithm() - Sample # " + n + " is in class # " + n3);
        }
        System.out.println(" ");
        System.out.println("DAM.java - A2Algorithm() -  classified.length = " + this.classified.length);
        for (n = 0; n < this.classified.length; ++n) {
            System.out.println("DAM.java - A2Algorithm() -  classified[" + n + "].size() = " + this.classified[n].size());
        }
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("******************** End A2Algorithm() ********************");
        System.out.println(" ");
        return new Matrix(dArray);
    }

    public double getTValue(int n, double d) {
        double[][] dArrayArray = new double[][]{{1.0, 6.314, 12.706, 31.821, 63.657, 636.619}, {2.0, 2.92, 4.303, 6.965, 9.925, 31.598}, {3.0, 2.353, 3.182, 4.541, 5.841, 12.941}, {4.0, 2.132, 2.776, 3.747, 4.604, 8.61}, {5.0, 2.015, 2.571, 3.365, 4.032, 6.859}, {6.0, 1.943, 2.447, 3.143, 3.707, 5.959}, {7.0, 1.895, 2.365, 2.998, 3.499, 5.405}, {8.0, 1.86, 2.306, 2.896, 3.355, 5.041}, {9.0, 1.833, 2.262, 2.821, 3.25, 4.781}, {10.0, 1.812, 2.228, 2.764, 3.169, 4.587}, {11.0, 1.796, 2.201, 2.718, 3.106, 4.437}, {12.0, 1.782, 2.179, 2.681, 3.055, 4.318}, {13.0, 1.771, 2.16, 2.65, 3.012, 4.221}, {14.0, 1.761, 2.145, 2.624, 2.997, 4.14}, {15.0, 1.753, 2.131, 2.602, 2.947, 4.073}, {16.0, 1.746, 2.12, 2.583, 2.921, 4.015}, {17.0, 1.74, 2.11, 2.567, 2.898, 3.965}, {18.0, 1.734, 2.101, 2.552, 2.878, 3.922}, {19.0, 1.729, 2.093, 2.539, 2.861, 3.883}, {20.0, 1.725, 2.086, 2.528, 2.845, 3.85}, {21.0, 1.721, 2.08, 2.518, 2.831, 3.819}, {22.0, 1.717, 2.074, 2.508, 2.819, 3.792}, {23.0, 1.714, 2.069, 2.5, 2.807, 3.767}, {24.0, 1.711, 2.064, 2.492, 2.797, 3.745}, {25.0, 1.708, 2.06, 2.485, 2.787, 3.725}, {26.0, 1.706, 2.056, 2.479, 2.779, 3.707}, {27.0, 1.703, 2.052, 2.473, 2.771, 3.69}, {28.0, 1.701, 2.048, 2.467, 2.763, 3.674}, {29.0, 1.699, 2.045, 2.462, 2.756, 3.659}, {30.0, 1.697, 2.042, 2.457, 2.75, 3.646}, {40.0, 1.684, 2.021, 2.423, 2.704, 3.551}, {60.0, 1.671, 2.0, 2.39, 2.66, 3.46}, {120.0, 1.658, 1.98, 2.358, 2.617, 3.373}, {1000.0, 1.645, 1.96, 2.326, 2.576, 3.291}};
        int n2 = 0;
        int n3 = 0;
        double d2 = 1.0E-5;
        if (Math.abs(d - 0.1) < d2) {
            n3 = 1;
        } else if (Math.abs(d - 0.05) < d2) {
            n3 = 2;
        } else if (Math.abs(d - 0.02) < d2) {
            n3 = 3;
        } else if (Math.abs(d - 0.01) < d2) {
            n3 = 4;
        } else if (Math.abs(d - 0.001) < d2) {
            n3 = 5;
        } else {
            return -2.0;
        }
        if (n <= 0) {
            System.out.println("DAM.java: getTValue() - degreeOfFreedom <= 0, return");
            return -2.0;
        }
        if (n <= 30) {
            n2 = n - 1;
        } else if (n > 30 && n < 40) {
            n2 = 29;
        } else if (n >= 40 && n < 60) {
            n2 = 30;
        } else if (n >= 60 && n < 120) {
            n2 = 31;
        } else if (n >= 120 && n < 1000) {
            n2 = 32;
        } else if (n >= 1000) {
            n2 = 33;
        } else if (n <= 0) {
            // empty if block
        }
        return dArrayArray[n2][n3];
    }

    private Matrix getSampleMeans(Matrix matrix) {
        int n = matrix.getColumnDimension();
        int n2 = matrix.getRowDimension();
        Matrix matrix2 = new Matrix(1, n);
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            d = 0.0;
            n3 = 0;
            for (int j = 0; j < n2; ++j) {
                double d3 = matrix.get(j, i);
                if (Double.isNaN(d3)) continue;
                d += d3;
                ++n3;
            }
            d2 = d / (double)n3;
            matrix2.set(0, i, d2);
        }
        return matrix2;
    }

    private Matrix getSampleVariances(Matrix matrix, Matrix matrix2) {
        int n = matrix2.getRowDimension();
        int n2 = matrix2.getColumnDimension();
        Matrix matrix3 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix3.set(i, j, this.getSampleVariance(matrix, matrix2));
            }
        }
        return matrix3;
    }

    private double getSampleNormalizedSum(Matrix matrix, Matrix matrix2) {
        double d = 0.0;
        double d2 = 0.0;
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            double d3 = matrix2.get(0, i);
            for (int j = 0; j < n; ++j) {
                d2 = matrix.get(j, i);
                if (Double.isNaN(d2)) continue;
                d += Math.pow(d2 - d3, 2.0);
                ++this.denominator;
            }
        }
        return d;
    }

    private double getSampleVariance(Matrix matrix, Matrix matrix2) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = matrix.getColumnDimension();
        int n3 = matrix.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            double d3 = matrix2.get(0, i);
            for (int j = 0; j < n3; ++j) {
                d2 = matrix.get(j, i);
                if (Double.isNaN(d2)) continue;
                d += Math.pow(d2 - d3, 2.0);
                ++n;
            }
        }
        return Math.sqrt(d / (double)(n - 1));
    }

    private Matrix getCovarianceMatrix(Matrix matrix, Matrix matrix2) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        Matrix[] matrixArray = new Matrix[n2];
        for (int i = 0; i < n2; ++i) {
            matrixArray[i] = new Matrix(1, n);
            matrixArray[i] = matrix.getMatrix(0, n - 1, i, i).transpose();
        }
        Matrix matrix3 = new Matrix(n, n);
        for (int i = 0; i < n2; ++i) {
            matrix3 = matrix3.plus(matrixArray[i].minus(matrix2).transpose().times(matrixArray[i].minus(matrix2)));
        }
        matrix3 = matrix3.times(1.0 / (double)(n2 - 1));
        return matrix3;
    }

    private double getGroupMean(double[] dArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d += dArray[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double d2 = d / (double)n;
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        return d2;
    }

    private boolean isFoundInVector(int n, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (n != (Integer)vector.get(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Matrix getJamaMatrix(FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = floatMatrix.A[i][j];
            }
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    public FloatMatrix getFloatMatrix(Matrix matrix) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = (float)matrix.getArray()[i][j];
            }
        }
        FloatMatrix floatMatrix = new FloatMatrix(fArray);
        return floatMatrix;
    }

    private Matrix getMeansForGenes(Vector[] vectorArray) {
        Matrix matrix = new Matrix(vectorArray.length, this.numberOfSamples);
        for (int i = 0; i < vectorArray.length; ++i) {
            Matrix matrix2 = this.getMeanForGenes(vectorArray[i]);
            matrix.setMatrix(i, i, 0, this.numberOfSamples - 1, matrix2);
        }
        return matrix;
    }

    private Matrix getMeanForGenes(Vector vector) {
        Matrix matrix = new Matrix(1, this.numberOfSamples);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            double d = 0.0;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                double d2 = this.expMatrix.get(((Integer)vector.get(j)).intValue(), i);
                if (Double.isNaN(d2)) continue;
                d += d2;
                ++n2;
            }
            matrix.set(0, i, d / (double)n2);
        }
        return matrix;
    }

    private Matrix getVariancesForGenes(Vector[] vectorArray, Matrix matrix) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix2.set(i, j, this.getClusterVarianceForGenes(vectorArray[i], j, matrix.get(i, j)));
            }
        }
        return matrix2;
    }

    private double getSampleNormalizedSumForGenes(Vector vector, int n, double d) {
        int n2 = vector.size();
        double d2 = 0.0;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            double d3 = this.expMatrix.get(((Integer)vector.get(i)).intValue(), n);
            if (Double.isNaN(d3)) continue;
            d2 += Math.pow(d3 - d, 2.0);
            ++this.validN;
        }
        return d2;
    }

    private double getClusterVarianceForGenes(Vector vector, int n, double d) {
        return Math.sqrt(this.getSampleNormalizedSumForGenes(vector, n, d) / (double)(this.validN - 1));
    }

    private Matrix getMeans(Vector[] vectorArray) {
        Matrix matrix = new Matrix(vectorArray.length, this.numberOfGenes);
        for (int i = 0; i < vectorArray.length; ++i) {
            Matrix matrix2 = this.getMean(vectorArray[i]);
            matrix.setMatrix(i, i, 0, this.numberOfGenes - 1, matrix2);
        }
        return matrix;
    }

    private Matrix getMean(Vector vector) {
        Matrix matrix = new Matrix(1, this.numberOfGenes);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numberOfGenes; ++i) {
            double d = 0.0;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                double d2 = this.expMatrixTranspose.get(((Integer)vector.get(j)).intValue(), i);
                if (Double.isNaN(d2)) continue;
                d += d2;
                ++n2;
            }
            matrix.set(0, i, d / (double)n2);
        }
        return matrix;
    }

    private Matrix getVariances(Vector[] vectorArray, Matrix matrix) {
        int n = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix2.set(i, j, this.getClusterVariance(vectorArray[i], j, matrix.get(i, j)));
            }
        }
        return matrix2;
    }

    private double getSampleNormalizedSum(Vector vector, int n, double d) {
        int n2 = vector.size();
        double d2 = 0.0;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            double d3 = this.expMatrixTranspose.get(((Integer)vector.get(i)).intValue(), n);
            if (Double.isNaN(d3)) continue;
            d2 += Math.pow(d3 - d, 2.0);
            ++this.validN;
        }
        return d2;
    }

    private double getClusterVariance(Vector vector, int n, double d) {
        return Math.sqrt(this.getSampleNormalizedSum(vector, n, d) / (double)(this.validN - 1));
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private void printMatrix(Matrix matrix) {
        DecimalFormat decimalFormat = new DecimalFormat("####.000000");
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                System.out.print(decimalFormat.format(matrix.get(i, j)) + "  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println(" ");
    }

    private void printMatrix(FloatMatrix floatMatrix) {
        DecimalFormat decimalFormat = new DecimalFormat("####.000000");
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                System.out.print(decimalFormat.format(floatMatrix.get(i, j)) + "  ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        System.out.println(" ");
    }

    public void abort() {
        this.stop = true;
    }
}

