/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.CastClust;
import org.tigr.microarray.mev.cluster.algorithm.impl.KMC;
import org.tigr.util.FloatMatrix;

public class FOM
extends AbstractAlgorithm {
    private boolean stop = false;
    private boolean clusterGenes;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmEvent algorithmEvent;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n = algorithmParameters.getInt("distance-function", 4);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        this.clusterGenes = algorithmParameters.getBoolean("cluster-genes", true);
        int n2 = algorithmParameters.getInt("fom-iterations", 1);
        int n3 = algorithmParameters.getInt("method", 2);
        float f2 = algorithmParameters.getFloat("interval", 0.1f);
        int n4 = algorithmParameters.getInt("iterations", 50);
        int n5 = algorithmParameters.getInt("number-of-clusters", 20);
        boolean bl2 = algorithmParameters.getBoolean("average", true);
        boolean bl3 = algorithmParameters.getBoolean("calculate-means", true);
        FloatMatrix floatMatrix = algorithmData.getMatrix("experiment");
        int n6 = floatMatrix.getRowDimension();
        int n7 = floatMatrix.getColumnDimension();
        AbstractAlgorithm abstractAlgorithm = null;
        abstractAlgorithm = n3 == 2 ? new KMC() : new CastClust(true);
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-factor", String.valueOf(f));
        algorithmData2.addParam("distance-absolute", String.valueOf(bl));
        algorithmData2.addParam("distance-function", String.valueOf(n));
        algorithmData2.addParam("number-of-iterations", String.valueOf(n4));
        algorithmData2.addParam("calculate-means", String.valueOf(bl3));
        AlgorithmData algorithmData3 = null;
        Cluster cluster = new Cluster();
        float[] fArray = null;
        FloatMatrix floatMatrix2 = null;
        int n8 = 0;
        int[] nArray = new int[1];
        if (n3 == 2) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, n5);
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setId(2);
            algorithmData2.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
            fArray = new float[n5];
            floatMatrix2 = new FloatMatrix(n2, n5);
            for (int i = 0; i < n2; ++i) {
                algorithmEvent.setDescription("Calculating FOMs for FOM iteration " + String.valueOf(i + 1) + " of " + String.valueOf(n2) + " iterations.");
                this.fireValueChanged(algorithmEvent);
                for (int j = 0; j < n5; ++j) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(j);
                    this.fireValueChanged(algorithmEvent);
                    algorithmData2.addParam("number-of-clusters", String.valueOf(j + 1));
                    algorithmData3 = abstractAlgorithm.execute(algorithmData2);
                    cluster = algorithmData3.getCluster("cluster");
                    floatMatrix2.set(i, j, (float)this.getFOM(floatMatrix, cluster, n6, n7));
                }
            }
        } else {
            n8 = (int)(1.0f / f2);
            algorithmEvent = new AlgorithmEvent((Object)this, 1, n8);
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setId(2);
            algorithmData2.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
            nArray = new int[n8];
            float f3 = 0.0f;
            fArray = new float[n8];
            for (int i = 0; i < n8; ++i) {
                if ((f3 += f2) > 1.0f) {
                    f3 = 1.0f;
                }
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("calculating for threshold of " + String.valueOf(f3));
                this.fireValueChanged(algorithmEvent);
                algorithmData2.addParam("threshold", String.valueOf(f3));
                algorithmData3 = abstractAlgorithm.execute(algorithmData2);
                cluster = algorithmData3.getCluster("cluster");
                fArray[i] = (float)this.getFOM(floatMatrix, cluster, n6, n7);
                nArray[i] = cluster.getNodeList().getSize();
            }
        }
        algorithmEvent = new AlgorithmData();
        if (n3 == 2) {
            algorithmEvent.addMatrix("fom-matrix", floatMatrix2);
        } else {
            algorithmEvent.addMatrix("fom-values", new FloatMatrix(fArray, 1));
        }
        algorithmEvent.addIntArray("numOfCastClusters", nArray);
        return algorithmEvent;
    }

    public double getFOM(FloatMatrix floatMatrix, Cluster cluster, int n, int n2) {
        int n3;
        float f;
        int[] nArray;
        int n4 = 0;
        NodeList nodeList = cluster.getNodeList();
        int n5 = nodeList.getSize();
        double[][] dArray = new double[n2][n5];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n5; ++j) {
                dArray[i][j] = 0.0;
                nArray = nodeList.getNode(j).getFeaturesIndexes();
                n4 = 0;
                for (int k = 0; k < nArray.length; ++k) {
                    f = floatMatrix.get(nArray[k], i);
                    if (Float.isNaN(f)) continue;
                    double[] dArray2 = dArray[i];
                    int n6 = j;
                    dArray2[n6] = dArray2[n6] + (double)f;
                    ++n4;
                }
                if (n4 > 0) {
                    double[] dArray3 = dArray[i];
                    int n7 = j;
                    dArray3[n7] = dArray3[n7] / (double)n4;
                    continue;
                }
                dArray[i][j] = 0.0;
            }
        }
        double[] dArray4 = new double[n2];
        double d = 1.0;
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = 0.0;
            for (int j = 0; j < n5; ++j) {
                nArray = nodeList.getNode(j).getFeaturesIndexes();
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    f = floatMatrix.get(nArray[n3], i);
                    if (Float.isNaN(f)) continue;
                    int n8 = i;
                    dArray4[n8] = dArray4[n8] + Math.pow((double)f - dArray[i][j], 2.0);
                }
            }
            dArray4[i] = Math.sqrt(dArray4[i] / (double)n);
        }
        double d2 = 0.0;
        for (n3 = 0; n3 < n2; ++n3) {
            d2 += dArray4[n3];
        }
        return d2;
    }

    public void abort() {
        this.stop = true;
    }
}

