/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.util.Adjustment;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class GSH
extends AbstractAlgorithm {
    private long StartTime;
    private long CalculationTime;
    private JLabel StatusLabel;
    private int CurrentCluster;
    private int CreatedCluster;
    private GSCluster[] clusters;
    private GSCluster[] resultClusters;
    private boolean gshGenes;
    private int m;
    private int n;
    private int k;
    private int fakedMatrix;
    private int swapTime;
    private int matrixSize;
    private int geneAssaigned = 0;
    private int validN;
    private Matrix dataMatrix;
    private Matrix workingMatrix;
    private SingularValueDecomposition SVD;
    private EigenvalueDecomposition EVD;
    private double[][] values;
    private Matrix eigenVector;
    private double[] prinCom;
    private double[] currentGene;
    private GSCluster unassigned;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    ProgressDialog PD;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private int hcl_function;
    private boolean hcl_absolute;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.gshGenes = algorithmParameters.getBoolean("gsh-cluster-genes", true);
        this.fakedMatrix = n3 = algorithmParameters.getInt("number-of-fakedMatrix", 20);
        this.swapTime = n2 = algorithmParameters.getInt("number-of-swap", 5);
        this.k = n = algorithmParameters.getInt("number-of-clusters", 5);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n4 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.n = this.number_of_genes = this.expMatrix.getRowDimension();
        this.m = this.number_of_samples = this.expMatrix.getColumnDimension();
        this.values = new double[this.n][this.m];
        this.prinCom = new double[this.m];
        JFrame jFrame = new JFrame();
        this.PD = this.gshGenes ? new ProgressDialog(jFrame, "Gene Shaving -- Progress", false, 6) : new ProgressDialog(jFrame, "Sample Shaving -- Progress", false, 6);
        JPanel jPanel = this.PD.getLabelPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JButton jButton = new JButton(" Cancel ");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GSH.this.stop = true;
                GSH.this.PD.dismiss();
            }
        });
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jButton, "South");
        this.PD.setMainPanel(jPanel2);
        this.PD.setSize(450, 200);
        this.calculate();
        FloatMatrix floatMatrix = this.getMeans(this.clusters);
        FloatMatrix floatMatrix2 = this.getVariances(this.clusters, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n4, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters-means", floatMatrix);
        algorithmData2.addMatrix("clusters-variances", floatMatrix2);
        return algorithmData2;
    }

    public void getMatrix() {
        int n;
        int n2;
        double[][] dArray = new double[this.n][this.m];
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < this.m; ++n) {
                dArray[n2][n] = this.expMatrix.A[n2][n];
            }
        }
        Adjustment.meanCenterSpots((FloatMatrix)this.expMatrix);
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < this.m; ++n) {
                this.values[n2][n] = this.expMatrix.A[n2][n];
                this.expMatrix.A[n2][n] = (float)dArray[n2][n];
            }
        }
        this.dataMatrix = new Matrix(this.values);
    }

    public void calculate() {
        int n;
        int n2;
        this.PD.setMessage(0, "Distance: " + AbstractAlgorithm.getDistanceName((int)this.function));
        this.PD.setMessage(1, "Clusters to be created: " + this.k);
        this.PD.setMessage(2, "0 clusters created.");
        this.PD.setMessage(3, this.geneAssaigned + " genes have been assigned to clusters.");
        this.PD.setMessage(4, this.n - this.geneAssaigned + " genes left to be assigned to clusters.");
        this.PD.setTimerLabel(5, "Running for ", " seconds.", 1000);
        this.PD.setVisible(true);
        this.getMatrix();
        this.CreatedCluster = 0;
        this.resultClusters = new GSCluster[this.k + 1];
        this.resultClusters[this.k] = new GSCluster();
        for (n2 = 0; n2 < this.n; ++n2) {
            this.resultClusters[this.k].add(new Integer(n2));
        }
        while (this.CreatedCluster < this.k) {
            this.CurrentCluster = 0;
            this.unassigned = new GSCluster();
            for (n2 = 0; n2 < this.n; ++n2) {
                this.unassigned.add(new Integer(n2));
            }
            n2 = this.getIteration();
            this.clusters = new GSCluster[n2];
            for (n = 0; n < this.clusters.length; ++n) {
                this.clusters[n] = new GSCluster();
            }
            for (n = 0; n < n2; ++n) {
                int n3;
                this.matrixSize = this.unassigned.size();
                double[] dArray = new double[this.matrixSize];
                int[] nArray = new int[this.matrixSize];
                for (n3 = 0; n3 < this.matrixSize; ++n3) {
                    nArray[n3] = (Integer)this.unassigned.elementAt(n3);
                }
                this.workingMatrix = this.dataMatrix.getMatrix(nArray, 0, this.m - 1);
                this.getPrincipleComponent();
                for (n3 = 0; n3 < this.matrixSize; ++n3) {
                    this.currentGene = this.getGene(n3);
                    dArray[n3] = this.getInnerProduct(this.prinCom, this.currentGene);
                }
                this.shaveGene(dArray);
                ++this.CurrentCluster;
            }
            n = 0;
            double d = 0.0;
            for (int i = 0; i < this.clusters.length; ++i) {
                this.workingMatrix = (Matrix)this.dataMatrix.clone();
                double d2 = this.getDk(this.clusters[i]) - this.getD_k(this.clusters[i]);
                if (!(d2 > d)) continue;
                d = d2;
                n = i;
            }
            this.resultClusters[this.CreatedCluster] = (GSCluster)this.clusters[n].clone();
            this.geneAssaigned += this.resultClusters[this.CreatedCluster].size();
            this.PD.setMessage(2, this.CreatedCluster + 1 + " clusters created.");
            if (this.gshGenes) {
                this.PD.setMessage(3, this.geneAssaigned + " genes have been assigned to clusters.");
                this.PD.setMessage(4, this.n - this.geneAssaigned + " genes left to be assigned to clusters.");
            } else {
                this.PD.setMessage(3, this.geneAssaigned + " experiments have been assigned to clusters.");
                this.PD.setMessage(4, this.n - this.geneAssaigned + " experiments left to be assigned to clusters.");
            }
            this.updateMatrix();
            ++this.CreatedCluster;
        }
        for (n2 = 0; n2 < this.resultClusters.length - 1; ++n2) {
            for (n = 0; n < this.resultClusters[n2].size(); ++n) {
                try {
                    this.resultClusters[this.k].removeElement(this.resultClusters[n2].elementAt(n));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Exception when removing elements");
                }
            }
        }
        for (n2 = 0; n2 < this.resultClusters.length; ++n2) {
            for (n = 0; n < this.resultClusters[n2].size(); ++n) {
            }
        }
        this.clusters = this.resultClusters;
        this.PD.dismiss();
    }

    public void abort() {
        this.stop = true;
    }

    public void getPrincipleComponent() {
        double[][] dArray = new double[1][this.matrixSize];
        this.EVD = this.workingMatrix.times(this.workingMatrix.transpose()).eig();
        Matrix matrix = this.EVD.getD();
        Matrix matrix2 = this.EVD.getV();
        for (int i = 0; i < this.matrixSize; ++i) {
            dArray[0][i] = matrix2.get(i, 0);
        }
        this.eigenVector = new Matrix(dArray);
        Matrix matrix3 = this.eigenVector.times(this.workingMatrix);
        for (int i = 0; i < this.m; ++i) {
            this.prinCom[i] = matrix3.get(0, i);
        }
    }

    public int getIteration() {
        int n = 0;
        int n2 = this.n;
        while (n2 > 1) {
            n2 -= Math.max((int)((double)n2 * 0.1), 1);
            ++n;
        }
        return n;
    }

    public double getInnerProduct(double[] dArray, double[] dArray2) {
        int n = 0;
        double d = 0.0;
        if (dArray.length != dArray2.length) {
            System.out.println("Vector has different number of elements!");
        } else {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public double[] getGene(int n) {
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.workingMatrix.get(n, i);
        }
        return dArray;
    }

    public void shaveGene(double[] dArray) {
        int n;
        int n2 = Math.max((int)((double)this.unassigned.size() * 0.1), 1);
        int[] nArray = new int[n2];
        Integer n3 = new Integer(-1);
        for (n = 0; n < n2; ++n) {
            double d = dArray[0];
            int n4 = 0;
            for (int i = 0; i < this.matrixSize; ++i) {
                if (!(d > dArray[i])) continue;
                d = dArray[i];
                n4 = i;
            }
            nArray[n] = n4;
            dArray[n4] = Double.MAX_VALUE;
        }
        for (n = 0; n < n2; ++n) {
            this.clusters[this.CurrentCluster].add((Integer)this.unassigned.elementAt(nArray[n]));
            this.unassigned.setElementAt(n3, nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            this.unassigned.removeElement(n3);
        }
    }

    public double getDk(GSCluster gSCluster) {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        double d = 0.0;
        FloatMatrix floatMatrix = gSCluster.getAveGene();
        for (n = 0; n < this.m; ++n) {
            f += floatMatrix.get(0, n);
        }
        f /= (float)this.m;
        for (n = 0; n < this.m; ++n) {
            f2 = (float)((double)f2 + Math.pow(floatMatrix.get(0, n) - f, 2.0));
        }
        f2 /= (float)this.m;
        for (n = 0; n < this.m; ++n) {
            for (int i = 0; i < gSCluster.size(); ++i) {
                double d2 = this.workingMatrix.get(((Integer)gSCluster.get(i)).intValue(), n);
                d += Math.pow(d2 - (double)floatMatrix.get(0, n), 2.0);
            }
        }
        double d3 = (double)f2 / (d /= (double)(this.m * gSCluster.size())) / (1.0 + (double)f2 / d);
        return d3;
    }

    public double getD_k(GSCluster gSCluster) {
        double d = 0.0;
        for (int i = 0; i < this.fakedMatrix; ++i) {
            this.getPermutedMatrix();
            d += this.getDk(gSCluster);
        }
        return d /= (double)this.fakedMatrix;
    }

    public void getPermutedMatrix() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.swapTime; ++j) {
                Random random = new Random();
                int n = (int)Math.floor(random.nextFloat() * (float)this.m);
                n = Math.min(n, this.m - 1);
                double d = this.workingMatrix.get(i, n);
                int n2 = (int)Math.floor(random.nextFloat() * (float)this.m);
                n2 = Math.min(n2, this.m - 1);
                this.workingMatrix.set(i, n, this.workingMatrix.get(i, n2));
                this.workingMatrix.set(i, n2, d);
            }
        }
    }

    public void updateMatrix() {
        double[][] dArray = new double[1][this.m];
        FloatMatrix floatMatrix = this.resultClusters[this.CreatedCluster].getAveGene();
        for (int i = 0; i < this.m; ++i) {
            dArray[0][i] = floatMatrix.get(0, i);
        }
        Matrix matrix = new Matrix(dArray);
        Matrix matrix2 = Matrix.identity((int)this.m, (int)this.m);
        Matrix matrix3 = matrix2.minus(matrix.transpose().times(matrix));
        this.dataMatrix = this.dataMatrix.times(matrix3);
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.gshGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(GSCluster[] gSClusterArray) {
        FloatMatrix floatMatrix = new FloatMatrix(gSClusterArray.length, this.number_of_samples);
        for (int i = 0; i < gSClusterArray.length; ++i) {
            FloatMatrix floatMatrix2 = gSClusterArray[i].getMean();
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(GSCluster[] gSClusterArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(gSClusterArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(GSCluster gSCluster, int n, float f) {
        int n2 = gSCluster.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Integer)gSCluster.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(GSCluster gSCluster, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(gSCluster, n, f) / (float)(this.validN - 1));
    }

    private class GSCluster
    extends Vector {
        private FloatMatrix AveGene;
        private FloatMatrix mean;

        public GSCluster() {
            this.AveGene = new FloatMatrix(1, GSH.this.m);
            this.mean = new FloatMatrix(1, GSH.this.m);
        }

        public FloatMatrix getAveGene() {
            int n = this.size();
            for (int i = 0; i < GSH.this.m; ++i) {
                double d = 0.0;
                for (int j = 0; j < n; ++j) {
                    float f = (float)GSH.this.workingMatrix.get(((Integer)this.get(j)).intValue(), i);
                    if (Float.isNaN(f)) continue;
                    d += (double)f;
                }
                this.AveGene.set(0, i, (float)(d / (double)n));
            }
            return this.AveGene;
        }

        public Vector fGenes() {
            Vector<Float> vector = new Vector<Float>();
            for (int i = 0; i < this.size(); ++i) {
                vector.addElement(new Float(((Integer)this.elementAt(i)).intValue()));
            }
            return vector;
        }

        public void calculateMean() {
            int n = this.size();
            for (int i = 0; i < GSH.this.number_of_samples; ++i) {
                float f = 0.0f;
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    float f2 = GSH.this.expMatrix.get(((Integer)this.get(j)).intValue(), i);
                    if (Float.isNaN(f2)) continue;
                    f += f2;
                    ++n2;
                }
                this.mean.set(0, i, f / (float)n2);
            }
        }

        public FloatMatrix getMean() {
            this.calculateMean();
            return this.mean;
        }
    }
}

