/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.CDATASectionImpl;
import com.ibm.xml.dom.CommentImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DOMImplementationImpl;
import com.ibm.xml.dom.DeepNodeListImpl;
import com.ibm.xml.dom.DocumentFragmentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.EntityImpl;
import com.ibm.xml.dom.EntityReferenceImpl;
import com.ibm.xml.dom.NodeImpl;
import com.ibm.xml.dom.NotationImpl;
import com.ibm.xml.dom.ProcessingInstructionImpl;
import com.ibm.xml.dom.TextImpl;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    private static final boolean DEBUG_PRINT_TABLES = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected int fNodeCount = 0;
    protected byte[][] fNodeType;
    protected int[][] fNodeName;
    protected int[][] fNodeValue;
    protected int[][] fNodeParent;
    protected int[][] fNodeFirstChild;
    protected int[][] fNodeLastChild;
    protected int[][] fNodePrevSib;
    protected int[][] fNodeNextSib;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected ParserState fParserState;
    protected StringPool fStringPool;

    public DocumentImpl() {
        super(null, null, null);
        this.ownerDocument = this;
    }

    public DocumentImpl(ParserState state) {
        super(null, 0);
        this.fParserState = state;
        this.fStringPool = state.getStringPool();
        this.ownerDocument = this;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() {
        return null;
    }

    public Node cloneNode(boolean deep) {
        DocumentImpl newdoc = new DocumentImpl();
        if (deep) {
            NodeImpl n = (NodeImpl)this.getFirstChild();
            while (n != null) {
                newdoc.appendChild(newdoc.importNode(n, true));
                n = n.nextSibling;
            }
        }
        return newdoc;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        short type = newChild.getNodeType();
        if (type == 1 && this.docElement != null || type == 10 && this.docType != null) {
            throw new DOMExceptionImpl(3, null);
        }
        super.insertBefore(newChild, refChild);
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = null;
        } else if (type == 10) {
            this.docType = null;
        }
        return oldChild;
    }

    public void setNodeValue(String x) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!DocumentImpl.isXMLName(name)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new AttrImpl(this, name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) throws DOMException {
        if (!DocumentImpl.isXMLName(tagName)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ElementImpl(this, tagName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (!DocumentImpl.isXMLName(name)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new EntityReferenceImpl(this, name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (!DocumentImpl.isXMLName(target)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public DocumentType getDoctype() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public DocumentType createDocumentType(String name) throws DOMException {
        if (!DocumentImpl.isXMLName(name)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new DocumentTypeImpl(this, name);
    }

    public Entity createEntity(String name) throws DOMException {
        return new EntityImpl(this, name);
    }

    public Notation createNotation(String name) throws DOMException {
        return new NotationImpl(this, name);
    }

    public ElementDefinitionImpl createElementDefinition(String name) throws DOMException {
        return new ElementDefinitionImpl(this, name);
    }

    public Node importNode(Node source, boolean deep) throws DOMException {
        NodeImpl newnode = null;
        short type = source.getNodeType();
        switch (type) {
            case 1: {
                Element newelement = this.createElement(source.getNodeName());
                NamedNodeMap srcattr = source.getAttributes();
                if (srcattr != null) {
                    int i = 0;
                    while (i < srcattr.getLength()) {
                        newelement.setAttributeNode((AttrImpl)this.importNode(srcattr.item(i), true));
                        ++i;
                    }
                }
                newnode = (NodeImpl)((Object)newelement);
                break;
            }
            case 2: {
                newnode = (NodeImpl)((Object)this.createAttribute(source.getNodeName()));
                break;
            }
            case 3: {
                newnode = (NodeImpl)((Object)this.createTextNode(source.getNodeValue()));
                break;
            }
            case 4: {
                newnode = (NodeImpl)((Object)this.createCDATASection(source.getNodeValue()));
                break;
            }
            case 5: {
                newnode = (NodeImpl)((Object)this.createEntityReference(source.getNodeName()));
                deep = false;
                break;
            }
            case 6: {
                Entity srcentity = (Entity)source;
                EntityImpl newentity = (EntityImpl)this.createEntity(source.getNodeName());
                newentity.setPublicId(srcentity.getPublicId());
                newentity.setSystemId(srcentity.getSystemId());
                newentity.setNotationName(srcentity.getNotationName());
                newnode = newentity;
                break;
            }
            case 7: {
                newnode = (ProcessingInstructionImpl)this.createProcessingInstruction(source.getNodeName(), source.getNodeValue());
                break;
            }
            case 8: {
                newnode = (NodeImpl)((Object)this.createComment(source.getNodeValue()));
                break;
            }
            case 10: {
                int i;
                DocumentTypeImpl newdoctype = (DocumentTypeImpl)this.createDocumentType(source.getNodeName());
                NamedNodeMap smap = ((DocumentType)source).getEntities();
                NamedNodeMap tmap = newdoctype.getEntities();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem((EntityImpl)this.importNode(smap.item(i), true));
                        ++i;
                    }
                }
                smap = ((DocumentType)source).getNotations();
                tmap = newdoctype.getNotations();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem((NotationImpl)this.importNode(smap.item(i), true));
                        ++i;
                    }
                }
                newnode = newdoctype;
                break;
            }
            case 11: {
                newnode = (NodeImpl)((Object)this.createDocumentFragment());
                break;
            }
            case 12: {
                Notation srcnotation = (Notation)source;
                NotationImpl newnotation = (NotationImpl)this.createNotation(source.getNodeName());
                newnotation.setPublicId(srcnotation.getPublicId());
                newnotation.setSystemId(srcnotation.getSystemId());
                newnode = newnotation;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, null);
            }
        }
        if (deep) {
            Node srckid = source.getFirstChild();
            while (srckid != null) {
                newnode.appendChild(this.importNode(srckid, true));
                srckid = srckid.getNextSibling();
            }
        }
        return newnode;
    }

    public int createDocument() {
        int nodeIndex = this.createNode((short)9);
        return nodeIndex;
    }

    public int createDocumentType(int rootElementNameIndex) {
        int nodeIndex = this.createNode((short)10);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeName[chunk][index] = rootElementNameIndex;
        return nodeIndex;
    }

    public int createNotation(int notationIndex) {
        int nodeIndex = this.createNode((short)12);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int extraDataIndex = this.createNode((short)3);
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        this.fNodeValue[chunk][index] = extraDataIndex;
        EntityPool pool = this.fParserState.getEntityPool();
        this.fNodeName[chunk][index] = pool.getNotationName(notationIndex);
        this.fNodeFirstChild[echunk][eindex] = pool.getPublicId(notationIndex);
        this.fNodeLastChild[echunk][eindex] = pool.getSystemId(notationIndex);
        return nodeIndex;
    }

    public int createEntity(int entityIndex) {
        int nodeIndex = this.createNode((short)6);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int extraDataIndex = this.createNode((short)3);
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        this.fNodeValue[chunk][index] = extraDataIndex;
        EntityPool pool = this.fParserState.getEntityPool();
        this.fNodeName[chunk][index] = pool.getEntityName(entityIndex);
        this.fNodeFirstChild[echunk][eindex] = pool.getPublicId(entityIndex);
        this.fNodeLastChild[echunk][eindex] = pool.getSystemId(entityIndex);
        this.fNodePrevSib[echunk][eindex] = pool.getNotationName(entityIndex);
        return nodeIndex;
    }

    public int createEntityReference(int entityRefIndex) {
        int nameIndex;
        int nodeIndex = this.createNode((short)5);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeName[chunk][index] = nameIndex = this.fParserState.getEntityPool().getEntityName(entityRefIndex);
        return nodeIndex;
    }

    public int createElement(int elementNameIndex, int attrListIndex) {
        int elementNodeIndex = this.createNode((short)1);
        int elementChunk = elementNodeIndex >> 11;
        int elementIndex = elementNodeIndex & 0x7FF;
        this.fNodeName[elementChunk][elementIndex] = elementNameIndex;
        if (attrListIndex != -1) {
            AttrPool attrPool = this.fParserState.getAttrPool();
            int first = attrPool.getFirstAttr(attrListIndex);
            int lastAttrNodeIndex = -1;
            int lastAttrChunk = -1;
            int lastAttrIndex = -1;
            int index = first;
            while (index != -1) {
                int attrNodeIndex = this.createNode((short)2);
                int attrChunk = attrNodeIndex >> 11;
                int attrIndex = attrNodeIndex & 0x7FF;
                this.fNodeParent[attrChunk][attrIndex] = elementNodeIndex;
                this.fNodeName[attrChunk][attrIndex] = attrPool.getAttrName(index);
                this.fNodeValue[attrChunk][attrIndex] = attrPool.isSpecified(index) ? 1 : 0;
                int textNodeIndex = this.createNode((short)3);
                int textChunk = textNodeIndex >> 11;
                int textIndex = textNodeIndex & 0x7FF;
                this.fNodeValue[textChunk][textIndex] = attrPool.getAttValue(index);
                this.appendChild(attrNodeIndex, textNodeIndex);
                if (index == first) {
                    this.fNodeValue[elementChunk][elementIndex] = attrNodeIndex;
                } else {
                    this.fNodeNextSib[lastAttrChunk][lastAttrIndex] = attrNodeIndex;
                    this.fNodePrevSib[attrChunk][attrIndex] = lastAttrNodeIndex;
                }
                lastAttrNodeIndex = attrNodeIndex;
                lastAttrChunk = attrChunk;
                lastAttrIndex = attrIndex;
                index = attrPool.getNextAttr(index);
            }
        }
        return elementNodeIndex;
    }

    public int createAttribute(int attrNameIndex, int attrValueIndex, boolean specified) {
        int nodeIndex = this.createNode((short)2);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeName[chunk][index] = attrNameIndex;
        this.fNodeValue[chunk][index] = specified ? 1 : 0;
        int textNodeIndex = this.createTextNode(attrValueIndex, false);
        this.appendChild(nodeIndex, textNodeIndex);
        return nodeIndex;
    }

    public int createElementDefinition(int elementNameIndex) {
        int nodeIndex = this.createNode((short)-1);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeName[chunk][index] = elementNameIndex;
        return nodeIndex;
    }

    public int createTextNode(int dataIndex, boolean ignorableWhitespace) {
        int nodeIndex = this.createNode((short)3);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeValue[chunk][index] = dataIndex;
        this.fNodeFirstChild[chunk][index] = ignorableWhitespace ? 1 : 0;
        return nodeIndex;
    }

    public int createCDATASection(int dataIndex) {
        int nodeIndex = this.createNode((short)4);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeValue[chunk][index] = dataIndex;
        return nodeIndex;
    }

    public int createProcessingInstruction(int targetIndex, int dataIndex) {
        int nodeIndex = this.createNode((short)7);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeName[chunk][index] = targetIndex;
        this.fNodeValue[chunk][index] = dataIndex;
        return nodeIndex;
    }

    public int createComment(int dataIndex) {
        int nodeIndex = this.createNode((short)8);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.fNodeValue[chunk][index] = dataIndex;
        return nodeIndex;
    }

    public void appendChild(int parentIndex, int childIndex) {
        int prev;
        int pchunk = parentIndex >> 11;
        int pindex = parentIndex & 0x7FF;
        int chunk = childIndex >> 11;
        int index = childIndex & 0x7FF;
        this.fNodeParent[chunk][index] = parentIndex;
        this.fNodePrevSib[chunk][index] = prev = this.fNodeLastChild[pchunk][pindex];
        if (prev == -1) {
            this.fNodeFirstChild[pchunk][pindex] = childIndex;
        } else {
            int chnk = prev >> 11;
            int indx = prev & 0x7FF;
            this.fNodeNextSib[chnk][indx] = childIndex;
        }
        this.fNodeLastChild[pchunk][pindex] = childIndex;
    }

    public void setAsFirstChild(int parentIndex, int childIndex) {
        int pchunk = parentIndex >> 11;
        int pindex = parentIndex & 0x7FF;
        int chunk = childIndex >> 11;
        int index = childIndex & 0x7FF;
        this.fNodeFirstChild[pchunk][pindex] = childIndex;
        int next = childIndex;
        while (next != -1) {
            childIndex = next;
            next = this.fNodeNextSib[chunk][index];
            chunk = next >> 11;
            index = next & 0x7FF;
        }
        this.fNodeLastChild[pchunk][pindex] = childIndex;
    }

    public int getParentNode(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeParent[chunk][index];
    }

    public int getFirstChild(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeFirstChild[chunk][index];
    }

    public int getLastChild(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int lastChild = this.fNodeLastChild[chunk][index];
        if (lastChild != -1 && this.fNodeType[chunk][index] == 3) {
            int previousIndex = this.fNodePrevSib[chunk][index];
            chunk = previousIndex >> 11;
            index = previousIndex & 0x7FF;
            if (previousIndex != -1 && this.fNodeType[chunk][index] == 3) {
                while (previousIndex != -1 && this.fNodeType[chunk][index] == 3) {
                    nodeIndex = previousIndex;
                    previousIndex = this.fNodePrevSib[chunk][index];
                    chunk = previousIndex >> 11;
                    index = previousIndex & 0x7FF;
                }
                return nodeIndex;
            }
        }
        return lastChild;
    }

    public int getPreviousSibling(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int previousIndex = this.fNodePrevSib[chunk][index];
        if (previousIndex != -1 && this.fNodeType[chunk][index] != 3 && this.fNodeType[chunk = previousIndex >> 11][index = previousIndex & 0x7FF] == 3) {
            while (previousIndex != -1 && this.fNodeType[chunk][index] == 3) {
                nodeIndex = previousIndex;
                previousIndex = this.fNodePrevSib[chunk][index];
                chunk = previousIndex >> 11;
                index = previousIndex & 0x7FF;
            }
            return nodeIndex;
        }
        return previousIndex;
    }

    public int getNextSibling(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        nodeIndex = this.fNodeNextSib[chunk][index];
        while (nodeIndex != -1 && this.fNodeType[chunk][index] == 3) {
            nodeIndex = this.fNodeNextSib[chunk][index];
            chunk = nodeIndex >> 11;
            index = nodeIndex & 0x7FF;
        }
        return nodeIndex;
    }

    public int getRealNextSibling(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeNextSib[chunk][index];
    }

    public int lookupElementDefinition(int elementNameIndex) {
        if (this.fNodeCount > 1) {
            int docTypeIndex = -1;
            int index = this.getFirstChild(0);
            while (index != -1) {
                if (this.getNodeType(index) == 10) {
                    docTypeIndex = index;
                    break;
                }
                index = this.getNextSibling(index);
            }
            int index2 = this.getFirstChild(docTypeIndex);
            while (index2 != -1) {
                if (this.getIntNodeName(index2) == elementNameIndex) {
                    return index2;
                }
                index2 = this.getNextSibling(index2);
            }
        }
        return -1;
    }

    public int getAttributeList(int elementNodeIndex) {
        if (elementNodeIndex == -1) {
            return -1;
        }
        int chunk = elementNodeIndex >> 11;
        int index = elementNodeIndex & 0x7FF;
        return this.fNodeValue[chunk][index];
    }

    public NodeImpl getNodeObject(int nodeIndex) {
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        byte type = this.fNodeType[chunk][index];
        NodeImpl node = null;
        switch (type) {
            case 2: {
                node = new AttrImpl(this, nodeIndex);
                break;
            }
            case 4: {
                node = new CDATASectionImpl(this, nodeIndex);
                break;
            }
            case 8: {
                node = new CommentImpl(this, nodeIndex);
                break;
            }
            case 9: {
                node = this;
                break;
            }
            case 10: {
                node = new DocumentTypeImpl(this, nodeIndex);
                this.docType = (DocumentTypeImpl)node;
                break;
            }
            case 1: {
                node = new ElementImpl(this, nodeIndex);
                if (this.docElement != null) break;
                this.docElement = (ElementImpl)node;
                break;
            }
            case 6: {
                node = new EntityImpl(this, nodeIndex);
                break;
            }
            case 5: {
                node = new EntityReferenceImpl(this, nodeIndex);
                break;
            }
            case 12: {
                node = new NotationImpl(this, nodeIndex);
                break;
            }
            case 7: {
                node = new ProcessingInstructionImpl(this, nodeIndex);
                break;
            }
            case 3: {
                node = new TextImpl(this, nodeIndex);
                break;
            }
            case -1: {
                node = new ElementDefinitionImpl(this, nodeIndex);
            }
        }
        if (node != null) {
            return node;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeName(int nodeIndex) {
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int nameIndex = this.fNodeName[chunk][index];
        if (nameIndex == -1) {
            return null;
        }
        return this.fStringPool.toString(nameIndex);
    }

    public String getNodeValue(int nodeIndex) {
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int valueIndex = this.fNodeValue[chunk][index];
        if (valueIndex == -1) {
            return null;
        }
        return this.fStringPool.toString(valueIndex);
    }

    public int getIntNodeName(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeName[chunk][index];
    }

    public int getIntNodeValue(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeValue[chunk][index];
    }

    public short getNodeType(int nodeIndex) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return this.fNodeType[chunk][index];
    }

    public static boolean isXMLName(String s) {
        char[] ca = new char[s.length()];
        s.getChars(0, s.length(), ca, 0);
        if (!Character.isLetter(ca[0]) && "_:".indexOf(ca[0]) == -1) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            char c = ca[i];
            int ctype = Character.getType(c);
            if (!Character.isLetterOrDigit(c) && ".-_:".indexOf(c) == -1 && (ctype < 6 || ctype > 8 || c >= '\u06dd' && c <= '\u06de' || c >= '\u20dd' && c <= '\u20e0' || c >= '\u309b') && (ctype != 4 || c >= '\u02d0' && c <= '\u0559' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u309b' && c <= '\u309c') && c != '\u00b7' && c != '\u0387') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void print() {
    }

    void synchronizeChildren() {
        this.syncChildren = false;
        super.synchronizeChildren();
        NodeImpl node = this.firstChild;
        while (node != null) {
            short type = node.getNodeType();
            if (type == 10) {
                this.docType = (DocumentTypeImpl)node;
            } else if (type == 1) {
                this.docElement = (ElementImpl)node;
            }
            node = node.nextSibling;
        }
    }

    protected boolean ensureCapacity(int chunk, int index) {
        if (this.fNodeType == null) {
            this.fNodeType = new byte[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeFirstChild = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeNextSib = new int[32][];
        }
        try {
            return this.fNodeType[chunk][index] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fNodeType, 0, newByteArray, 0, chunk);
            this.fNodeType = newByteArray;
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeName, 0, newIntArray, 0, chunk);
            this.fNodeName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeValue, 0, newIntArray, 0, chunk);
            this.fNodeValue = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeParent, 0, newIntArray, 0, chunk);
            this.fNodeParent = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeFirstChild, 0, newIntArray, 0, chunk);
            this.fNodeFirstChild = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeLastChild, 0, newIntArray, 0, chunk);
            this.fNodeLastChild = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodePrevSib, 0, newIntArray, 0, chunk);
            this.fNodePrevSib = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeNextSib, 0, newIntArray, 0, chunk);
            this.fNodeNextSib = newIntArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[chunk] = new byte[2048];
        this.fNodeName[chunk] = new int[2048];
        this.fNodeValue[chunk] = new int[2048];
        this.fNodeParent[chunk] = new int[2048];
        this.fNodeFirstChild[chunk] = new int[2048];
        this.fNodeLastChild[chunk] = new int[2048];
        this.fNodePrevSib[chunk] = new int[2048];
        this.fNodeNextSib[chunk] = new int[2048];
        return true;
    }

    protected int createNode(short nodeType) {
        int chunk = this.fNodeCount >> 11;
        int index = this.fNodeCount & 0x7FF;
        this.ensureCapacity(chunk, index);
        this.fNodeType[chunk][index] = (byte)nodeType;
        this.fNodeName[chunk][index] = -1;
        this.fNodeValue[chunk][index] = -1;
        this.fNodeParent[chunk][index] = -1;
        this.fNodeFirstChild[chunk][index] = -1;
        this.fNodeLastChild[chunk][index] = -1;
        this.fNodePrevSib[chunk][index] = -1;
        this.fNodeNextSib[chunk][index] = -1;
        return this.fNodeCount++;
    }
}

