/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.CharacterDataImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    boolean isIgnorableWhitespace = false;

    TextImpl(DocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, nodeIndex);
    }

    public TextImpl(DocumentImpl ownerDoc, String data) {
        super(ownerDoc, data);
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public boolean isIgnorableWhitespace() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.isIgnorableWhitespace;
    }

    public void setIgnorableWhitespace(boolean isIgnorableWhitespace) {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        this.isIgnorableWhitespace = isIgnorableWhitespace;
    }

    public Node cloneNode(boolean deep) {
        return this.ownerDocument.createTextNode(this.getNodeValue());
    }

    public Text splitText(int offset) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (offset < 0 || offset > this.value.length() - 1) {
            throw new DOMExceptionImpl(1, null);
        }
        Text newText = this.ownerDocument.createTextNode(this.value.substring(offset));
        this.setNodeValue(this.value.substring(0, offset));
        if (this.parentNode != null) {
            this.parentNode.insertBefore(newText, this.nextSibling);
        }
        return newText;
    }

    protected void synchronizeData() {
        this.value = this.ownerDocument.getNodeValue(this.fNodeIndex);
        int parent = -1;
        if (this.getNodeType() == 3 && (parent = this.ownerDocument.getParentNode(this.fNodeIndex)) != -1 && this.ownerDocument.getNodeType(parent) == 1) {
            int realNext = this.ownerDocument.getRealNextSibling(this.fNodeIndex);
            short type = this.ownerDocument.getNodeType(realNext);
            if (realNext != -1 && type == 3) {
                StringBuffer sb = new StringBuffer(this.value);
                while (realNext != -1 && type == 3) {
                    sb.append(this.ownerDocument.getNodeValue(realNext));
                    realNext = this.ownerDocument.getRealNextSibling(realNext);
                    type = this.ownerDocument.getNodeType(realNext);
                }
                this.value = sb.toString();
            }
        }
        this.syncData = false;
    }

    protected void synchronizeChildren() {
        this.isIgnorableWhitespace = this.ownerDocument.getFirstChild(this.fNodeIndex) == 1;
        this.syncChildren = false;
    }
}

