/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.InsertableElementsInfo;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.internal.CMBinOp;
import com.ibm.xml.internal.CMException;
import com.ibm.xml.internal.CMLeaf;
import com.ibm.xml.internal.CMNode;
import com.ibm.xml.internal.CMStateSet;
import com.ibm.xml.internal.CMUniOp;

class DFAContentModel
implements ContentModel {
    private static final String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static final String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private ElementDeclPool fDeclPool = null;
    private int fElementIndex = 0;
    private int[] fElemMap = null;
    private int fElemMapSize = 0;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private XMLErrorHandler fErrHandler = null;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private ContentSpecNode fSpecNode = null;
    private StringPool fStringPool = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;

    static {
        fEpsilonString.intern();
        fEOCString.intern();
    }

    public DFAContentModel(int elementIndex, StringPool stringPool, ElementDeclPool declPool) throws CMException {
        this.fElementIndex = elementIndex;
        this.fDeclPool = declPool;
        this.fStringPool = stringPool;
        this.fEpsilonIndex = this.fStringPool.addSymbol(fEpsilonString);
        this.fEOCIndex = this.fStringPool.addSymbol(fEOCString);
        this.fSpecNode = new ContentSpecNode();
        this.fDeclPool.getContentSpecNode(this.fDeclPool.getContentSpec(this.fElementIndex), this.fSpecNode);
        this.buildDFA();
    }

    public int validateContent(int childCount, int[] children) throws CMException {
        if (childCount == 0) {
            if (this.fEmptyContentIsValid) {
                return -1;
            }
            return 0;
        }
        int curState = 0;
        int childIndex = 0;
        while (childIndex < childCount) {
            int curElem = children[childIndex];
            int elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                if (this.fElemMap[elemIndex] == curElem) break;
                ++elemIndex;
            }
            if (elemIndex == this.fElemMapSize) {
                return childIndex;
            }
            if ((curState = this.fTransTable[curState][elemIndex]) == -1) {
                return childIndex;
            }
            ++childIndex;
        }
        if (!this.fFinalStateFlags[curState]) {
            return childCount;
        }
        return -1;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws CMException {
        int curState = 0;
        int childIndex = 0;
        while (childIndex < info.insertAt) {
            int curElem = info.curChildren[childIndex];
            int elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                if (this.fElemMap[elemIndex] == curElem) break;
                ++elemIndex;
            }
            if (elemIndex == this.fElemMapSize) {
                return childIndex;
            }
            if ((curState = this.fTransTable[curState][elemIndex]) == -1) {
                return childIndex;
            }
            ++childIndex;
        }
        int insertState = curState;
        info.canHoldPCData = false;
        info.isValidEOC = this.fFinalStateFlags[insertState];
        info.resultsCount = this.fElemMapSize;
        if (info.results == null || info.results.length < info.resultsCount) {
            info.results = new boolean[info.resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < info.resultsCount) {
            info.possibleChildren = new int[info.resultsCount];
        }
        int index = 0;
        while (index < this.fElemMapSize) {
            info.possibleChildren[index] = this.fElemMap[index];
            info.results[index] = this.fTransTable[insertState][index] != -1;
            ++index;
        }
        if (fullyValid) {
            int index2 = 0;
            while (index2 < info.resultsCount) {
                if (info.results[index2]) {
                    info.curChildren[info.insertAt] = info.possibleChildren[index2];
                    if (this.validateContent(info.childCount, info.curChildren) != -1) {
                        info.results[index2] = false;
                    }
                }
                ++index2;
            }
        }
        return -1;
    }

    private void buildDFA() throws CMException {
        ContentSpecNode nodeTmp = new ContentSpecNode();
        CMLeaf nodeEOC = new CMLeaf(0, this.fEOCIndex);
        this.fHeadNode = new CMBinOp(5, this.buildSyntaxTree(this.fDeclPool.getContentSpec(this.fElementIndex), nodeTmp), nodeEOC);
        this.fEOCPos = this.fLeafCount;
        nodeEOC.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int index = 0;
        while (index < this.fLeafCount) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
            ++index;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int outIndex = 0;
        while (outIndex < this.fLeafCount) {
            int elemIndex = this.fLeafList[outIndex].getElemIndex();
            int inIndex = 0;
            while (inIndex < this.fElemMapSize) {
                if (this.fElemMap[inIndex] == elemIndex) break;
                ++inIndex;
            }
            if (inIndex == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize++] = elemIndex;
            }
            ++outIndex;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(this.fEOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = 0;
                while (leafIndex < this.fLeafCount) {
                    if (setT.getBit(leafIndex) && this.fLeafList[leafIndex].getElemIndex() == this.fElemMap[elemIndex]) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    ++leafIndex;
                }
                if (!newSet.isEmpty()) {
                    int stateIndex = 0;
                    while (stateIndex < curState) {
                        if (statesToDo[stateIndex].isSameSet(newSet)) break;
                        ++stateIndex;
                    }
                    if (stateIndex == curState) {
                        statesToDo[curState] = newSet;
                        this.fTransTable[curState] = this.makeDefStateList();
                        ++curState;
                        newSet = null;
                    }
                    transEntry[elemIndex] = stateIndex;
                    if (curState == curArraySize) {
                        int newSize = (int)((double)curArraySize * 1.5);
                        CMStateSet[] newToDo = new CMStateSet[newSize];
                        boolean[] newFinalFlags = new boolean[newSize];
                        int[][] newTransTable = new int[newSize][];
                        int expIndex = 0;
                        while (expIndex < curArraySize) {
                            newToDo[expIndex] = statesToDo[expIndex];
                            newFinalFlags[expIndex] = this.fFinalStateFlags[expIndex];
                            newTransTable[expIndex] = this.fTransTable[expIndex];
                            ++expIndex;
                        }
                        curArraySize = newSize;
                        statesToDo = newToDo;
                        this.fFinalStateFlags = newFinalFlags;
                        this.fTransTable = newTransTable;
                    }
                }
                ++elemIndex;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private final CMNode buildSyntaxTree(int startNode, ContentSpecNode specNode) throws CMException {
        CMNode nodeRet = null;
        this.fDeclPool.getContentSpecNode(startNode, specNode);
        if (specNode.type == 0) {
            nodeRet = new CMLeaf(specNode.type, specNode.value, this.fLeafCount++);
        } else {
            int leftNode = specNode.value;
            int rightNode = specNode.otherValue;
            if (specNode.type == 4 || specNode.type == 5) {
                nodeRet = new CMBinOp(specNode.type, this.buildSyntaxTree(leftNode, specNode), this.buildSyntaxTree(rightNode, specNode));
            } else if (specNode.type == 2) {
                nodeRet = new CMUniOp(specNode.type, this.buildSyntaxTree(leftNode, specNode));
            } else if (specNode.type == 1) {
                nodeRet = new CMBinOp(4, this.buildSyntaxTree(leftNode, specNode), new CMLeaf(0, this.fEpsilonIndex));
            } else if (specNode.type == 3) {
                nodeRet = new CMBinOp(5, this.buildSyntaxTree(leftNode, specNode), new CMUniOp(2, this.buildSyntaxTree(leftNode, specNode)));
            } else {
                throw new CMException(152);
            }
        }
        return nodeRet;
    }

    private void calcFollowList(CMNode nodeCur) throws CMException {
        if (nodeCur.type() == 4) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
            return;
        }
        if (nodeCur.type() == 5) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
            CMStateSet last = ((CMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((CMBinOp)nodeCur).getRight().firstPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
            return;
        }
        if (nodeCur.type() == 2) {
            this.calcFollowList(((CMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
            return;
        }
        if (nodeCur.type() == 3 || nodeCur.type() == 1) {
            throw new CMException(157);
        }
    }

    private void dumpTree(CMNode nodeCur, int level) throws CMException {
        int index = 0;
        while (index < level) {
            System.out.print("   ");
            ++index;
        }
        int type = nodeCur.type();
        if (type == 4 || type == 5) {
            if (type == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (nodeCur.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
            this.dumpTree(((CMBinOp)nodeCur).getLeft(), level + 1);
            this.dumpTree(((CMBinOp)nodeCur).getRight(), level + 1);
            return;
        }
        if (nodeCur.type() == 2) {
            System.out.print("Rep Node ");
            if (nodeCur.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
            this.dumpTree(((CMUniOp)nodeCur).getChild(), level + 1);
            return;
        }
        if (nodeCur.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)nodeCur).getPosition() + "), " + this.fStringPool.toString(((CMLeaf)nodeCur).getElemIndex()) + "(elemIndex=" + ((CMLeaf)nodeCur).getElemIndex() + ") ");
            if (nodeCur.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
            return;
        }
        throw new CMException(157);
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        int index = 0;
        while (index < this.fElemMapSize) {
            retArray[index] = -1;
            ++index;
        }
        return retArray;
    }

    private int postTreeBuildInit(CMNode nodeCur, int curIndex) throws CMException {
        nodeCur.setMaxStates(this.fLeafCount);
        if (nodeCur.type() == 4 || nodeCur.type() == 5) {
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getLeft(), curIndex);
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getRight(), curIndex);
        } else if (nodeCur.type() == 2) {
            curIndex = this.postTreeBuildInit(((CMUniOp)nodeCur).getChild(), curIndex);
        } else if (nodeCur.type() == 0) {
            if (((CMLeaf)nodeCur).getElemIndex() != this.fEpsilonIndex) {
                this.fLeafList[curIndex++] = (CMLeaf)nodeCur;
            }
        } else {
            throw new CMException(157);
        }
        return curIndex;
    }
}

