/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttDef;
import com.ibm.xml.framework.Attr;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import org.xml.sax.AttributeList;

public final class DefaultAttrPool
implements AttrPool,
AttributeList {
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;
    static final int ATTRFLAG_SPECIFIED = 64;
    static final int ATTRFLAG_LASTATTR = 128;
    private StringPool fStringPool = null;
    private XMLErrorHandler fErrorHandler = null;
    private int fAttlistIndex = -1;
    private int fAttlistLength = 0;
    private int fAttrCount = 0;
    private int[][] fAttName = new int[32][];
    private int[][] fAttValue = new int[32][];
    private byte[][] fAttTypeAndFlags = new byte[32][];

    public DefaultAttrPool(ParserState parserState) {
        this.fStringPool = parserState.cacheStringPool();
        this.fErrorHandler = parserState.getErrorHandler();
    }

    public void reset(ParserState parserState) {
        this.fStringPool = parserState.cacheStringPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fAttlistIndex = -1;
        this.fAttlistLength = 0;
        this.fAttrCount = 0;
    }

    public AttrPool resetOrCopy(ParserState parserState) {
        return new DefaultAttrPool(parserState);
    }

    private boolean ensureCapacity(int chunk, int index) {
        try {
            return this.fAttName[chunk][index] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttName, 0, newIntArray, 0, chunk);
            this.fAttName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttValue, 0, newIntArray, 0, chunk);
            this.fAttValue = newIntArray;
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fAttTypeAndFlags, 0, newByteArray, 0, chunk);
            this.fAttTypeAndFlags = newByteArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttName[chunk] = new int[32];
        this.fAttValue[chunk] = new int[32];
        this.fAttTypeAndFlags[chunk] = new byte[32];
        return true;
    }

    public int addAttr(Attr attr, int firstAttrIndex) throws Exception {
        int index;
        int chunk;
        if (firstAttrIndex != -1) {
            chunk = firstAttrIndex >> 5;
            index = firstAttrIndex & 0x1F;
            while (firstAttrIndex < this.fAttrCount) {
                if (this.fAttName[chunk][index] == attr.attName) {
                    this.fErrorHandler.error1(9, attr.attName);
                    return -1;
                }
                ++firstAttrIndex;
                if (++index != 32) continue;
                ++chunk;
                index = 0;
            }
        } else {
            chunk = this.fAttrCount >> 5;
            index = this.fAttrCount & 0x1F;
        }
        this.ensureCapacity(chunk, index);
        this.fAttName[chunk][index] = attr.attName;
        this.fAttValue[chunk][index] = attr.attValue;
        this.fAttTypeAndFlags[chunk][index] = (byte)((attr.specified ? 64 : 0) | attr.attType);
        int attrIndex = this.fAttrCount++;
        return attrIndex;
    }

    public void setIsLastAttr(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        byte[] byArray = this.fAttTypeAndFlags[chunk];
        int n = index;
        byArray[n] = (byte)(byArray[n] | 0x80);
    }

    public int getAttrName(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttName[chunk][index];
    }

    public int getAttType(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttTypeAndFlags[chunk][index] & 0x3F;
    }

    public int getAttValue(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttValue[chunk][index];
    }

    public boolean isSpecified(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return true;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return (this.fAttTypeAndFlags[chunk][index] & 0x40) != 0;
    }

    public boolean isLastAttr(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return true;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return (this.fAttTypeAndFlags[chunk][index] & 0x80) != 0;
    }

    public void releaseAttrList(int attrListIndex) {
        boolean last;
        if (attrListIndex == -1) {
            return;
        }
        int chunk = attrListIndex >> 5;
        int index = attrListIndex & 0x1F;
        do {
            last = (this.fAttTypeAndFlags[chunk][index] & 0x80) != 0;
            this.fAttName[chunk][index] = -1;
            if ((this.fAttTypeAndFlags[chunk][index] & 0x40) != 0) {
                this.fStringPool.releaseString(this.fAttValue[chunk][index]);
            }
            this.fAttValue[chunk][index] = -1;
            if (++index != 32) continue;
            ++chunk;
            index = 0;
        } while (!last);
        if (this.fAttrCount == (chunk << 5) + index) {
            this.fAttrCount = attrListIndex;
            return;
        }
        try {
            this.fErrorHandler.error(169);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public AttributeList getAttributeList(int attrListIndex) {
        this.fAttlistIndex = attrListIndex;
        if (this.fAttlistIndex == -1) {
            this.fAttlistLength = 0;
        } else {
            int chunk = this.fAttlistIndex >> 5;
            int index = this.fAttlistIndex & 0x1F;
            this.fAttlistLength = 1;
            while ((this.fAttTypeAndFlags[chunk][index] & 0x80) == 0) {
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                ++this.fAttlistLength;
            }
        }
        return this;
    }

    public int getLength() {
        return this.fAttlistLength;
    }

    public String getName(int i) {
        if (i < 0 || i >= this.fAttlistLength) {
            return null;
        }
        int chunk = this.fAttlistIndex + i >> 5;
        int index = this.fAttlistIndex + i & 0x1F;
        return this.fStringPool.toString(this.fAttName[chunk][index]);
    }

    public String getType(int i) {
        if (i < 0 || i >= this.fAttlistLength) {
            return null;
        }
        int chunk = this.fAttlistIndex + i >> 5;
        int index = this.fAttlistIndex + i & 0x1F;
        int attType = this.fAttTypeAndFlags[chunk][index] & 0x3F;
        if (attType == 9) {
            attType = 6;
        }
        return AttDef.getAttTypeString(attType);
    }

    public String getValue(int i) {
        if (i < 0 || i >= this.fAttlistLength) {
            return null;
        }
        int chunk = this.fAttlistIndex + i >> 5;
        int index = this.fAttlistIndex + i & 0x1F;
        return this.fStringPool.toString(this.fAttValue[chunk][index]);
    }

    public String getType(String name) {
        int nameIndex = this.fStringPool.addSymbol(name.intern());
        if (nameIndex == -1) {
            return null;
        }
        int chunk = this.fAttlistIndex >> 5;
        int index = this.fAttlistIndex & 0x1F;
        int i = 0;
        while (i < this.fAttlistLength) {
            if (this.fAttName[chunk][index] == nameIndex) {
                int attType = this.fAttTypeAndFlags[chunk][index] & 0x3F;
                if (attType == 9) {
                    attType = 6;
                }
                return AttDef.getAttTypeString(attType);
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        return null;
    }

    public String getValue(String name) {
        int nameIndex = this.fStringPool.addSymbol(name.intern());
        if (nameIndex == -1) {
            return null;
        }
        int chunk = this.fAttlistIndex >> 5;
        int index = this.fAttlistIndex & 0x1F;
        int i = 0;
        while (i < this.fAttlistLength) {
            if (this.fAttName[chunk][index] == nameIndex) {
                return this.fStringPool.toString(this.fAttValue[chunk][index]);
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        return null;
    }

    public int getFirstAttr(int attrListIndex) {
        if (attrListIndex < 0 || attrListIndex >= this.fAttrCount) {
            return -1;
        }
        return attrListIndex;
    }

    public int getNextAttr(int attrIndex) {
        if (this.isLastAttr(attrIndex)) {
            return -1;
        }
        return attrIndex + 1;
    }
}

