/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.BaseKind;
import iubio.bioseq.SeqInfo;

public class Bioseq
implements Cloneable {
    public static final short kOtherSeq = 0;
    public static final short kDNA = 1;
    public static final short kRNA = 2;
    public static final short kNucleic = 3;
    public static final short kAmino = 4;
    public static final short kIndelSeq = 5;
    public static final int baseOnly = 0;
    public static final int maskOnly = 1;
    public static final int nucAndMask = 2;
    public static final int maskOnlyAsText = 3;
    public static boolean gUseByteArray = true;
    public int gBaseType = 0;
    protected byte[] bSeq;

    public Bioseq() {
        this(0);
    }

    public Bioseq(int maxlen) {
        this.bSeq = new byte[maxlen];
    }

    public Bioseq(byte[] b) {
        this.copyFrom(b);
    }

    public Bioseq(byte[] b, int offs, int len) {
        this.copyFrom(b, offs, len);
    }

    public Bioseq(char[] c) {
        this.copyFrom(c);
    }

    public Bioseq(char[] c, int offs, int len) {
        this.copyFrom(c, offs, len);
    }

    public Bioseq(String s) {
        this.copyFrom(s);
    }

    public Bioseq(Object ob) {
        this.copyFrom(ob);
    }

    public void copyFrom(Object ob) {
        if (ob instanceof byte[]) {
            this.copyFrom((byte[])ob);
        } else if (ob instanceof char[]) {
            this.copyFrom((char[])ob);
        } else if (ob instanceof String) {
            this.copyFrom((String)ob);
        }
    }

    public final void copyFrom(byte[] b) {
        this.copyFrom(b, 0, b.length);
    }

    public void copyFrom(byte[] b, int offs, int len) {
        this.bSeq = new byte[len];
        System.arraycopy(b, offs, this.bSeq, 0, len);
    }

    public final void copyFrom(char[] c) {
        this.copyFrom(c, 0, c.length);
    }

    public void copyFrom(char[] c, int offs, int len) {
        this.bSeq = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.bSeq[i] = (byte)c[i + offs];
        }
    }

    public void copyFrom(String s) {
        this.bSeq = s.getBytes();
    }

    public int length() {
        return this.bSeq.length;
    }

    public void clear() {
        this.bSeq = null;
        this.bSeq = new byte[0];
    }

    public void setbases(byte[] theBases) {
        this.bSeq = theBases;
    }

    public void setbase(int i, byte b) {
        this.bSeq[i] = b;
    }

    public void setbase(int i, char c) {
        this.setbase(i, (byte)c);
    }

    public byte basebyte(int i) {
        return this.bSeq[i];
    }

    public char basechar(int i) {
        return (char)this.basebyte(i);
    }

    public char base(int i, int basepart) {
        return (char)this.basebyte(i);
    }

    public boolean isBytes() {
        return true;
    }

    public byte[] bases() {
        return this.toBytes(0);
    }

    public final byte[] toBytes() {
        return this.toBytes(this.gBaseType);
    }

    public byte[] toBytes(int basepart) {
        return this.bSeq;
    }

    public byte[] toBytes(int offset, int count, int basepart) {
        if (offset < 0) {
            offset = 0;
        }
        if (this.bSeq != null) {
            if (offset == 0 && count == this.bSeq.length) {
                return this.bSeq;
            }
            int len = this.bSeq.length - offset;
            if (count > 0 && count < len) {
                len = count;
            }
            byte[] b = new byte[len];
            System.arraycopy(this.bSeq, offset, b, 0, len);
            return b;
        }
        return null;
    }

    public final char[] toChars() {
        return this.toChars(this.gBaseType);
    }

    public final char[] toChars(int basepart) {
        return this.toChars(0, -1, basepart);
    }

    public char[] toChars(int offset, int count, int basepart) {
        if (offset < 0) {
            offset = 0;
        }
        if (this.bSeq != null) {
            int len = this.bSeq.length - offset;
            if (count > 0 && count < len) {
                len = count;
            }
            char[] c = new char[len];
            for (int i = 0; i < len; ++i) {
                c[i] = (char)this.bSeq[i + offset];
            }
            return c;
        }
        return null;
    }

    public String toString() {
        return new String(this.toChars());
    }

    public Object clone() {
        try {
            Bioseq bs = (Bioseq)super.clone();
            byte[] ba = new byte[this.bSeq.length];
            System.arraycopy(this.bSeq, 0, ba, 0, this.bSeq.length);
            bs.bSeq = ba;
            return bs;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
    }

    public int getSeqtype() {
        int len = this.length();
        SeqInfo sk = SeqInfo.getSeqInfo(len, true, false);
        sk.add(this.bSeq, 0, len);
        return sk.getKind();
    }

    public static int getSeqtype(String s, int offset, int seqlen) {
        SeqInfo sk = SeqInfo.getSeqInfo(seqlen, true, false);
        sk.add(s, offset, seqlen);
        return sk.getKind();
    }

    public static int getSeqtype(byte[] ba, int offset, int seqlen) {
        SeqInfo sk = SeqInfo.getSeqInfo(seqlen, true, false);
        sk.add(ba, offset, seqlen);
        return sk.getKind();
    }

    public final SeqInfo getSeqStats() {
        return this.getSeqStats(0, this.length());
    }

    public SeqInfo getSeqStats(int offset, int seqlen) {
        SeqInfo sk = SeqInfo.getSeqInfo(seqlen, false, true);
        sk.add(this.bSeq, offset, seqlen);
        return sk;
    }

    public void reverseComplement() {
        this.reverseComplement(0, this.length());
    }

    public void reverseComplement(int offset, int count) {
        byte[] ba = new byte[count];
        byte[] bases = this.toBytes(offset, count, 0);
        int seqkind = this.getSeqtype();
        boolean isamino = seqkind == 4;
        boolean isrna = seqkind == 2;
        int baend = count - 1;
        if (isamino) {
            for (int i = 0; i < count; ++i) {
                ba[baend - i] = bases[i];
            }
        } else {
            for (int i = 0; i < count; ++i) {
                ba[baend - i] = BaseKind.nucleicComplement(bases[i], isrna);
            }
        }
        this.setbases(ba);
    }

    public final boolean equals(Bioseq b) {
        return Bioseq.equals(this.bSeq, b.bases());
    }

    public static boolean equals(byte[] a, byte[] b) {
        int n = a.length;
        if (n == b.length) {
            while (n-- != 0) {
                if (a[n] == b[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(Bioseq b) {
        return Bioseq.equalsIgnoreCase(this.bSeq, b.bases());
    }

    public static boolean equalsIgnoreCase(byte[] a, byte[] b) {
        int n = a.length;
        if (n == b.length) {
            while (n-- != 0) {
                if (Character.toUpperCase((char)a[n]) == Character.toUpperCase((char)b[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void compress(byte gapc) {
        byte[] cb = Bioseq.compress(this.bSeq, 0, this.bSeq.length, gapc);
        this.setbases(cb);
    }

    public final void compress(int offset, int seqlen, byte gapc) {
        byte[] cb = Bioseq.compress(this.bSeq, offset, seqlen, gapc);
        this.setbases(cb);
    }

    public static byte[] compress(byte[] src, int offset, int seqlen, byte gapc) {
        byte[] dst = new byte[seqlen];
        int j = 0;
        for (int i = 0; i < seqlen; ++i) {
            if (src[i + offset] == gapc) continue;
            dst[j++] = src[i + offset];
        }
        if (j != seqlen) {
            return Bioseq.expand(dst, j);
        }
        return dst;
    }

    public final void replace(int len, char oldbase, char newbase) {
        Bioseq.replace(this, len, oldbase, newbase);
    }

    public static void replace(Bioseq seq, int len, char oldbase, char newbase) {
        for (int i = 0; i < len; ++i) {
            if (seq.bSeq[i] != (byte)oldbase) continue;
            seq.bSeq[i] = (byte)newbase;
        }
    }

    public final void replace(int len, String oldbases, String newbases) {
        Bioseq.replace(this, len, oldbases, newbases);
    }

    public static void replace(Bioseq seq, int len, String oldbases, String newbases) {
        if (oldbases == null || newbases == null) {
            return;
        }
        int nbases = oldbases.length();
        for (int j = 0; j < nbases; ++j) {
            byte oldb = (byte)oldbases.charAt(j);
            byte newb = (byte)newbases.charAt(j);
            for (int i = 0; i < len; ++i) {
                if (seq.bSeq[i] != oldb) continue;
                seq.bSeq[i] = newb;
            }
        }
    }

    public final void expand(int newlen) {
        byte[] exb = Bioseq.expand(this.bSeq, newlen);
        this.setbases(exb);
    }

    public static byte[] expand(byte[] src, int newlen) {
        int minlen = src.length;
        if (minlen > newlen) {
            minlen = newlen;
        }
        byte[] b = new byte[newlen];
        System.arraycopy(src, 0, b, 0, minlen);
        for (int i = minlen; i < newlen; ++i) {
            b[i] = 63;
        }
        return b;
    }

    public final byte[] dup() {
        return Bioseq.dup(this.bSeq);
    }

    public static byte[] dup(byte[] src) {
        int len = src.length;
        byte[] b = new byte[len];
        System.arraycopy(src, 0, b, 0, len);
        return b;
    }

    public final int cmp(Bioseq b, int len) {
        return Bioseq.cmp(this.bSeq, b.bases(), len);
    }

    public static int cmp(byte[] a, byte[] b, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] <= b[i]) continue;
            return 1;
        }
        return 0;
    }

    public final int indexOf(byte b, int len) {
        return Bioseq.indexOf(this.bSeq, b, len);
    }

    public static int indexOf(byte[] a, byte b, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public final void copy(byte[] dst, int dstOffset, int len) {
        Bioseq.copy(this.bSeq, 0, dst, dstOffset, len);
    }

    public static void copy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int len) {
        System.arraycopy(src, srcOffset, dst, dstOffset, len);
    }
}

