/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Environ;
import flybase.FastProperties;
import flybase.FastVector;
import iubio.readseq.BioseqFileFilter;
import iubio.readseq.BioseqFormats;
import iubio.readseq.GetFeaturelist;
import iubio.readseq.GetUrls;
import iubio.readseq.MakeFileChooser;
import iubio.readseq.MessageApp;
import iubio.readseq.XmlSeqWriter;
import iubio.readseq.app;
import iubio.readseq.help;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class AppFrame
extends JFrame
implements MessageApp {
    public static String propname = "AppFrame";
    public static final String labelSuffix = "Label";
    public static final String tooltipSuffix = "Tip";
    public static final String checkedSuffix = "Checked";
    public static final String radioSuffix = "Radio";
    public static final String radioGroupSuffix = "Group";
    public static final String actionSuffix = "Action";
    private app myapp;
    private FastProperties props = new FastProperties();
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    protected JFileChooser fchooser;
    protected BioseqFileFilter bioseqfilter;
    protected JTextArea messageText;
    private String choosenOutputName;
    private FastVector inputitems = new FastVector();
    private Action[] defaultActions;
    private RunAction runact;
    StyleSheet defaultStyles;
    boolean gotStyles;
    Hashtable radiogroups = new Hashtable();

    public AppFrame(app myapp) {
        this.myapp = myapp;
        String pname = System.getProperty(propname, propname);
        this.props.loadProperties(pname);
        this.initframe();
        myapp.pretty.userset();
        MakeFileChooser makechooser = new MakeFileChooser(this);
        makechooser.start();
    }

    protected void initframe() {
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        this.menuItems = new Hashtable();
        this.menubar = this.createMenubar("menubar", this.commands);
        this.setJMenuBar(this.menubar);
        this.setTitle(this.props.getProperty("title", "Readseq"));
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    this.finalize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        JPanel northbar = new JPanel();
        JComponent fc = this.makeFormatChoice();
        JLabel jlab = new JLabel("Output format:");
        jlab.setFont(new Font("dialog", 0, 12));
        jlab.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        jlab.setEnabled(true);
        jlab.setToolTipText("Select sequence format for saving output");
        northbar.add(jlab);
        northbar.add(fc);
        this.getContentPane().add("North", northbar);
        this.getContentPane().add("Center", this.makeMessageBox());
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = Environ.gEnv.getInt("ReadseqApp.width", 450);
        int height = Environ.gEnv.getInt("ReadseqApp.height", 350);
        this.setSize(width, height);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    public void errmessage(String msg) {
        this.messageText.append(msg + "\n");
        int dlen = this.messageText.getDocument().getLength();
        this.messageText.select(dlen, dlen);
    }

    public void infomessage(String msg) {
        this.messageText.append(msg + "\n");
        int dlen = this.messageText.getDocument().getLength();
        this.messageText.select(dlen, dlen);
    }

    void initFileChooser() {
        if (this.fchooser == null) {
            this.fchooser = new JFileChooser();
            this.fchooser.setFileSelectionMode(2);
            this.fchooser.setMultiSelectionEnabled(true);
            this.bioseqfilter = new BioseqFileFilter();
            FileFilter[] ff = this.fchooser.getChoosableFileFilters();
            for (int i = 0; i < ff.length; ++i) {
                this.fchooser.removeChoosableFileFilter(ff[i]);
            }
            this.fchooser.addChoosableFileFilter(this.bioseqfilter);
            this.fchooser.addChoosableFileFilter(this.fchooser.getAcceptAllFileFilter());
            File dir = new File(System.getProperty("user.dir"));
            this.fchooser.setCurrentDirectory(dir);
        }
    }

    JComponent makeFormatChoice() {
        JComboBox<String> cb = new JComboBox<String>();
        int n = BioseqFormats.nFormats();
        for (int i = 0; i <= n; ++i) {
            if (!BioseqFormats.canwrite(i)) continue;
            String nm = BioseqFormats.formatName(i);
            cb.addItem(nm);
        }
        String selname = BioseqFormats.formatName(BioseqFormats.getFormatId(this.myapp.outformat));
        cb.setSelectedItem(selname);
        cb.getAccessibleContext().setAccessibleName("Biosequence formats");
        cb.getAccessibleContext().setAccessibleDescription("Choose a file format");
        Action act = this.getAction("outformat");
        if (act != null) {
            cb.addActionListener(act);
            cb.setEnabled(act.isEnabled());
        } else {
            cb.setEnabled(false);
        }
        return cb;
    }

    JComponent makeMessageBox() {
        String fontspec = Environ.gEnv.get("ReadseqApp.textFont", "monospaced-plain-10");
        this.messageText = new JTextArea(20, 85);
        this.messageText.setFont(Font.decode(fontspec));
        this.messageText.setEditable(false);
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.add((Component)new JScrollPane(this.messageText){

            public Dimension getPreferredSize() {
                Dimension size = AppFrame.this.getSize();
                return new Dimension(size.width, size.height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(100, 50);
            }
        }, "Center");
        this.messageText.setBorder(new EmptyBorder(4, 4, 4, 4));
        messagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return messagePanel;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected Frame getFrame(Component c) {
        if (c != null) {
            for (Container p = c.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof Frame)) continue;
                return (Frame)p;
            }
        }
        return null;
    }

    public Action[] getActions() {
        if (this.defaultActions == null) {
            this.runact = new RunAction();
            this.defaultActions = new Action[]{new ListAction(), new LcAction(), new UcAction(), new NcAction(), new DegapAction(), new ChecksumAction(), new ReverseAction(), new TranslateAction(), new VerboseAction(), new OutformatAction(), new InformatAction(), new NameleftAction(), new NamerightAction(), new NametopAction(), new NamewidthAction(), new NumleftAction(), new NumrightAction(), new NumtopAction(), new NumbotAction(), new MatchcAction(), new GapcountAction(), new SeqwidthAction(), new TabAction(), new ColtabAction(), new XmlDtdAction(), new ChoosefeatAction(), new RemovefeatAction(), new AllfeatAction(), new SubrangeAction(), new ExtractRangeAction(), new ClearopenAction(), new AboutAction(), new AboutDetailsAction(), new AboutFormatAction(), new AboutAllFormatsAction(), this.runact, new OpenurlAction(), new OpenAction(), new SaveAction(), new QuitAction()};
        }
        return this.defaultActions;
    }

    void checkEnabledActions() {
        this.runact.checkEnabled();
    }

    public StyleSheet getStyleSheet() {
        if (!this.gotStyles) {
            StyleSheet dss = new StyleSheet();
            this.gotStyles = true;
            try {
                InputStream is = AppResources.global.getStream("readseq.css");
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                dss.loadRules(r, null);
                ((Reader)r).close();
            }
            catch (Throwable e) {
                return null;
            }
            this.defaultStyles = dss;
        }
        return this.defaultStyles;
    }

    protected void openActionFrame(JTextComponent jview, String title, String menuprop) {
        JScrollPane jscroll = new JScrollPane(jview);
        Dimension screenSize = this.getToolkit().getScreenSize();
        jscroll.setMaximumSize(new Dimension(screenSize.width - 200, screenSize.height - 100));
        Action[] actions = new Action[]{new SaveTextAction(jview), new CloseTextAction(jview), new CopyTextAction(jview), new PrintTextAction(jview)};
        Hashtable<Object, Action> acthash = new Hashtable<Object, Action>();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            acthash.put(a.getValue("Name"), a);
        }
        JFrame frame = new JFrame(title);
        JMenuBar mbar = this.createMenubar(menuprop, acthash);
        if (mbar != null) {
            frame.setJMenuBar(mbar);
        }
        frame.getContentPane().add(jscroll);
        frame.pack();
        frame.setLocation(90, 50);
        frame.setVisible(true);
    }

    protected JMenuBar createMenubar(String propkey, Hashtable acthash) {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.props.getProperty(propkey));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i], acthash);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    protected JMenu createMenu(String key, Hashtable acthash) {
        String[] itemKeys = this.tokenize(this.props.getProperty(key));
        String label = this.props.getProperty(key + labelSuffix);
        if (label == null) {
            label = key;
        }
        JMenu menu = new JMenu(label);
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i], acthash);
            menu.add(mi);
        }
        return menu;
    }

    protected JMenuItem createMenuItem(String cmd, Hashtable acthash) {
        JMenuItem mi;
        boolean val;
        Boolean bn;
        String astr = this.props.getProperty(cmd + actionSuffix);
        if (astr == null) {
            astr = cmd;
        }
        Action act = acthash == null ? null : (Action)acthash.get(cmd);
        boolean ischeck = false;
        boolean isradio = false;
        boolean checkval = false;
        String cmdlab = this.props.getProperty(cmd + checkedSuffix);
        if (cmdlab != null) {
            ischeck = true;
        } else {
            cmdlab = this.props.getProperty(cmd + radioSuffix);
            if (cmdlab != null) {
                isradio = true;
            } else {
                cmdlab = this.props.getProperty(cmd + labelSuffix);
            }
        }
        if (ischeck) {
            bn = act == null ? null : (Boolean)act.getValue("BoolValue");
            val = bn != null ? bn : checkval;
            mi = new JCheckBoxMenuItem(cmdlab, val);
        } else if (isradio) {
            bn = act == null ? null : (Boolean)act.getValue("BoolValue");
            val = bn != null ? bn : checkval;
            JRadioButtonMenuItem rbm = new JRadioButtonMenuItem(cmdlab, val);
            mi = rbm;
            String bgname = act == null ? "bgroup" : (String)act.getValue(radioGroupSuffix);
            ButtonGroup bg = (ButtonGroup)this.radiogroups.get(bgname);
            if (bg == null) {
                bg = new ButtonGroup();
                this.radiogroups.put(bgname, bg);
            }
            bg.add(rbm);
        } else {
            String sval = act == null ? null : (String)act.getValue("StringValue");
            mi = sval != null ? new ValueMenuItem(cmdlab, sval) : new JMenuItem(cmdlab);
        }
        mi.setActionCommand(astr);
        String tip = this.props.getProperty(cmd + tooltipSuffix);
        if (tip != null) {
            mi.setToolTipText(tip);
        }
        if (act != null) {
            ActionChangedListener actli = new ActionChangedListener(mi);
            mi.addActionListener(act);
            act.addPropertyChangeListener(actli);
            mi.setEnabled(act.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            } else if (propertyName.equals("StringValue")) {
                String text = (String)e.getNewValue();
                if (this.menuItem instanceof ValueMenuItem) {
                    ((ValueMenuItem)this.menuItem).setValue(text);
                }
            }
        }
    }

    private class ValueMenuItem
    extends JMenuItem {
        String val;
        String lab;

        ValueMenuItem(String label, String val) {
            super(label);
            this.lab = label;
            this.setValue(val);
        }

        void setValue(String val) {
            this.val = val;
            String title = this.lab;
            if (val != null) {
                title = title + " [" + val + "]";
            }
            this.setText(title);
        }
    }

    class RunAction
    extends AbstractAction {
        RunAction() {
            super("run");
            this.checkEnabled();
        }

        void checkEnabled() {
            this.setEnabled(AppFrame.this.choosenOutputName != null && AppFrame.this.inputitems != null && !AppFrame.this.inputitems.isEmpty());
        }

        public void actionPerformed(ActionEvent e) {
            ((AppFrame)AppFrame.this).myapp.outname = AppFrame.this.choosenOutputName;
            AppFrame.this.myapp.setInputObjects(AppFrame.this.inputitems);
            Thread loader = new Thread(AppFrame.this.myapp);
            loader.start();
            AppFrame.this.choosenOutputName = null;
            this.checkEnabled();
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        public void actionPerformed(ActionEvent e) {
            if (AppFrame.this.fchooser == null) {
                AppFrame.this.initFileChooser();
            }
            AppFrame.this.fchooser.setFileSelectionMode(2);
            AppFrame.this.fchooser.setMultiSelectionEnabled(true);
            int returnVal = AppFrame.this.fchooser.showOpenDialog(AppFrame.this);
            if (returnVal == 0) {
                File f;
                File[] files = AppFrame.this.fchooser.getSelectedFiles();
                if (files.length == 0 && (f = AppFrame.this.fchooser.getSelectedFile()) != null) {
                    files = new File[]{f};
                }
                if (files.length == 0) {
                    AppFrame.this.errmessage("\n No files selected");
                } else {
                    int i;
                    for (i = 0; i < files.length; ++i) {
                        AppFrame.this.inputitems.addElement(files[i]);
                    }
                    AppFrame.this.infomessage("Will read data from these items: ");
                    for (i = 0; i < AppFrame.this.inputitems.size(); ++i) {
                        AppFrame.this.infomessage(String.valueOf(AppFrame.this.inputitems.elementAt(i)));
                    }
                    AppFrame.this.checkEnabledActions();
                }
            }
        }
    }

    class OpenurlAction
    extends AbstractAction {
        OpenurlAction() {
            super("openurl");
        }

        public void actionPerformed(ActionEvent e) {
            GetUrls getu = new GetUrls(AppFrame.this);
            if (getu.choose()) {
                int i;
                FastVector v = getu.getValue();
                for (i = 0; i < v.size(); ++i) {
                    AppFrame.this.inputitems.addElement(v.elementAt(i));
                }
                AppFrame.this.infomessage("Will read data from these items: ");
                for (i = 0; i < AppFrame.this.inputitems.size(); ++i) {
                    AppFrame.this.infomessage(String.valueOf(AppFrame.this.inputitems.elementAt(i)));
                }
                AppFrame.this.checkEnabledActions();
            }
        }
    }

    class ClearopenAction
    extends AbstractAction {
        ClearopenAction() {
            super("clearopen");
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.inputitems.removeAllElements();
            AppFrame.this.infomessage("Input data cleared. ");
            AppFrame.this.checkEnabledActions();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent e) {
            int returnVal;
            if (AppFrame.this.fchooser == null) {
                AppFrame.this.initFileChooser();
            }
            AppFrame.this.fchooser.setFileSelectionMode(0);
            AppFrame.this.fchooser.setMultiSelectionEnabled(false);
            File savef = AppFrame.this.fchooser.getSelectedFile();
            if (savef != null) {
                AppFrame.this.myapp.setInputObjects(AppFrame.this.inputitems);
                String savename = AppFrame.this.myapp.guessOutname(BioseqFormats.getFormatId(((AppFrame)AppFrame.this).myapp.outformat));
                savef = new File(savef.getParent(), savename);
                AppFrame.this.fchooser.setSelectedFile(savef);
            }
            if ((returnVal = AppFrame.this.fchooser.showSaveDialog(AppFrame.this)) == 0) {
                File f = AppFrame.this.fchooser.getSelectedFile();
                boolean okay = false;
                if (f.exists()) {
                    String title = "Replace file?";
                    String message = "Replace existing '" + f.getName() + "' ?";
                    Object[] options = new Object[]{"Replace", "Cancel"};
                    int result = JOptionPane.showOptionDialog(AppFrame.this, message, title, 0, 2, null, options, options[0]);
                    okay = result == 0;
                } else {
                    okay = true;
                }
                if (okay) {
                    AppFrame.this.choosenOutputName = f.toString();
                    AppFrame.this.infomessage("Save output to: " + AppFrame.this.choosenOutputName);
                    AppFrame.this.checkEnabledActions();
                }
            }
        }
    }

    class SaveTextAction
    extends TextAction {
        SaveTextAction(JTextComponent jtext) {
            super("saved", jtext);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.jtext == null) {
                return;
            }
            JFileChooser jchooser = new JFileChooser(System.getProperty("user.dir"));
            int ok = jchooser.showSaveDialog(AppFrame.this.getFrame(this.jtext));
            if (ok == 0) {
                try {
                    FileWriter wr = new FileWriter(jchooser.getSelectedFile());
                    this.jtext.write(wr);
                    wr.close();
                }
                catch (Exception ex) {
                    AppFrame.this.errmessage("Error: " + ex);
                }
            }
        }
    }

    class CopyTextAction
    extends TextAction {
        CopyTextAction(JTextComponent jtext) {
            super("copyd", jtext);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.jtext == null) {
                return;
            }
            if (this.jtext.getSelectionStart() < this.jtext.getSelectionEnd()) {
                this.jtext.copy();
            } else {
                Clipboard clipboard = this.jtext.getToolkit().getSystemClipboard();
                String srcData = this.jtext.getText();
                clipboard.setContents(new StringSelection(srcData), null);
            }
        }
    }

    class CloseTextAction
    extends TextAction {
        CloseTextAction(JTextComponent jtext) {
            super("closed", jtext);
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = AppFrame.this.getFrame(this.jtext);
            if (frame != null) {
                frame.setVisible(false);
                frame.dispose();
            }
        }
    }

    class PrintTextAction
    extends TextAction {
        PrintTextAction(JTextComponent jtext) {
            super("printd", jtext);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.jtext == null) {
                return;
            }
            Frame frame = AppFrame.this.getFrame(this.jtext);
            PrintJob printjob = frame.getToolkit().getPrintJob(frame, frame.getTitle(), null);
            this.printpages(printjob);
            printjob.end();
        }

        void printpages(PrintJob printjob) {
            boolean morepages;
            Graphics g = printjob.getGraphics();
            Dimension paged = printjob.getPageDimension();
            Dimension viewd = this.jtext.getSize();
            int npages = (paged.height - 1 + viewd.height) / paged.height;
            int ipage = 0;
            int ytop = 0;
            int xleft = 0;
            boolean bl = morepages = npages > 0;
            while (morepages) {
                Rectangle oldclip = g.getClipBounds();
                Rectangle clip = new Rectangle(oldclip);
                clip.width = Math.min(clip.width, viewd.width);
                clip.y = ytop;
                clip.x = xleft;
                g.translate(-xleft, -ytop);
                this.jtext.print(g);
                g.translate(xleft, ytop);
                g.setClip(oldclip);
                PrintJob pj = ((PrintGraphics)((Object)g)).getPrintJob();
                g.dispose();
                boolean bl2 = morepages = ++ipage < npages && (ytop += clip.height) < viewd.height;
                if (morepages && pj != null) {
                    g = pj.getGraphics();
                    if (g != null) continue;
                    morepages = false;
                    continue;
                }
                morepages = false;
            }
        }
    }

    abstract class TextAction
    extends AbstractAction {
        JTextComponent jtext;

        TextAction(String name, JTextComponent jtext) {
            super(name);
            this.jtext = jtext;
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("quit");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    class AboutDetailsAction
    extends TextViewAction {
        AboutDetailsAction() {
            super("details");
        }

        public void actionPerformed(ActionEvent e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream pr = new PrintStream(baos);
            help h = new help(false, true, pr);
            baos.reset();
            h.extraHelp();
            this.makeHtmlUI(baos.toString(), "More about " + AppFrame.this.props.getProperty("title", "Readseq"));
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    AppFrame.this.infomessage("Hyperlink error: " + t.toString());
                }
            }
        }
    }

    class AboutFormatAction
    extends TextViewAction {
        AboutFormatAction() {
            super("formathelp");
        }

        AboutFormatAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            this.showFmt(BioseqFormats.getFormatId(((AppFrame)AppFrame.this).myapp.outformat));
        }

        void showFmt(int ifmt) {
            help h;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream pr = new PrintStream(baos);
            if (ifmt == 0) {
                h = new help(false, true, pr);
                h.formatHelp();
            } else {
                h = new help(false, false, pr);
                h.formatDoc(ifmt);
                h.formatDocEnd();
            }
            String text = baos.toString();
            text = text.replace('\r', '\n');
            if (ifmt == 0) {
                this.makeHtmlUI(text, "Format details ");
            } else {
                this.makeTextUI(text, "Format details for " + BioseqFormats.formatName(ifmt));
            }
        }
    }

    class AboutAllFormatsAction
    extends AboutFormatAction {
        AboutAllFormatsAction() {
            super("formatallhelp");
        }

        public void actionPerformed(ActionEvent e) {
            this.showFmt(0);
        }
    }

    class AboutAction
    extends TextViewAction {
        AboutAction() {
            super("about");
        }

        public void actionPerformed(ActionEvent e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream pr = new PrintStream(baos);
            help h = new help(pr);
            String text = baos.toString();
            text = text.replace('\r', '\n');
            this.makeTextUI(text, "About " + AppFrame.this.props.getProperty("title", "Readseq"));
        }
    }

    abstract class TextViewAction
    extends AbstractAction {
        TextViewAction(String name) {
            super(name);
        }

        void makeHtmlUI(String html, String title) {
            JEditorPane jview = new JEditorPane("text/html", html);
            jview.setBorder(new EmptyBorder(6, 6, 6, 6));
            jview.setBackground(Color.white);
            jview.setEditable(false);
            jview.addHyperlinkListener(new Hyperactive());
            HTMLEditorKit ed = (HTMLEditorKit)jview.getEditorKit();
            if (AppFrame.this.getStyleSheet() != null) {
                ed.setStyleSheet(AppFrame.this.getStyleSheet());
            }
            AppFrame.this.openActionFrame(jview, title, "details.menubar");
        }

        void makeTextUI(String text, String title) {
            JTextArea jtext = new JTextArea(text, 40, 80);
            jtext.setBorder(new EmptyBorder(6, 6, 6, 6));
            jtext.setFont(new Font("monospaced", 0, 12));
            jtext.setBackground(Color.white);
            jtext.setEditable(false);
            AppFrame.this.openActionFrame(jtext, title, "details.menubar");
        }
    }

    class NamewidthAction
    extends GetvalueAction {
        NamewidthAction() {
            super("Namewidth");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.namewidth));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.namewidth = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ColtabAction
    extends GetvalueAction {
        ColtabAction() {
            super("Coltab");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.spacer));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.spacer = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class TabAction
    extends GetvalueAction {
        TabAction() {
            super("Tab");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.tab));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.tab = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class SeqwidthAction
    extends GetvalueAction {
        SeqwidthAction() {
            super("Seqwidth");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.seqwidth));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.seqwidth = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GapcountAction
    extends CheckboxAction {
        GapcountAction() {
            super("Gapcount");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.degap);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.degap = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class MatchcAction
    extends CheckboxAction {
        MatchcAction() {
            super("Matchc");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.domatch);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.domatch = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumbotAction
    extends CheckboxAction {
        NumbotAction() {
            super("Numbot");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numbot);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.numbot = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumtopAction
    extends CheckboxAction {
        NumtopAction() {
            super("Numtop");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numtop);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.numtop = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumrightAction
    extends CheckboxAction {
        NumrightAction() {
            super("Numright");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numright);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.numright = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumleftAction
    extends CheckboxAction {
        NumleftAction() {
            super("Numleft");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numleft);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.numleft = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NametopAction
    extends CheckboxAction {
        NametopAction() {
            super("Nametop");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nametop);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.nametop = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NamerightAction
    extends CheckboxAction {
        NamerightAction() {
            super("Nameright");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nameright);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.nameright = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NameleftAction
    extends CheckboxAction {
        NameleftAction() {
            super("Nameleft");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nameleft);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.pretty.nameleft = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class ExtractRangeAction
    extends GetvalueAction {
        ExtractRangeAction() {
            super("extract");
            this.setval(((AppFrame)AppFrame.this).myapp.extractrange);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.extractrange = this.val;
        }
    }

    class SubrangeAction
    extends GetvalueAction {
        SubrangeAction() {
            super("subrange");
            this.setval(((AppFrame)AppFrame.this).myapp.featsubrange);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.featsubrange = this.val;
        }
    }

    class RemovefeatAction
    extends CheckboxAction {
        RemovefeatAction() {
            super("removefeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String msg = AppFrame.this.props.getProperty("removefeatRadio", "Remove features");
            GetFeaturelist gf = new GetFeaturelist(AppFrame.this, "Remove features", msg);
            gf.setValue(((AppFrame)AppFrame.this).myapp.nofeatlist);
            if (gf.choose()) {
                ((AppFrame)AppFrame.this).myapp.nofeatlist = gf.getValue();
                AppFrame.this.infomessage("Removed features: " + ((AppFrame)AppFrame.this).myapp.nofeatlist);
            } else {
                this.setValue(e, false);
            }
        }
    }

    class ChoosefeatAction
    extends CheckboxAction {
        ChoosefeatAction() {
            super("choosefeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String msg = AppFrame.this.props.getProperty("choosefeatRadio", "Select features");
            GetFeaturelist gf = new GetFeaturelist(AppFrame.this, "Select features", msg);
            gf.setValue(((AppFrame)AppFrame.this).myapp.featlist);
            if (gf.choose()) {
                ((AppFrame)AppFrame.this).myapp.featlist = gf.getValue();
                AppFrame.this.infomessage("Selected features: " + ((AppFrame)AppFrame.this).myapp.featlist);
            } else {
                this.setValue(e, false);
            }
        }
    }

    class AllfeatAction
    extends CheckboxAction {
        AllfeatAction() {
            super("allfeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
            this.setval(!AppFrame.this.myapp.hasFeatlist() && !AppFrame.this.myapp.hasNofeatlist());
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (this.val) {
                ((AppFrame)AppFrame.this).myapp.featlist = null;
                ((AppFrame)AppFrame.this).myapp.nofeatlist = null;
            }
        }
    }

    class XmlDtdAction
    extends CheckboxAction {
        XmlDtdAction() {
            super("xmldtd");
            this.setval(XmlSeqWriter.includeDTD);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            XmlSeqWriter.includeDTD = this.val;
        }
    }

    class VerboseAction
    extends CheckboxAction {
        VerboseAction() {
            super("verbose");
            this.setval(((AppFrame)AppFrame.this).myapp.verbose);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.verbose = this.val;
        }
    }

    class TranslateAction
    extends GetvalueAction {
        TranslateAction() {
            super("trans");
            this.setval("");
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            AppFrame.this.myapp.setTranslation(this.val, false);
        }
    }

    class ReverseAction
    extends CheckboxAction {
        ReverseAction() {
            super("reverse");
            this.setval(((AppFrame)AppFrame.this).myapp.doreverse);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.doreverse = this.val;
        }
    }

    class ChecksumAction
    extends CheckboxAction {
        ChecksumAction() {
            super("checksum");
            this.setval(((AppFrame)AppFrame.this).myapp.dochecksum);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.dochecksum = this.val;
        }
    }

    class DegapAction
    extends CheckboxAction {
        DegapAction() {
            super("degap");
            this.setval(((AppFrame)AppFrame.this).myapp.degap);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.degap = this.val;
        }
    }

    class NcAction
    extends CheckboxAction {
        NcAction() {
            super("nc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(!((AppFrame)AppFrame.this).myapp.dolowercase && !((AppFrame)AppFrame.this).myapp.douppercase);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (this.val) {
                ((AppFrame)AppFrame.this).myapp.dolowercase = false;
                ((AppFrame)AppFrame.this).myapp.douppercase = false;
            }
        }
    }

    class UcAction
    extends CheckboxAction {
        UcAction() {
            super("uc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(((AppFrame)AppFrame.this).myapp.douppercase);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.douppercase = this.val;
        }
    }

    class LcAction
    extends CheckboxAction {
        LcAction() {
            super("lc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(((AppFrame)AppFrame.this).myapp.dolowercase);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.dolowercase = this.val;
        }
    }

    class ListAction
    extends CheckboxAction {
        ListAction() {
            super("list");
            this.setval(((AppFrame)AppFrame.this).myapp.dolist);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ((AppFrame)AppFrame.this).myapp.dolist = this.val;
        }
    }

    class GetvalueAction
    extends AbstractAction {
        String val;
        String message;

        GetvalueAction(String nm) {
            super(nm);
            this.message = AppFrame.this.props.getProperty(nm + AppFrame.labelSuffix, "Select a value");
        }

        void setval(String val) {
            this.val = val;
            if (val != null) {
                this.putValue("StringValue", val);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String title = "Get value";
            Object[] selectionValues = null;
            String initialValue = this.val;
            Object result = JOptionPane.showInputDialog(AppFrame.this, this.message, title, 3, null, selectionValues, initialValue);
            if (result instanceof String) {
                this.firePropertyChange("StringValue", this.val, (String)result);
                this.val = (String)result;
            }
        }
    }

    class CheckboxAction
    extends AbstractAction {
        boolean val = true;

        CheckboxAction(String nm) {
            super(nm);
        }

        void setval(boolean val) {
            this.val = val;
            this.putValue("BoolValue", new Boolean(val));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem ck = (JCheckBoxMenuItem)e.getSource();
                this.val = ck.isSelected();
            } else if (e.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem ck = (JRadioButtonMenuItem)e.getSource();
                this.val = ck.isSelected();
            }
        }

        public void setValue(ActionEvent e, boolean newval) {
            if (e.getSource() instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem ck = (JCheckBoxMenuItem)e.getSource();
                ck.setSelected(newval);
                this.val = newval;
            } else if (e.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem ck = (JRadioButtonMenuItem)e.getSource();
                ck.setSelected(newval);
                this.val = newval;
            }
        }
    }

    class InformatAction
    extends AbstractAction {
        InformatAction() {
            super("informat");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem ck = (JRadioButtonMenuItem)e.getSource();
            } else if (e.getSource() instanceof JComboBox) {
                JComboBox cb = (JComboBox)e.getSource();
                String fname = (String)cb.getSelectedItem();
                AppFrame.this.infomessage("Selected in format=" + fname);
                ((AppFrame)AppFrame.this).myapp.informat = fname;
            }
        }
    }

    class OutformatAction
    extends AbstractAction {
        OutformatAction() {
            super("outformat");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox cb = (JComboBox)e.getSource();
                String fname = (String)cb.getSelectedItem();
                AppFrame.this.infomessage("Selected out format=" + fname);
                ((AppFrame)AppFrame.this).myapp.outformat = fname;
            }
        }
    }
}

