/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TimestampUtils {
    private static String[] testData = new String[]{"2004-12-10 22:58:49.964907-09", "0027-12-10 22:59:29-09 BC", "0027-12-10 BC", "14034-12-10", "23:01:05.372441-09", "23:01:05", "23:01:05.123", "00:00:00.01"};
    private static int[] testTypes = new int[]{93, 93, 91, 91, 92, 92, 92, 92};

    private static int loadCalendar(GregorianCalendar cal, String s, String type) throws SQLException {
        int slen = s.length();
        if (slen == 8 && s.equals("infinity") || slen == 9 && s.equals("-infinity")) {
            throw new PSQLException(GT.tr("Infinite value found for timestamp.  Java has no corresponding representation."), PSQLState.DATETIME_OVERFLOW);
        }
        cal.setTime(new Date(0L));
        int nanos = 0;
        try {
            int start = 0;
            int end = TimestampUtils.firstNonDigit(s, start);
            int num = TimestampUtils.number(s, start, end);
            char sep = TimestampUtils.charAt(s, end);
            if (sep == '-') {
                cal.set(1, num);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                num = TimestampUtils.number(s, start, end);
                cal.set(2, num - 1);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                num = TimestampUtils.number(s, start, end);
                cal.set(5, num);
                start = end + 1;
                while (TimestampUtils.charAt(s, start) == ' ') {
                    ++start;
                }
                end = TimestampUtils.firstNonDigit(s, start);
                try {
                    num = TimestampUtils.number(s, start, end);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                sep = TimestampUtils.charAt(s, end);
            }
            if (sep == ':') {
                cal.set(11, num);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                num = TimestampUtils.number(s, start, end);
                cal.set(12, num);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                num = TimestampUtils.number(s, start, end);
                cal.set(13, num);
                start = end + 1;
                sep = TimestampUtils.charAt(s, end);
                if (sep == '.') {
                    end = TimestampUtils.firstNonDigit(s, start);
                    num = TimestampUtils.number(s, start, end);
                    int numlength = 9 - s.substring(start, end).length();
                    int i = 0;
                    while (i < numlength) {
                        num *= 10;
                        ++i;
                    }
                    nanos = num;
                    start = end + 1;
                    sep = TimestampUtils.charAt(s, end);
                }
            }
            if (sep == '-' || sep == '+') {
                int tzsign = sep == '-' ? -1 : 1;
                end = TimestampUtils.firstNonDigit(s, start);
                int tzhr = TimestampUtils.number(s, start, end);
                start = end + 1;
                end = TimestampUtils.firstNonDigit(s, start);
                sep = TimestampUtils.charAt(s, end);
                int tzmin = 0;
                if (sep == ':') {
                    tzmin = TimestampUtils.number(s, start, end);
                    start = end + 1;
                }
                int tzoffset = tzsign * tzhr * 60 + tzmin;
                cal.set(15, tzoffset *= 60000);
                cal.set(16, 0);
                while (TimestampUtils.charAt(s, start) == ' ') {
                    ++start;
                }
            }
            if (start < slen) {
                String era = s.substring(start);
                if (era.equals("AD")) {
                    cal.set(0, 1);
                } else if (era.equals("BC")) {
                    cal.set(0, 0);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{type, s}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)nfe);
        }
        return nanos;
    }

    public static Timestamp toTimestamp(GregorianCalendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            cal.set(15, 0);
            cal.set(16, 0);
            int nanos = TimestampUtils.loadCalendar(cal, s, "timestamp");
            Timestamp result = new Timestamp(cal.getTime().getTime());
            result.setNanos(nanos);
            Timestamp timestamp = result;
            return timestamp;
        }
    }

    public static Time toTime(GregorianCalendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            Time result;
            cal.set(15, 0);
            cal.set(16, 0);
            int nanos = TimestampUtils.loadCalendar(cal, s, "time");
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(0, 1);
            cal.set(14, (nanos + 500000) / 1000000);
            Time time = result = new Time(cal.getTime().getTime());
            return time;
        }
    }

    public static java.sql.Date toDate(GregorianCalendar cal, String s) throws SQLException {
        if (s == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            java.sql.Date result;
            cal.set(15, 0);
            cal.set(16, 0);
            TimestampUtils.loadCalendar(cal, s, "date");
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            java.sql.Date date = result = new java.sql.Date(cal.getTime().getTime());
            return date;
        }
    }

    public static String toString(StringBuffer sbuf, GregorianCalendar cal, Timestamp x) {
        StringBuffer stringBuffer = sbuf;
        synchronized (stringBuffer) {
            GregorianCalendar gregorianCalendar = cal;
            synchronized (gregorianCalendar) {
                cal.setTime(x);
                sbuf.setLength(0);
                TimestampUtils.appendDate(sbuf, cal);
                sbuf.append(' ');
                TimestampUtils.appendTime(sbuf, cal, x.getNanos());
                TimestampUtils.appendTimeZone(sbuf, x);
                TimestampUtils.appendEra(sbuf, cal);
                String string = sbuf.toString();
                return string;
            }
        }
    }

    public static String toString(StringBuffer sbuf, GregorianCalendar cal, java.sql.Date x) {
        StringBuffer stringBuffer = sbuf;
        synchronized (stringBuffer) {
            GregorianCalendar gregorianCalendar = cal;
            synchronized (gregorianCalendar) {
                cal.setTime(x);
                sbuf.setLength(0);
                TimestampUtils.appendDate(sbuf, cal);
                TimestampUtils.appendEra(sbuf, cal);
                String string = sbuf.toString();
                return string;
            }
        }
    }

    public static String toString(StringBuffer sbuf, GregorianCalendar cal, Time x) {
        StringBuffer stringBuffer = sbuf;
        synchronized (stringBuffer) {
            GregorianCalendar gregorianCalendar = cal;
            synchronized (gregorianCalendar) {
                cal.setTime(x);
                sbuf.setLength(0);
                TimestampUtils.appendTime(sbuf, cal, cal.get(14) * 1000000);
                String string = sbuf.toString();
                return string;
            }
        }
    }

    private static void appendDate(StringBuffer sbuf, Calendar cal) {
        int l_year = cal.get(1);
        int l_yearlen = String.valueOf(l_year).length();
        int i = 4;
        while (i > l_yearlen) {
            sbuf.append("0");
            --i;
        }
        sbuf.append(l_year);
        sbuf.append('-');
        int l_month = cal.get(2) + 1;
        if (l_month < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_month);
        sbuf.append('-');
        int l_day = cal.get(5);
        if (l_day < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_day);
    }

    private static void appendTime(StringBuffer sbuf, Calendar cal, int nanos) {
        int hours = cal.get(11);
        if (hours < 10) {
            sbuf.append('0');
        }
        sbuf.append(hours);
        sbuf.append(':');
        int minutes = cal.get(12);
        if (minutes < 10) {
            sbuf.append('0');
        }
        sbuf.append(minutes);
        sbuf.append(':');
        int seconds = cal.get(13);
        if (seconds < 10) {
            sbuf.append('0');
        }
        sbuf.append(seconds);
        char[] decimalStr = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        char[] nanoStr = Integer.toString(nanos).toCharArray();
        System.arraycopy(nanoStr, 0, decimalStr, decimalStr.length - nanoStr.length, nanoStr.length);
        sbuf.append('.');
        sbuf.append(decimalStr, 0, 6);
    }

    private static void appendTimeZone(StringBuffer sbuf, Date x) {
        int offset = -x.getTimezoneOffset();
        int absoff = Math.abs(offset);
        int hours = absoff / 60;
        int mins = absoff - hours * 60;
        sbuf.append(offset >= 0 ? "+" : "-");
        if (hours < 10) {
            sbuf.append('0');
        }
        sbuf.append(hours);
        if (mins < 10) {
            sbuf.append('0');
        }
        sbuf.append(mins);
    }

    private static void appendEra(StringBuffer sbuf, Calendar cal) {
        if (cal.get(0) == 0) {
            sbuf.append(" BC");
        }
    }

    private static int firstNonDigit(String s, int start) {
        int slen = s.length();
        int i = start;
        while (i < slen) {
            if (!Character.isDigit(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return slen;
    }

    private static int number(String s, int start, int end) {
        if (start >= end) {
            throw new NumberFormatException();
        }
        String num = s.substring(start, end);
        return Integer.parseInt(num);
    }

    private static char charAt(String s, int pos) {
        if (pos >= 0 && pos < s.length()) {
            return s.charAt(pos);
        }
        return '\u0000';
    }

    public static void main(String[] args) throws Exception {
        StringBuffer sbuf = new StringBuffer();
        GregorianCalendar cal = new GregorianCalendar();
        int i = 0;
        while (i < testData.length) {
            String data = testData[i];
            System.out.println("Orig: " + data);
            String result = null;
            switch (testTypes[i]) {
                case 93: {
                    result = TimestampUtils.toString(sbuf, cal, TimestampUtils.toTimestamp(cal, data));
                    break;
                }
                case 92: {
                    result = TimestampUtils.toString(sbuf, cal, TimestampUtils.toTime(cal, data));
                    break;
                }
                case 91: {
                    result = TimestampUtils.toString(sbuf, cal, TimestampUtils.toDate(cal, data));
                }
            }
            System.out.println(result);
            System.out.println();
            ++i;
        }
        System.out.println(TimestampUtils.toString(sbuf, cal, new Timestamp(0L)));
    }
}

