/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class AffineGeneralOpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    private int interp_right;
    private int interp_bottom;

    public AffineGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        this.interp_right = this.interp_width - this.interp_left - 1;
        this.interp_bottom = this.interp_height - this.interp_top - 1;
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f = (float)((Point2D)float_2).getX();
            float f2 = (float)((Point2D)float_2).getY();
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
            int n15 = (int)Math.floor(f);
            int n16 = (int)Math.floor(f2);
            float f3 = f - (float)n15;
            float f4 = f2 - (float)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        byte[] byArray3 = byArray2[n20];
                        int n21 = nArray3[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                nArray[n24][n23++] = byArray3[n22 + n21] & 0xFF;
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        int n28 = (int)(f3 * (float)this.shiftvalue);
                        int n29 = (int)(f4 * (float)this.shiftvalue);
                        int n30 = this.interp.interpolate(nArray, n28, n29);
                        int n31 = n30 < 0 ? 0 : (n30 > 255 ? 255 : n30);
                        byArray[n20][n14 + nArray2[n20]] = (byte)(n31 & 0xFF);
                        ++n20;
                    }
                }
                if ((double)f3 < this.fracdx1) {
                    n15 += this.incx;
                    f3 = (float)((double)f3 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f3 = (float)((double)f3 - this.fracdx1);
                }
                if ((double)f4 < this.fracdy1) {
                    n16 += this.incy;
                    f4 = (float)((double)f4 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f4 = (float)((double)f4 - this.fracdy1);
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        double[][] dArray = new double[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray3 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            double d = ((Point2D)float_2).getX();
            double d2 = ((Point2D)float_2).getY();
            int n15 = (int)Math.floor(d -= 0.5);
            int n16 = (int)Math.floor(d2 -= 0.5);
            double d3 = d - (double)n15;
            double d4 = d2 - (double)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        double d5;
                        double[] dArray4 = dArray3[n20];
                        int n21 = nArray2[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                dArray[n24][n23++] = dArray4[n22 + n21];
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        dArray2[n20][n14 + nArray[n20]] = d5 = this.interp.interpolate(dArray, (float)d3, (float)d4);
                        ++n20;
                    }
                }
                if (d3 < this.fracdx1) {
                    n15 += this.incx;
                    d3 += this.fracdx;
                } else {
                    n15 += this.incx1;
                    d3 -= this.fracdx1;
                }
                if (d4 < this.fracdy1) {
                    n16 += this.incy;
                    d4 += this.fracdy;
                } else {
                    n16 += this.incy1;
                    d4 -= this.fracdy1;
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float[][] fArray = new float[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f = (float)((Point2D)float_2).getX();
            float f2 = (float)((Point2D)float_2).getY();
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
            int n15 = (int)Math.floor(f);
            int n16 = (int)Math.floor(f2);
            float f3 = f - (float)n15;
            float f4 = f2 - (float)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        float f5;
                        float[] fArray4 = fArray3[n20];
                        int n21 = nArray2[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                fArray[n24][n23++] = fArray4[n22 + n21];
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        fArray2[n20][n14 + nArray[n20]] = f5 = this.interp.interpolate(fArray, f3, f4);
                        ++n20;
                    }
                }
                if ((double)f3 < this.fracdx1) {
                    n15 += this.incx;
                    f3 = (float)((double)f3 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f3 = (float)((double)f3 - this.fracdx1);
                }
                if ((double)f4 < this.fracdy1) {
                    n16 += this.incy;
                    f4 = (float)((double)f4 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f4 = (float)((double)f4 - this.fracdy1);
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3 = 0;
        int[][] nArray = new int[this.interp_height][this.interp_width];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f = (float)((Point2D)float_2).getX();
            float f2 = (float)((Point2D)float_2).getY();
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
            int n15 = (int)Math.floor(f);
            int n16 = (int)Math.floor(f2);
            float f3 = f - (float)n15;
            float f4 = f2 - (float)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        int[] nArray6 = nArray4[n20];
                        int n21 = nArray5[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                nArray[n24][n23++] = nArray6[n22 + n21];
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        int n28 = (int)(f3 * (float)this.shiftvalue);
                        int n29 = (int)(f4 * (float)this.shiftvalue);
                        int n30 = this.interp.interpolate(nArray, n28, n29);
                        int n31 = n30 < Integer.MIN_VALUE ? Integer.MIN_VALUE : (n30 > Integer.MAX_VALUE ? Integer.MAX_VALUE : n30);
                        nArray2[n20][n14 + nArray3[n20]] = n31;
                        ++n20;
                    }
                }
                if ((double)f3 < this.fracdx1) {
                    n15 += this.incx;
                    f3 = (float)((double)f3 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f3 = (float)((double)f3 - this.fracdx1);
                }
                if ((double)f4 < this.fracdy1) {
                    n16 += this.incy;
                    f4 = (float)((double)f4 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f4 = (float)((double)f4 - this.fracdy1);
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f = (float)((Point2D)float_2).getX();
            float f2 = (float)((Point2D)float_2).getY();
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
            int n15 = (int)Math.floor(f);
            int n16 = (int)Math.floor(f2);
            float f3 = f - (float)n15;
            float f4 = f2 - (float)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        short[] sArray3 = sArray2[n20];
                        int n21 = nArray3[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                nArray[n24][n23++] = sArray3[n22 + n21];
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        int n28 = (int)(f3 * (float)this.shiftvalue);
                        int n29 = (int)(f4 * (float)this.shiftvalue);
                        int n30 = this.interp.interpolate(nArray, n28, n29);
                        int n31 = n30 < Short.MIN_VALUE ? Short.MIN_VALUE : (n30 > Short.MAX_VALUE ? Short.MAX_VALUE : (int)((short)n30));
                        sArray[n20][n14 + nArray2[n20]] = n31;
                        ++n20;
                    }
                }
                if ((double)f3 < this.fracdx1) {
                    n15 += this.incx;
                    f3 = (float)((double)f3 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f3 = (float)((double)f3 - this.fracdx1);
                }
                if ((double)f4 < this.fracdy1) {
                    n16 += this.incy;
                    f4 = (float)((double)f4 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f4 = (float)((double)f4 - this.fracdy1);
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f = (float)((Point2D)float_2).getX();
            float f2 = (float)((Point2D)float_2).getY();
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
            int n15 = (int)Math.floor(f);
            int n16 = (int)Math.floor(f2);
            float f3 = f - (float)n15;
            float f4 = f2 - (float)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                if ((float)n15 >= this.src_rect_x1 + (float)this.interp_left && (float)n15 < this.src_rect_x2 - (float)this.interp_right && (float)n16 >= this.src_rect_y1 + (float)this.interp_top && (float)n16 < this.src_rect_y2 - (float)this.interp_bottom) {
                    int n20 = 0;
                    while (n20 < n8) {
                        short[] sArray3 = sArray2[n20];
                        int n21 = nArray3[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                nArray[n24][n23++] = sArray3[n22 + n21] & 0xFFFF;
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        int n28 = (int)(f3 * (float)this.shiftvalue);
                        int n29 = (int)(f4 * (float)this.shiftvalue);
                        int n30 = this.interp.interpolate(nArray, n28, n29);
                        int n31 = n30 < 0 ? 0 : (n30 > 65535 ? 65535 : n30);
                        sArray[n20][n14 + nArray2[n20]] = (short)(n31 & 0xFFFF);
                        ++n20;
                    }
                }
                if ((double)f3 < this.fracdx1) {
                    n15 += this.incx;
                    f3 = (float)((double)f3 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f3 = (float)((double)f3 - this.fracdx1);
                }
                if ((double)f4 < this.fracdy1) {
                    n16 += this.incy;
                    f4 = (float)((double)f4 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f4 = (float)((double)f4 - this.fracdy1);
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }
}

