/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.JobDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.run.CommandLineFactory;
import uk.ac.sanger.jcon.run.CommandLineFactoryVelocityImpl;
import uk.ac.sanger.jcon.run.Coordinator;
import uk.ac.sanger.jcon.run.Processor;
import uk.ac.sanger.jcon.run.ProcessorFactory;

public abstract class AbstractCoordinator
implements Coordinator {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$AbstractCoordinator == null ? (class$uk$ac$sanger$jcon$run$AbstractCoordinator = AbstractCoordinator.class$("uk.ac.sanger.jcon.run.AbstractCoordinator")) : class$uk$ac$sanger$jcon$run$AbstractCoordinator).getName());
    protected JobDAO jobDAO;
    protected StatusDAO statusDAO;
    protected ProcessorFactory pFactory;
    protected CommandLineFactory clFactory;
    protected Task taskLite;
    protected int jobGrabSize;
    protected int jobPollInterval;
    protected int maxConcurrentJobs;
    protected Processor[] processors;
    protected boolean isCoordinating;
    protected boolean stopRequested;
    protected Status started;
    protected Status ready;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$AbstractCoordinator;

    public AbstractCoordinator(ProcessorFactory pFactory, JobDAO jobDAO, StatusDAO statusDAO) {
        this.pFactory = pFactory;
        this.jobDAO = jobDAO;
        this.statusDAO = statusDAO;
        this.clFactory = CommandLineFactoryVelocityImpl.getInstance();
        this.isCoordinating = false;
        this.stopRequested = false;
    }

    public Task getTask() {
        return this.taskLite;
    }

    public synchronized void setTask(Task taskLite) {
        cat.info((Object)("Changed current Task to " + taskLite));
        this.taskLite = taskLite;
    }

    public int getMaxConcurrentJobs() {
        return this.maxConcurrentJobs;
    }

    public int getJobGrabSize() {
        return this.jobGrabSize;
    }

    public void setJobGrabSize(int jobGrabSize) throws JobControlException {
        if (jobGrabSize < 1 || jobGrabSize > this.maxConcurrentJobs) {
            throw new JobControlException("Failed to set Job grab size to a value exceeding the maximum concurrent number of Jobs");
        }
        cat.debug((Object)("Now fetching groups of " + jobGrabSize + " jobs from storage"));
        this.jobGrabSize = jobGrabSize;
    }

    public abstract void startCoordinating() throws IllegalStateException;

    public abstract void stopCoordinating() throws IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coordinate() {
        try {
            this.started = this.statusDAO.readStatusById(3);
            this.ready = this.statusDAO.readStatusById(2);
        }
        catch (Exception e) {
            cat.error((Object)"Caught Exception while reading startup values.", (Throwable)e);
        }
        while (this.isCoordinating) {
            int freeSlots = this.countFreeProcessors();
            cat.info((Object)("Currently running: " + (this.maxConcurrentJobs - freeSlots) + " jobs. Max concurrent Jobs allowed: " + this.maxConcurrentJobs + " (" + freeSlots + " free slots; grab size " + this.jobGrabSize + ")"));
            if (this.stopRequested) {
                if (freeSlots == this.processors.length) {
                    cat.info((Object)"No Jobs running. Coordinator stopping now.");
                    this.isCoordinating = false;
                    return;
                }
                cat.info((Object)"Jobs still running. Awaiting their completion before Coordinator is stopped.");
                this.waitFor(this.jobPollInterval);
                this.checkRunningJobs();
                continue;
            }
            if (this.taskLite == null) {
                cat.info((Object)"Not Task available");
                this.waitFor(this.jobPollInterval);
                continue;
            }
            if (freeSlots >= this.jobGrabSize) {
                try {
                    AbstractCoordinator abstractCoordinator = this;
                    synchronized (abstractCoordinator) {
                        Collection readyJobs = this.jobDAO.readNJobsByStatusAndTaskId(freeSlots, this.ready, this.taskLite.getId());
                        this.assignReadyJobs(readyJobs);
                    }
                }
                catch (Exception e) {
                    cat.error((Object)"Caught Exception while fetching ready Jobs.", (Throwable)e);
                }
            }
            this.waitFor(this.jobPollInterval);
            this.checkRunningJobs();
        }
    }

    protected void checkRunningJobs() {
    }

    protected synchronized void waitFor(int milliSeconds) {
        try {
            cat.info((Object)("Waiting for " + milliSeconds + " ms"));
            this.wait(milliSeconds);
        }
        catch (InterruptedException ie) {
            cat.error((Object)"Caught Exception", (Throwable)ie);
        }
    }

    protected void createProcessors() {
        this.processors = new Processor[this.getMaxConcurrentJobs()];
        for (int i = 0; i < this.processors.length; ++i) {
            this.processors[i] = this.pFactory.createProcessor(this.clFactory, this.statusDAO);
        }
    }

    protected int countFreeProcessors() {
        int freeProcs = 0;
        for (int i = 0; i < this.processors.length; ++i) {
            if (!this.processors[i].getFree()) continue;
            ++freeProcs;
        }
        return freeProcs;
    }

    protected Processor getFreeProcessor() {
        for (int i = 0; i < this.processors.length; ++i) {
            cat.debug((Object)("Testing whether processor " + i + " is free"));
            if (!this.processors[i].getFree()) continue;
            cat.debug((Object)("Processor " + i + " is free"));
            return this.processors[i];
        }
        return null;
    }

    protected void setFreeProcessor(Job job) {
        int index = this.findProcessorIndex(job.getId());
        if (index == -1) {
            cat.error((Object)("Failed to find which Processor was processing Job [" + job.getId() + "]"));
        } else {
            cat.debug((Object)("Set processor " + index + " free on completion of Job [" + job.getId() + "]"));
            this.processors[index].setFree(true);
        }
    }

    protected int findProcessorIndex(int jobId) {
        for (int i = 0; i < this.processors.length; ++i) {
            Job procJob;
            if (this.processors[i].getFree() || (procJob = this.processors[i].getJob()) == null || jobId != procJob.getId()) continue;
            return i;
        }
        return -1;
    }

    protected void assignReadyJobs(Collection readyJobs) {
        Iterator ri = readyJobs.iterator();
        while (ri.hasNext()) {
            Job job = (Job)ri.next();
            Processor proc = this.getFreeProcessor();
            if (proc != null) {
                cat.debug((Object)("About to start " + job));
                PropertyChangeListener listener = this.createUpdateListener();
                job.addPropertyChangeListener("status", listener);
                try {
                    proc.process(job);
                }
                catch (Exception e) {
                    cat.error((Object)("Caught Exception while starting Job [" + job.getId() + "]"), (Throwable)e);
                    cat.debug((Object)("Removing status update listener from Job [" + job.getId() + "]"));
                    job.removePropertyChangeListener(listener);
                    this.setFreeProcessor(job);
                }
                continue;
            }
            cat.error((Object)"Failed to find a free Processor");
        }
    }

    protected PropertyChangeListener createUpdateListener() {
        return new UpdateListener();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UpdateListener
    implements PropertyChangeListener {
        UpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent evt) {
            job = (Job)evt.getSource();
            oldState = ((Status)evt.getOldValue()).getId();
            newState = ((Status)evt.getNewValue()).getId();
            terminated = false;
            try {
                try {
                    switch (newState) {
                        case 3: {
                            AbstractCoordinator.this.jobDAO.updateJobStarted(job);
                            ** break;
                        }
                        case 4: {
                            AbstractCoordinator.this.jobDAO.updateJobCompleted(job);
                            terminated = true;
                            ** break;
                        }
                        case 5: {
                            AbstractCoordinator.this.jobDAO.updateJobFailedCascade(job);
                            terminated = true;
                            ** break;
                        }
                        case 6: {
                            terminated = true;
                            ** break;
                        }
                        case 7: {
                            terminated = true;
                            ** break;
                        }
                    }
                    AbstractCoordinator.cat.warn((Object)("Coordinator was asked to apply unexpected update of Job [" + job.getId() + "] from status " + oldState + " to " + newState));
                }
                catch (Exception e) {
                    AbstractCoordinator.cat.error((Object)("Coordinator failed to update Job [" + job.getId() + "]"), (Throwable)e);
                    var8_7 = null;
                    if (terminated == false) return;
                    AbstractCoordinator.this.setFreeProcessor(job);
                    job.removePropertyChangeListener(this);
                    return;
                }
                var8_6 = null;
                if (terminated == false) return;
                AbstractCoordinator.this.setFreeProcessor(job);
            }
            catch (Throwable var7_10) {
                var8_8 = null;
                if (terminated == false) throw var7_10;
                AbstractCoordinator.this.setFreeProcessor(job);
                job.removePropertyChangeListener(this);
                throw var7_10;
            }
            job.removePropertyChangeListener(this);
        }
    }
}

