/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmap;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmap.MonochromeColourMap;
import org.biolegato.gdesupport.canvas.colourmask.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public class GDECharColourMap
extends MonochromeColourMap {
    public static final Color neutralColour = new Color(64, 64, 64);

    public GDECharColourMap() {
        this.setName("<default>");
    }

    public GDECharColourMap(Color foreground, Color background, Color foregroundSelect, Color backgroundSelect) {
        super(foreground, background, foregroundSelect, backgroundSelect);
        this.setName("<default>");
    }

    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, int pstart, int pend) {
        char[] stringArray = this.safesubstring(seq, pstart, pend).toCharArray();
        Color fgCurrent = this.foreground;
        if (seq.get((Object)"mask") instanceof ColourMap) {
            ((ColourMap)seq.get((Object)"mask")).regularDrawString(ta, gfx, xstart, ystart, seq, pstart, pend);
        } else {
            for (char character : stringArray) {
                if (Sequence.Type.DNA.equals(seq.get((Object)"type")) || Sequence.Type.RNA.equals(seq.get((Object)"type"))) {
                    switch (character) {
                        case 'A': 
                        case 'a': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(1);
                            break;
                        }
                        case 'B': 
                        case 'D': 
                        case 'H': 
                        case 'I': 
                        case 'K': 
                        case 'M': 
                        case 'N': 
                        case 'R': 
                        case 'S': 
                        case 'V': 
                        case 'W': 
                        case 'Y': 
                        case 'b': 
                        case 'd': 
                        case 'h': 
                        case 'i': 
                        case 'k': 
                        case 'm': 
                        case 'n': 
                        case 'r': 
                        case 's': 
                        case 'v': 
                        case 'w': 
                        case 'y': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(3);
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(4);
                            break;
                        }
                        case 'T': 
                        case 'U': 
                        case 't': 
                        case 'u': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(5);
                            break;
                        }
                        case 'X': {
                            character = 'N';
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        }
                        case 'x': {
                            character = 'n';
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        }
                        default: {
                            character = '-';
                            fgCurrent = neutralColour;
                            break;
                        }
                    }
                } else if (Sequence.Type.PROTEIN.equals(seq.get((Object)"type"))) {
                    switch (character) {
                        case 'A': 
                        case 'G': 
                        case 'O': 
                        case 'P': 
                        case 'S': 
                        case 'T': 
                        case 'a': 
                        case 'g': 
                        case 'o': 
                        case 'p': 
                        case 's': 
                        case 't': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(6);
                            break;
                        }
                        case 'B': 
                        case 'D': 
                        case 'E': 
                        case 'N': 
                        case 'Q': 
                        case 'Z': 
                        case 'b': 
                        case 'd': 
                        case 'e': 
                        case 'n': 
                        case 'q': 
                        case 'z': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(4);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(1);
                            break;
                        }
                        case 'F': 
                        case 'W': 
                        case 'Y': 
                        case 'f': 
                        case 'w': 
                        case 'y': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(3);
                            break;
                        }
                        case 'H': 
                        case 'K': 
                        case 'R': 
                        case 'h': 
                        case 'k': 
                        case 'r': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(7);
                            break;
                        }
                        case 'I': 
                        case 'J': 
                        case 'L': 
                        case 'M': 
                        case 'V': 
                        case 'i': 
                        case 'j': 
                        case 'l': 
                        case 'm': 
                        case 'v': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(5);
                            break;
                        }
                        case '*': 
                        case 'X': 
                        case 'x': {
                            fgCurrent = GDEColourMaskFile.getDefaultColour(2);
                            break;
                        }
                        default: {
                            fgCurrent = neutralColour;
                            break;
                        }
                    }
                } else {
                    fgCurrent = this.foreground;
                }
                this.drawString(ta, gfx, xstart, ystart, "" + character, fgCurrent, this.background);
                xstart += ta.columnSize();
            }
        }
    }
}

