/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.Editable;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmap.MonochromeColourMap;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;
import org.biolegato.gdesupport.canvas.textarea.BLComponent;

public class BLTextArea
extends BLComponent
implements FocusListener,
Editable,
SeqDocListener,
KeyListener,
MouseMotionListener,
MouseListener {
    protected boolean insertMode = false;
    protected boolean selectionMove = false;
    protected boolean selectionMouse = false;
    protected int row = 0;
    protected int column = 0;
    private int sx1 = -1;
    private int sy1 = -1;
    private int sx2 = -1;
    private int sy2 = -1;
    protected ColourMap normalMap = defaultColourMap;
    protected ColourMap greyedOutMap = defaultGreyColourMap;
    protected ColourMap currentMap = this.normalMap;
    protected JPopupMenu popup = new JPopupMenu();
    protected LinkedList<CursorListener> cursorListeners = new LinkedList();
    protected LinkedList<ModeListener> modeListeners = new LinkedList();
    protected final Color invalidzone = Color.RED;
    public final BLTextArea blTextAreaSelf = this;
    public static final ColourMap defaultColourMap = new MonochromeColourMap(Color.BLACK, Color.WHITE, Color.WHITE, Color.BLUE);
    public static final ColourMap defaultGreyColourMap = new MonochromeColourMap(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.WHITE);
    public static final long serialVersionUID = 7526472295622777004L;

    public BLTextArea() {
        BLMain.getSeqDoc().addListener((SeqDocListener)this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Cut"){
            private static final long serialVersionUID = 7526472295622777029L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.cut();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Copy"){
            private static final long serialVersionUID = 7526472295622777030L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.copy();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Paste"){
            private static final long serialVersionUID = 7526472295622777031L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.paste();
            }
        }));
        this.setFont(BLMain.DEFAULT_FONT);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setFocusTraversalKeysEnabled(false);
        this.refreshSize();
        this.setDoubleBuffered(true);
        this.repaint();
    }

    public void addCursorListener(CursorListener listener) {
        this.cursorListeners.add(listener);
    }

    public void addModeListener(ModeListener listener) {
        this.modeListeners.add(listener);
    }

    public void changePosition(int newColumn, int newRow) {
        int oldRow = this.row;
        int oldColumn = this.column;
        newRow = Math.max(0, Math.min(newRow, BLMain.getSeqDoc().getLineCount() - 1));
        newColumn = Math.max(0, Math.min(newColumn, BLMain.getSeqDoc().getLineLength(newRow)));
        this.row = newRow;
        this.column = newColumn;
        this.repaint(this.column2X(oldColumn), this.row2Y(oldRow), this.column2X(oldColumn), this.row2Y(oldRow + 1));
        this.repaint(this.column2X(this.column), this.row2Y(this.row), this.column2X(this.column), this.row2Y(this.row + 1));
        for (CursorListener listener : this.cursorListeners) {
            listener.cursorChange(this, this.column, this.row);
        }
        this.scrollRectToVisible(new Rectangle(this.column2X(this.column), this.row2Y(this.row), 1, 1));
    }

    public SeqDoc getSeqDoc() {
        return BLMain.getSeqDoc();
    }

    public void setColourMap(ColourMap c) {
        if (this.currentMap == this.normalMap) {
            this.currentMap = c;
            c.setBackground(this.getBackground());
        }
        this.normalMap = this.currentMap;
        this.repaint();
    }

    public void setGreyColourMap(ColourMap c) {
        if (this.currentMap == this.greyedOutMap) {
            this.currentMap = c;
        }
        this.greyedOutMap = this.currentMap;
        this.repaint();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.normalMap.setBackground(c);
    }

    public Sequence[] getData() {
        String currentSequence = "";
        Sequence current = null;
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        if (!this.isEmptySelection()) {
            for (int count = this.getMinSY(); count <= this.getMaxSY(); ++count) {
                int lineLength = BLMain.getSeqDoc().getLineLength(count);
                if (this.getMinSX() >= lineLength || (current = BLMain.getSeqDoc().getLine(count)) == null) continue;
                current = (Sequence)current.clone();
                currentSequence = current.get((Object)"sequence").toString();
                if (this.getMaxSX() < lineLength) {
                    currentSequence = currentSequence.substring(0, this.getMaxSX());
                }
                if (this.getMinSX() > 0) {
                    currentSequence = currentSequence.substring(this.getMinSX());
                }
                if (!currentSequence.equals(current.get((Object)"sequence").toString())) {
                    current.put("sequence", (Object)currentSequence);
                }
                result.add(current);
            }
        }
        return result.toArray(new Sequence[0]);
    }

    public void paintComponent(Graphics gfx) {
        Rectangle area = gfx.getClipBounds();
        int x = area.x;
        int y = area.y;
        int width = area.width;
        int height = area.height;
        int startrow = this.Y2Row(y);
        int endrow = Math.min(BLMain.getSeqDoc().getLineCount(), startrow + this.Y2Row(height) + 1);
        int startcol = this.X2Column(x);
        int endcol = startcol + this.X2Column(width);
        int xstart = this.column2X(startcol);
        int ystart = this.row2Y(startrow);
        int startSelect = this.getMinSX();
        int endSelect = this.getMaxSX();
        ColourMap useMap = this.currentMap;
        if (gfx != null) {
            gfx.setColor(this.getBackground());
            gfx.fillRect(xstart, ystart, width, height);
            for (int count = startrow; count < endrow; ++count) {
                Sequence currentLine = BLMain.getSeqDoc().getLine(count);
                useMap = this.currentMap;
                if (this.hasFocus() && currentLine.containsKey((Object)"mask")) {
                    useMap = (ColourMap)currentLine.get((Object)"mask");
                }
                if (this.isSelectedLine(count) && endSelect >= 0 && startSelect >= 0 && endSelect - startSelect > 0 && endSelect <= endcol) {
                    useMap.regularDrawString(this, gfx, xstart, this.row2Y(count), currentLine, startcol, startSelect);
                    useMap.selectDrawString(this, gfx, xstart + Math.round(this.columnSize() * startSelect), this.row2Y(count), currentLine, startSelect, endSelect);
                    useMap.regularDrawString(this, gfx, xstart + Math.round(this.columnSize() * endSelect), this.row2Y(count), currentLine, endSelect, endcol);
                    continue;
                }
                useMap.regularDrawString(this, gfx, xstart, this.row2Y(count), currentLine, startcol, endcol);
            }
            if (this.hasFocus() && this.column2X(this.column) >= x && this.column2X(this.column) <= x + width && this.row2Y(this.row) >= y && this.row2Y(this.row + 1) <= y + height) {
                gfx.setColor(this.getForeground());
                gfx.drawLine(this.column2X(this.column), this.row2Y(this.row), this.column2X(this.column), this.row2Y(this.row + 1));
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.refreshSize();
        this.repaint();
    }

    public void keyTyped(KeyEvent event) {
        boolean canInsert = true;
        try {
            switch (event.getKeyChar()) {
                case '\b': 
                case '\u007f': {
                    break;
                }
                case '\n': {
                    if (this.row + 1 < BLMain.getSeqDoc().getLineCount()) {
                        this.changePosition(Math.min(BLMain.getSeqDoc().getLineLength(this.row + 1), this.column), this.row + 1);
                        this.resetSelection();
                    }
                    break;
                }
                case '\uffff': {
                    break;
                }
                default: {
                    if (!this.isEmptySelection()) {
                        this.deleteSelection();
                    } else if (this.insertMode && BLMain.getSeqDoc().getLineCount() > 0 && BLMain.getSeqDoc().getLineLength(0) > 0) {
                        canInsert = this.delete(this.column, this.row, 1, 0);
                    }
                    if (this.isEmptySelection() || !this.insertMode || canInsert) {
                        this.insert(this.column, this.row, String.valueOf(event.getKeyChar()));
                        this.changePosition(this.column + 1, this.row);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void keyPressed(KeyEvent event) {
        int backspacecol = 0;
        boolean moved = false;
        try {
            switch (event.getKeyChar()) {
                case '\b': {
                    if (!this.isEmptySelection()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.row > 0 || this.column > 0) {
                        if (this.column <= 0 && this.row > 0) {
                            backspacecol = BLMain.getSeqDoc().getLineLength(this.row - 1);
                        }
                        if (this.column - 1 >= 0 && this.delete(this.column - 1, this.row, 1, 0)) {
                            if (this.column <= 0 && this.row > 0) {
                                this.changePosition(backspacecol, this.row - 1);
                                break;
                            }
                            this.changePosition(this.column - 1, this.row);
                        }
                    }
                    break;
                }
                case '\u007f': {
                    if (!this.isEmptySelection()) {
                        this.deleteSelection();
                        break;
                    }
                    if (BLMain.getSeqDoc().getLineCount() > 0 && BLMain.getSeqDoc().getLineLength(0) > 0) {
                        this.delete(this.column, this.row, 1, 0);
                    }
                    break;
                }
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            if (this.isEmptySelection()) {
                                this.moveSelection(this.column, this.row);
                                this.stretchSelection(this.column, this.row);
                            }
                            this.selectionMove = true;
                            break;
                        }
                        case 37: {
                            if (this.column > 0) {
                                this.changePosition(this.column - 1, this.row);
                                moved = true;
                                break;
                            }
                            if (this.row <= 0) break;
                            this.changePosition(BLMain.getSeqDoc().getLineLength(this.row), this.row - 1);
                            moved = true;
                            break;
                        }
                        case 39: {
                            if (this.column + 1 <= BLMain.getSeqDoc().getLineLength(this.row)) {
                                this.changePosition(this.column + 1, this.row);
                                moved = true;
                                break;
                            }
                            if (this.row + 1 >= BLMain.getSeqDoc().getLineCount()) break;
                            this.changePosition(0, this.row + 1);
                            moved = true;
                            break;
                        }
                        case 38: {
                            if (this.row <= 0) break;
                            this.changePosition(Math.min(BLMain.getSeqDoc().getLineLength(this.row - 1), this.column), this.row - 1);
                            moved = true;
                            break;
                        }
                        case 40: {
                            if (this.row + 1 >= BLMain.getSeqDoc().getLineCount()) break;
                            this.changePosition(Math.min(BLMain.getSeqDoc().getLineLength(this.row + 1), this.column), this.row + 1);
                            moved = true;
                            break;
                        }
                        case 36: {
                            this.changePosition(0, this.row);
                            moved = true;
                            break;
                        }
                        case 35: {
                            this.changePosition(BLMain.getSeqDoc().getLineLength(this.row), this.row);
                            moved = true;
                            break;
                        }
                        case 65485: {
                            this.copy();
                            break;
                        }
                        case 65489: {
                            this.cut();
                            break;
                        }
                        case 65487: {
                            this.paste();
                            break;
                        }
                        case 155: {
                            this.insertMode = !this.insertMode;
                            for (ModeListener listener : this.modeListeners) {
                                listener.insertionMode(this.insertMode);
                            }
                            break;
                        }
                        default: {
                            if (!"true".equalsIgnoreCase(BLMain.getProperty((String)"debug"))) break;
                            BLMain.warning((String)("Unhandled key pressed --- getKeyChar() = " + event.getKeyChar() + "\tgetKeyCode() = " + event.getKeyCode()), (String)"BLTextArea");
                        }
                    }
                    if (this.column >= BLMain.getSeqDoc().getLineLength(this.row)) {
                        this.changePosition(BLMain.getSeqDoc().getLineLength(this.row), this.row);
                    }
                    if (moved) {
                        if (this.selectionMove) {
                            this.stretchSelection(this.column, this.row);
                        } else if (!this.isEmptySelection()) {
                            this.resetSelection();
                        }
                        moved = false;
                    }
                    break;
                }
                default: {
                    this.deleteSelection();
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void keyReleased(KeyEvent event) {
        try {
            block1 : switch (event.getKeyChar()) {
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = false;
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void mouseClicked(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            this.changePosition(this.X2Column(event.getX()), this.Y2Row(event.getY()));
            if (!this.selectionMove) {
                this.resetSelection();
            } else {
                this.stretchSelection(this.column, this.row);
            }
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(this, event.getX(), event.getY());
        } else if (!this.selectionMove) {
            this.resetSelection();
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.selectionMouse = false;
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        this.changePosition(this.X2Column(event.getX()), this.Y2Row(event.getY()));
        if (!this.selectionMouse) {
            this.moveSelection(this.column, this.row);
            this.selectionMouse = true;
        } else {
            this.stretchSelection(this.column, this.row);
        }
        this.requestFocus();
        this.requestFocusInWindow();
    }

    public void mouseMoved(MouseEvent event) {
    }

    protected void refreshSize() {
        int width = (BLMain.getSeqDoc().getLongestLine() + 1) * this.columnSize();
        int height = this.rowSize() * BLMain.getSeqDoc().getLineCount();
        Dimension size = new Dimension(width, height);
        this.setSize(size);
        this.setPreferredSize(size);
        this.revalidate();
    }

    public void addPopupMenuItem(JMenuItem act) {
        this.popup.add(act);
    }

    public void removePopupMenuItem(JMenuItem act) {
        this.popup.remove(act);
    }

    public void copy() {
        if (!this.isEmptySelection()) {
            BLMain.setClipboard((Sequence[])this.getData());
        }
    }

    public void cut() {
        if (!this.isEmptySelection()) {
            this.copy();
            this.deleteSelection();
        }
    }

    public void paste() {
        this.deleteSelection();
        this.insert(this.column, this.row, BLMain.getClipboard());
    }

    public void selectAll() {
        this.moveSelection(0, 0);
        this.stretchSelection(BLMain.getSeqDoc().getLongestLine(), BLMain.getSeqDoc().getLineCount() - 1);
    }

    public boolean insert(int x, int y, String data) {
        return BLMain.getSeqDoc().insert(x, y, data);
    }

    public boolean insert(int x, int y, Sequence[] data) {
        boolean result = true;
        for (int count = 0; count < data.length; ++count) {
            if (y + count < BLMain.getSeqDoc().getLineCount()) {
                result &= this.insert(x, y + count, data[count].get((Object)"sequence").toString());
                continue;
            }
            result &= BLMain.getSeqDoc().addSequence(y + count, data[count]);
        }
        return result;
    }

    public boolean delete(int x, int y, int w, int h) {
        return BLMain.getSeqDoc().delete(x, y, w, h);
    }

    public boolean deleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        boolean result = false;
        if (!this.isEmptySelection() && this.delete(x, y, w, h)) {
            this.resetSelection();
            this.changePosition(x, y);
            result = true;
        }
        return result;
    }

    public boolean getInsertMode() {
        return this.insertMode;
    }

    public void sequenceAdded(SeqDoc source, int index, Sequence sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight() - y;
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceChanged(SeqDoc source, int index, Sequence sequence, String key) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = this.rowSize();
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceRemoved(SeqDoc source, int index, Sequence sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight() - y;
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void focusGained(FocusEvent e) {
        this.currentMap = this.normalMap;
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.currentMap = this.greyedOutMap;
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.repaint();
    }

    public void resetSelection() {
        this.moveSelection(0, 0);
        this.stretchSelection(0, 0);
    }

    public void moveSelection(int newx, int newy) {
        boolean x = false;
        int y = this.row2Y(Math.min(newy, this.getMinSY()) - 1);
        int w = (int)this.getSize().getWidth();
        int h = this.row2Y(Math.max(newy, this.getMaxSY()) + 1);
        this.sx1 = newx;
        this.sy1 = newy;
        this.repaint(0, y, w, h);
    }

    public void stretchSelection(int newx, int newy) {
        boolean x = false;
        int y = this.row2Y(Math.min(newy, this.getMinSY()) - 1);
        int w = (int)this.getSize().getWidth();
        int h = this.row2Y(Math.max(newy, this.getMaxSY()) + 1);
        this.sx2 = newx;
        this.sy2 = newy;
        this.repaint(0, y, w, h);
    }

    protected boolean isEmptySelection() {
        return this.sx1 == this.sx2 || this.sy1 == this.sy2;
    }

    public int getMinSX() {
        return Math.min(this.sx1, this.sx2);
    }

    public int getMaxSX() {
        return Math.max(this.sx1, this.sx2);
    }

    public int getMinSY() {
        return Math.min(this.sy1, this.sy2);
    }

    public int getMaxSY() {
        return Math.max(this.sy1, this.sy2);
    }

    public int getSX1() {
        return this.sx1;
    }

    public int getSY1() {
        return this.sy1;
    }

    public int getSX2() {
        return this.sx1;
    }

    public int getSY2() {
        return this.sy2;
    }

    public boolean isSelectedLine(int y) {
        return y >= this.getMinSY() && y <= this.getMaxSY();
    }
}

