/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.Color;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.GDECharColourMap;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public class GDETextArea
extends BLTextArea {
    private static final long serialVersionUID = 7526472295622777017L;

    public GDETextArea() {
        this.setColourMap(new GDECharColourMap());
        this.setBackground(new Color(255, 255, 240));
        this.greyedOutMap = new GDECharColourMap(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.WHITE);
    }

    public void changeCase() {
        String data = null;
        Sequence[] seqList = null;
        if (!this.isEmptySelection()) {
            for (Sequence seq : seqList = this.getData()) {
                data = seq.get((Object)"sequence").toString();
                if (data.length() < 0) continue;
                if (Character.isUpperCase(data.charAt(0))) {
                    seq.put("sequence", (Object)data.toLowerCase());
                    continue;
                }
                seq.put("sequence", (Object)data.toUpperCase());
            }
            this.deleteSelection();
            this.insert(this.column, this.row, seqList);
        }
    }

    public void cut() {
        if (!this.isEmptySelection()) {
            this.copy();
            this.pdeleteSelection();
        }
    }

    public void paste() {
        this.pdeleteSelection();
        this.insert(this.column, this.row, BLMain.getClipboard());
    }

    public boolean pdeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        boolean result = false;
        if (!this.isEmptySelection() && this.pdelete(x, y, w, h)) {
            this.moveSelection(0, 0);
            this.stretchSelection(0, 0);
            this.changePosition(x, y);
            result = true;
        }
        return result;
    }

    public boolean isSelectedLine(int y) {
        boolean result = super.isSelectedLine(y);
        Sequence current = null;
        LinkedList group = null;
        if (!result && (current = BLMain.getSeqDoc().getLine(y)).get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)current.get((Object)"group")))) != null) {
            for (Sequence seq : group) {
                if (!super.isSelectedLine(BLMain.getSeqDoc().indexOf(seq))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void moveSelection(int newx, int newy) {
        boolean x = false;
        boolean y = false;
        int w = (int)this.getSize().getWidth();
        int h = (int)this.getSize().getHeight();
        super.moveSelection(newx, newy);
        this.repaint(0, 0, w, h);
    }

    public void stretchSelection(int newx, int newy) {
        boolean x = false;
        boolean y = false;
        int w = (int)this.getSize().getWidth();
        int h = (int)this.getSize().getHeight();
        super.stretchSelection(newx, newy);
        this.repaint(0, 0, w, h);
    }

    public boolean isProtectionsOn(Sequence seq, String text) {
        return this.getProtectAlignment(seq, text) || this.getProtectAmbiguous(seq, text) || this.getProtectUnambiguous(seq, text);
    }

    public boolean getProtectAlignment(Sequence seq, String text) {
        boolean protect = false;
        if (Boolean.TRUE.equals(seq.get((Object)"protect_align"))) {
            if (Sequence.Type.DNA.equals(seq.get((Object)"type")) || Sequence.Type.RNA.equals(seq.get((Object)"type"))) {
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] != 'a' && test[count] != 'c' && test[count] != 't' && test[count] != 'g' && test[count] != 'u' && test[count] != 'r' && test[count] != 'y' && test[count] != 'w' && test[count] != 's' && test[count] != 'm' && test[count] != 'k' && test[count] != 'h' && test[count] != 'b' && test[count] != 'v' && test[count] != 'i' && test[count] != 'd' && test[count] != 'n';
                }
            } else if (Sequence.Type.PROTEIN.equals(seq.get((Object)"type"))) {
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == ' ' || test[count] == '\n' || test[count] == '\t' || test[count] == '\r' || test[count] == '-';
                }
                protect = Pattern.matches("[\\s-]", text);
            }
        }
        return protect;
    }

    public boolean getProtectAmbiguous(Sequence seq, String text) {
        boolean protect;
        block2: {
            block3: {
                protect = false;
                if (!Boolean.TRUE.equals(seq.get((Object)"protect_ambig"))) break block2;
                if (!Sequence.Type.DNA.equals(seq.get((Object)"type")) && !Sequence.Type.RNA.equals(seq.get((Object)"type"))) break block3;
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == 'r' || test[count] == 'y' || test[count] == 'w' || test[count] == 's' || test[count] == 'm' || test[count] == 'k' || test[count] == 'h' || test[count] == 'b' || test[count] == 'v' || test[count] == 'i' || test[count] == 'd' || test[count] == 'n';
                }
                break block2;
            }
            if (!Sequence.Type.PROTEIN.equals(seq.get((Object)"type"))) break block2;
            char[] test = text.toLowerCase().toCharArray();
            for (int count = 0; !protect && count < test.length; ++count) {
                protect = protect || test[count] == 'b' || test[count] == '*' || test[count] == 'z' || test[count] == 'x';
            }
        }
        return protect;
    }

    public boolean getProtectUnambiguous(Sequence seq, String text) {
        boolean protect;
        block2: {
            block3: {
                protect = false;
                if (!Boolean.TRUE.equals(seq.get((Object)"protect_unambig"))) break block2;
                if (!Sequence.Type.DNA.equals(seq.get((Object)"type")) && !Sequence.Type.RNA.equals(seq.get((Object)"type"))) break block3;
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == 'a' || test[count] == 'c' || test[count] == 't' || test[count] == 'g' || test[count] == 'u';
                }
                break block2;
            }
            if (!Sequence.Type.PROTEIN.equals(seq.get((Object)"type"))) break block2;
            char[] test = text.toLowerCase().toCharArray();
            for (int count = 0; !protect && count < test.length; ++count) {
                protect = protect || test[count] != 'b' && test[count] != '*' && test[count] != 'z' && test[count] != 'x' && test[count] != ' ' && test[count] != '\n' && test[count] != '\t' && test[count] != '\r' && test[count] != '-';
            }
        }
        return protect;
    }

    public boolean insert(int x, int y, String text) {
        LinkedList group;
        boolean result = true;
        Sequence current = BLMain.getSeqDoc().getLine(y);
        if (current.get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)current.get((Object)"group")))) != null) {
            for (Sequence seq : group) {
                int gln = BLMain.getSeqDoc().indexOf(seq);
                if (gln >= 0 && gln < BLMain.getSeqDoc().getLineCount()) {
                    if (this.isProtectionsOn(seq, text)) continue;
                    result &= super.insert(x, gln, text);
                    continue;
                }
                BLMain.error((String)("Invalid row number: " + gln + " seq: " + seq.get((Object)"name")), (String)"boolean GDETextArea.insert (char)");
            }
        } else if (!this.isProtectionsOn(current, text)) {
            result = super.insert(x, y, text);
        }
        return result;
    }

    public boolean delete(int x, int y, int w, int h) {
        boolean result = false;
        Sequence current = null;
        for (int count = y; count <= y + h; ++count) {
            LinkedList group;
            current = BLMain.getSeqDoc().getLine(count);
            if (current.get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)current.get((Object)"group")))) != null) {
                for (Sequence seq : group) {
                    int gln = BLMain.getSeqDoc().indexOf(seq);
                    if ((gln < y || gln > y + h) && gln < BLMain.getSeqDoc().getLineCount()) {
                        result &= this.pdelete(x, gln, w, 0);
                        continue;
                    }
                    if (gln < BLMain.getSeqDoc().getLineCount()) continue;
                    BLMain.error((String)("Invalid row number: " + gln), (String)"boolean GDETextArea.insert (char)");
                }
            }
            result = this.pdelete(x, count, w, 0);
        }
        return result;
    }

    public boolean pdelete(int x, int y, int w, int h) {
        Sequence current = null;
        String text = null;
        boolean result = false;
        for (int count = y; count <= y + h; ++count) {
            current = BLMain.getSeqDoc().getLine(count);
            text = current.get((Object)"sequence").toString();
            if (x > 0 && x < text.length()) {
                text = text.substring(x);
            } else if (x > text.length()) {
                text = "";
            }
            if (w > 0 && w < text.length()) {
                text = text.substring(0, w);
            } else if (w < 0) {
                text = "";
            }
            if (this.isProtectionsOn(current, text)) continue;
            result = super.delete(x, count, w, 0);
        }
        return result;
    }
}

