/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.properties;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.PropertiesListener;
import org.biolegato.core.properties.PropertiesNumber;

public class BLProperties
extends Properties {
    private Hashtable<String, LinkedList<PropertiesListener>> propertiesListeners = new Hashtable();
    private static LinkedList<PropertiesExtension> propertyExtensionList = new LinkedList();
    private static final long serialVersionUID = 7526472295622776168L;

    public BLProperties() {
        super(new Properties(){
            private static final long serialVersionUID = 7526472295622777034L;
            {
                this.setProperty("debug", "false");
                this.setProperty("plugins", BLMain.PROGRAM_DIR + File.separator + "plugins");
                this.setProperty("temp", BLMain.CURRENT_DIR);
                this.setProperty("font.size", "12");
                this.setProperty("font.type", "Monospace");
                this.setProperty("shell.name", System.getProperty("os.name").startsWith("Windows 9") || System.getProperty("os.name").equals("Windows ME") ? "command.com" : (System.getProperty("os.name").startsWith("Windows") ? "cmd.exe" : "/bin/sh"));
                this.setProperty("shell.parameter", System.getProperty("os.name").startsWith("Windows") ? "/C" : "-c");
                this.setProperty("pwd.properties", "true");
                this.setProperty("user.properties", "true");
                this.setProperty("user.plugins", "true");
                this.setProperty("undo", "false");
                this.setProperty("undo.size", "5");
                this.setProperty("default.canvas", "Raw");
                this.setProperty("default.fileformat", "genbank");
                this.setProperty("default.sequencename", "New sequence");
            }
        });
        this.reset();
        this.loadPropertiesFile(BLMain.PROGRAM_DIR + File.separator + ".blproperties");
        if (!"false".equalsIgnoreCase(this.getProperty("user.properties")) && System.getProperty("user.home") != null) {
            this.loadPropertiesFile(System.getProperty("user.home") + File.separator + ".blproperties");
        }
        if (!"false".equalsIgnoreCase(this.getProperty("pwd.properties"))) {
            this.loadPropertiesFile("." + File.separator + ".blproperties");
        }
    }

    public Object setProperty(String key, String value) {
        Object result = null;
        if (key != null && value != null) {
            key = key.toLowerCase();
            result = super.setProperty(key, value);
            LinkedList<PropertiesListener> listenerList = this.propertiesListeners.get(key.toLowerCase());
            if (listenerList != null && !listenerList.isEmpty()) {
                for (PropertiesListener listener : listenerList) {
                    listener.propertiesUpdate(key, value);
                }
            }
        }
        return result;
    }

    public String getProperty(String key) {
        String result = super.getProperty(key = key.toLowerCase());
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void addPropertiesListener(String key, PropertiesListener listener) {
        if (!this.propertiesListeners.containsKey(key = key.toLowerCase())) {
            this.propertiesListeners.put(key, new LinkedList());
        }
        this.propertiesListeners.get(key).add(listener);
    }

    private void reset() {
        super.clear();
        this.setProperty("GDE.menu", "true");
        this.setProperty("GDE.help.viewer", "$BIRCH/script/gde_help_viewer.csh");
        this.setProperty("GDE.help.path", System.getenv("GDE_HELP_DIR") != null ? System.getenv("GDE_HELP_DIR") : "");
        this.setProperty("GDE.colour.1.red", "255");
        this.setProperty("GDE.colour.1.green", "0");
        this.setProperty("GDE.colour.1.blue", "0");
        this.setProperty("GDE.colour.2.red", "240");
        this.setProperty("GDE.colour.2.green", "180");
        this.setProperty("GDE.colour.2.blue", "20");
        this.setProperty("GDE.colour.3.red", "0");
        this.setProperty("GDE.colour.3.green", "0");
        this.setProperty("GDE.colour.3.blue", "255");
        this.setProperty("GDE.colour.4.red", "0");
        this.setProperty("GDE.colour.4.green", "0");
        this.setProperty("GDE.colour.4.blue", "0");
        this.setProperty("GDE.colour.5.red", "0");
        this.setProperty("GDE.colour.5.green", "200");
        this.setProperty("GDE.colour.5.blue", "0");
        this.setProperty("GDE.colour.6.red", "255");
        this.setProperty("GDE.colour.6.green", "0");
        this.setProperty("GDE.colour.6.blue", "160");
        this.setProperty("GDE.colour.7.red", "0");
        this.setProperty("GDE.colour.7.green", "160");
        this.setProperty("GDE.colour.7.blue", "200");
        this.setProperty("GDE.colour.8.red", "0");
        this.setProperty("GDE.colour.8.green", "127");
        this.setProperty("GDE.colour.8.blue", "255");
        this.setProperty("GDE.colour.9.red", "105");
        this.setProperty("GDE.colour.9.green", "139");
        this.setProperty("GDE.colour.9.blue", "30");
        this.setProperty("GDE.colour.10.red", "128");
        this.setProperty("GDE.colour.10.green", "0");
        this.setProperty("GDE.colour.10.blue", "255");
        this.setProperty("GDE.colour.11.red", "125");
        this.setProperty("GDE.colour.11.green", "158");
        this.setProperty("GDE.colour.11.blue", "192");
        this.setProperty("GDE.colour.12.red", "205");
        this.setProperty("GDE.colour.12.green", "205");
        this.setProperty("GDE.colour.12.blue", "0");
        this.setProperty("GDE.colour.13.red", "139");
        this.setProperty("GDE.colour.13.green", "10");
        this.setProperty("GDE.colour.13.blue", "80");
        this.setProperty("GDE.colour.14.red", "233");
        this.setProperty("GDE.colour.14.green", "116");
        this.setProperty("GDE.colour.14.blue", "81");
        this.setProperty("GDE.colour.15.red", "0");
        this.setProperty("GDE.colour.15.green", "180");
        this.setProperty("GDE.colour.15.blue", "127");
        this.setProperty("GDE.colour.16.red", "127");
        this.setProperty("GDE.colour.16.green", "230");
        this.setProperty("GDE.colour.16.blue", "0");
        this.setProperty("seqcolourdir", BLMain.PROGRAM_DIR + File.separator + "colourmasks");
    }

    private void loadPropertiesFile(String fileName) {
        if (new File(fileName).exists()) {
            try {
                this.load(new FileInputStream(fileName));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void showPropertiesWindow(JFrame window) {
        final JDialog propertiesWindow = new JDialog(window);
        Box outerPane = new Box(3);
        Box mainPane = new Box(3);
        JButton changeButton = new JButton(new AbstractAction("Close"){
            private static final long serialVersionUID = 7526472295622777011L;

            public void actionPerformed(ActionEvent e) {
                propertiesWindow.dispose();
            }
        });
        outerPane.add(mainPane);
        outerPane.add(changeButton);
        PropertiesNumber fontChangeBox = new PropertiesNumber(this, "Font size", "font.size", 10, 100);
        mainPane.add(fontChangeBox);
        for (PropertiesExtension ext : propertyExtensionList) {
            ext.propertiesComponent(mainPane);
        }
        propertiesWindow.add(outerPane);
        propertiesWindow.setLocationRelativeTo(window);
        propertiesWindow.pack();
        propertiesWindow.setVisible(true);
        propertiesWindow.setDefaultCloseOperation(2);
    }

    public void addExtension(PropertiesExtension extension) {
        if (extension != null) {
            propertyExtensionList.add(extension);
        }
    }
}

