/*
 * Decompiled with CFR 0.152.
 */
package ExpDesigner;

import ExpDesigner.Combo;
import ExpDesigner.ExpD_GUI;
import ExpDesigner.Experiment;
import ExpDesigner.Probe;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class LoopViewer
implements Serializable {
    private Vector probeVector;
    private Vector experimentVector;
    Ellipse2D.Double[] circ;
    static Point cPt;
    static Point[] cPtarray;
    static Point cPtSelf;
    static Point[] cPtarraySelf;
    static int probeBound;
    static int probeCount;

    public LoopViewer() {
        this(new Vector(), new Vector());
    }

    public LoopViewer(Vector probeVector, Vector experimentVector) {
        this.probeVector = probeVector;
        this.experimentVector = experimentVector;
        probeCount = this.getprobeCount();
        System.out.println("probeCount" + probeCount);
    }

    public int getprobeCount() {
        return this.probeVector.size();
    }

    public Point[] getcPtarray() {
        return cPtarray;
    }

    public Point[] getcPtarraySelf() {
        return cPtarraySelf;
    }

    public String getName(int index) {
        return ((Probe)this.probeVector.elementAt(index)).getProbeName();
    }

    public void drawCircle(Graphics2D gr) {
        int i = 0;
        while (i < probeCount) {
            Probe probe = (Probe)this.probeVector.elementAt(i);
            int x = probe.getPoint().x;
            int y = probe.getPoint().y;
            gr.setPaint(Color.black);
            gr.setFont(new Font("Arial", 1, 12));
            gr.drawOval(x - probeBound, y - probeBound, 20, 20);
            gr.setPaint(Color.white);
            gr.fillOval(x - probeBound, y - probeBound, 20, 20);
            gr.setPaint(Color.black);
            gr.drawString(((Probe)this.probeVector.elementAt(i)).getProbeName(), x - 5, y + 3);
            if (Combo.ptcounter == 1 && Combo.s_command.equals("ExpDesigner.ExpD_GUI") && i == Combo.first) {
                gr.setPaint(Color.yellow);
                gr.fillOval(ExpD_GUI.xfirst - probeBound, ExpD_GUI.yfirst - probeBound, 20, 20);
                gr.setPaint(Color.black);
                gr.drawString(((Probe)this.probeVector.elementAt(i)).getProbeName(), x - 3, y + 3);
            }
            ++i;
        }
    }

    public void drawImage(Graphics2D g) {
        probeCount = this.getprobeCount();
        cPtarray = new Point[probeCount];
        cPtarraySelf = new Point[probeCount];
        int topBorder = 20;
        int rightBorder = 20;
        int bottomBorder = 20;
        int leftBorder = 20;
        int arcArrow = 6;
        int drawableWidth = ExpD_GUI.size_width - 20 - 20;
        int drawableHeight = ExpD_GUI.size_height - 20 - 20;
        if (drawableWidth < drawableHeight) {
            drawableHeight = drawableWidth;
        }
        if (drawableHeight < drawableWidth) {
            drawableWidth = drawableHeight;
        }
        int radius = (int)((double)drawableWidth / 2.5);
        int radius2 = (int)((double)drawableWidth / 1.6);
        double degreeSpace = 360 / probeCount;
        double degreeSp = 360 / arcArrow;
        Point centerPoint = new Point(drawableWidth / 2 + 20, drawableHeight / 2 + 20);
        this.circ = new Ellipse2D.Double[probeCount];
        int i = 0;
        while (i < probeCount) {
            int x = centerPoint.x + (int)((double)radius * this.cos(90.0 - (double)i * degreeSpace));
            int y = centerPoint.y - (int)((double)radius * this.sin(90.0 - (double)i * degreeSpace));
            LoopViewer.cPtarray[i] = cPt = new Point(x, y);
            ((Probe)this.probeVector.elementAt(i)).setPoint(cPt);
            int x_self = centerPoint.x + (int)((double)radius2 * this.cos(90.0 - (double)i * degreeSpace));
            int y_self = centerPoint.y - (int)((double)radius2 * this.sin(90.0 - (double)i * degreeSpace));
            LoopViewer.cPtarraySelf[i] = cPtSelf = new Point(x_self, y_self);
            ++i;
        }
        this.drawCircle(g);
    }

    private double sin(double theta) {
        return Math.sin(theta / 180.0 * Math.PI);
    }

    private double cos(double theta) {
        return Math.cos(theta / 180.0 * Math.PI);
    }

    public void addProbe(Probe newProbe) {
        this.probeVector.add(newProbe);
    }

    public void addProbe(String str, int i) {
        this.probeVector.add(new Probe(str, i));
    }

    public void addExperiment(Experiment newExperiment) {
        this.experimentVector.add(newExperiment);
    }

    public Vector getProbeVector() {
        return this.probeVector;
    }

    public void setProbeVector(Vector probeVector) {
        this.probeVector = probeVector;
    }

    public Vector getExperimentVector() {
        return this.experimentVector;
    }

    public void setExperimentVector(Vector experimentVector) {
        this.experimentVector = experimentVector;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        System.out.println("in loopViewer serial 1.");
        out.defaultWriteObject();
        System.out.println("in loopViewer serial 2.");
        int i = 0;
        while (i < this.probeVector.size()) {
            out.writeObject(this.probeVector.elementAt(i));
            ++i;
        }
    }

    static {
        probeBound = 10;
    }
}

