/*
 * Decompiled with CFR 0.152.
 */
package ExpDesigner;

import ExpDesigner.FilePane;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.midas.engine.MaAnovaParameter;

public class MatrixDisplay
extends JPanel
implements Printable {
    private ME meventListener;
    private static int dimension;
    private static int[][] matrix;
    String[] names;
    private final int topBorder = 20;
    private final int rightBorder = 20;
    private final int bottomBorder = 20;
    private final int leftBorder = 20;
    private int drawableWidth;
    private int drawableHeight;
    private int cellWidth;
    private int cellHeight;
    boolean flag;
    static String[][] stored;
    public static String[] command;
    private String selectedFile;
    private String FolderStr;
    private FilePane filePane;

    public MatrixDisplay() {
        String[] empty = new String[]{};
        this.meventListener = new ME();
        this.addMouseListener(this.meventListener);
        this.initializeMatrixDisplay(0, 0, empty);
        this.selectedFile = "";
        this.FolderStr = "C:\\";
    }

    public int[][] getMatrix() {
        return matrix;
    }

    public MatrixDisplay(int count, int defaultValue, String[] names) {
        this.initializeMatrixDisplay(count, defaultValue, names);
    }

    public void initializeMatrixDisplay(int count, int defaultValue, String[] names) {
        this.initializeMatrix(count, defaultValue);
        this.setMatrixNames(names);
        this.setBackground(new Color(50, 100, 200));
        System.out.println("initialize mD");
    }

    public void initializeMatrix(int count, int defaultValue) {
        if (MaAnovaParameter.Matrix == null) {
            dimension = count;
            matrix = new int[count][count];
            int i = 0;
            while (i < count) {
                int j = 0;
                while (j < count) {
                    MatrixDisplay.matrix[i][j] = defaultValue;
                    ++j;
                }
                ++i;
            }
        } else if (count < MaAnovaParameter.Matrix.length) {
            dimension = count;
            matrix = new int[count][count];
            int i = 0;
            while (i < count) {
                int j = 0;
                while (j < count) {
                    MatrixDisplay.matrix[i][j] = defaultValue;
                    ++j;
                }
                ++i;
            }
        } else {
            matrix = MaAnovaParameter.Matrix;
            dimension = matrix.length;
        }
    }

    public void setCommand(String commd, String col, String ro) {
        MatrixDisplay.command[0] = commd;
        MatrixDisplay.command[1] = col;
        MatrixDisplay.command[2] = ro;
    }

    public String[] getCommand() {
        return command;
    }

    public void setMatrixNames(String[] names) {
        this.names = names;
    }

    public void cellHit(int column, int row) {
        if (column > 0 && row > 0) {
            this.matrixCellHit(column - 1, row - 1);
        }
    }

    public void matrixCellHit(int column, int row) {
        if (column >= dimension || row >= dimension) {
            return;
        }
        if (matrix[column][row] != 0) {
            MatrixDisplay.matrix[column][row] = 0;
            this.setCommand("200", this.names[column], this.names[row]);
        } else {
            System.out.println("folderstr : " + MaAnovaParameter.pFolderStr);
            if (MaAnovaParameter.pFolderStr == "Please specify a directory") {
                JOptionPane.showMessageDialog(null, "Select folder at first.");
                return;
            }
            if (this.filePane == null) {
                this.filePane = new FilePane();
                this.filePane.setModal(true);
                this.filePane.pack();
                this.filePane.setVisible(true);
                System.out.println("inside MD111");
                String fpath = this.filePane.getFilePath();
                System.out.println("fpath=" + fpath);
                if (fpath == null) {
                    return;
                }
                int lastslash = fpath.lastIndexOf(System.getProperty("file.separator"));
                System.out.println("separator=" + lastslash);
                int l = fpath.length();
                if (lastslash == -1) {
                    this.FolderStr = "";
                    this.selectedFile = fpath;
                } else {
                    this.selectedFile = fpath.substring(lastslash + 1, l);
                    this.FolderStr = fpath.substring(0, lastslash + 1);
                }
                System.out.println("MD file=" + this.selectedFile);
                System.out.println("MD folder=" + this.FolderStr);
                MatrixDisplay.matrix[column][row] = 1;
                this.setCommand("400", this.names[column], this.names[row]);
                boolean A = true;
            } else {
                this.filePane.setVisible(true);
                System.out.println("inside MD1");
                String fpath = this.filePane.getFilePath();
                int lastslash = fpath.lastIndexOf(System.getProperty("file.separator"));
                int l = fpath.length();
                if (lastslash == -1) {
                    this.FolderStr = "";
                    this.selectedFile = fpath;
                } else {
                    this.selectedFile = fpath.substring(lastslash + 1, l);
                    this.FolderStr = fpath.substring(0, lastslash + 1);
                }
                System.out.println("MD file=" + this.selectedFile);
                System.out.println("MD folder=" + this.FolderStr);
                MatrixDisplay.matrix[column][row] = 1;
                this.setCommand("400", this.names[column], this.names[row]);
                boolean A = true;
                System.out.println("inside MD1 else");
            }
        }
    }

    public static void matrixClear() {
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                MatrixDisplay.matrix[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public int print(Graphics g, PageFormat format, int pagenum) {
        if (pagenum > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(format.getImageableX(), format.getImageableY());
        if (format.getImageableWidth() / (double)this.getWidth() < format.getImageableHeight() / (double)this.getWidth()) {
            g2.scale(format.getImageableWidth() / (double)this.getWidth(), format.getImageableWidth() / (double)this.getWidth());
        } else {
            g2.scale(format.getImageableHeight() / (double)this.getHeight(), format.getImageableHeight() / (double)this.getHeight());
        }
        this.drawImage(g2);
        System.out.println("willPrint" + this.getWidth() + " " + this.getHeight());
        return 0;
    }

    public void drawImage(Graphics2D g) {
        this.drawableWidth = (int)this.getSize().getWidth() - 20 - 20;
        this.drawableHeight = (int)this.getSize().getHeight() - 20 - 20;
        if (this.drawableWidth < this.drawableHeight) {
            this.drawableHeight = this.drawableWidth;
        }
        if (this.drawableHeight < this.drawableWidth) {
            this.drawableWidth = this.drawableHeight;
        }
        this.cellWidth = this.drawableWidth / (dimension + 1);
        this.cellHeight = this.drawableHeight / (dimension + 1);
        int i = 1;
        while (i <= dimension) {
            g.setColor(Color.green);
            if (this.cellWidth > 16) {
                g.setFont(new Font("Helvetica", 1, 16));
            } else {
                g.setFont(new Font("Helvetica", 1, this.cellWidth));
            }
            g.drawString("C y 3", 20 + this.cellWidth, 15);
            g.drawRect(20 + i * this.cellWidth + 10, 20, this.cellWidth, this.cellHeight);
            g.fillRect(20 + i * this.cellWidth + 10, 20, this.cellWidth, this.cellHeight);
            g.setColor(Color.black);
            g.setFont(new Font("Helvetica", 1, this.cellWidth * 3 / 4));
            g.drawString(this.names[i - 1], 20 + i * this.cellWidth + this.cellWidth / 4 + 10, 20 + this.cellHeight);
            g.setColor(Color.red);
            if (this.cellWidth > 18) {
                g.setFont(new Font("Helvetica", 1, 16));
                g.drawString("C y 5", 20, 20 + this.cellHeight - this.cellHeight / 8);
            } else {
                g.setFont(new Font("Helvetica", 1, this.cellWidth));
                g.drawString("C", 20 - this.cellWidth / 2 - 5, 20 + 2 * this.cellHeight);
                g.drawString("y", 20 - this.cellWidth / 2 - 5, 20 + 2 * this.cellHeight + 15);
                g.drawString("5", 20 - this.cellWidth / 2 - 5, 20 + 2 * this.cellHeight + 35);
            }
            g.drawRect(30, 20 + i * this.cellHeight, this.cellWidth, this.cellHeight);
            g.fillRect(30, 20 + i * this.cellHeight, this.cellWidth, this.cellHeight);
            g.setColor(Color.black);
            g.setFont(new Font("Helvetica", 1, this.cellWidth * 3 / 4));
            g.drawString(this.names[i - 1], 20 + this.cellWidth / 4 + 10, 20 + i * this.cellHeight + this.cellHeight);
            ++i;
        }
        int i2 = 0;
        while (i2 < dimension) {
            int j = 0;
            while (j < dimension) {
                g.setColor(this.convertValueToColor(matrix[i2][j]));
                g.fillRect(20 + (i2 + 1) * this.cellWidth + 10, 20 + (j + 1) * this.cellWidth, this.cellWidth, this.cellHeight);
                g.setColor(Color.black);
                g.drawRect(20 + (i2 + 1) * this.cellWidth + 10, 20 + (j + 1) * this.cellWidth, this.cellWidth, this.cellHeight);
                ++j;
            }
            ++i2;
        }
    }

    public int getTargetRow(int y) {
        return (y - 20) / this.cellHeight;
    }

    public int getTargetColumn(int x) {
        return (x - 20 - 10) / this.cellWidth;
    }

    public Color convertValueToColor(int value) {
        Color color;
        switch (value) {
            case 0: {
                color = Color.white;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.red;
                break;
            }
            case 3: {
                color = Color.green;
                break;
            }
            case 4: {
                color = Color.yellow;
                break;
            }
            case 5: {
                color = Color.blue;
                break;
            }
            case 6: {
                color = Color.blue;
                break;
            }
            case 7: {
                color = Color.blue;
                break;
            }
            default: {
                color = Color.white;
            }
        }
        return color;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        this.drawImage(g);
    }

    public void processMouseClick(int x, int y) {
        int k = this.getTargetColumn(x);
        int w = this.getTargetRow(y);
        this.cellHit(k, w);
    }

    public String GetSelectedFile() {
        return this.selectedFile;
    }

    public void SetFolderString(String str) {
        this.FolderStr = str;
    }

    public String GetFolderString() {
        return this.FolderStr;
    }

    static {
        command = new String[3];
    }

    private class ME
    extends MouseAdapter {
        private ME() {
        }

        public void mousePressed(MouseEvent event) {
            MatrixDisplay.this.processMouseClick(event.getX(), event.getY());
        }
    }
}

