/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class ThresholdOpImage
extends PointOpImage {
    private double[] low;
    private double[] high;
    private double[] constants;
    private byte[][] byteTable = null;

    public ThresholdOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, tileCache, imageLayout, true);
        int n = this.getSampleModel().getNumBands();
        this.low = new double[n];
        this.high = new double[n];
        this.constants = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.low[n2] = dArray.length < n ? dArray[0] : dArray[n2];
            this.high[n2] = dArray2.length < n ? dArray2[0] : dArray2[n2];
            this.constants[n2] = dArray3.length < n ? dArray3[0] : dArray3[n2];
            ++n2;
        }
        this.permitInPlaceOperation();
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2) {
        int n8;
        int n9;
        int n10;
        if (this.byteTable == null) {
            n10 = this.getSampleModel().getNumBands();
            this.byteTable = new byte[n10][256];
            int n11 = 0;
            while (n11 < n10) {
                double d = this.low[n11];
                double d2 = this.high[n11];
                n9 = (int)this.constants[n11];
                byte[] byArray3 = this.byteTable[n11];
                n8 = 0;
                while (n8 < 256) {
                    byArray3[n8] = (double)n8 >= d && (double)n8 <= d2 ? n9 : (byte)n8;
                    ++n8;
                }
                ++n11;
            }
        }
        n10 = 0;
        while (n10 < n3) {
            byte[] byArray4 = byArray[n10];
            byte[] byArray5 = byArray2[n10];
            byte[] byArray6 = this.byteTable[n10];
            int n12 = nArray2[n10] + n2;
            int n13 = nArray2[n10];
            n9 = nArray[n10];
            while (n13 < n12) {
                int n14 = n13 + n;
                n8 = n13;
                int n15 = n9;
                while (n8 < n14) {
                    byArray5[n8] = byArray6[byArray4[n15] & 0xFF];
                    n8 += n6;
                    n15 += n4;
                }
                n13 += n7;
                n9 += n5;
            }
            ++n10;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.source0.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getFloatDataArrays(), n3, n4, nArray2, rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getDoubleDataArrays(), n3, n4, nArray2, rasterAccessor2.getDoubleDataArrays());
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            double d3 = this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    double d4 = dArray3[n14];
                    dArray4[n13] = d4 >= d && d4 <= d2 ? d3 : d4;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void floatLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            float f = (float)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    float f2 = fArray3[n14];
                    fArray4[n13] = (double)f2 >= d && (double)f2 <= d2 ? f : f2;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4) {
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            int n9 = (int)this.constants[n8];
            int n10 = nArray3[n8] + n2;
            int n11 = nArray3[n8];
            int n12 = nArray[n8];
            while (n11 < n10) {
                int n13 = n11 + n;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    int n16 = nArray5[n15];
                    nArray6[n14] = (double)n16 >= d && (double)n16 <= d2 ? n9 : n16;
                    n14 += n6;
                    n15 += n4;
                }
                n11 += n7;
                n12 += n5;
            }
            ++n8;
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            short s = (short)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    short s2 = sArray3[n14];
                    sArray4[n13] = (double)s2 >= d && (double)s2 <= d2 ? s : s2;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void ushortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            short s = (short)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    int n15 = sArray3[n14] & 0xFFFF;
                    sArray4[n13] = (double)n15 >= d && (double)n15 <= d2 ? s : (short)n15;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }
}

