/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.properties.PropertiesListener;
import org.biolegato.gdesupport.canvas.list.GDEList;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;
import org.biolegato.gdesupport.canvas.undo.Undoable;

public class GDECanvas
extends DataCanvas
implements CursorListener,
FocusListener,
ModeListener,
PropertiesListener {
    private boolean useNameList = false;
    private GDEList nameList = new GDEList(this);
    private GDETextArea dataCollector = null;
    private static final long serialVersionUID = 7526472295622776154L;
    private JScrollPane dataPane;
    private JScrollPane altDataPane;
    private Box canvasPane = new Box(2);
    private JSplitPane splitPane;
    private final GDECanvas canvasSelf = this;
    private final JLabel status = new JLabel("Row: 1 Col: 1");
    private final JLabel insertStatus = new JLabel("     ");
    private Stack<Undoable> undoStack = new Stack();
    private Stack<Undoable> redoStack = new Stack();
    private final AbstractAction splitAction = new AbstractAction("Split"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDETextArea altDataCollector = null;
            altDataCollector = "true".equalsIgnoreCase(BLMain.getProperty((String)"undo")) ? new UndoableGDETextArea(GDECanvas.this.canvasSelf) : new GDETextArea();
            GDECanvas.this.canvasPane.remove(GDECanvas.this.dataPane);
            GDECanvas.this.altDataPane = new JScrollPane(altDataCollector, 22, 32);
            GDECanvas.this.splitPane = new JSplitPane(1, GDECanvas.this.dataPane, GDECanvas.this.altDataPane);
            GDECanvas.this.splitPane.setAlignmentX(0.5f);
            GDECanvas.this.splitPane.setAlignmentY(0.5f);
            GDECanvas.this.canvasPane.add(GDECanvas.this.splitPane);
            GDECanvas.this.dataCollector.removePopupMenuItem(GDECanvas.this.splitMenuItem);
            GDECanvas.this.dataCollector.addPopupMenuItem(GDECanvas.this.joinMenuItem);
            altDataCollector.addPopupMenuItem(new JMenuItem(GDECanvas.this.joinAction));
        }
    };
    public final AbstractAction joinAction = new AbstractAction("Join"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            if (GDECanvas.this.splitPane != null) {
                GDECanvas.this.canvasPane.remove(GDECanvas.this.splitPane);
                GDECanvas.this.splitPane = null;
                GDECanvas.this.altDataPane = null;
                GDECanvas.this.canvasPane.add(GDECanvas.this.dataPane);
            }
            GDECanvas.this.dataCollector.removePopupMenuItem(GDECanvas.this.joinMenuItem);
            GDECanvas.this.dataCollector.addPopupMenuItem(GDECanvas.this.splitMenuItem);
        }
    };
    public final AbstractAction cutAction = new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.cut();
        }
    };
    public final AbstractAction copyAction = new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.copy();
        }
    };
    public final AbstractAction pasteAction = new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.paste();
        }
    };
    public final AbstractAction undoAction = new AbstractAction("Undo"){
        private static final long serialVersionUID = 7526472295622777038L;
        {
            this.putValue("MnemonicKey", new Integer(85));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.undo();
        }
    };
    public final AbstractAction redoAction = new AbstractAction("Redo"){
        private static final long serialVersionUID = 7526472295622777039L;
        {
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.redo();
        }
    };
    public final AbstractAction changeCaseAction = new AbstractAction("Change case"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.changeCase();
        }
    };
    public final AbstractAction selectAllAction = new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.selectAll();
        }
    };
    public final AbstractAction groupAction = new AbstractAction("Group"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            Sequence.group((Sequence[])GDECanvas.this.getData());
        }
    };
    public final AbstractAction ungroupAction = new AbstractAction("Ungroup"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            Sequence.ungroup((Sequence[])GDECanvas.this.getData());
        }
    };
    private final JMenuItem selectByNameMenuItem;
    private final JMenuItem splitMenuItem;
    private final JMenuItem joinMenuItem;
    private final JMenuItem cutMenuItem;
    private final JMenuItem copyMenuItem;
    private final JMenuItem pasteMenuItem;
    private final JMenuItem undoMenuItem;
    private final JMenuItem redoMenuItem;
    private final JMenuItem changeCaseMenuItem;
    private final JMenuItem selectGroupMenuItem;
    private final JMenuItem selectAllMenuItem;
    private final JMenuItem groupMenuItem;
    private final JMenuItem ungroupMenuItem;
    private final JMenuItem getInfoMenuItem;
    public final GDECanvas gdeCanvasSelf;

    public GDECanvas() {
        super(3);
        this.selectByNameMenuItem = new JMenuItem(this.nameList.selectByNameAction);
        this.splitMenuItem = new JMenuItem(this.splitAction);
        this.joinMenuItem = new JMenuItem(this.joinAction);
        this.cutMenuItem = new JMenuItem(this.cutAction);
        this.copyMenuItem = new JMenuItem(this.copyAction);
        this.pasteMenuItem = new JMenuItem(this.pasteAction);
        this.undoMenuItem = new JMenuItem(this.undoAction);
        this.redoMenuItem = new JMenuItem(this.redoAction);
        this.changeCaseMenuItem = new JMenuItem(this.changeCaseAction);
        this.selectGroupMenuItem = new JMenuItem(this.nameList.selectGroupAction);
        this.selectAllMenuItem = new JMenuItem(this.selectAllAction);
        this.groupMenuItem = new JMenuItem(this.groupAction);
        this.ungroupMenuItem = new JMenuItem(this.ungroupAction);
        this.getInfoMenuItem = new JMenuItem(this.nameList.getInfoAction);
        this.gdeCanvasSelf = this;
        this.dataCollector = "true".equalsIgnoreCase(BLMain.getProperty((String)"undo")) ? new UndoableGDETextArea(this) : new GDETextArea();
        this.dataCollector.addFocusListener(this);
        this.dataCollector.addCursorListener(this);
        this.dataCollector.addModeListener(this);
        this.nameList.addFocusListener(this);
        BLMain.addPropertiesListener((String)"font.size", (PropertiesListener)this);
        BLMain.addPropertiesListener((String)"font.bold", (PropertiesListener)this);
        this.dataCollector.addPopupMenuItem(this.splitMenuItem);
        this.nameList.addPopupMenuItem(new JMenuItem(this.groupAction));
        this.nameList.addPopupMenuItem(new JMenuItem(this.ungroupAction));
        this.dataPane = new JScrollPane(this.dataCollector, 22, 32);
        JScrollPane listPane = new JScrollPane(this.nameList, 21, 32);
        this.dataPane.setPreferredSize(new Dimension(200, 150));
        listPane.setPreferredSize(new Dimension(100, 150));
        this.dataPane.setVerticalScrollBar(listPane.getVerticalScrollBar());
        this.updateFont();
        this.canvasPane.add(this.dataPane);
        JSplitPane mainPane = new JSplitPane(1, listPane, this.canvasPane);
        mainPane.setAlignmentX(0.5f);
        mainPane.setAlignmentY(0.5f);
        Box statusBar = new Box(2);
        statusBar.setAlignmentX(0.0f);
        statusBar.add(this.status);
        statusBar.add(this.insertStatus);
        this.add(mainPane, "First");
        this.add(new JSeparator(0));
        this.add(statusBar, "Last");
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof JTabbedPane && ((JTabbedPane)source).getSelectedComponent() == this) {
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.cutMenuItem, 0);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.copyMenuItem, 1);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.pasteMenuItem, 2);
            if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
                BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.undoMenuItem, 3);
                BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.redoMenuItem, 4);
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectGroupMenuItem, 5);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectAllMenuItem, 6);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.groupMenuItem, 7);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.ungroupMenuItem, 8);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.getInfoMenuItem, 9);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.changeCaseMenuItem, 10);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectByNameMenuItem, 11);
        } else {
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.cutMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.copyMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.pasteMenuItem);
            if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
                BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.undoMenuItem);
                BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.redoMenuItem);
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.selectGroupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.selectAllMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.groupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.ungroupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.getInfoMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.changeCaseMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.selectByNameMenuItem);
        }
    }

    public Sequence[] getData() {
        LinkedList lines = new LinkedList();
        Sequence[] result = new Sequence[]{};
        result = this.useNameList ? this.nameList.getData() : this.dataCollector.getData();
        return result != null ? result : new Sequence[]{};
    }

    public String getTabName() {
        return "GDE";
    }

    public void focusGained(FocusEvent event) {
        if (event.getComponent() instanceof GDEList) {
            this.useNameList = true;
        } else if (event.getComponent() instanceof BLTextArea) {
            this.useNameList = false;
        }
    }

    public void focusLost(FocusEvent event) {
    }

    private void updateFont() {
        int fontsize = 12;
        String fontsizestr = BLMain.getProperty((String)"font.size");
        if (fontsizestr != null) {
            try {
                fontsize = Integer.parseInt(fontsizestr);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        Font currentFont = new Font("Lucida Sans Typewriter", 0, fontsize);
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"font.bold"))) {
            this.dataCollector.setFont(currentFont.deriveFont(1));
        } else {
            this.dataCollector.setFont(currentFont);
        }
        this.nameList.setFont(currentFont);
    }

    public void copy() {
        if (this.useNameList) {
            this.nameList.copy();
        } else {
            this.dataCollector.copy();
        }
    }

    public void cut() {
        if (this.useNameList) {
            this.nameList.cut();
        } else {
            this.dataCollector.cut();
        }
    }

    public void paste() {
        if (this.useNameList) {
            this.nameList.paste();
        } else {
            this.dataCollector.paste();
        }
    }

    public void selectAll() {
        this.nameList.selectAll();
        this.dataCollector.selectAll();
        this.nameList.requestFocus();
    }

    private void changeCase() {
        if (this.useNameList) {
            this.nameList.changeCase();
        } else {
            this.dataCollector.changeCase();
        }
    }

    public void cursorChange(BLTextArea source, int column, int row) {
        this.status.setText("Row: " + (row + 1) + " Col: " + (column + 1));
    }

    public void insertionMode(boolean mode) {
        if (mode) {
            this.insertStatus.setText("[INS]");
        } else {
            this.insertStatus.setText("     ");
        }
    }

    public void propertiesUpdate(String key, String value) {
        if (key.toLowerCase().startsWith("font.")) {
            this.updateFont();
        }
    }

    public boolean undo() {
        boolean result = !this.undoStack.empty();
        Undoable undone = null;
        if (result && (undone = this.undoStack.pop().undo()) != null) {
            this.redoStack.push(undone);
        }
        return result;
    }

    public boolean redo() {
        boolean result = !this.redoStack.empty();
        Undoable redone = null;
        if (result && (redone = this.redoStack.pop().undo()) != null) {
            this.undoStack.push(redone);
        }
        return result;
    }

    public void addUndo(Undoable undo) {
        int undomax = 0;
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            this.redoStack.clear();
            this.undoStack.push(undo);
            if (BLMain.getProperty((String)"undo.size") != null && BLMain.testNumber((char[])BLMain.getProperty((String)"undo.size").toCharArray())) {
                try {
                    undomax = Integer.parseInt(BLMain.getProperty((String)"undo.size"));
                    while (undomax > 0 && this.undoStack.size() > undomax) {
                        this.undoStack.remove(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

