/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmap;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public abstract class ColourMap {
    protected Color foreground = Color.BLACK;
    protected Color background = Color.WHITE;
    protected Color foregroundSelect = Color.WHITE;
    protected Color backgroundSelect = Color.BLUE;
    private String name = "";

    public abstract void regularDrawString(BLTextArea var1, Graphics var2, int var3, int var4, Sequence var5, int var6, int var7);

    public void selectDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, int pstart, int pend) {
        this.drawString(ta, gfx, xstart, ystart, this.safesubstring(seq, pstart, pend), this.foregroundSelect, this.backgroundSelect);
    }

    protected void drawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, String string, Color foreground, Color background) {
        int xstartMod = 0;
        char[] drawArray = string.toCharArray();
        gfx.setColor(background);
        gfx.fillRect(xstart, ystart, string.length() * ta.columnSize(), ta.rowSize());
        gfx.setFont(ta.getFont());
        gfx.setColor(foreground);
        for (int column = 0; column < drawArray.length; ++column) {
            xstartMod = (ta.columnSize() - ta.getFontMetrics(ta.getFont()).charWidth(drawArray[column])) / 2;
            gfx.drawChars(drawArray, column, 1, xstart + xstartMod, ystart + ta.rowSize() - 5);
            xstart += ta.columnSize();
        }
    }

    public String safesubstring(Sequence seq, int pstart, int pend) {
        String sequence = seq.get((Object)"sequence").toString();
        pstart = Math.max(0, Math.min(sequence.length(), pstart));
        pend = Math.max(0, Math.min(sequence.length(), pend));
        return sequence.substring(pstart, pend);
    }

    public Color getForeground() {
        return this.background;
    }

    public void setForeground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

