/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Atom;
import MCview.Bond;
import MCview.MCMatrix;
import MCview.PDBChain;
import MCview.PDBfile;
import MCview.Zsort;
import jalview.analysis.AlignSeq;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.FeatureRenderer;
import jalview.gui.SeqCanvas;
import jalview.gui.SequenceRenderer;
import jalview.io.AppletFormatAdapter;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class PDBCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
StructureListener {
    boolean redrawneeded = true;
    int omx = 0;
    int mx = 0;
    int omy = 0;
    int my = 0;
    public PDBfile pdb;
    PDBEntry pdbentry;
    int bsize;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float maxwidth;
    float scale;
    String inStr;
    String inType;
    boolean bysequence = true;
    boolean depthcue = true;
    boolean wire = false;
    boolean bymolecule = false;
    boolean zbuffer = true;
    boolean dragging;
    int xstart;
    int xend;
    int ystart;
    int yend;
    int xmid;
    int ymid;
    Font font = new Font("Helvetica", 0, 10);
    SeqCanvas seqcanvas;
    public SequenceI[] sequence;
    final StringBuffer mappingDetails = new StringBuffer();
    PDBChain mainchain;
    Vector highlightRes;
    boolean pdbAction = false;
    boolean seqColoursReady = false;
    FeatureRenderer fr;
    Color backgroundColour = Color.black;
    AlignmentPanel ap;
    StructureSelectionManager ssm;
    String errorMessage;
    Vector visiblebonds;
    Zsort zsort;
    int foundchain = -1;
    Bond highlightBond1;
    Bond highlightBond2;
    String lastMessage;
    StringBuffer resetLastRes = new StringBuffer();
    StringBuffer eval = new StringBuffer();

    void init(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap, String protocol) {
        this.ap = ap;
        this.pdbentry = pdbentry;
        this.sequence = seq;
        this.ssm = StructureSelectionManager.getStructureSelectionManager();
        try {
            this.pdb = this.ssm.setMapping(seq, chains, pdbentry.getFile(), protocol);
            if (protocol.equals(AppletFormatAdapter.PASTE)) {
                pdbentry.setFile("INLINE" + this.pdb.id);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (this.pdb == null) {
            this.errorMessage = "Error loading file: " + pdbentry.getId();
            return;
        }
        pdbentry.setId(this.pdb.id);
        this.ssm.addStructureViewerListener(this);
        this.colourBySequence();
        int max = -10;
        int maxchain = -1;
        int pdbstart = 0;
        int pdbend = 0;
        int seqstart = 0;
        int seqend = 0;
        SequenceI sequence = seq[0];
        for (int i = 0; i < this.pdb.chains.size(); ++i) {
            this.mappingDetails.append("\n\nPDB Sequence is :\nSequence = " + ((PDBChain)this.pdb.chains.elementAt((int)i)).sequence.getSequenceAsString());
            this.mappingDetails.append("\nNo of residues = " + ((PDBChain)this.pdb.chains.elementAt((int)i)).residues.size() + "\n\n");
            AlignSeq as = new AlignSeq(sequence, ((PDBChain)this.pdb.chains.elementAt((int)i)).sequence, "pep");
            as.calcScoreMatrix();
            as.traceAlignment();
            PrintStream ps = new PrintStream(System.out){

                public void print(String x) {
                    PDBCanvas.this.mappingDetails.append(x);
                }

                public void println() {
                    PDBCanvas.this.mappingDetails.append("\n");
                }
            };
            as.printAlignment(ps);
            if (as.maxscore > max) {
                max = as.maxscore;
                maxchain = i;
                pdbstart = as.seq2start;
                pdbend = as.seq2end;
                seqstart = as.seq1start + sequence.getStart() - 1;
                seqend = as.seq1end + sequence.getEnd() - 1;
            }
            this.mappingDetails.append("\nPDB start/end " + pdbstart + " " + pdbend);
            this.mappingDetails.append("\nSEQ start/end " + seqstart + " " + seqend);
        }
        this.mainchain = (PDBChain)this.pdb.chains.elementAt(maxchain);
        this.mainchain.pdbstart = pdbstart;
        this.mainchain.pdbend = pdbend;
        this.mainchain.seqstart = seqstart;
        this.mainchain.seqend = seqend;
        this.mainchain.isVisible = true;
        this.pdb = this.pdb;
        this.prefsize = new Dimension(this.getSize().width, this.getSize().height);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                this.keyPressed(evt);
            }
        });
        this.findCentre();
        this.findWidth();
        this.setupBonds();
        this.scale = this.findScale();
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    void setupBonds() {
        this.seqColoursReady = false;
        this.visiblebonds = new Vector();
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            if (!((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) continue;
            Vector tmp = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            for (int i = 0; i < tmp.size(); ++i) {
                this.visiblebonds.addElement(tmp.elementAt(i));
            }
        }
        this.updateSeqColours();
        this.seqColoursReady = true;
        this.redrawneeded = true;
        this.repaint();
    }

    public void findWidth() {
        float[] max = new float[3];
        float[] min = new float[3];
        max[0] = -1.0E30f;
        max[1] = -1.0E30f;
        max[2] = -1.0E30f;
        min[0] = 1.0E30f;
        min[1] = 1.0E30f;
        min[2] = 1.0E30f;
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            if (!((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) continue;
            Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            for (int i = 0; i < bonds.size(); ++i) {
                Bond tmp = (Bond)bonds.elementAt(i);
                if (tmp.start[0] >= max[0]) {
                    max[0] = tmp.start[0];
                }
                if (tmp.start[1] >= max[1]) {
                    max[1] = tmp.start[1];
                }
                if (tmp.start[2] >= max[2]) {
                    max[2] = tmp.start[2];
                }
                if (tmp.start[0] <= min[0]) {
                    min[0] = tmp.start[0];
                }
                if (tmp.start[1] <= min[1]) {
                    min[1] = tmp.start[1];
                }
                if (tmp.start[2] <= min[2]) {
                    min[2] = tmp.start[2];
                }
                if (tmp.end[0] >= max[0]) {
                    max[0] = tmp.end[0];
                }
                if (tmp.end[1] >= max[1]) {
                    max[1] = tmp.end[1];
                }
                if (tmp.end[2] >= max[2]) {
                    max[2] = tmp.end[2];
                }
                if (tmp.end[0] <= min[0]) {
                    min[0] = tmp.end[0];
                }
                if (tmp.end[1] <= min[1]) {
                    min[1] = tmp.end[1];
                }
                if (!(tmp.end[2] <= min[2])) continue;
                min[2] = tmp.end[2];
            }
        }
        this.width[0] = Math.abs(max[0] - min[0]);
        this.width[1] = Math.abs(max[1] - min[1]);
        this.width[2] = Math.abs(max[2] - min[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
    }

    public float findScale() {
        int height;
        int width;
        if (this.getWidth() != 0) {
            width = this.getWidth();
            height = this.getHeight();
        } else {
            width = this.prefsize.width;
            height = this.prefsize.height;
        }
        int dim = width < height ? width : height;
        return (float)((double)dim / (1.5 * (double)this.maxwidth));
    }

    public void findCentre() {
        float xtot = 0.0f;
        float ytot = 0.0f;
        float ztot = 0.0f;
        int bsize = 0;
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            if (!((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) continue;
            Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            bsize += bonds.size();
            for (int i = 0; i < bonds.size(); ++i) {
                xtot = xtot + ((Bond)bonds.elementAt((int)i)).start[0] + ((Bond)bonds.elementAt((int)i)).end[0];
                ytot = ytot + ((Bond)bonds.elementAt((int)i)).start[1] + ((Bond)bonds.elementAt((int)i)).end[1];
                ztot = ztot + ((Bond)bonds.elementAt((int)i)).start[2] + ((Bond)bonds.elementAt((int)i)).end[2];
            }
        }
        this.centre[0] = xtot / (2.0f * (float)bsize);
        this.centre[1] = ytot / (2.0f * (float)bsize);
        this.centre[2] = ztot / (2.0f * (float)bsize);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.seqColoursReady || this.errorMessage != null) {
            g.setColor(Color.black);
            g.setFont(new Font("Verdana", 1, 14));
            g.drawString(this.errorMessage == null ? "Retrieving PDB data...." : this.errorMessage, 20, this.getHeight() / 2);
            return;
        }
        if (this.img == null || this.prefsize.width != this.getWidth() || this.prefsize.height != this.getHeight()) {
            this.prefsize.width = this.getWidth();
            this.prefsize.height = this.getHeight();
            this.scale = this.findScale();
            this.img = this.createImage(this.prefsize.width, this.prefsize.height);
            this.ig = this.img.getGraphics();
            Graphics2D ig2 = (Graphics2D)this.ig;
            ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.redrawneeded = true;
        }
        if (this.redrawneeded) {
            this.drawAll(this.ig, this.prefsize.width, this.prefsize.height);
            this.redrawneeded = false;
        }
        g.drawImage(this.img, 0, 0, this);
        this.pdbAction = false;
    }

    public void drawAll(Graphics g, int width, int height) {
        g.setColor(this.backgroundColour);
        g.fillRect(0, 0, width, height);
        this.drawScene(g);
        this.drawLabels(g);
    }

    public void updateSeqColours() {
        if (this.pdbAction) {
            return;
        }
        this.colourBySequence();
        this.redrawneeded = true;
        this.repaint();
    }

    void colourBySequence() {
        SequenceRenderer sr = new SequenceRenderer(this.ap.av);
        StructureMapping[] mapping = this.ssm.getMapping(this.pdbentry.getFile());
        boolean showFeatures = false;
        if (this.ap.av.getShowSequenceFeatures()) {
            if (this.fr == null) {
                this.fr = new FeatureRenderer(this.ap);
            }
            this.fr.transferSettings(this.ap.alignFrame.getFeatureRenderer());
            showFeatures = true;
        }
        if (this.bysequence && this.pdb != null) {
            for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
                PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
                for (int i = 0; i < chain.bonds.size(); ++i) {
                    Bond tmp = (Bond)chain.bonds.elementAt(i);
                    tmp.startCol = Color.lightGray;
                    tmp.endCol = Color.lightGray;
                    if (chain != this.mainchain) continue;
                    for (int s = 0; s < this.sequence.length; ++s) {
                        for (int m = 0; m < mapping.length; ++m) {
                            if (mapping[m].getSequence() != this.sequence[s]) continue;
                            int pos = mapping[m].getSeqPos(tmp.at1.resNumber) - 1;
                            if (pos > 0) {
                                pos = this.sequence[s].findIndex(pos);
                                tmp.startCol = sr.getResidueBoxColour(this.sequence[s], pos);
                                if (showFeatures) {
                                    tmp.startCol = this.fr.findFeatureColour(tmp.startCol, this.sequence[s], pos);
                                }
                            }
                            if ((pos = mapping[m].getSeqPos(tmp.at2.resNumber) - 1) <= 0) continue;
                            pos = this.sequence[s].findIndex(pos);
                            tmp.endCol = sr.getResidueBoxColour(this.sequence[s], pos);
                            if (!showFeatures) continue;
                            tmp.endCol = this.fr.findFeatureColour(tmp.endCol, this.sequence[s], pos);
                        }
                    }
                }
            }
        }
    }

    public void drawScene(Graphics g) {
        if (this.zbuffer) {
            if (this.zsort == null) {
                this.zsort = new Zsort();
            }
            this.zsort.Zsort(this.visiblebonds);
        }
        Bond tmpBond = null;
        for (int i = 0; i < this.visiblebonds.size(); ++i) {
            tmpBond = (Bond)this.visiblebonds.elementAt(i);
            this.xstart = (int)((tmpBond.start[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2));
            this.ystart = (int)((this.centre[1] - tmpBond.start[1]) * this.scale + (float)(this.getHeight() / 2));
            this.xend = (int)((tmpBond.end[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2));
            this.yend = (int)((this.centre[1] - tmpBond.end[1]) * this.scale + (float)(this.getHeight() / 2));
            this.xmid = (this.xend + this.xstart) / 2;
            this.ymid = (this.yend + this.ystart) / 2;
            if (this.depthcue && !this.bymolecule) {
                if (tmpBond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    g.setColor(tmpBond.startCol.darker().darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol.darker().darker());
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                } else if (tmpBond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    g.setColor(tmpBond.startCol.darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol.darker());
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                } else {
                    g.setColor(tmpBond.startCol);
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol);
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                }
            } else if (this.depthcue && this.bymolecule) {
                if (tmpBond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    g.setColor(Color.green.darker().darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                } else if (tmpBond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    g.setColor(Color.green.darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                } else {
                    g.setColor(Color.green);
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                }
            } else if (!this.depthcue && !this.bymolecule) {
                g.setColor(tmpBond.startCol);
                this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                g.setColor(tmpBond.endCol);
                this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
            } else {
                this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
            }
            if (this.highlightBond1 != null && this.highlightBond1 == tmpBond) {
                g.setColor(tmpBond.endCol.brighter().brighter().brighter().brighter());
                this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
            }
            if (this.highlightBond2 == null || this.highlightBond2 != tmpBond) continue;
            g.setColor(tmpBond.startCol.brighter().brighter().brighter().brighter());
            this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
        }
    }

    public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (!this.wire) {
            if ((double)((float)Math.abs(y2 - y1) / (float)Math.abs(x2 - x1)) < 0.5) {
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
                g.drawLine(x1, y1 - 1, x2, y2 - 1);
            } else {
                g.setColor(g.getColor().brighter());
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x1 + 1, y1, x2 + 1, y2);
                g.drawLine(x1 - 1, y1, x2 - 1, y2);
            }
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 38) {
            this.scale = (float)((double)this.scale * 1.1);
            this.redrawneeded = true;
            this.repaint();
        } else if (evt.getKeyCode() == 40) {
            this.scale = (float)((double)this.scale * 0.9);
            this.redrawneeded = true;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pdbAction = true;
        Atom fatom = this.findAtom(e.getX(), e.getY());
        if (fatom != null) {
            PDBChain chain;
            fatom.isSelected = !fatom.isSelected;
            this.redrawneeded = true;
            this.repaint();
            if (this.foundchain != -1 && (chain = (PDBChain)this.pdb.chains.elementAt(this.foundchain)) == this.mainchain && fatom.alignmentMapping != -1) {
                if (this.highlightRes == null) {
                    this.highlightRes = new Vector();
                }
                if (this.highlightRes.contains(fatom.alignmentMapping + "")) {
                    this.highlightRes.remove(fatom.alignmentMapping + "");
                } else {
                    this.highlightRes.add(fatom.alignmentMapping + "");
                }
            }
        }
        this.mx = e.getX();
        this.my = e.getY();
        this.omx = this.mx;
        this.omy = this.my;
        this.dragging = false;
    }

    public void mouseMoved(MouseEvent e) {
        this.pdbAction = true;
        if (this.highlightBond1 != null) {
            this.highlightBond1.at2.isSelected = false;
            this.highlightBond2.at1.isSelected = false;
            this.highlightBond1 = null;
            this.highlightBond2 = null;
        }
        Atom fatom = this.findAtom(e.getX(), e.getY());
        PDBChain chain = null;
        if (this.foundchain != -1 && (chain = (PDBChain)this.pdb.chains.elementAt(this.foundchain)) == this.mainchain) {
            this.mouseOverStructure(fatom.resNumber, chain.id);
        }
        if (fatom != null) {
            this.setToolTipText(chain.id + ":" + fatom.resNumber + " " + fatom.resName);
        } else {
            this.mouseOverStructure(-1, chain != null ? chain.id : null);
            this.setToolTipText(null);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.mx = x;
        this.my = y;
        MCMatrix objmat = new MCMatrix(3, 3);
        objmat.setIdentity();
        if ((evt.getModifiers() & 4) != 0) {
            objmat.rotatez(this.mx - this.omx);
        } else {
            objmat.rotatex(this.my - this.omy);
            objmat.rotatey(this.omx - this.mx);
        }
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            for (int i = 0; i < bonds.size(); ++i) {
                Bond tmpBond = (Bond)bonds.elementAt(i);
                tmpBond.translate(-this.centre[0], -this.centre[1], -this.centre[2]);
                tmpBond.start = objmat.vectorMultiply(tmpBond.start);
                tmpBond.end = objmat.vectorMultiply(tmpBond.end);
                tmpBond.translate(this.centre[0], this.centre[1], this.centre[2]);
            }
        }
        objmat = null;
        this.omx = this.mx;
        this.omy = this.my;
        this.dragging = true;
        this.redrawneeded = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        this.dragging = false;
    }

    void drawLabels(Graphics g) {
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
            if (!chain.isVisible) continue;
            Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            for (int i = 0; i < bonds.size(); ++i) {
                Bond tmpBond = (Bond)bonds.elementAt(i);
                if (tmpBond.at1.isSelected) {
                    this.labelAtom(g, tmpBond, 1);
                }
                if (!tmpBond.at2.isSelected) continue;
                this.labelAtom(g, tmpBond, 2);
            }
        }
    }

    public void labelAtom(Graphics g, Bond b, int n) {
        int ystart;
        int xstart;
        g.setFont(this.font);
        g.setColor(Color.red);
        if (n == 1) {
            xstart = (int)((b.start[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2));
            ystart = (int)((this.centre[1] - b.start[1]) * this.scale + (float)(this.getHeight() / 2));
            g.drawString(b.at1.resName + "-" + b.at1.resNumber, xstart, ystart);
        }
        if (n == 2) {
            xstart = (int)((b.end[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2));
            ystart = (int)((this.centre[1] - b.end[1]) * this.scale + (float)(this.getHeight() / 2));
            g.drawString(b.at2.resName + "-" + b.at2.resNumber, xstart, ystart);
        }
    }

    public Atom findAtom(int x, int y) {
        Atom fatom = null;
        this.foundchain = -1;
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
            Bond tmpBond = null;
            if (chain.isVisible) {
                int truey;
                int truex;
                Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                for (int i = 0; i < bonds.size(); ++i) {
                    int truey2;
                    tmpBond = (Bond)bonds.elementAt(i);
                    truex = (int)((tmpBond.start[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2));
                    if (Math.abs(truex - x) > 2 || Math.abs((truey2 = (int)((this.centre[1] - tmpBond.start[1]) * this.scale + (float)(this.getHeight() / 2))) - y) > 2) continue;
                    fatom = tmpBond.at1;
                    this.foundchain = ii;
                    break;
                }
                if (Math.abs((truex = (int)((tmpBond.end[0] - this.centre[0]) * this.scale + (float)(this.getWidth() / 2))) - x) <= 2 && Math.abs((truey = (int)((tmpBond.end[1] - this.centre[1]) * this.scale + (float)(this.getHeight() / 2))) - y) <= 2) {
                    fatom = tmpBond.at2;
                    this.foundchain = ii;
                    break;
                }
            }
            if (fatom == null) continue;
            chain = (PDBChain)this.pdb.chains.elementAt(this.foundchain);
        }
        return fatom;
    }

    public void highlightRes(int ii) {
        if (!this.seqColoursReady) {
            return;
        }
        if (this.highlightRes != null && this.highlightRes.contains(ii - 1 + "")) {
            return;
        }
        int index = -1;
        for (index = 0; index < this.mainchain.bonds.size(); ++index) {
            Bond tmpBond = (Bond)this.mainchain.bonds.elementAt(index);
            if (tmpBond.at1.alignmentMapping != ii - 1) continue;
            if (this.highlightBond1 != null) {
                this.highlightBond1.at2.isSelected = false;
            }
            if (this.highlightBond2 != null) {
                this.highlightBond2.at1.isSelected = false;
            }
            this.highlightBond1 = null;
            this.highlightBond2 = null;
            if (index > 0) {
                this.highlightBond1 = (Bond)this.mainchain.bonds.elementAt(index - 1);
                this.highlightBond1.at2.isSelected = true;
            }
            if (index == this.mainchain.bonds.size()) break;
            this.highlightBond2 = (Bond)this.mainchain.bonds.elementAt(index);
            this.highlightBond2.at1.isSelected = true;
            break;
        }
        this.redrawneeded = true;
        this.repaint();
    }

    public void setAllchainsVisible(boolean b) {
        for (int ii = 0; ii < this.pdb.chains.size(); ++ii) {
            PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
            chain.isVisible = b;
        }
        this.mainchain.isVisible = true;
        this.findCentre();
        this.setupBonds();
    }

    public String getPdbFile() {
        return this.pdbentry.getFile();
    }

    public void mouseOverStructure(int pdbResNum, String chain) {
        if (this.lastMessage == null || !this.lastMessage.equals(pdbResNum + chain)) {
            this.ssm.mouseOverStructure(pdbResNum, chain, this.pdbentry.getFile());
        }
        this.lastMessage = pdbResNum + chain;
    }

    public void highlightAtom(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (!this.seqColoursReady) {
            return;
        }
        if (this.highlightRes != null && this.highlightRes.contains(atomIndex - 1 + "")) {
            return;
        }
        int index = -1;
        for (index = 0; index < this.mainchain.bonds.size(); ++index) {
            Bond tmpBond = (Bond)this.mainchain.bonds.elementAt(index);
            if (tmpBond.at1.atomIndex != atomIndex) continue;
            if (this.highlightBond1 != null) {
                this.highlightBond1.at2.isSelected = false;
            }
            if (this.highlightBond2 != null) {
                this.highlightBond2.at1.isSelected = false;
            }
            this.highlightBond1 = null;
            this.highlightBond2 = null;
            if (index > 0) {
                this.highlightBond1 = (Bond)this.mainchain.bonds.elementAt(index - 1);
                this.highlightBond1.at2.isSelected = true;
            }
            if (index == this.mainchain.bonds.size()) break;
            this.highlightBond2 = (Bond)this.mainchain.bonds.elementAt(index);
            this.highlightBond2.at1.isSelected = true;
            break;
        }
        this.redrawneeded = true;
        this.repaint();
    }

    public Color getColour(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        return Color.white;
    }

    public void updateColours(Object source) {
        this.colourBySequence();
        this.redrawneeded = true;
        this.repaint();
    }
}

