/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.FeatureProperties;
import jalview.datamodel.GraphLine;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import jalview.util.ShiftList;
import java.util.Hashtable;
import java.util.Vector;

public class Dna {
    private static int compare_codonpos(int[] cdp1, int[] cdp2) {
        if (cdp2 == null || cdp1[0] == cdp2[0] && cdp1[1] == cdp2[1] && cdp1[2] == cdp2[2]) {
            return 0;
        }
        if (cdp1[0] < cdp2[0] || cdp1[1] < cdp2[1] || cdp1[2] < cdp2[2]) {
            return -1;
        }
        return 1;
    }

    public static AlignmentI CdnaTranslate(SequenceI[] selection, String[] seqstring, int[] viscontigs, char gapCharacter, AlignmentAnnotation[] annotations, int aWidth, Alignment dataset) {
        return Dna.CdnaTranslate(selection, seqstring, null, viscontigs, gapCharacter, annotations, aWidth, dataset);
    }

    public static AlignmentI CdnaTranslate(SequenceI[] selection, String[] seqstring, DBRefEntry[] product, int[] viscontigs, char gapCharacter, AlignmentAnnotation[] annotations, int aWidth, Alignment dataset) {
        AlignedCodonFrame codons = new AlignedCodonFrame(aWidth);
        int sSize = selection.length;
        Vector<SequenceI> pepseqs = new Vector<SequenceI>();
        for (int s = 0; s < sSize; ++s) {
            SequenceI newseq = Dna.translateCodingRegion(selection[s], seqstring[s], viscontigs, codons, gapCharacter, product != null ? product[s] : null);
            if (newseq == null) continue;
            pepseqs.addElement(newseq);
            SequenceI ds = newseq;
            while (ds.getDatasetSequence() != null) {
                ds = ds.getDatasetSequence();
            }
            dataset.addSequence(ds);
        }
        if (codons.aaWidth == 0) {
            return null;
        }
        Object[] newseqs = new SequenceI[pepseqs.size()];
        pepseqs.copyInto(newseqs);
        Alignment al = new Alignment((SequenceI[])newseqs);
        al.padGaps();
        al.setDataset(dataset);
        Dna.translateAlignedAnnotations(annotations, al, codons);
        al.addCodonFrame(codons);
        return al;
    }

    public static boolean canTranslate(SequenceI[] selection, int[] viscontigs) {
        for (int gd = 0; gd < selection.length; ++gd) {
            int d;
            SequenceI dna = selection[gd];
            Object[] dnarefs = DBRefUtils.selectRefs(dna.getDBRef(), DBRefSource.DNACODINGDBS);
            if (dnarefs == null) continue;
            Vector<DBRefEntry> mappedrefs = new Vector<DBRefEntry>();
            DBRefEntry[] refs = dna.getDBRef();
            for (d = 0; d < refs.length; ++d) {
                if (refs[d].getMap() == null || refs[d].getMap().getMap() == null || refs[d].getMap().getMap().getFromRatio() != 3 || refs[d].getMap().getMap().getToRatio() != 1) continue;
                mappedrefs.addElement(refs[d]);
            }
            dnarefs = new DBRefEntry[mappedrefs.size()];
            mappedrefs.copyInto(dnarefs);
            for (d = 0; d < dnarefs.length; ++d) {
                Mapping mp = ((DBRefEntry)dnarefs[d]).getMap();
                if (mp == null) continue;
                for (int vc = 0; vc < viscontigs.length; vc += 2) {
                    int[] mpr = mp.locateMappedRange(viscontigs[vc], viscontigs[vc + 1]);
                    if (mpr == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static AlignmentI CdnaTranslate(SequenceI[] selection, int[] viscontigs, char gapCharacter, Alignment dataset) {
        int alwidth = 0;
        Vector<String> cdnasqs = new Vector<String>();
        Vector<SequenceI> cdnasqi = new Vector<SequenceI>();
        Vector<Mapping> cdnaprod = new Vector<Mapping>();
        int gd = 0;
        if (gd < selection.length) {
            SequenceI dna = selection[gd];
            Object[] dnarefs = DBRefUtils.selectRefs(dna.getDBRef(), DBRefSource.DNACODINGDBS);
            if (dnarefs != null) {
                int d;
                Vector<DBRefEntry> mappedrefs = new Vector<DBRefEntry>();
                DBRefEntry[] refs = dna.getDBRef();
                for (d = 0; d < refs.length; ++d) {
                    if (refs[d].getMap() == null || refs[d].getMap().getMap() == null || refs[d].getMap().getMap().getFromRatio() != 3 || refs[d].getMap().getMap().getToRatio() != 1) continue;
                    mappedrefs.addElement(refs[d]);
                }
                dnarefs = new DBRefEntry[mappedrefs.size()];
                mappedrefs.copyInto(dnarefs);
                for (d = 0; d < dnarefs.length; ++d) {
                    Mapping mp = ((DBRefEntry)dnarefs[d]).getMap();
                    StringBuffer sqstr = new StringBuffer();
                    if (mp == null) continue;
                    Mapping intersect = mp.intersectVisContigs(viscontigs);
                    if (sqstr.length() > alwidth) {
                        alwidth = sqstr.length();
                    }
                    cdnasqs.addElement(sqstr.toString());
                    cdnasqi.addElement(dna);
                    cdnaprod.addElement(intersect);
                }
            }
            Object[] cdna = new SequenceI[cdnasqs.size()];
            Object[] prods = new DBRefEntry[cdnaprod.size()];
            Object[] xons = new String[cdnasqs.size()];
            cdnasqs.copyInto(xons);
            cdnaprod.copyInto(prods);
            cdnasqi.copyInto(cdna);
            return Dna.CdnaTranslate((SequenceI[])cdna, (String[])xons, (DBRefEntry[])prods, viscontigs, gapCharacter, null, alwidth, dataset);
        }
        return null;
    }

    public static void translateAlignedAnnotations(AlignmentAnnotation[] annotations, AlignmentI al, AlignedCodonFrame codons) {
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                SequenceI aaSeq;
                Annotation[] anots;
                if (annotations[i].autoCalculated) continue;
                int aSize = codons.getaaWidth();
                Annotation[] annotationArray = anots = annotations[i].annotations == null ? null : new Annotation[aSize];
                if (anots != null) {
                    for (int a = 0; a < aSize; ++a) {
                        if (codons.codons[a] == null || codons.codons[a][0] != codons.codons[a][2] - 2) continue;
                        anots[a] = Dna.getCodonAnnotation(codons.codons[a], annotations[i].annotations);
                    }
                }
                AlignmentAnnotation aa = new AlignmentAnnotation(annotations[i].label, annotations[i].description, anots);
                aa.graph = annotations[i].graph;
                aa.graphGroup = annotations[i].graphGroup;
                aa.graphHeight = annotations[i].graphHeight;
                if (annotations[i].getThreshold() != null) {
                    aa.setThreshold(new GraphLine(annotations[i].getThreshold()));
                }
                if (annotations[i].hasScore) {
                    aa.setScore(annotations[i].getScore());
                }
                if (annotations[i].sequenceRef != null && (aaSeq = codons.getAaForDnaSeq(annotations[i].sequenceRef)) != null) {
                    aa.setSequenceRef(aaSeq);
                    aa.createSequenceMapping(aaSeq, aaSeq.getStart(), true);
                    aa.adjustForAlignment();
                    aaSeq.addAlignmentAnnotation(aa);
                }
                al.addAnnotation(aa);
            }
        }
    }

    private static Annotation getCodonAnnotation(int[] is, Annotation[] annotations) {
        for (int p = 0; p < 3; ++p) {
            if (annotations[is[p]] == null) continue;
            return new Annotation(annotations[is[p]]);
        }
        return null;
    }

    public static SequenceI translateCodingRegion(SequenceI selection, String seqstring, int[] viscontigs, AlignedCodonFrame codons, char gapCharacter, DBRefEntry product) {
        int vc;
        Vector<int[]> skip = new Vector<int[]>();
        int[] skipint = null;
        ShiftList vismapping = new ShiftList();
        int[] scontigs = new int[viscontigs.length];
        int npos = 0;
        for (vc = 0; vc < viscontigs.length; vc += 2) {
            if (vc == 0) {
                vismapping.addShift(npos, viscontigs[vc]);
            } else {
                vismapping.addShift(npos, viscontigs[vc] - viscontigs[vc - 1] + 1);
            }
            scontigs[vc] = viscontigs[vc];
            scontigs[vc + 1] = viscontigs[vc + 1];
        }
        StringBuffer protein = new StringBuffer();
        String seq = seqstring.replace('U', 'T');
        char[] codon = new char[3];
        int[] cdp = new int[3];
        int rf = 0;
        int lastnpos = 0;
        int aspos = 0;
        int resSize = 0;
        int nend = seq.length();
        for (npos = 0; npos < nend; ++npos) {
            if (!Comparison.isGap(seq.charAt(npos))) {
                cdp[rf] = npos;
                codon[rf++] = seq.charAt(npos);
            }
            if (rf != 3) continue;
            String aa = ResidueProperties.codonTranslate(new String(codon));
            rf = 0;
            if (aa == null) {
                aa = String.valueOf(gapCharacter);
                if (skipint == null) {
                    skipint = new int[]{cdp[0], cdp[2]};
                }
                skipint[1] = cdp[2];
            } else {
                if (skipint != null) {
                    skipint[0] = vismapping.shift((int)skipint[0]);
                    skipint[1] = vismapping.shift((int)skipint[1]);
                    for (vc = 0; vc < scontigs.length; vc += 2) {
                        if (scontigs[vc + 1] < skipint[0] || scontigs[vc] > skipint[0] || skipint[0] == scontigs[vc]) continue;
                        int[] t = new int[scontigs.length + 2];
                        System.arraycopy(scontigs, 0, t, 0, vc - 1);
                    }
                    skip.addElement(skipint);
                    skipint = null;
                }
                if (aa.equals("STOP")) {
                    aa = "X";
                }
                ++resSize;
            }
            boolean findpos = true;
            while (findpos) {
                codons.checkCodonFrameWidth(aspos);
                switch (Dna.compare_codonpos(cdp, codons.codons[aspos])) {
                    case -1: {
                        codons.insertAAGap(aspos, gapCharacter);
                        findpos = false;
                        break;
                    }
                    case 1: {
                        aa = "" + gapCharacter + aa;
                        ++aspos;
                        break;
                    }
                    case 0: {
                        findpos = false;
                    }
                }
            }
            protein.append(aa);
            lastnpos = npos;
            if (codons.codons[aspos] == null) {
                codons.codons[aspos] = new int[]{cdp[0], cdp[1], cdp[2]};
            }
            if (++aspos < codons.aaWidth) continue;
            codons.aaWidth = aspos + 1;
        }
        if (resSize > 0) {
            Sequence newseq = new Sequence(selection.getName(), protein.toString());
            if (rf != 0) {
                Cache.log.debug((Object)"trimming contigs for incomplete terminal codon.");
                vc = scontigs.length - 1;
                lastnpos = vismapping.shift(lastnpos);
                while (vc >= 0 && scontigs[vc] > lastnpos) {
                    if (vc > 0 && scontigs[vc - 1] > lastnpos) {
                        vc -= 2;
                        continue;
                    }
                    scontigs[vc] = lastnpos;
                }
                if (vc > 0 && vc + 1 < scontigs.length) {
                    int[] t = new int[vc + 1];
                    System.arraycopy(scontigs, 0, t, 0, vc + 1);
                    scontigs = t;
                }
                if (vc <= 0) {
                    scontigs = null;
                }
            }
            if (scontigs != null) {
                npos = 0;
                for (vc = 0; vc < scontigs.length; vc += 2) {
                    scontigs[vc] = selection.findPosition(scontigs[vc]);
                    scontigs[vc + 1] = selection.findPosition(scontigs[vc + 1]);
                    if (scontigs[vc + 1] == selection.getEnd()) break;
                }
                if (vc + 2 < scontigs.length) {
                    int[] t = new int[vc + 2];
                    System.arraycopy(scontigs, 0, t, 0, vc + 2);
                    scontigs = t;
                }
                MapList map = new MapList(scontigs, new int[]{1, resSize}, 3, 1);
                if (product != null) {
                    newseq.setName(product.getSource() + "|" + product.getAccessionId());
                    if (product.getMap() != null) {
                        // empty if block
                    }
                }
                Dna.transferCodedFeatures(selection, newseq, map, null, null);
                SequenceI rseq = newseq.deriveSequence();
                codons.addMap(selection, rseq, map);
                return rseq;
            }
        }
        return null;
    }

    private static void transferCodedFeatures(SequenceI dna, SequenceI pep, MapList map, Hashtable featureTypes, Hashtable featureGroups) {
        SequenceFeature[] sf = dna.getDatasetSequence().getSequenceFeatures();
        DBRefEntry[] dnarefs = DBRefUtils.selectRefs(dna.getDBRef(), DBRefSource.DNACODINGDBS);
        if (dnarefs != null) {
            for (int d = 0; d < dnarefs.length; ++d) {
                Mapping mp = dnarefs[d].getMap();
                if (mp == null) continue;
            }
        }
        if (sf != null) {
            for (int f = 0; f < sf.length; ++f) {
                Boolean fgstate;
                Boolean bl = fgstate = featureGroups == null ? null : (Boolean)featureGroups.get(sf[f].featureGroup);
                if (!(featureTypes != null && !featureTypes.containsKey(sf[f].getType()) || fgstate != null && fgstate == false) && !FeatureProperties.isCodingFeature(null, sf[f].getType())) continue;
            }
        }
    }
}

