/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.NJTree;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FontChooser;
import jalview.appletgui.TreeCanvas;
import jalview.bin.JalviewLite;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceI;
import jalview.io.NewickFile;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TreePanel
extends EmbmenuFrame
implements ActionListener,
ItemListener {
    SequenceI[] seq;
    String type;
    String pwtype;
    int start;
    int end;
    TreeCanvas treeCanvas;
    NJTree tree;
    AlignViewport av;
    BorderLayout borderLayout1 = new BorderLayout();
    protected ScrollPane scrollPane = new ScrollPane();
    MenuBar jMenuBar1 = new MenuBar();
    Menu jMenu2 = new Menu();
    protected MenuItem fontSize = new MenuItem();
    protected CheckboxMenuItem bootstrapMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem distanceMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem placeholdersMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem fitToWindow = new CheckboxMenuItem();
    Menu fileMenu = new Menu();
    MenuItem newickOutput = new MenuItem();
    MenuItem inputData = new MenuItem();

    public NJTree getTree() {
        return this.tree;
    }

    public TreePanel(AlignViewport av, String type, String pwtype) {
        try {
            this.jbInit();
            this.setMenuBar(this.jMenuBar1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initTreePanel(av, type, pwtype, null);
    }

    public TreePanel(AlignViewport av, String type, String pwtype, NewickFile newtree) {
        try {
            this.jbInit();
            this.setMenuBar(this.jMenuBar1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initTreePanel(av, type, pwtype, newtree);
    }

    void initTreePanel(AlignViewport av, String type, String pwtype, NewickFile newTree) {
        this.av = av;
        this.type = type;
        this.pwtype = pwtype;
        this.treeCanvas = new TreeCanvas(av, this.scrollPane);
        TreeLoader tl = new TreeLoader(newTree);
        tl.start();
        this.embedMenuIfNeeded(this.treeCanvas);
        this.scrollPane.add((Component)this.treeCanvas, "Center");
    }

    void showOriginalData() {
        if (this.tree.seqData != null) {
            char gc = '-';
            try {
                gc = this.av.getGapCharacter();
            }
            catch (Exception ex) {
                // empty catch block
            }
            Object[] alAndColsel = this.tree.seqData.getAlignmentAndColumnSelection(gc);
            if (alAndColsel != null && alAndColsel[0] != null) {
                Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
                AlignFrame af = new AlignFrame(al, this.av.applet, "Original Data for Tree", false);
                af.viewport.setHiddenColumns((ColumnSelection)alAndColsel[1]);
            }
        } else {
            System.out.println("Original Tree Data not available");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.newickOutput) {
            this.newickOutput_actionPerformed();
        } else if (evt.getSource() == this.fontSize) {
            this.fontSize_actionPerformed();
        } else if (evt.getSource() == this.inputData) {
            this.showOriginalData();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.fitToWindow) {
            this.treeCanvas.fitToWindow = this.fitToWindow.getState();
        } else if (evt.getSource() == this.distanceMenu) {
            this.treeCanvas.setShowDistances(this.distanceMenu.getState());
        } else if (evt.getSource() == this.bootstrapMenu) {
            this.treeCanvas.setShowBootstrap(this.bootstrapMenu.getState());
        } else if (evt.getSource() == this.placeholdersMenu) {
            this.treeCanvas.setMarkPlaceholders(this.placeholdersMenu.getState());
        }
        this.treeCanvas.repaint();
    }

    public void newickOutput_actionPerformed() {
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        String output = fout.print(false, true);
        CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
        cap.setText(output);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, this.type + " " + this.pwtype, 500, 100);
    }

    public Font getTreeFont() {
        return this.treeCanvas.font;
    }

    public void setTreeFont(Font font) {
        this.treeCanvas.font = font;
        this.treeCanvas.repaint();
    }

    protected void fontSize_actionPerformed() {
        if (this.treeCanvas == null) {
            return;
        }
        new FontChooser(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBackground(Color.white);
        this.setFont(new Font("Verdana", 0, 12));
        this.jMenu2.setLabel("View");
        this.fontSize.setLabel("Font...");
        this.fontSize.addActionListener(this);
        this.bootstrapMenu.setLabel("Show Bootstrap Values");
        this.bootstrapMenu.addItemListener(this);
        this.distanceMenu.setLabel("Show Distances");
        this.distanceMenu.addItemListener(this);
        this.placeholdersMenu.setLabel("Mark Unassociated Leaves");
        this.placeholdersMenu.addItemListener(this);
        this.fitToWindow.setState(true);
        this.fitToWindow.setLabel("Fit To Window");
        this.fitToWindow.addItemListener(this);
        this.fileMenu.setLabel("File");
        this.newickOutput.setLabel("Newick Format");
        this.newickOutput.addActionListener(this);
        this.inputData.setLabel("Input Data...");
        this.add((Component)this.scrollPane, "Center");
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu2.add(this.fitToWindow);
        this.jMenu2.add(this.fontSize);
        this.jMenu2.add(this.distanceMenu);
        this.jMenu2.add(this.bootstrapMenu);
        this.jMenu2.add(this.placeholdersMenu);
        this.fileMenu.add(this.newickOutput);
        this.fileMenu.add(this.inputData);
        this.inputData.addActionListener(this);
    }

    class TreeLoader
    extends Thread {
        NewickFile newtree;
        AlignmentView odata = null;

        public TreeLoader(NewickFile newtree) {
            this.newtree = newtree;
        }

        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = this.odata == null ? new NJTree(TreePanel.this.av.alignment.getSequencesArray(), this.newtree) : new NJTree(TreePanel.this.av.alignment.getSequencesArray(), this.odata, this.newtree);
            } else {
                SequenceI[] seqs;
                int end;
                int start;
                AlignmentView seqStrings = TreePanel.this.av.getAlignmentView(TreePanel.this.av.getSelectionGroup() != null);
                if (TreePanel.this.av.getSelectionGroup() == null) {
                    start = 0;
                    end = TreePanel.this.av.alignment.getWidth();
                    seqs = TreePanel.this.av.alignment.getSequencesArray();
                } else {
                    start = TreePanel.this.av.getSelectionGroup().getStartRes();
                    end = TreePanel.this.av.getSelectionGroup().getEndRes() + 1;
                    seqs = TreePanel.this.av.getSelectionGroup().getSequencesInOrder(TreePanel.this.av.alignment);
                }
                TreePanel.this.tree = new NJTree(seqs, seqStrings, TreePanel.this.type, TreePanel.this.pwtype, start, end);
            }
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.treeCanvas.setTree(TreePanel.this.tree);
            if (this.newtree != null) {
                TreePanel.this.distanceMenu.setState(this.newtree.HasDistances());
                TreePanel.this.bootstrapMenu.setState(this.newtree.HasBootstrap());
                TreePanel.this.treeCanvas.setShowBootstrap(this.newtree.HasBootstrap());
                TreePanel.this.treeCanvas.setShowDistances(this.newtree.HasDistances());
            }
            TreePanel.this.treeCanvas.repaint();
            TreePanel.this.av.setCurrentTree(TreePanel.this.tree);
        }
    }
}

