/*
 * Decompiled with CFR 0.152.
 */
package jalview.binding;

import jalview.binding.Annotation;
import jalview.binding.Sequence;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class SequenceSet
implements Serializable {
    private String _gapChar;
    private boolean _aligned;
    private boolean _has_aligned;
    private Vector _sequenceList = new Vector();
    private Vector _annotationList = new Vector();

    public void addAnnotation(Annotation vAnnotation) throws IndexOutOfBoundsException {
        this._annotationList.addElement(vAnnotation);
    }

    public void addAnnotation(int index, Annotation vAnnotation) throws IndexOutOfBoundsException {
        this._annotationList.add(index, vAnnotation);
    }

    public void addSequence(Sequence vSequence) throws IndexOutOfBoundsException {
        this._sequenceList.addElement(vSequence);
    }

    public void addSequence(int index, Sequence vSequence) throws IndexOutOfBoundsException {
        this._sequenceList.add(index, vSequence);
    }

    public void deleteAligned() {
        this._has_aligned = false;
    }

    public Enumeration enumerateAnnotation() {
        return this._annotationList.elements();
    }

    public Enumeration enumerateSequence() {
        return this._sequenceList.elements();
    }

    public boolean getAligned() {
        return this._aligned;
    }

    public Annotation getAnnotation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._annotationList.size()) {
            throw new IndexOutOfBoundsException("getAnnotation: Index value '" + index + "' not in range [0.." + (this._annotationList.size() - 1) + "]");
        }
        return (Annotation)this._annotationList.get(index);
    }

    public Annotation[] getAnnotation() {
        Annotation[] array = new Annotation[]{};
        return this._annotationList.toArray(array);
    }

    public int getAnnotationCount() {
        return this._annotationList.size();
    }

    public String getGapChar() {
        return this._gapChar;
    }

    public Sequence getSequence(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._sequenceList.size()) {
            throw new IndexOutOfBoundsException("getSequence: Index value '" + index + "' not in range [0.." + (this._sequenceList.size() - 1) + "]");
        }
        return (Sequence)this._sequenceList.get(index);
    }

    public Sequence[] getSequence() {
        Sequence[] array = new Sequence[]{};
        return this._sequenceList.toArray(array);
    }

    public int getSequenceCount() {
        return this._sequenceList.size();
    }

    public boolean hasAligned() {
        return this._has_aligned;
    }

    public boolean isAligned() {
        return this._aligned;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllAnnotation() {
        this._annotationList.clear();
    }

    public void removeAllSequence() {
        this._sequenceList.clear();
    }

    public boolean removeAnnotation(Annotation vAnnotation) {
        boolean removed = this._annotationList.remove(vAnnotation);
        return removed;
    }

    public Annotation removeAnnotationAt(int index) {
        Object obj = this._annotationList.remove(index);
        return (Annotation)obj;
    }

    public boolean removeSequence(Sequence vSequence) {
        boolean removed = this._sequenceList.remove(vSequence);
        return removed;
    }

    public Sequence removeSequenceAt(int index) {
        Object obj = this._sequenceList.remove(index);
        return (Sequence)obj;
    }

    public void setAligned(boolean aligned) {
        this._aligned = aligned;
        this._has_aligned = true;
    }

    public void setAnnotation(int index, Annotation vAnnotation) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._annotationList.size()) {
            throw new IndexOutOfBoundsException("setAnnotation: Index value '" + index + "' not in range [0.." + (this._annotationList.size() - 1) + "]");
        }
        this._annotationList.set(index, vAnnotation);
    }

    public void setAnnotation(Annotation[] vAnnotationArray) {
        this._annotationList.clear();
        for (int i = 0; i < vAnnotationArray.length; ++i) {
            this._annotationList.add(vAnnotationArray[i]);
        }
    }

    public void setGapChar(String gapChar) {
        this._gapChar = gapChar;
    }

    public void setSequence(int index, Sequence vSequence) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._sequenceList.size()) {
            throw new IndexOutOfBoundsException("setSequence: Index value '" + index + "' not in range [0.." + (this._sequenceList.size() - 1) + "]");
        }
        this._sequenceList.set(index, vSequence);
    }

    public void setSequence(Sequence[] vSequenceArray) {
        this._sequenceList.clear();
        for (int i = 0; i < vSequenceArray.length; ++i) {
            this._sequenceList.add(vSequenceArray[i]);
        }
    }

    public static SequenceSet unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SequenceSet)Unmarshaller.unmarshal((Class)SequenceSet.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

