/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import ext.vamsas.ServiceHandle;
import jalview.analysis.AAFrequency;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.Conservation;
import jalview.analysis.CrossRef;
import jalview.analysis.Dna;
import jalview.analysis.NJTree;
import jalview.analysis.ParseProperties;
import jalview.bin.Cache;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.commands.RemoveGapColCommand;
import jalview.commands.RemoveGapsCommand;
import jalview.commands.SlideSequencesCommand;
import jalview.commands.TrimRegionCommand;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationColourChooser;
import jalview.gui.AnnotationExporter;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.FeatureSettings;
import jalview.gui.Finder;
import jalview.gui.FontChooser;
import jalview.gui.IProgressIndicator;
import jalview.gui.Jalview2XML;
import jalview.gui.OOMWarning;
import jalview.gui.OverviewPanel;
import jalview.gui.PCAPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.PrintThread;
import jalview.gui.RedundancyPanel;
import jalview.gui.SequenceFetcher;
import jalview.gui.SliderPanel;
import jalview.gui.TextColourChooser;
import jalview.gui.TreePanel;
import jalview.gui.UserDefinedColours;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.FeaturesFile;
import jalview.io.FileLoader;
import jalview.io.FormatAdapter;
import jalview.io.HTMLOutput;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.JnetAnnotationMaker;
import jalview.io.NewickFile;
import jalview.jbgui.GAlignFrame;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.UserColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.ws.DBRefFetcher;
import jalview.ws.Discoverer;
import jalview.ws.WSClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AlignFrame
extends GAlignFrame
implements DropTargetListener,
IProgressIndicator {
    public static final int DEFAULT_WIDTH = 700;
    public static final int DEFAULT_HEIGHT = 500;
    public AlignmentPanel alignPanel;
    AlignViewport viewport;
    Vector alignPanels = new Vector();
    String currentFileFormat = null;
    String fileName = null;
    Hashtable progressBars;
    public FeatureSettings featureSettings;
    protected int _annotationScoreVectorHash;
    static /* synthetic */ Class class$jalview$gui$Desktop;

    public AlignFrame(AlignmentI al, int width, int height) {
        this(al, null, width, height);
    }

    public AlignFrame(AlignmentI al, ColumnSelection hiddenColumns, int width, int height) {
        this.setSize(width, height);
        this.viewport = new AlignViewport(al, hiddenColumns);
        this.alignPanel = new AlignmentPanel(this, this.viewport);
        if (al.getDataset() == null) {
            al.setDataset(null);
        }
        this.addAlignmentPanel(this.alignPanel, true);
        this.init();
    }

    public AlignFrame(AlignmentPanel ap) {
        this.viewport = ap.av;
        this.alignPanel = ap;
        this.addAlignmentPanel(ap, false);
        this.init();
    }

    void init() {
        String sortby;
        if (this.viewport.conservation == null) {
            this.BLOSUM62Colour.setEnabled(false);
            this.conservationMenuItem.setEnabled(false);
            this.modifyConservation.setEnabled(false);
        }
        if ((sortby = Cache.getDefault("SORT_ALIGNMENT", "No sort")).equals("Id")) {
            this.sortIDMenuItem_actionPerformed(null);
        } else if (sortby.equals("Pairwise Identity")) {
            this.sortPairwiseMenuItem_actionPerformed(null);
        }
        if (Desktop.desktop != null) {
            this.setDropTarget(new DropTarget(this, this));
            this.addServiceListeners();
            this.setGUINucleotide(this.viewport.alignment.isNucleotide());
        }
        this.setMenusFromViewport(this.viewport);
        this.buildSortByAnnotationScoresMenu();
        if (this.viewport.wrapAlignment) {
            this.wrapMenuItem_actionPerformed(null);
        }
        if (Cache.getDefault("SHOW_OVERVIEW", false)) {
            this.overviewMenuItem_actionPerformed(null);
        }
        this.addKeyListener();
    }

    public void setFileName(String file, String format) {
        this.fileName = file;
        this.currentFileFormat = format;
        this.reload.setEnabled(true);
    }

    void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (AlignFrame.this.viewport.cursorMode && (evt.getKeyCode() >= 48 && evt.getKeyCode() <= 57 || evt.getKeyCode() >= 96 && evt.getKeyCode() <= 105) && Character.isDigit(evt.getKeyChar())) {
                    AlignFrame.this.alignPanel.seqPanel.numberPressed(evt.getKeyChar());
                }
                switch (evt.getKeyCode()) {
                    case 27: {
                        AlignFrame.this.deselectAllSequenceMenuItem_actionPerformed(null);
                        break;
                    }
                    case 40: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.moveSelectedSequences(false);
                        }
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.moveCursor(0, 1);
                        break;
                    }
                    case 38: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.moveSelectedSequences(true);
                        }
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.moveCursor(0, -1);
                        break;
                    }
                    case 37: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.slideSequences(false, AlignFrame.this.alignPanel.seqPanel.getKeyboardNo1());
                            break;
                        }
                        AlignFrame.this.alignPanel.seqPanel.moveCursor(-1, 0);
                        break;
                    }
                    case 39: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.slideSequences(true, AlignFrame.this.alignPanel.seqPanel.getKeyboardNo1());
                            break;
                        }
                        AlignFrame.this.alignPanel.seqPanel.moveCursor(1, 0);
                        break;
                    }
                    case 32: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.insertGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                        break;
                    }
                    case 8: 
                    case 127: {
                        if (!AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.cut_actionPerformed(null);
                            break;
                        }
                        AlignFrame.this.alignPanel.seqPanel.deleteGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                        break;
                    }
                    case 83: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.setCursorRow();
                        break;
                    }
                    case 67: {
                        if (!AlignFrame.this.viewport.cursorMode || evt.isControlDown()) break;
                        AlignFrame.this.alignPanel.seqPanel.setCursorColumn();
                        break;
                    }
                    case 80: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.setCursorPosition();
                        break;
                    }
                    case 10: 
                    case 44: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.setCursorRowAndColumn();
                        break;
                    }
                    case 81: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.setSelectionAreaAtCursor(true);
                        break;
                    }
                    case 77: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.seqPanel.setSelectionAreaAtCursor(false);
                        break;
                    }
                    case 113: {
                        AlignFrame.this.viewport.cursorMode = !AlignFrame.this.viewport.cursorMode;
                        AlignFrame.this.statusBar.setText("Keyboard editing mode is " + (AlignFrame.this.viewport.cursorMode ? "on" : "off"));
                        if (AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.alignPanel.seqPanel.seqCanvas.cursorX = AlignFrame.this.viewport.startRes;
                            AlignFrame.this.alignPanel.seqPanel.seqCanvas.cursorY = AlignFrame.this.viewport.startSeq;
                        }
                        AlignFrame.this.alignPanel.seqPanel.seqCanvas.repaint();
                        break;
                    }
                    case 112: {
                        try {
                            ClassLoader cl = (class$jalview$gui$Desktop == null ? (class$jalview$gui$Desktop = AlignFrame.class$("jalview.gui.Desktop")) : class$jalview$gui$Desktop).getClassLoader();
                            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)"help/help");
                            HelpSet hs = new HelpSet(cl, url);
                            HelpBroker hb = hs.createHelpBroker();
                            hb.setCurrentID("home");
                            hb.setDisplayed(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 72: {
                        boolean toggleSeqs = !evt.isControlDown();
                        boolean toggleCols = !evt.isShiftDown();
                        boolean hide = false;
                        SequenceGroup sg = AlignFrame.this.viewport.getSelectionGroup();
                        if (toggleSeqs) {
                            if (sg != null && sg.getSize() != AlignFrame.this.viewport.alignment.getHeight()) {
                                AlignFrame.this.hideSelSequences_actionPerformed(null);
                                hide = true;
                            } else if (!toggleCols || AlignFrame.this.viewport.colSel.getSelected().size() <= 0) {
                                AlignFrame.this.showAllSeqs_actionPerformed(null);
                            }
                        }
                        if (!toggleCols) break;
                        if (AlignFrame.this.viewport.colSel.getSelected().size() > 0) {
                            AlignFrame.this.hideSelColumns_actionPerformed(null);
                            if (toggleSeqs) break;
                            AlignFrame.this.viewport.selectionGroup = sg;
                            break;
                        }
                        if (hide) break;
                        AlignFrame.this.showAllColumns_actionPerformed(null);
                        break;
                    }
                    case 33: {
                        if (AlignFrame.this.viewport.wrapAlignment) {
                            AlignFrame.this.alignPanel.scrollUp(true);
                            break;
                        }
                        AlignFrame.this.alignPanel.setScrollValues(AlignFrame.this.viewport.startRes, AlignFrame.this.viewport.startSeq - AlignFrame.this.viewport.endSeq + AlignFrame.this.viewport.startSeq);
                        break;
                    }
                    case 34: {
                        if (AlignFrame.this.viewport.wrapAlignment) {
                            AlignFrame.this.alignPanel.scrollUp(false);
                            break;
                        }
                        AlignFrame.this.alignPanel.setScrollValues(AlignFrame.this.viewport.startRes, AlignFrame.this.viewport.startSeq + AlignFrame.this.viewport.endSeq - AlignFrame.this.viewport.startSeq);
                    }
                }
            }

            public void keyReleased(KeyEvent evt) {
                switch (evt.getKeyCode()) {
                    case 37: {
                        if (!evt.isAltDown() && AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.viewport.firePropertyChange("alignment", null, AlignFrame.this.viewport.getAlignment().getSequences());
                        break;
                    }
                    case 39: {
                        if (!evt.isAltDown() && AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.viewport.firePropertyChange("alignment", null, AlignFrame.this.viewport.getAlignment().getSequences());
                    }
                }
            }
        });
    }

    public void addAlignmentPanel(AlignmentPanel ap, boolean newPanel) {
        ap.alignFrame = this;
        this.alignPanels.addElement(ap);
        PaintRefresher.Register(ap, ap.av.getSequenceSetId());
        int aSize = this.alignPanels.size();
        this.tabbedPane.setVisible(aSize > 1 || ap.av.viewName != null);
        if (aSize == 1 && ap.av.viewName == null) {
            this.getContentPane().add((Component)ap, "Center");
        } else {
            if (aSize == 2) {
                this.setInitialTabVisible();
            }
            this.expandViews.setEnabled(true);
            this.gatherViews.setEnabled(true);
            this.tabbedPane.addTab(ap.av.viewName, ap);
            ap.setVisible(false);
        }
        if (newPanel) {
            if (ap.av.padGaps) {
                ap.av.alignment.padGaps();
            }
            ap.av.updateConservation(ap);
            ap.av.updateConsensus(ap);
        }
    }

    public void setInitialTabVisible() {
        this.expandViews.setEnabled(true);
        this.gatherViews.setEnabled(true);
        this.tabbedPane.setVisible(true);
        AlignmentPanel first = (AlignmentPanel)this.alignPanels.firstElement();
        this.tabbedPane.addTab(first.av.viewName, first);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    public AlignViewport getViewport() {
        return this.viewport;
    }

    private void addServiceListeners() {
        this.BuildWebServiceMenu();
        final PropertyChangeListener thisListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("services")) {
                    AlignFrame.this.BuildWebServiceMenu();
                }
            }
        };
        Desktop.discoverer.addPropertyChangeListener(thisListener);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent evt) {
                Desktop.discoverer.removePropertyChangeListener(thisListener);
                AlignFrame.this.closeMenuItem_actionPerformed(true);
            }
        });
    }

    public void setGUINucleotide(boolean nucleotide) {
        this.showTranslation.setVisible(nucleotide);
        this.conservationMenuItem.setEnabled(!nucleotide);
        this.modifyConservation.setEnabled(!nucleotide);
        if (!nucleotide) {
            this.calculateMenu.remove(this.calculateMenu.getItemCount() - 2);
        }
    }

    public void setMenusForViewport() {
        this.setMenusFromViewport(this.viewport);
    }

    void setMenusFromViewport(AlignViewport av) {
        this.padGapsMenuitem.setSelected(av.padGaps);
        this.colourTextMenuItem.setSelected(av.showColourText);
        this.abovePIDThreshold.setSelected(av.getAbovePIDThreshold());
        this.conservationMenuItem.setSelected(av.getConservationSelected());
        this.seqLimits.setSelected(av.getShowJVSuffix());
        this.idRightAlign.setSelected(av.rightAlignIds);
        this.centreColumnLabelsMenuItem.setState(av.centreColumnLabels);
        this.renderGapsMenuItem.setSelected(av.renderGaps);
        this.wrapMenuItem.setSelected(av.wrapAlignment);
        this.scaleAbove.setVisible(av.wrapAlignment);
        this.scaleLeft.setVisible(av.wrapAlignment);
        this.scaleRight.setVisible(av.wrapAlignment);
        this.annotationPanelMenuItem.setState(av.showAnnotation);
        this.viewBoxesMenuItem.setSelected(av.showBoxes);
        this.viewTextMenuItem.setSelected(av.showText);
        this.setColourSelected(ColourSchemeProperty.getColourName(av.getGlobalColourScheme()));
        this.showSeqFeatures.setSelected(av.showSequenceFeatures);
        this.hiddenMarkers.setState(av.showHiddenMarkers);
        this.applyToAllGroups.setState(av.colourAppliesToAllGroups);
        this.setShowProductsEnabled();
        this.updateEditMenuBar();
    }

    public void setProgressBar(String message, long id) {
        if (this.progressBars == null) {
            this.progressBars = new Hashtable();
        }
        GridLayout layout = (GridLayout)this.statusPanel.getLayout();
        if (this.progressBars.get(new Long(id)) != null) {
            JPanel progressPanel = (JPanel)this.progressBars.get(new Long(id));
            this.statusPanel.remove(progressPanel);
            this.progressBars.remove(progressPanel);
            progressPanel = null;
            if (message != null) {
                this.statusBar.setText(message);
            }
            layout.setRows(layout.getRows() - 1);
        } else {
            JPanel progressPanel = new JPanel(new BorderLayout(10, 5));
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            progressPanel.add((Component)new JLabel(message), "West");
            progressPanel.add((Component)progressBar, "Center");
            layout.setRows(layout.getRows() + 1);
            this.statusPanel.add(progressPanel);
            this.progressBars.put(new Long(id), progressPanel);
        }
        this.setMenusForViewport();
        this.validate();
    }

    public boolean operationInProgress() {
        return this.progressBars != null && this.progressBars.size() > 0;
    }

    public String getVersion() {
        return Cache.getProperty("VERSION");
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer();
    }

    public void fetchSequence_actionPerformed(ActionEvent e) {
        new SequenceFetcher(this);
    }

    public void addFromFile_actionPerformed(ActionEvent e) {
        Desktop.instance.inputLocalFileMenuItem_actionPerformed(this.viewport);
    }

    public void reload_actionPerformed(ActionEvent e) {
        if (this.fileName != null) {
            if (this.currentFileFormat.equals("Jalview")) {
                JInternalFrame[] frames = Desktop.desktop.getAllFrames();
                for (int i = 0; i < frames.length; ++i) {
                    if (!(frames[i] instanceof AlignFrame) || frames[i] == this || !((AlignFrame)frames[i]).fileName.equals(this.fileName)) continue;
                    try {
                        frames[i].setSelected(true);
                        Desktop.instance.closeAssociatedWindows();
                        continue;
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                }
                Desktop.instance.closeAssociatedWindows();
                FileLoader loader = new FileLoader();
                String protocol = this.fileName.startsWith("http:") ? "URL" : "File";
                loader.LoadFile(this.viewport, this.fileName, protocol, this.currentFileFormat);
            } else {
                Rectangle bounds = this.getBounds();
                FileLoader loader = new FileLoader();
                String protocol = this.fileName.startsWith("http:") ? "URL" : "File";
                AlignFrame newframe = loader.LoadFileWaitTillLoaded(this.fileName, protocol, this.currentFileFormat);
                newframe.setBounds(bounds);
                this.closeMenuItem_actionPerformed(true);
            }
        }
    }

    public void addFromText_actionPerformed(ActionEvent e) {
        Desktop.instance.inputTextboxMenuItem_actionPerformed(this.viewport);
    }

    public void addFromURL_actionPerformed(ActionEvent e) {
        Desktop.instance.inputURLMenuItem_actionPerformed(this.viewport);
    }

    public void save_actionPerformed(ActionEvent e) {
        if (this.fileName == null || this.currentFileFormat == null || !FormatAdapter.isValidIOFormat(this.currentFileFormat, true) || this.fileName.startsWith("http")) {
            this.saveAs_actionPerformed(null);
        } else {
            this.saveAlignment(this.fileName, this.currentFileFormat);
        }
    }

    public void saveAs_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), AppletFormatAdapter.WRITABLE_EXTENSIONS, AppletFormatAdapter.WRITABLE_FNAMES, this.currentFileFormat, false);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save Alignment to file");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            this.currentFileFormat = chooser.getSelectedFormat();
            if (this.currentFileFormat == null) {
                JOptionPane.showInternalMessageDialog(Desktop.desktop, "You must select a file format before saving!", "File format not specified", 2);
                value = chooser.showSaveDialog(this);
                return;
            }
            this.fileName = chooser.getSelectedFile().getPath();
            Cache.setProperty("DEFAULT_FILE_FORMAT", this.currentFileFormat);
            Cache.setProperty("LAST_DIRECTORY", this.fileName);
            if (this.currentFileFormat.indexOf(" ") > -1) {
                this.currentFileFormat = this.currentFileFormat.substring(0, this.currentFileFormat.indexOf(" "));
            }
            this.saveAlignment(this.fileName, this.currentFileFormat);
        }
    }

    public boolean saveAlignment(String file, String format) {
        boolean success = true;
        if (format.equalsIgnoreCase("Jalview")) {
            String shortName = this.title;
            if (shortName.indexOf(File.separatorChar) > -1) {
                shortName = shortName.substring(shortName.lastIndexOf(File.separatorChar) + 1);
            }
            success = new Jalview2XML().SaveAlignment(this, file, shortName);
            this.statusBar.setText("Successfully saved to file: " + this.fileName + " in " + format + " format.");
        } else {
            FormatAdapter f;
            String output;
            int reply;
            if (!AppletFormatAdapter.isValidFormat(format, true)) {
                JOptionPane.showInternalMessageDialog(this, "Cannot save file " + this.fileName + " using format " + format, "Alignment output format not supported", 2);
                this.saveAs_actionPerformed(null);
                return false;
            }
            String[] omitHidden = null;
            if (this.viewport.hasHiddenColumns && (reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "The Alignment contains hidden columns.\nDo you want to save only the visible alignment?", "Save / Omit Hidden Columns", 0, 3)) == 0) {
                omitHidden = this.viewport.getViewAsString(false);
            }
            if ((output = (f = new FormatAdapter()).formatSequences(format, (AlignmentI)((Alignment)this.viewport.alignment), omitHidden, f.getCacheSuffixDefault(format), this.viewport.colSel)) == null) {
                success = false;
            } else {
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    out.print(output);
                    out.close();
                    this.setTitle(file);
                    this.statusBar.setText("Successfully saved to file: " + this.fileName + " in " + format + " format.");
                }
                catch (Exception ex) {
                    success = false;
                    ex.printStackTrace();
                }
            }
        }
        if (!success) {
            JOptionPane.showInternalMessageDialog(this, "Couldn't save file: " + this.fileName, "Error Saving File", 2);
        }
        return success;
    }

    protected void outputText_actionPerformed(ActionEvent e) {
        int reply;
        String[] omitHidden = null;
        if (this.viewport.hasHiddenColumns && (reply = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "The Alignment contains hidden columns.\nDo you want to output only the visible alignment?", "Save / Omit Hidden Columns", 0, 3)) == 0) {
            omitHidden = this.viewport.getViewAsString(false);
        }
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(null);
        Desktop.addInternalFrame(cap, "Alignment output - " + e.getActionCommand(), 600, 500);
        cap.setText(new FormatAdapter().formatSequences(e.getActionCommand(), this.viewport.alignment, omitHidden, this.viewport.colSel));
    }

    protected void htmlMenuItem_actionPerformed(ActionEvent e) {
        new HTMLOutput(this.alignPanel, this.alignPanel.seqPanel.seqCanvas.getSequenceRenderer(), this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer());
    }

    public void createImageMap(File file, String image) {
        this.alignPanel.makePNGImageMap(file, image);
    }

    public void createPNG(File f) {
        this.alignPanel.makePNG(f);
    }

    public void createEPS(File f) {
        this.alignPanel.makeEPS(f);
    }

    public void pageSetup_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintThread.pf = printJob.pageDialog(printJob.defaultPage());
    }

    public void printMenuItem_actionPerformed(ActionEvent e) {
        PrintThread thread = new PrintThread(this.alignPanel);
        thread.start();
    }

    public void exportFeatures_actionPerformed(ActionEvent e) {
        new AnnotationExporter().exportFeatures(this.alignPanel);
    }

    public void exportAnnotations_actionPerformed(ActionEvent e) {
        new AnnotationExporter().exportAnnotations(this.alignPanel, this.viewport.showAnnotation ? this.viewport.alignment.getAlignmentAnnotation() : null, this.viewport.alignment.getGroups(), ((Alignment)this.viewport.alignment).alignmentProperties);
    }

    public void associatedData_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Load Jalview Annotations or Features File");
        chooser.setToolTipText("Load Jalview Annotations / Features file");
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", choice);
            this.loadJalviewDataFile(choice);
        }
    }

    public void closeMenuItem_actionPerformed(boolean closeAllTabs) {
        if (this.alignPanels != null && this.alignPanels.size() < 2) {
            closeAllTabs = true;
        }
        try {
            if (this.alignPanels != null) {
                if (closeAllTabs) {
                    for (int i = 0; i < this.alignPanels.size(); ++i) {
                        AlignmentPanel ap = (AlignmentPanel)this.alignPanels.elementAt(i);
                        StructureSelectionManager.getStructureSelectionManager().removeStructureViewerListener(ap.seqPanel, null);
                        PaintRefresher.RemoveComponent(ap.seqPanel.seqCanvas);
                        PaintRefresher.RemoveComponent(ap.idPanel.idCanvas);
                        PaintRefresher.RemoveComponent(ap);
                        ap.av.alignment = null;
                    }
                } else {
                    int index = this.tabbedPane.getSelectedIndex();
                    this.alignPanels.removeElement(this.alignPanel);
                    PaintRefresher.RemoveComponent(this.alignPanel.seqPanel.seqCanvas);
                    PaintRefresher.RemoveComponent(this.alignPanel.idPanel.idCanvas);
                    PaintRefresher.RemoveComponent(this.alignPanel);
                    this.viewport.alignment = null;
                    this.alignPanel = null;
                    this.viewport = null;
                    this.tabbedPane.removeTabAt(index);
                    this.tabbedPane.validate();
                    if (index == this.tabbedPane.getTabCount()) {
                        --index;
                    }
                    this.tabSelectionChanged(index);
                }
            }
            if (closeAllTabs) {
                this.setClosed(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void updateEditMenuBar() {
        CommandI command;
        if (this.viewport.historyList.size() > 0) {
            this.undoMenuItem.setEnabled(true);
            command = (CommandI)this.viewport.historyList.peek();
            this.undoMenuItem.setText("Undo " + command.getDescription());
        } else {
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setText("Undo");
        }
        if (this.viewport.redoList.size() > 0) {
            this.redoMenuItem.setEnabled(true);
            command = (CommandI)this.viewport.redoList.peek();
            this.redoMenuItem.setText("Redo " + command.getDescription());
        } else {
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setText("Redo");
        }
    }

    public void addHistoryItem(CommandI command) {
        if (command.getSize() > 0) {
            this.viewport.historyList.push(command);
            this.viewport.redoList.clear();
            this.updateEditMenuBar();
            this.viewport.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
        }
    }

    AlignmentI[] getViewAlignments() {
        if (this.alignPanels != null) {
            Enumeration e = this.alignPanels.elements();
            AlignmentI[] als = new AlignmentI[this.alignPanels.size()];
            int i = 0;
            while (e.hasMoreElements()) {
                als[i] = ((AlignmentPanel)e.nextElement()).av.getAlignment();
                ++i;
            }
            return als;
        }
        if (this.viewport != null) {
            return new AlignmentI[]{this.viewport.alignment};
        }
        return null;
    }

    protected void undoMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.historyList.empty()) {
            return;
        }
        CommandI command = (CommandI)this.viewport.historyList.pop();
        this.viewport.redoList.push(command);
        command.undoCommand(this.getViewAlignments());
        AlignViewport originalSource = this.getOriginatingSource(command);
        this.updateEditMenuBar();
        if (originalSource != null) {
            originalSource.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
            originalSource.firePropertyChange("alignment", null, originalSource.alignment.getSequences());
        }
    }

    protected void redoMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.redoList.size() < 1) {
            return;
        }
        CommandI command = (CommandI)this.viewport.redoList.pop();
        this.viewport.historyList.push(command);
        command.doCommand(this.getViewAlignments());
        AlignViewport originalSource = this.getOriginatingSource(command);
        this.updateEditMenuBar();
        if (originalSource != null) {
            originalSource.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
            originalSource.firePropertyChange("alignment", null, originalSource.alignment.getSequences());
        }
    }

    AlignViewport getOriginatingSource(CommandI command) {
        AlignViewport originalSource = null;
        AlignmentI al = null;
        if (command instanceof EditCommand) {
            EditCommand editCommand = (EditCommand)command;
            al = editCommand.getAlignment();
            Vector comps = (Vector)PaintRefresher.components.get(this.viewport.getSequenceSetId());
            for (int i = 0; i < comps.size(); ++i) {
                if (!(comps.elementAt(i) instanceof AlignmentPanel) || al != ((AlignmentPanel)comps.elementAt((int)i)).av.alignment) continue;
                originalSource = ((AlignmentPanel)comps.elementAt((int)i)).av;
                break;
            }
        }
        if (originalSource == null) {
            if (al != null) {
                PaintRefresher.validateSequences(al, this.viewport.alignment);
            }
            originalSource = this.viewport;
        }
        return originalSource;
    }

    public void moveSelectedSequences(boolean up) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        if (up) {
            for (int i = 1; i < this.viewport.alignment.getHeight(); ++i) {
                SequenceI seq = this.viewport.alignment.getSequenceAt(i);
                if (!sg.getSequences(null).contains(seq)) continue;
                SequenceI temp = this.viewport.alignment.getSequenceAt(i - 1);
                if (sg.getSequences(null).contains(temp)) continue;
                this.viewport.alignment.getSequences().setElementAt(temp, i);
                this.viewport.alignment.getSequences().setElementAt(seq, i - 1);
            }
        } else {
            for (int i = this.viewport.alignment.getHeight() - 2; i > -1; --i) {
                SequenceI seq = this.viewport.alignment.getSequenceAt(i);
                if (!sg.getSequences(null).contains(seq)) continue;
                SequenceI temp = this.viewport.alignment.getSequenceAt(i + 1);
                if (sg.getSequences(null).contains(temp)) continue;
                this.viewport.alignment.getSequences().setElementAt(temp, i);
                this.viewport.alignment.getSequences().setElementAt(seq, i + 1);
            }
        }
        this.alignPanel.paintAlignment(true);
    }

    synchronized void slideSequences(boolean right, int size) {
        Vector sg = new Vector();
        if (this.viewport.cursorMode) {
            sg.addElement(this.viewport.alignment.getSequenceAt(this.alignPanel.seqPanel.seqCanvas.cursorY));
        } else if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() != this.viewport.alignment.getHeight()) {
            sg = this.viewport.getSelectionGroup().getSequences(this.viewport.hiddenRepSequences);
        }
        if (sg.size() < 1) {
            return;
        }
        Vector<SequenceI> invertGroup = new Vector<SequenceI>();
        for (int i = 0; i < this.viewport.alignment.getHeight(); ++i) {
            if (sg.contains(this.viewport.alignment.getSequenceAt(i))) continue;
            invertGroup.add(this.viewport.alignment.getSequenceAt(i));
        }
        SequenceI[] seqs1 = new SequenceI[sg.size()];
        for (int i = 0; i < sg.size(); ++i) {
            seqs1[i] = (SequenceI)sg.elementAt(i);
        }
        SequenceI[] seqs2 = new SequenceI[invertGroup.size()];
        for (int i = 0; i < invertGroup.size(); ++i) {
            seqs2[i] = (SequenceI)invertGroup.elementAt(i);
        }
        SlideSequencesCommand ssc = right ? new SlideSequencesCommand("Slide Sequences", seqs2, seqs1, size, this.viewport.getGapCharacter()) : new SlideSequencesCommand("Slide Sequences", seqs1, seqs2, size, this.viewport.getGapCharacter());
        int groupAdjustment = 0;
        if (ssc.getGapsInsertedBegin() && right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(size, 0);
            } else {
                groupAdjustment = size;
            }
        } else if (!ssc.getGapsInsertedBegin() && !right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(-size, 0);
            } else {
                groupAdjustment = -size;
            }
        }
        if (groupAdjustment != 0) {
            this.viewport.getSelectionGroup().setStartRes(this.viewport.getSelectionGroup().getStartRes() + groupAdjustment);
            this.viewport.getSelectionGroup().setEndRes(this.viewport.getSelectionGroup().getEndRes() + groupAdjustment);
        }
        boolean appendHistoryItem = false;
        if (this.viewport.historyList != null && this.viewport.historyList.size() > 0 && this.viewport.historyList.peek() instanceof SlideSequencesCommand) {
            appendHistoryItem = ssc.appendSlideCommand((SlideSequencesCommand)this.viewport.historyList.peek());
        }
        if (!appendHistoryItem) {
            this.addHistoryItem(ssc);
        }
        this.repaint();
    }

    protected void copy_actionPerformed(ActionEvent e) {
        System.gc();
        if (this.viewport.getSelectionGroup() == null) {
            return;
        }
        SequenceI[] seqs = this.viewport.getSelectionAsNewSequence();
        String[] omitHidden = null;
        if (this.viewport.hasHiddenColumns) {
            omitHidden = this.viewport.getViewAsString(true);
        }
        String output = new FormatAdapter().formatSequences("Fasta", seqs, omitHidden);
        StringSelection ss = new StringSelection(output);
        try {
            Desktop.internalCopy = true;
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(""), null);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, Desktop.instance);
        }
        catch (OutOfMemoryError er) {
            new OOMWarning("copying region", er);
            return;
        }
        Vector<int[]> hiddenColumns = null;
        if (this.viewport.hasHiddenColumns) {
            hiddenColumns = new Vector<int[]>();
            int hiddenOffset = this.viewport.getSelectionGroup().getStartRes();
            for (int i = 0; i < this.viewport.getColumnSelection().getHiddenColumns().size(); ++i) {
                int[] region = (int[])this.viewport.getColumnSelection().getHiddenColumns().elementAt(i);
                hiddenColumns.addElement(new int[]{region[0] - hiddenOffset, region[1] - hiddenOffset});
            }
        }
        Desktop.jalviewClipboard = new Object[]{seqs, this.viewport.alignment.getDataset(), hiddenColumns};
        this.statusBar.setText("Copied " + seqs.length + " sequences to clipboard.");
    }

    protected void pasteNew_actionPerformed(ActionEvent e) {
        this.paste(true);
    }

    protected void pasteThis_actionPerformed(ActionEvent e) {
        this.paste(false);
    }

    void paste(boolean newAlignment) {
        boolean externalPaste = true;
        try {
            int i;
            int i2;
            SequenceI[] sequences;
            String format;
            String str;
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = c.getContents(this);
            if (contents == null) {
                return;
            }
            try {
                str = (String)contents.getTransferData(DataFlavor.stringFlavor);
                if (str.length() < 1) {
                    return;
                }
                format = new IdentifyFile().Identify(str, "Paste");
            }
            catch (OutOfMemoryError er) {
                new OOMWarning("Out of memory pasting sequences!!", er);
                return;
            }
            boolean annotationAdded = false;
            AlignmentI alignment = null;
            if (Desktop.jalviewClipboard != null) {
                SequenceI[] newseq = (SequenceI[])Desktop.jalviewClipboard[0];
                sequences = new SequenceI[newseq.length];
                for (i2 = 0; i2 < newseq.length; ++i2) {
                    sequences[i2] = new Sequence(newseq[i2]);
                }
                alignment = new Alignment(sequences);
                externalPaste = false;
            } else {
                alignment = new FormatAdapter().readFile(str, "Paste", format);
                sequences = alignment.getSequencesArray();
            }
            int alwidth = 0;
            if (newAlignment) {
                if (Desktop.jalviewClipboard != null) {
                    alignment.setDataset((Alignment)Desktop.jalviewClipboard[1]);
                } else {
                    alignment.setDataset(null);
                }
                alwidth = alignment.getWidth() + 1;
            } else {
                Alignment pastedal = alignment;
                alignment = this.viewport.getAlignment();
                alwidth = alignment.getWidth() + 1;
                boolean importDs = Desktop.jalviewClipboard != null && Desktop.jalviewClipboard[1] != alignment.getDataset();
                Vector<SequenceI> newDs = importDs ? new Vector<SequenceI>() : null;
                for (i = 0; i < sequences.length; ++i) {
                    if (importDs) {
                        newDs.addElement(null);
                    }
                    SequenceI ds = sequences[i].getDatasetSequence();
                    if (importDs && ds != null) {
                        if (!newDs.contains(ds)) {
                            newDs.setElementAt(ds, i);
                            ds = new Sequence(ds);
                            sequences[i].setDatasetSequence(ds);
                        } else {
                            ds = sequences[newDs.indexOf(ds)].getDatasetSequence();
                        }
                    } else {
                        sequences[i] = sequences[i].deriveSequence();
                        alignment.getDataset().addSequence(sequences[i].getDatasetSequence());
                    }
                    alignment.addSequence(sequences[i]);
                }
                if (newDs != null) {
                    newDs.clear();
                }
                if (pastedal.getAlignmentAnnotation() != null) {
                    AlignmentAnnotation[] alann = pastedal.getAlignmentAnnotation();
                    for (int i3 = 0; i3 < alann.length; ++i3) {
                        annotationAdded = true;
                        if (alann[i3].sequenceRef != null || alann[i3].autoCalculated) continue;
                        AlignmentAnnotation newann = new AlignmentAnnotation(alann[i3]);
                        newann.padAnnotation(alwidth);
                        alignment.addAnnotation(newann);
                    }
                }
            }
            if (!newAlignment) {
                this.addHistoryItem(new EditCommand("Add sequences", 3, sequences, 0, alignment.getWidth(), alignment));
            }
            for (i2 = 0; i2 < sequences.length; ++i2) {
                if (sequences[i2].getAnnotation() == null) continue;
                for (int a = 0; a < sequences[i2].getAnnotation().length; ++a) {
                    annotationAdded = true;
                    sequences[i2].getAnnotation()[a].adjustForAlignment();
                    sequences[i2].getAnnotation()[a].padAnnotation(alwidth);
                    alignment.addAnnotation(sequences[i2].getAnnotation()[a]);
                    alignment.setAnnotationIndex(sequences[i2].getAnnotation()[a], a);
                }
            }
            if (!newAlignment) {
                this.viewport.setEndSeq(alignment.getHeight());
                if (annotationAdded) {
                    AlignmentI[] alview = this.getViewAlignments();
                    for (int i4 = 0; i4 < sequences.length; ++i4) {
                        AlignmentAnnotation[] sann = sequences[i4].getAnnotation();
                        if (sann == null) continue;
                        for (int avnum = 0; avnum < alview.length; ++avnum) {
                            if (alview[avnum] == alignment) continue;
                            int avwidth = alview[avnum].getWidth() + 1;
                            for (int a = 0; a < sann.length; ++a) {
                                AlignmentAnnotation newann = new AlignmentAnnotation(sann[a]);
                                sequences[i4].addAlignmentAnnotation(newann);
                                newann.padAnnotation(avwidth);
                                alview[avnum].addAnnotation(newann);
                                alview[avnum].setAnnotationIndex(newann, a);
                            }
                        }
                    }
                    this.buildSortByAnnotationScoresMenu();
                }
                this.viewport.firePropertyChange("alignment", null, alignment.getSequences());
            } else {
                AlignFrame af = new AlignFrame(alignment, 700, 500);
                String newtitle = new String("Copied sequences");
                if (Desktop.jalviewClipboard != null && Desktop.jalviewClipboard[2] != null) {
                    Vector hc = (Vector)Desktop.jalviewClipboard[2];
                    for (i = 0; i < hc.size(); ++i) {
                        int[] region = (int[])hc.elementAt(i);
                        af.viewport.hideColumns(region[0], region[1]);
                    }
                }
                af.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().transferSettings(this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer());
                newtitle = !externalPaste ? (this.title.startsWith("Copied sequences") ? this.title : newtitle.concat("- from " + this.title)) : new String("Pasted sequences");
                Desktop.addInternalFrame(af, newtitle, 700, 500);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Exception whilst pasting: " + ex);
        }
    }

    protected void cut_actionPerformed(ActionEvent e) {
        this.copy_actionPerformed(null);
        this.delete_actionPerformed(null);
    }

    protected void delete_actionPerformed(ActionEvent evt) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = sg.getSequenceAt(i);
            seqs.addElement(seq);
        }
        if (sg.getSize() == this.viewport.alignment.getHeight()) {
            this.viewport.getColumnSelection().removeElements(sg.getStartRes(), sg.getEndRes() + 1);
        }
        SequenceI[] cut = new SequenceI[seqs.size()];
        for (int i = 0; i < seqs.size(); ++i) {
            cut[i] = (SequenceI)seqs.elementAt(i);
        }
        this.addHistoryItem(new EditCommand("Cut Sequences", 2, cut, sg.getStartRes(), sg.getEndRes() - sg.getStartRes() + 1, this.viewport.alignment));
        this.viewport.setSelectionGroup(null);
        this.viewport.alignment.deleteGroup(sg);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        if (this.viewport.getAlignment().getHeight() < 1) {
            try {
                this.setClosed(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void deleteGroups_actionPerformed(ActionEvent e) {
        this.viewport.alignment.deleteAllGroups();
        this.viewport.sequenceColours = null;
        this.viewport.setSelectionGroup(null);
        PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
        this.alignPanel.paintAlignment(true);
    }

    public void selectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
        SequenceGroup sg = new SequenceGroup();
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addSequence(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        sg.setEndRes(this.viewport.alignment.getWidth() - 1);
        this.viewport.setSelectionGroup(sg);
        this.alignPanel.paintAlignment(true);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    public void deselectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.cursorMode) {
            this.alignPanel.seqPanel.keyboardNo1 = null;
            this.alignPanel.seqPanel.keyboardNo2 = null;
        }
        this.viewport.setSelectionGroup(null);
        this.viewport.getColumnSelection().clear();
        this.viewport.setSelectionGroup(null);
        this.alignPanel.seqPanel.seqCanvas.highlightSearchResults(null);
        this.alignPanel.idPanel.idCanvas.searchResults = null;
        this.alignPanel.paintAlignment(true);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    public void invertSequenceMenuItem_actionPerformed(ActionEvent e) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            this.selectAllSequenceMenuItem_actionPerformed(null);
            return;
        }
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addOrRemove(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        this.alignPanel.paintAlignment(true);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    public void invertColSel_actionPerformed(ActionEvent e) {
        this.viewport.invertColumnSelection();
        this.alignPanel.paintAlignment(true);
    }

    public void remove2LeftMenuItem_actionPerformed(ActionEvent e) {
        this.trimAlignment(true);
    }

    public void remove2RightMenuItem_actionPerformed(ActionEvent e) {
        this.trimAlignment(false);
    }

    void trimAlignment(boolean trimLeft) {
        ColumnSelection colSel = this.viewport.getColumnSelection();
        if (colSel.size() > 0) {
            TrimRegionCommand trimRegion;
            int column = trimLeft ? colSel.getMin() : colSel.getMax();
            SequenceI[] seqs = this.viewport.getSelectionGroup() != null ? this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences) : this.viewport.alignment.getSequencesArray();
            if (trimLeft) {
                trimRegion = new TrimRegionCommand("Remove Left", TrimRegionCommand.TRIM_LEFT, seqs, column, this.viewport.alignment, this.viewport.colSel, this.viewport.selectionGroup);
                this.viewport.setStartRes(0);
            } else {
                trimRegion = new TrimRegionCommand("Remove Right", TrimRegionCommand.TRIM_RIGHT, seqs, column, this.viewport.alignment, this.viewport.colSel, this.viewport.selectionGroup);
            }
            this.statusBar.setText("Removed " + trimRegion.getSize() + " columns.");
            this.addHistoryItem(trimRegion);
            Vector groups = this.viewport.alignment.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.get(i);
                if ((!trimLeft || sg.adjustForRemoveLeft(column)) && (trimLeft || sg.adjustForRemoveRight(column))) continue;
                this.viewport.alignment.deleteGroup(sg);
            }
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        }
    }

    public void removeGappedColumnMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.alignment.getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences);
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.alignment.getSequencesArray();
        }
        RemoveGapColCommand removeGapCols = new RemoveGapColCommand("Remove Gapped Columns", seqs, start, end, this.viewport.alignment);
        this.addHistoryItem(removeGapCols);
        this.statusBar.setText("Removed " + removeGapCols.getSize() + " empty columns.");
        SequenceI seq = this.viewport.alignment.getSequenceAt(0);
        int startRes = seq.findPosition(this.viewport.startRes);
        this.viewport.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    public void removeAllGapsMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.alignment.getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences);
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.alignment.getSequencesArray();
        }
        SequenceI seq = this.viewport.alignment.getSequenceAt(0);
        int startRes = seq.findPosition(this.viewport.startRes);
        this.addHistoryItem(new RemoveGapsCommand("Remove Gaps", seqs, start, end, this.viewport.alignment));
        this.viewport.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    public void padGapsMenuitem_actionPerformed(ActionEvent e) {
        this.viewport.padGaps = this.padGapsMenuitem.isSelected();
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    public void findMenuItem_actionPerformed(ActionEvent e) {
        new Finder();
    }

    public void newView_actionPerformed(ActionEvent e) {
        AlignmentPanel newap = new Jalview2XML().copyAlignPanel(this.alignPanel, true);
        newap.av.gatherViewsHere = false;
        if (this.viewport.viewName == null) {
            this.viewport.viewName = "Original";
        }
        newap.av.historyList = this.viewport.historyList;
        newap.av.redoList = this.viewport.redoList;
        int index = Desktop.getViewCount(this.viewport.getSequenceSetId());
        String newViewName = "View " + index;
        Vector comps = (Vector)PaintRefresher.components.get(this.viewport.getSequenceSetId());
        Vector<String> existingNames = new Vector<String>();
        for (int i = 0; i < comps.size(); ++i) {
            if (!(comps.elementAt(i) instanceof AlignmentPanel)) continue;
            AlignmentPanel ap = (AlignmentPanel)comps.elementAt(i);
            if (existingNames.contains(ap.av.viewName)) continue;
            existingNames.addElement(ap.av.viewName);
        }
        while (existingNames.contains(newViewName)) {
            newViewName = "View " + ++index;
        }
        newap.av.viewName = newViewName;
        this.addAlignmentPanel(newap, false);
        if (this.alignPanels.size() == 2) {
            this.viewport.gatherViewsHere = true;
        }
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void expandViews_actionPerformed(ActionEvent e) {
        Desktop.instance.explodeViews(this);
    }

    public void gatherViews_actionPerformed(ActionEvent e) {
        Desktop.instance.gatherViews(this);
    }

    public void font_actionPerformed(ActionEvent e) {
        new FontChooser(this.alignPanel);
    }

    protected void seqLimit_actionPerformed(ActionEvent e) {
        this.viewport.setShowJVSuffix(this.seqLimits.isSelected());
        this.alignPanel.idPanel.idCanvas.setPreferredSize(this.alignPanel.calculateIdWidth());
        this.alignPanel.paintAlignment(true);
    }

    public void idRightAlign_actionPerformed(ActionEvent e) {
        this.viewport.rightAlignIds = this.idRightAlign.isSelected();
        this.alignPanel.paintAlignment(true);
    }

    public void centreColumnLabels_actionPerformed(ActionEvent e) {
        this.viewport.centreColumnLabels = this.centreColumnLabelsMenuItem.getState();
        this.alignPanel.paintAlignment(true);
    }

    protected void colourTextMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setColourText(this.colourTextMenuItem.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    public void wrapMenuItem_actionPerformed(ActionEvent e) {
        this.scaleAbove.setVisible(this.wrapMenuItem.isSelected());
        this.scaleLeft.setVisible(this.wrapMenuItem.isSelected());
        this.scaleRight.setVisible(this.wrapMenuItem.isSelected());
        this.viewport.setWrapAlignment(this.wrapMenuItem.isSelected());
        this.alignPanel.setWrapAlignment(this.wrapMenuItem.isSelected());
    }

    public void showAllSeqs_actionPerformed(ActionEvent e) {
        this.viewport.showAllHiddenSeqs();
    }

    public void showAllColumns_actionPerformed(ActionEvent e) {
        this.viewport.showAllHiddenColumns();
        this.repaint();
    }

    public void hideSelSequences_actionPerformed(ActionEvent e) {
        this.viewport.hideAllSelectedSeqs();
        this.alignPanel.paintAlignment(true);
    }

    public void hideSelColumns_actionPerformed(ActionEvent e) {
        this.viewport.hideSelectedColumns();
        this.alignPanel.paintAlignment(true);
    }

    public void hiddenMarkers_actionPerformed(ActionEvent e) {
        this.viewport.setShowHiddenMarkers(this.hiddenMarkers.isSelected());
        this.repaint();
    }

    protected void scaleAbove_actionPerformed(ActionEvent e) {
        this.viewport.setScaleAboveWrapped(this.scaleAbove.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    protected void scaleLeft_actionPerformed(ActionEvent e) {
        this.viewport.setScaleLeftWrapped(this.scaleLeft.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    protected void scaleRight_actionPerformed(ActionEvent e) {
        this.viewport.setScaleRightWrapped(this.scaleRight.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    public void viewBoxesMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowBoxes(this.viewBoxesMenuItem.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    public void viewTextMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowText(this.viewTextMenuItem.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    protected void renderGapsMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setRenderGaps(this.renderGapsMenuItem.isSelected());
        this.alignPanel.paintAlignment(true);
    }

    public void featureSettings_actionPerformed(ActionEvent e) {
        if (this.featureSettings != null) {
            this.featureSettings.close();
            this.featureSettings = null;
        }
        this.featureSettings = new FeatureSettings(this);
    }

    public void showSeqFeatures_actionPerformed(ActionEvent evt) {
        this.viewport.setShowSequenceFeatures(this.showSeqFeatures.isSelected());
        this.alignPanel.paintAlignment(true);
        if (this.alignPanel.getOverviewPanel() != null) {
            this.alignPanel.getOverviewPanel().updateOverviewImage();
        }
    }

    public void annotationPanelMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowAnnotation(this.annotationPanelMenuItem.isSelected());
        this.alignPanel.setAnnotationVisible(this.annotationPanelMenuItem.isSelected());
    }

    public void alignmentProperties() {
        JEditorPane editPane = new JEditorPane("text/html", "");
        editPane.setEditable(false);
        StringBuffer contents = new StringBuffer("<html>");
        float avg = 0.0f;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 0; i < this.viewport.alignment.getHeight(); ++i) {
            int size = this.viewport.alignment.getSequenceAt(i).getEnd() - this.viewport.alignment.getSequenceAt(i).getStart();
            avg += (float)size;
            if (size > max) {
                max = size;
            }
            if (size >= min) continue;
            min = size;
        }
        avg /= (float)this.viewport.alignment.getHeight();
        contents.append("<br>Sequences: " + this.viewport.alignment.getHeight());
        contents.append("<br>Minimum Sequence Length: " + min);
        contents.append("<br>Maximum Sequence Length: " + max);
        contents.append("<br>Average Length: " + (int)avg);
        if (((Alignment)this.viewport.alignment).getProperties() != null) {
            Hashtable props = ((Alignment)this.viewport.alignment).getProperties();
            Enumeration en = props.keys();
            contents.append("<br><br><table border=\"1\">");
            while (en.hasMoreElements()) {
                int npos;
                String key = en.nextElement().toString();
                StringBuffer val = new StringBuffer();
                String vals = props.get(key).toString();
                int pos = 0;
                do {
                    if ((npos = vals.indexOf("\n", pos)) == -1) {
                        val.append(vals.substring(pos));
                    } else {
                        val.append(vals.substring(pos, npos));
                        val.append("<br>");
                    }
                    pos = npos + 1;
                } while (npos != -1);
                contents.append("<tr><td>" + key + "</td><td>" + val + "</td></tr>");
            }
            contents.append("</table>");
        }
        editPane.setText(contents.toString() + "</html>");
        JInternalFrame frame = new JInternalFrame();
        frame.getContentPane().add(new JScrollPane(editPane));
        Desktop.addInternalFrame(frame, "Alignment Properties: " + this.getTitle(), 500, 400);
    }

    public void overviewMenuItem_actionPerformed(ActionEvent e) {
        if (this.alignPanel.overviewPanel != null) {
            return;
        }
        JInternalFrame frame = new JInternalFrame();
        OverviewPanel overview = new OverviewPanel(this.alignPanel);
        frame.setContentPane(overview);
        Desktop.addInternalFrame(frame, "Overview " + this.getTitle(), frame.getWidth(), frame.getHeight());
        frame.pack();
        frame.setLayer(JLayeredPane.PALETTE_LAYER);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent evt) {
                AlignFrame.this.alignPanel.setOverviewPanel(null);
            }
        });
        this.alignPanel.setOverviewPanel(overview);
    }

    public void textColour_actionPerformed(ActionEvent e) {
        new TextColourChooser().chooseColour(this.alignPanel, null);
    }

    protected void noColourmenuItem_actionPerformed(ActionEvent e) {
        this.changeColour(null);
    }

    public void clustalColour_actionPerformed(ActionEvent e) {
        this.changeColour(new ClustalxColourScheme(this.viewport.alignment.getSequences(), this.viewport.alignment.getWidth()));
    }

    public void zappoColour_actionPerformed(ActionEvent e) {
        this.changeColour(new ZappoColourScheme());
    }

    public void taylorColour_actionPerformed(ActionEvent e) {
        this.changeColour(new TaylorColourScheme());
    }

    public void hydrophobicityColour_actionPerformed(ActionEvent e) {
        this.changeColour(new HydrophobicColourScheme());
    }

    public void helixColour_actionPerformed(ActionEvent e) {
        this.changeColour(new HelixColourScheme());
    }

    public void strandColour_actionPerformed(ActionEvent e) {
        this.changeColour(new StrandColourScheme());
    }

    public void turnColour_actionPerformed(ActionEvent e) {
        this.changeColour(new TurnColourScheme());
    }

    public void buriedColour_actionPerformed(ActionEvent e) {
        this.changeColour(new BuriedColourScheme());
    }

    public void nucleotideColour_actionPerformed(ActionEvent e) {
        this.changeColour(new NucleotideColourScheme());
    }

    public void annotationColour_actionPerformed(ActionEvent e) {
        new AnnotationColourChooser(this.viewport, this.alignPanel);
    }

    protected void applyToAllGroups_actionPerformed(ActionEvent e) {
        this.viewport.setColourAppliesToAllGroups(this.applyToAllGroups.isSelected());
    }

    public void changeColour(ColourSchemeI cs) {
        int threshold = 0;
        if (cs != null) {
            if (this.viewport.getAbovePIDThreshold()) {
                threshold = SliderPanel.setPIDSliderSource(this.alignPanel, cs, "Background");
                cs.setThreshold(threshold, this.viewport.getIgnoreGapsConsensus());
                this.viewport.setGlobalColourScheme(cs);
            } else {
                cs.setThreshold(0, this.viewport.getIgnoreGapsConsensus());
            }
            if (this.viewport.getConservationSelected()) {
                Alignment al = (Alignment)this.viewport.alignment;
                Conservation c = new Conservation("All", ResidueProperties.propHash, 3, al.getSequences(), 0, al.getWidth() - 1);
                c.calculate();
                c.verdict(false, this.viewport.ConsPercGaps);
                cs.setConservation(c);
                cs.setConservationInc(SliderPanel.setConservationSlider(this.alignPanel, cs, "Background"));
            } else {
                cs.setConservation(null);
            }
            cs.setConsensus(this.viewport.hconsensus);
        }
        this.viewport.setGlobalColourScheme(cs);
        if (this.viewport.getColourAppliesToAllGroups()) {
            Vector groups = this.viewport.alignment.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
                if (cs == null) {
                    sg.cs = null;
                    continue;
                }
                if (cs instanceof ClustalxColourScheme) {
                    sg.cs = new ClustalxColourScheme(sg.getSequences(this.viewport.hiddenRepSequences), sg.getWidth());
                } else if (cs instanceof UserColourScheme) {
                    sg.cs = new UserColourScheme(((UserColourScheme)cs).getColours());
                } else {
                    try {
                        sg.cs = (ColourSchemeI)cs.getClass().newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.viewport.getAbovePIDThreshold() || cs instanceof PIDColourScheme || cs instanceof Blosum62ColourScheme) {
                    sg.cs.setThreshold(threshold, this.viewport.getIgnoreGapsConsensus());
                    sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.viewport.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1));
                } else {
                    sg.cs.setThreshold(0, this.viewport.getIgnoreGapsConsensus());
                }
                if (this.viewport.getConservationSelected()) {
                    Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(this.viewport.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1);
                    c.calculate();
                    c.verdict(false, this.viewport.ConsPercGaps);
                    sg.cs.setConservation(c);
                    continue;
                }
                sg.cs.setConservation(null);
            }
        }
        if (this.alignPanel.getOverviewPanel() != null) {
            this.alignPanel.getOverviewPanel().updateOverviewImage();
        }
        this.alignPanel.paintAlignment(true);
    }

    protected void modifyPID_actionPerformed(ActionEvent e) {
        if (this.viewport.getAbovePIDThreshold() && this.viewport.globalColourScheme != null) {
            SliderPanel.setPIDSliderSource(this.alignPanel, this.viewport.getGlobalColourScheme(), "Background");
            SliderPanel.showPIDSlider();
        }
    }

    protected void modifyConservation_actionPerformed(ActionEvent e) {
        if (this.viewport.getConservationSelected() && this.viewport.globalColourScheme != null) {
            SliderPanel.setConservationSlider(this.alignPanel, this.viewport.globalColourScheme, "Background");
            SliderPanel.showConservationSlider();
        }
    }

    protected void conservationMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setConservationSelected(this.conservationMenuItem.isSelected());
        this.viewport.setAbovePIDThreshold(false);
        this.abovePIDThreshold.setSelected(false);
        this.changeColour(this.viewport.getGlobalColourScheme());
        this.modifyConservation_actionPerformed(null);
    }

    public void abovePIDThreshold_actionPerformed(ActionEvent e) {
        this.viewport.setAbovePIDThreshold(this.abovePIDThreshold.isSelected());
        this.conservationMenuItem.setSelected(false);
        this.viewport.setConservationSelected(false);
        this.changeColour(this.viewport.getGlobalColourScheme());
        this.modifyPID_actionPerformed(null);
    }

    public void userDefinedColour_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("User Defined...")) {
            new UserDefinedColours(this.alignPanel, null);
        } else {
            UserColourScheme udc = (UserColourScheme)UserDefinedColours.getUserColourSchemes().get(e.getActionCommand());
            this.changeColour(udc);
        }
    }

    public void updateUserColourMenu() {
        Component[] menuItems = this.colourMenu.getMenuComponents();
        int iSize = menuItems.length;
        for (int i = 0; i < iSize; ++i) {
            if (menuItems[i].getName() == null || !menuItems[i].getName().equals("USER_DEFINED")) continue;
            this.colourMenu.remove(menuItems[i]);
            --iSize;
        }
        if (UserDefinedColours.getUserColourSchemes() != null) {
            Enumeration userColours = UserDefinedColours.getUserColourSchemes().keys();
            while (userColours.hasMoreElements()) {
                final JRadioButtonMenuItem radioItem = new JRadioButtonMenuItem(userColours.nextElement().toString());
                radioItem.setName("USER_DEFINED");
                radioItem.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        if (evt.isControlDown() || SwingUtilities.isRightMouseButton(evt)) {
                            radioItem.removeActionListener(radioItem.getActionListeners()[0]);
                            int option = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "Remove from default list?", "Remove user defined colour", 0);
                            if (option == 0) {
                                UserDefinedColours.removeColourFromDefaults(radioItem.getText());
                                AlignFrame.this.colourMenu.remove(radioItem);
                            } else {
                                radioItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent evt) {
                                        AlignFrame.this.userDefinedColour_actionPerformed(evt);
                                    }
                                });
                            }
                        }
                    }
                });
                radioItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        AlignFrame.this.userDefinedColour_actionPerformed(evt);
                    }
                });
                this.colourMenu.insert(radioItem, 15);
                this.colours.add(radioItem);
            }
        }
    }

    public void PIDColour_actionPerformed(ActionEvent e) {
        this.changeColour(new PIDColourScheme());
    }

    public void BLOSUM62Colour_actionPerformed(ActionEvent e) {
        this.changeColour(new Blosum62ColourScheme());
    }

    public void sortPairwiseMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByPID(this.viewport.getAlignment(), this.viewport.getAlignment().getSequenceAt(0), null);
        this.addHistoryItem(new OrderCommand("Pairwise Sort", oldOrder, this.viewport.alignment));
        this.alignPanel.paintAlignment(true);
    }

    public void sortIDMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByID(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("ID Sort", oldOrder, this.viewport.alignment));
        this.alignPanel.paintAlignment(true);
    }

    public void sortGroupMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByGroup(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Group Sort", oldOrder, this.viewport.alignment));
        this.alignPanel.paintAlignment(true);
    }

    public void removeRedundancyMenuItem_actionPerformed(ActionEvent e) {
        new RedundancyPanel(this.alignPanel, this);
    }

    public void pairwiseAlignmentMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.getSelectionGroup() == null || this.viewport.getSelectionGroup().getSize() < 2) {
            JOptionPane.showInternalMessageDialog(this, "You must select at least 2 sequences.", "Invalid Selection", 2);
        } else {
            JInternalFrame frame = new JInternalFrame();
            frame.setContentPane(new PairwiseAlignPanel(this.viewport));
            Desktop.addInternalFrame(frame, "Pairwise Alignment", 600, 500);
        }
    }

    public void PCAMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() < 4 && this.viewport.getSelectionGroup().getSize() > 0 || this.viewport.getAlignment().getHeight() < 4) {
            JOptionPane.showInternalMessageDialog(this, "Principal component analysis must take\nat least 4 input sequences.", "Sequence selection insufficient", 2);
            return;
        }
        new PCAPanel(this.alignPanel);
    }

    public void autoCalculate_actionPerformed(ActionEvent e) {
        this.viewport.autoCalculateConsensus = this.autoCalculate.isSelected();
        if (this.viewport.autoCalculateConsensus) {
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        }
    }

    public void averageDistanceTreeMenuItem_actionPerformed(ActionEvent e) {
        this.NewTreePanel("AV", "PID", "Average distance tree using PID");
    }

    public void neighbourTreeMenuItem_actionPerformed(ActionEvent e) {
        this.NewTreePanel("NJ", "PID", "Neighbour joining tree using PID");
    }

    protected void njTreeBlosumMenuItem_actionPerformed(ActionEvent e) {
        this.NewTreePanel("NJ", "BL", "Neighbour joining tree using BLOSUM62");
    }

    protected void avTreeBlosumMenuItem_actionPerformed(ActionEvent e) {
        this.NewTreePanel("AV", "BL", "Average distance tree using BLOSUM62");
    }

    void NewTreePanel(String type, String pwType, String title) {
        TreePanel tp;
        if (this.viewport.getSelectionGroup() != null) {
            if (this.viewport.getSelectionGroup().getSize() < 3) {
                JOptionPane.showMessageDialog(Desktop.desktop, "You need to have more than two sequences selected to build a tree!", "Not enough sequences", 2);
                return;
            }
            int s = 0;
            SequenceGroup sg = this.viewport.getSelectionGroup();
            while (s < sg.getSize()) {
                if (((SequenceI)sg.getSequences(null).elementAt(s++)).getLength() >= sg.getEndRes()) continue;
                JOptionPane.showMessageDialog(Desktop.desktop, "The selected region to create a tree may\nonly contain residues or gaps.\nTry using the Pad function in the edit menu,\nor one of the multiple sequence alignment web services.", "Sequences in selection are not aligned", 2);
                return;
            }
            title = title + " on region";
            tp = new TreePanel(this.alignPanel, type, pwType);
        } else {
            if (!this.viewport.alignment.isAligned()) {
                JOptionPane.showMessageDialog(Desktop.desktop, "The sequences must be aligned before creating a tree.\nTry using the Pad function in the edit menu,\nor one of the multiple sequence alignment web services.", "Sequences not aligned", 2);
                return;
            }
            if (this.viewport.alignment.getHeight() < 2) {
                return;
            }
            tp = new TreePanel(this.alignPanel, type, pwType);
        }
        title = title + " from ";
        if (this.viewport.viewName != null) {
            title = title + this.viewport.viewName + " of ";
        }
        title = title + this.title;
        Desktop.addInternalFrame(tp, title, 600, 500);
    }

    public void addSortByOrderMenuItem(String title, final AlignmentOrder order) {
        JMenuItem item = new JMenuItem("by " + title);
        this.sort.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceI[] oldOrder = AlignFrame.this.viewport.getAlignment().getSequencesArray();
                AlignmentSorter.sortBy(AlignFrame.this.viewport.getAlignment(), order);
                AlignFrame.this.addHistoryItem(new OrderCommand(order.getName(), oldOrder, AlignFrame.this.viewport.alignment));
                AlignFrame.this.alignPanel.paintAlignment(true);
            }
        });
    }

    public void addSortByAnnotScoreMenuItem(JMenu sort, final String scoreLabel) {
        JMenuItem item = new JMenuItem(scoreLabel);
        sort.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceI[] oldOrder = AlignFrame.this.viewport.getAlignment().getSequencesArray();
                AlignmentSorter.sortByAnnotationScore(scoreLabel, AlignFrame.this.viewport.getAlignment());
                AlignFrame.this.addHistoryItem(new OrderCommand("Sort by " + scoreLabel, oldOrder, AlignFrame.this.viewport.alignment));
                AlignFrame.this.alignPanel.paintAlignment(true);
            }
        });
    }

    public void buildSortByAnnotationScoresMenu() {
        if (this.viewport.alignment.getAlignmentAnnotation() == null) {
            return;
        }
        if (this.viewport.alignment.getAlignmentAnnotation().hashCode() != this._annotationScoreVectorHash) {
            this.sortByAnnotScore.removeAll();
            Hashtable<String, String> scoreSorts = new Hashtable<String, String>();
            Enumeration sq = this.viewport.alignment.getSequences().elements();
            while (sq.hasMoreElements()) {
                AlignmentAnnotation[] aann = ((SequenceI)sq.nextElement()).getAnnotation();
                for (int i = 0; aann != null && i < aann.length; ++i) {
                    if (!aann[i].hasScore() || aann[i].sequenceRef == null) continue;
                    scoreSorts.put(aann[i].label, aann[i].label);
                }
            }
            Enumeration labels = scoreSorts.keys();
            while (labels.hasMoreElements()) {
                this.addSortByAnnotScoreMenuItem(this.sortByAnnotScore, (String)labels.nextElement());
            }
            this.sortByAnnotScore.setVisible(scoreSorts.size() > 0);
            scoreSorts.clear();
            this._annotationScoreVectorHash = this.viewport.alignment.getAlignmentAnnotation().hashCode();
        }
    }

    public void buildTreeMenu() {
        int i;
        this.sortByTreeMenu.removeAll();
        Vector comps = (Vector)PaintRefresher.components.get(this.viewport.getSequenceSetId());
        Vector treePanels = new Vector();
        int iSize = comps.size();
        for (i = 0; i < iSize; ++i) {
            if (!(comps.elementAt(i) instanceof TreePanel)) continue;
            treePanels.add(comps.elementAt(i));
        }
        iSize = treePanels.size();
        if (iSize < 1) {
            this.sortByTreeMenu.setVisible(false);
            return;
        }
        this.sortByTreeMenu.setVisible(true);
        for (i = 0; i < treePanels.size(); ++i) {
            TreePanel tp = (TreePanel)treePanels.elementAt(i);
            JMenuItem item = new JMenuItem(tp.getTitle());
            final NJTree tree = ((TreePanel)treePanels.elementAt(i)).getTree();
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SequenceI[] oldOrder = AlignFrame.this.viewport.getAlignment().getSequencesArray();
                    AlignmentSorter.sortByTree(AlignFrame.this.viewport.getAlignment(), tree);
                    AlignFrame.this.addHistoryItem(new OrderCommand("Tree Sort", oldOrder, AlignFrame.this.viewport.alignment));
                    AlignFrame.this.alignPanel.paintAlignment(true);
                }
            });
            this.sortByTreeMenu.add(item);
        }
    }

    public AlignmentView gatherSequencesForAlignment() {
        AlignmentView msa = null;
        msa = this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1 ? this.viewport.getAlignmentView(true) : this.viewport.getAlignmentView(false);
        return msa;
    }

    public AlignmentView gatherSeqOrMsaForSecStrPrediction() {
        AlignmentView seqs = null;
        seqs = this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 0 ? this.viewport.getAlignmentView(true) : this.viewport.getAlignmentView(false);
        if (!this.viewport.alignment.isAligned()) {
            seqs.setSequences(new SeqCigar[]{seqs.getSequences()[0]});
        }
        return seqs;
    }

    protected void LoadtreeMenuItem_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Select a newick-like tree file");
        chooser.setToolTipText("Load a tree file");
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", choice);
            NewickFile fin = null;
            try {
                fin = new NewickFile(choice, "File");
                this.viewport.setCurrentTree(this.ShowNewickTree(fin, choice).getTree());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Desktop.desktop, ex.getMessage(), "Problem reading tree file", 2);
                ex.printStackTrace();
            }
            if (fin != null && fin.hasWarningMessage()) {
                JOptionPane.showMessageDialog(Desktop.desktop, fin.getWarningMessage(), "Possible problem with tree file", 2);
            }
        }
    }

    public TreePanel ShowNewickTree(NewickFile nf, String title) {
        return this.ShowNewickTree(nf, title, 600, 500, 4, 5);
    }

    public TreePanel ShowNewickTree(NewickFile nf, String title, AlignmentView input) {
        return this.ShowNewickTree(nf, title, input, 600, 500, 4, 5);
    }

    public TreePanel ShowNewickTree(NewickFile nf, String title, int w, int h, int x, int y) {
        return this.ShowNewickTree(nf, title, null, w, h, x, y);
    }

    public TreePanel ShowNewickTree(NewickFile nf, String title, AlignmentView input, int w, int h, int x, int y) {
        TreePanel tp = null;
        try {
            nf.parse();
            if (nf.getTree() != null) {
                tp = new TreePanel(this.alignPanel, "FromFile", title, nf, input);
                tp.setSize(w, h);
                if (x > 0 && y > 0) {
                    tp.setLocation(x, y);
                }
                Desktop.addInternalFrame(tp, title, w, h);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tp;
    }

    public void BuildWebServiceMenu() {
        if (Discoverer.services != null && Discoverer.services.size() > 0) {
            WSClient impl;
            ServiceHandle sh;
            int i;
            int j;
            Vector msaws = (Vector)Discoverer.services.get("MsaWS");
            Vector secstrpr = (Vector)Discoverer.services.get("SecStrPred");
            Vector seqsrch = (Vector)Discoverer.services.get("SeqSearch");
            Vector<JMenu> wsmenu = new Vector<JMenu>();
            AlignFrame af = this;
            if (msaws != null) {
                JMenu msawsmenu = new JMenu("Alignment");
                j = msaws.size();
                for (i = 0; i < j; ++i) {
                    sh = (ServiceHandle)msaws.get(i);
                    impl = Discoverer.getServiceClient(sh);
                    impl.attachWSMenuEntry(msawsmenu, this);
                }
                wsmenu.add(msawsmenu);
            }
            if (secstrpr != null) {
                JMenu secstrmenu = new JMenu("Secondary Structure Prediction");
                j = secstrpr.size();
                for (i = 0; i < j; ++i) {
                    sh = (ServiceHandle)secstrpr.get(i);
                    impl = Discoverer.getServiceClient(sh);
                    impl.attachWSMenuEntry(secstrmenu, this);
                }
                wsmenu.add(secstrmenu);
            }
            if (seqsrch != null) {
                JMenu seqsrchmenu = new JMenu("Sequence Database Search");
                j = seqsrch.size();
                for (i = 0; i < j; ++i) {
                    sh = (ServiceHandle)seqsrch.elementAt(i);
                    impl = Discoverer.getServiceClient(sh);
                    impl.attachWSMenuEntry(seqsrchmenu, this);
                }
                wsmenu.add(seqsrchmenu);
            }
            this.resetWebServiceMenu();
            int j2 = wsmenu.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                this.webService.add((JMenu)wsmenu.get(i2));
            }
        } else {
            this.resetWebServiceMenu();
            this.webService.add(this.webServiceNoServices);
        }
    }

    private void resetWebServiceMenu() {
        this.webService.removeAll();
        JMenuItem rfetch = new JMenuItem("Fetch DB References");
        rfetch.setToolTipText("Retrieve and parse sequence database records for the alignment or the currently selected sequences");
        this.webService.add(rfetch);
        rfetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        new DBRefFetcher((this).AlignFrame.this.alignPanel.av.getSequenceSelection(), (this).AlignFrame.this.alignPanel.alignFrame).fetchDBRefs(false);
                    }
                }).start();
            }
        });
    }

    protected void setShowProductsEnabled() {
        SequenceI[] selection = this.viewport.getSequenceSelection();
        if (this.canShowProducts(selection, this.viewport.getSelectionGroup() != null, this.viewport.getAlignment().getDataset())) {
            this.showProducts.setEnabled(true);
        } else {
            this.showProducts.setEnabled(false);
        }
    }

    public boolean canShowProducts(SequenceI[] selection, boolean isRegionSelection, Alignment dataset) {
        boolean showp = false;
        try {
            this.showProducts.removeAll();
            final boolean dna = this.viewport.getAlignment().isNucleotide();
            final Alignment ds = dataset;
            String[] ptypes = CrossRef.findSequenceXrefTypes(dna, selection, dataset);
            SequenceI[] sel = selection;
            for (int t = 0; ptypes != null && t < ptypes.length; ++t) {
                showp = true;
                final boolean isRegSel = isRegionSelection;
                final AlignFrame af = this;
                final String source = ptypes[t];
                JMenuItem xtype = new JMenuItem(ptypes[t]);
                xtype.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        af.showProductsFor(af.viewport.getSequenceSelection(), ds, isRegSel, dna, source);
                    }
                });
                this.showProducts.add(xtype);
            }
            this.showProducts.setVisible(showp);
            this.showProducts.setEnabled(showp);
        }
        catch (Exception e) {
            Cache.log.warn((Object)"canTranslate threw an exception - please report to help@jalview.org", (Throwable)e);
            return false;
        }
        return showp;
    }

    protected void showProductsFor(SequenceI[] sel, Alignment ds, boolean isRegSel, boolean dna, String source) {
        final boolean fisRegSel = isRegSel;
        final boolean fdna = dna;
        final String fsrc = source;
        final AlignFrame ths = this;
        final SequenceI[] fsel = sel;
        Runnable foo = new Runnable(){

            public void run() {
                long sttime = System.currentTimeMillis();
                ths.setProgressBar("Searching for sequences from " + fsrc, sttime);
                try {
                    Alignment ds = ths.getViewport().alignment.getDataset();
                    Alignment prods = CrossRef.findXrefSequences(fsel, fdna, fsrc, ds);
                    if (prods != null) {
                        SequenceI[] sprods = new SequenceI[prods.getHeight()];
                        for (int s = 0; s < sprods.length; ++s) {
                            sprods[s] = prods.getSequenceAt(s).deriveSequence();
                            if (ds.getSequences() == null || !ds.getSequences().contains(sprods[s].getDatasetSequence())) {
                                ds.addSequence(sprods[s].getDatasetSequence());
                            }
                            sprods[s].updatePDBIds();
                        }
                        Alignment al = new Alignment(sprods);
                        AlignedCodonFrame[] cf = prods.getCodonFrames();
                        for (int s = 0; cf != null && s < cf.length; ++s) {
                            al.addCodonFrame(cf[s]);
                            cf[s] = null;
                        }
                        al.setDataset(ds);
                        AlignFrame naf = new AlignFrame(al, 700, 500);
                        String newtitle = "" + (fdna ? "Proteins " : "Nucleotides ") + " for " + (fisRegSel ? "selected region of " : "") + AlignFrame.this.getTitle();
                        Desktop.addInternalFrame(naf, newtitle, 700, 500);
                    } else {
                        System.err.println("No Sequences generated for xRef type " + fsrc);
                    }
                }
                catch (Exception e) {
                    Cache.log.error((Object)"Exception when finding crossreferences", (Throwable)e);
                }
                catch (OutOfMemoryError e) {
                    new OOMWarning("whilst fetching crossreferences", e);
                }
                catch (Error e) {
                    Cache.log.error((Object)"Error when finding crossreferences", (Throwable)e);
                }
                ths.setProgressBar("Finished searching for sequences from " + fsrc, sttime);
            }
        };
        Thread frunner = new Thread(foo);
        frunner.start();
    }

    public boolean canShowTranslationProducts(SequenceI[] selection, AlignmentI alignment) {
        try {
            return Dna.canTranslate(selection, this.viewport.getViewAsVisibleContigs(true));
        }
        catch (Exception e) {
            Cache.log.warn((Object)"canTranslate threw an exception - please report to help@jalview.org", (Throwable)e);
            return false;
        }
    }

    public void showProducts_actionPerformed(ActionEvent e) {
        SequenceI[] selection = this.viewport.getSequenceSelection();
        AlignmentI al = null;
        try {
            al = Dna.CdnaTranslate(selection, this.viewport.getViewAsVisibleContigs(true), this.viewport.getGapCharacter(), this.viewport.getAlignment().getDataset());
        }
        catch (Exception ex) {
            al = null;
            Cache.log.debug((Object)"Exception during translation.", (Throwable)ex);
        }
        if (al == null) {
            JOptionPane.showMessageDialog(Desktop.desktop, "Please select at least three bases in at least one sequence in order to perform a cDNA translation.", "Translation Failed", 2);
        } else {
            AlignFrame af = new AlignFrame(al, 700, 500);
            Desktop.addInternalFrame(af, "Translation of " + this.getTitle(), 700, 500);
        }
    }

    public void showTranslation_actionPerformed(ActionEvent e) {
        SequenceI[] selection = this.viewport.getSequenceSelection();
        String[] seqstring = this.viewport.getViewAsString(true);
        AlignmentI al = null;
        try {
            al = Dna.CdnaTranslate(selection, seqstring, this.viewport.getViewAsVisibleContigs(true), this.viewport.getGapCharacter(), this.viewport.alignment.getAlignmentAnnotation(), this.viewport.alignment.getWidth(), this.viewport.getAlignment().getDataset());
        }
        catch (Exception ex) {
            al = null;
            Cache.log.debug((Object)"Exception during translation.", (Throwable)ex);
        }
        if (al == null) {
            JOptionPane.showMessageDialog(Desktop.desktop, "Please select at least three bases in at least one sequence in order to perform a cDNA translation.", "Translation Failed", 2);
        } else {
            AlignFrame af = new AlignFrame(al, 700, 500);
            Desktop.addInternalFrame(af, "Translation of " + this.getTitle(), 700, 500);
        }
    }

    public boolean parseFeaturesFile(String file, String type) {
        boolean featuresFile = false;
        try {
            featuresFile = new FeaturesFile(file, type).parse(this.viewport.alignment.getDataset(), this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().featureColours, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (featuresFile) {
            this.viewport.showSequenceFeatures = true;
            this.showSeqFeatures.setSelected(true);
            this.alignPanel.paintAlignment(true);
        }
        return featuresFile;
    }

    public void dragEnter(DropTargetDragEvent evt) {
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void dragOver(DropTargetDragEvent evt) {
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    public void drop(DropTargetDropEvent evt) {
        Transferable t = evt.getTransferable();
        ArrayList<File> files = null;
        try {
            DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                evt.acceptDrop(3);
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            } else if (t.isDataFlavorSupported(uriListFlavor)) {
                evt.acceptDrop(3);
                String data = (String)t.getTransferData(uriListFlavor);
                files = new ArrayList<File>(1);
                StringTokenizer st = new StringTokenizer(data, "\r\n");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.startsWith("#")) continue;
                    URI uri = new URI(s);
                    File file = new File(uri);
                    files.add(file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (files != null) {
            try {
                for (int i = 0; i < files.size(); ++i) {
                    this.loadJalviewDataFile(files.get(i).toString());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadJalviewDataFile(String file) {
        try {
            boolean isAnnotation;
            String protocol = "File";
            if (file.indexOf("http:") > -1 || file.indexOf("file:") > -1) {
                protocol = "URL";
            }
            if (!(isAnnotation = new AnnotationFile().readAnnotationFile(this.viewport.alignment, file, protocol))) {
                String format = new IdentifyFile().Identify(file, protocol);
                if (format.equalsIgnoreCase("JnetFile")) {
                    JPredFile predictions = new JPredFile(file, protocol);
                    new JnetAnnotationMaker();
                    JnetAnnotationMaker.add_annotation(predictions, this.viewport.getAlignment(), 0, false);
                    isAnnotation = true;
                } else {
                    boolean isGroupsFile = this.parseFeaturesFile(file, protocol);
                    if (!isGroupsFile) {
                        new FileLoader().LoadFile(this.viewport, file, protocol, format);
                    } else {
                        this.alignPanel.paintAlignment(true);
                    }
                }
            }
            if (isAnnotation) {
                this.alignPanel.adjustAnnotationHeight();
                this.viewport.updateSequenceIdColours();
                this.buildSortByAnnotationScoresMenu();
                this.alignPanel.paintAlignment(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void tabSelectionChanged(int index) {
        if (index > -1) {
            this.alignPanel = (AlignmentPanel)this.alignPanels.elementAt(index);
            this.viewport = this.alignPanel.av;
            this.setMenusFromViewport(this.viewport);
        }
    }

    public void tabbedPane_mousePressed(MouseEvent e) {
        String reply;
        if (SwingUtilities.isRightMouseButton(e) && (reply = JOptionPane.showInternalInputDialog(this, "Enter View Name", "Edit View Name", 3)) != null) {
            this.viewport.viewName = reply;
            this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), reply);
        }
    }

    public AlignViewport getCurrentView() {
        return this.viewport;
    }

    protected void extractScores_actionPerformed(ActionEvent e) {
        ParseProperties pp = new ParseProperties(this.viewport.alignment);
        if (pp.getScoresFromDescription("description column", "score in description column ", "\\W*([-+eE0-9.]+)", true) > 0) {
            this.buildSortByAnnotationScoresMenu();
        }
    }

    public void setShowSeqFeatures(boolean b) {
        this.showSeqFeatures.setSelected(true);
        this.viewport.setShowSequenceFeatures(true);
    }
}

