/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnnotationColourChooser
extends JPanel {
    JInternalFrame frame;
    AlignViewport av;
    AlignmentPanel ap;
    ColourSchemeI oldcs;
    Hashtable oldgroupColours;
    AlignmentAnnotation currentAnnotation;
    boolean adjusting = false;
    JComboBox annotations;
    JPanel minColour = new JPanel();
    JPanel maxColour = new JPanel();
    JButton ok = new JButton();
    JButton cancel = new JButton();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JComboBox threshold = new JComboBox();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel3 = new JPanel();
    FlowLayout flowLayout2 = new FlowLayout();
    JSlider slider = new JSlider();
    JTextField thresholdValue = new JTextField(20);
    JCheckBox currentColours = new JCheckBox();
    JCheckBox thresholdIsMin = new JCheckBox();

    public AnnotationColourChooser(AlignViewport av, final AlignmentPanel ap) {
        this.oldcs = av.getGlobalColourScheme();
        if (av.alignment.getGroups() != null) {
            this.oldgroupColours = new Hashtable();
            Vector allGroups = ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.get(g);
                if (sg.cs == null) continue;
                this.oldgroupColours.put(sg, sg.cs);
            }
        }
        this.av = av;
        this.ap = ap;
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, "Colour by Annotation", 480, 145);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (!AnnotationColourChooser.this.adjusting) {
                    AnnotationColourChooser.this.thresholdValue.setText((float)AnnotationColourChooser.this.slider.getValue() / 1000.0f + "");
                    AnnotationColourChooser.this.valueChanged();
                }
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ap.paintAlignment(true);
            }
        });
        if (av.alignment.getAlignmentAnnotation() == null) {
            return;
        }
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            this.minColour.setBackground(acg.getMinColour());
            this.maxColour.setBackground(acg.getMaxColour());
        } else {
            this.minColour.setBackground(Color.orange);
            this.maxColour.setBackground(Color.red);
        }
        this.adjusting = true;
        Vector<String> list = new Vector<String>();
        int index = 1;
        for (int i = 0; i < av.alignment.getAlignmentAnnotation().length; ++i) {
            String label = av.alignment.getAlignmentAnnotation()[i].label;
            if (!list.contains(label)) {
                list.addElement(label);
                continue;
            }
            list.addElement(label + "_" + index++);
        }
        this.annotations = new JComboBox(list);
        this.threshold.addItem("No Threshold");
        this.threshold.addItem("Above Threshold");
        this.threshold.addItem("Below Threshold");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.adjusting = false;
        this.changeColour();
    }

    public AnnotationColourChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.minColour.setFont(new Font("Verdana", 0, 11));
        this.minColour.setBorder(BorderFactory.createEtchedBorder());
        this.minColour.setPreferredSize(new Dimension(40, 20));
        this.minColour.setToolTipText("Minimum Colour");
        this.minColour.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (AnnotationColourChooser.this.minColour.isEnabled()) {
                    AnnotationColourChooser.this.minColour_actionPerformed();
                }
            }
        });
        this.maxColour.setFont(new Font("Verdana", 0, 11));
        this.maxColour.setBorder(BorderFactory.createEtchedBorder());
        this.maxColour.setPreferredSize(new Dimension(40, 20));
        this.maxColour.setToolTipText("Maximum Colour");
        this.maxColour.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (AnnotationColourChooser.this.maxColour.isEnabled()) {
                    AnnotationColourChooser.this.maxColour_actionPerformed();
                }
            }
        });
        this.ok.setOpaque(false);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.ok_actionPerformed(e);
            }
        });
        this.cancel.setOpaque(false);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.cancel_actionPerformed(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.annotations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.annotations_actionPerformed(e);
            }
        });
        this.jPanel1.setBackground(Color.white);
        this.jPanel2.setBackground(Color.white);
        this.threshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.threshold_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.flowLayout2);
        this.thresholdValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.thresholdValue_actionPerformed(e);
            }
        });
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(true);
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 32));
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setColumns(7);
        this.jPanel3.setBackground(Color.white);
        this.currentColours.setFont(new Font("Verdana", 0, 11));
        this.currentColours.setOpaque(false);
        this.currentColours.setText("Use Original Colours");
        this.currentColours.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.currentColours_actionPerformed(e);
            }
        });
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setText("Threshold is Min/Max");
        this.thresholdIsMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationColourChooser.this.thresholdIsMin_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.ok);
        this.jPanel1.add(this.cancel);
        this.jPanel2.add(this.annotations);
        this.jPanel2.add(this.currentColours);
        this.jPanel2.add(this.minColour);
        this.jPanel2.add(this.maxColour);
        this.add((Component)this.jPanel3, "Center");
        this.jPanel3.add(this.threshold);
        this.jPanel3.add(this.slider);
        this.jPanel3.add(this.thresholdValue);
        this.jPanel3.add(this.thresholdIsMin);
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.jPanel2, "North");
    }

    public void minColour_actionPerformed() {
        Color col = JColorChooser.showDialog(this, "Select Colour for Minimum Value", this.minColour.getBackground());
        if (col != null) {
            this.minColour.setBackground(col);
        }
        this.minColour.repaint();
        this.changeColour();
    }

    public void maxColour_actionPerformed() {
        Color col = JColorChooser.showDialog(this, "Select Colour for Maximum Value", this.maxColour.getBackground());
        if (col != null) {
            this.maxColour.setBackground(col);
        }
        this.maxColour.repaint();
        this.changeColour();
    }

    void changeColour() {
        if (this.adjusting) {
            return;
        }
        this.currentAnnotation = this.av.alignment.getAlignmentAnnotation()[this.annotations.getSelectedIndex()];
        int aboveThreshold = -1;
        if (this.threshold.getSelectedItem().equals("Above Threshold")) {
            aboveThreshold = AnnotationColourGradient.ABOVE_THRESHOLD;
        } else if (this.threshold.getSelectedItem().equals("Below Threshold")) {
            aboveThreshold = AnnotationColourGradient.BELOW_THRESHOLD;
        }
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        if (aboveThreshold == AnnotationColourGradient.NO_THRESHOLD) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
        } else if (aboveThreshold != AnnotationColourGradient.NO_THRESHOLD && this.currentAnnotation.threshold == null) {
            this.currentAnnotation.setThreshold(new GraphLine((this.currentAnnotation.graphMax - this.currentAnnotation.graphMin) / 2.0f, "Threshold", Color.black));
        }
        if (aboveThreshold != AnnotationColourGradient.NO_THRESHOLD) {
            this.adjusting = true;
            float range = this.currentAnnotation.graphMax * 1000.0f - this.currentAnnotation.graphMin * 1000.0f;
            this.slider.setMinimum((int)(this.currentAnnotation.graphMin * 1000.0f));
            this.slider.setMaximum((int)(this.currentAnnotation.graphMax * 1000.0f));
            this.slider.setValue((int)(this.currentAnnotation.threshold.value * 1000.0f));
            this.thresholdValue.setText(this.currentAnnotation.threshold.value + "");
            this.slider.setMajorTickSpacing((int)(range / 10.0f));
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
        }
        AnnotationColourGradient acg = null;
        acg = this.currentColours.isSelected() ? new AnnotationColourGradient(this.currentAnnotation, this.av.getGlobalColourScheme(), aboveThreshold) : new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold);
        if (this.currentAnnotation.graphMin == 0.0f && this.currentAnnotation.graphMax == 0.0f) {
            acg.predefinedColours = true;
        }
        acg.thresholdIsMinMax = this.thresholdIsMin.isSelected();
        this.av.setGlobalColourScheme(acg);
        if (this.av.alignment.getGroups() != null) {
            Vector allGroups = this.ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.get(g);
                if (sg.cs == null) continue;
                sg.cs = this.currentColours.isSelected() ? new AnnotationColourGradient(this.currentAnnotation, sg.cs, aboveThreshold) : new AnnotationColourGradient(this.currentAnnotation, this.minColour.getBackground(), this.maxColour.getBackground(), aboveThreshold);
            }
        }
        this.ap.paintAlignment(false);
    }

    public void ok_actionPerformed(ActionEvent e) {
        this.changeColour();
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancel_actionPerformed(ActionEvent e) {
        this.reset();
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void reset() {
        this.av.setGlobalColourScheme(this.oldcs);
        if (this.av.alignment.getGroups() != null) {
            Vector allGroups = this.ap.av.alignment.getGroups();
            for (int g = 0; g < allGroups.size(); ++g) {
                SequenceGroup sg = (SequenceGroup)allGroups.get(g);
                sg.cs = (ColourSchemeI)this.oldgroupColours.get(sg);
            }
        }
    }

    public void thresholdCheck_actionPerformed(ActionEvent e) {
        this.changeColour();
    }

    public void annotations_actionPerformed(ActionEvent e) {
        this.changeColour();
    }

    public void threshold_actionPerformed(ActionEvent e) {
        this.changeColour();
    }

    public void thresholdValue_actionPerformed(ActionEvent e) {
        try {
            float f = Float.parseFloat(this.thresholdValue.getText());
            this.slider.setValue((int)(f * 1000.0f));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void valueChanged() {
        if (this.currentColours.isSelected() && !(this.av.getGlobalColourScheme() instanceof AnnotationColourGradient)) {
            this.changeColour();
        }
        this.currentAnnotation.threshold.value = (float)this.slider.getValue() / 1000.0f;
        this.ap.paintAlignment(false);
    }

    public void currentColours_actionPerformed(ActionEvent e) {
        if (this.currentColours.isSelected()) {
            this.reset();
        }
        this.maxColour.setEnabled(!this.currentColours.isSelected());
        this.minColour.setEnabled(!this.currentColours.isSelected());
        this.changeColour();
    }

    public void thresholdIsMin_actionPerformed(ActionEvent actionEvent) {
        this.changeColour();
    }
}

